/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDisruptIndustry
extends HubMissionWithBarEvent
implements ColonyPlayerHostileActListener {
    public static float MISSION_DAYS = 240.0f;
    protected MarketAPI market;
    protected Industry industry;
    protected int disruptDays;

    protected void createBarGiver(MarketAPI createdAt) {
    }

    protected String[] getTargetIndustries() {
        return new String[]{"heavyindustry", "orbitalworks"};
    }

    protected BaseHubMission.CreditReward getRewardTier() {
        return BaseHubMission.CreditReward.HIGH;
    }

    protected boolean requireFactionHostile() {
        return true;
    }

    protected void setMarketSearchParameters(MarketAPI createdAt, String[] industries) {
        this.requireMarketIsNot(createdAt);
        this.requireMarketLocationNot(createdAt.getContainingLocation());
        this.requireMarketFactionNotPlayer();
        if (this.requireFactionHostile()) {
            this.requireMarketFactionHostileTo(createdAt.getFactionId());
        }
        this.requireMarketNotHidden();
        this.requireMarketIndustries(ReqMode.ANY, industries);
        this.requireMarketNotInHyperspace();
        float q = this.getQuality();
        if (q <= 0.0f) {
            this.preferMarketSizeAtMost(4);
        } else if ((double)q <= 0.25) {
            this.preferMarketSizeAtMost(5);
        } else if ((double)q <= 0.5) {
            this.preferMarketSizeAtMost(6);
        } else if ((double)q <= 0.75) {
            this.preferMarketSizeAtMost(7);
        }
    }

    protected void addExtraTriggers(MarketAPI createdAt) {
    }

    protected boolean availableAtMarket(MarketAPI createdAt) {
        return true;
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (!this.availableAtMarket(createdAt)) {
            return false;
        }
        if (barEvent) {
            this.createBarGiver(createdAt);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        String id = this.getMissionId();
        if (!this.setPersonMissionRef(person, "$" + id + "_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        String[] industries = this.getTargetIndustries();
        this.setMarketSearchParameters(createdAt, industries);
        this.market = this.pickMarket();
        if (this.market == null) {
            return false;
        }
        String[] stringArray = industries;
        int n = industries.length;
        int n2 = 0;
        while (n2 < n) {
            String indId = stringArray[n2];
            this.industry = this.market.getIndustry(indId);
            if (this.industry != null) break;
            ++n2;
        }
        if (this.industry == null) {
            return false;
        }
        this.disruptDays = MarketCMD.getDisruptDaysPerToken(this.market, this.industry) * 3;
        if (!this.setMarketMissionRef(this.market, "$" + id + "_ref")) {
            return false;
        }
        int marines = this.getMarinesRequiredToDisrupt(this.market, this.industry, this.disruptDays);
        if (!this.isOkToOfferMissionRequiringMarines(marines)) {
            return false;
        }
        this.makeImportant(this.market, "$" + id + "_target", Stage.DISRUPT);
        this.setStartingStage((Object)Stage.DISRUPT);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.market, "$" + id + "_completed");
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_NO_PENALTY});
        this.connectWithMarketDecivilized((Object)Stage.DISRUPT, (Object)Stage.FAILED_NO_PENALTY, this.market);
        this.setStageOnMarketDecivilized((Object)Stage.FAILED_NO_PENALTY, createdAt);
        if (this.requireFactionHostile()) {
            this.connectWithHostilitiesEnded((Object)Stage.DISRUPT, (Object)Stage.FAILED_NO_PENALTY, person, this.market);
            this.setStageOnHostilitiesEnded((Object)Stage.FAILED_NO_PENALTY, person, this.market);
        }
        int bonus = this.getRewardBonusForMarines(this.getMarinesRequiredToDisrupt(this.market, this.industry, this.disruptDays));
        this.setCreditRewardWithBonus(this.getRewardTier(), bonus);
        this.addExtraTriggers(createdAt);
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        String id = this.getMissionId();
        this.set("$" + id + "_barEvent", this.isBarEvent());
        this.set("$" + id + "_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$" + id + "_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$" + id + "_heOrShe", this.getPerson().getHeOrShe());
        this.set("$" + id + "_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$" + id + "_industry", this.industry.getCurrentName());
        this.set("$" + id + "_disruptDays", this.disruptDays);
        this.set("$" + id + "_marines", Misc.getWithDGS(this.getMarinesRequiredToDisrupt(this.market, this.industry, this.disruptDays)));
        this.set("$" + id + "_personName", this.getPerson().getNameString());
        this.set("$" + id + "_systemName", this.market.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$" + id + "_marketName", this.market.getName());
        this.set("$" + id + "_marketOnOrAt", this.market.getOnOrAt());
        this.set("$" + id + "_dist", this.getDistanceLY(this.market));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DISRUPT) {
            BaseDisruptIndustry.addStandardMarketDesc("\u762b\u75ea " + this.industry.getCurrentName() + " " + this.market.getOnOrAt(), this.market, info, opad);
            this.addDisruptRaidInfo(this.market, this.industry, this.disruptDays, info, opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DISRUPT) {
            info.addPara("\u762b\u75ea " + this.industry.getCurrentName().toLowerCase() + " " + this.market.getOnOrAt() + " " + this.market.getName() + " \u5728 " + this.market.getStarSystem().getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u762b\u75ea " + this.industry.getCurrentName();
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.acceptImpl(dialog, memoryMap);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
        if (this.industry == industry && industry.getDisruptedDays() >= (float)this.disruptDays) {
            Global.getSector().getListenerManager().removeListener(this);
            String id = this.getMissionId();
            market.getMemoryWithoutUpdate().set("$" + id + "_raidedTargetIndustry", true, 0.0f);
        }
    }

    @Override
    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
    }

    @Override
    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    @Override
    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        DISRUPT,
        COMPLETED,
        FAILED,
        FAILED_NO_PENALTY;

    }
}

