/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class DeadDropMission
extends HubMissionWithBarEvent {
    public static float PROB_COMPLICATIONS = 0.5f;
    public static float PROB_PATROL_AFTER = 0.5f;
    public static float MISSION_DAYS = 120.0f;
    protected String thing;
    protected SectorEntityToken target;
    protected StarSystemAPI system;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverPost(this.pickOne(Ranks.POST_AGENT, Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
            this.setGiverImportance(this.pickImportance());
            this.setGiverFaction("pirates");
            this.setGiverTags("underworld");
            this.findOrCreateGiver(createdAt, false, false);
        }
        this.thing = this.pickOne("\u4e00\u4e2a\u4f3c\u4e4e\u5df2\u7ecf\u65e0\u6cd5\u8fd0\u4f5c\u7684\u6570\u636e\u82af\u7247", "\u4e00\u53f0\u6551\u96be\u8005\u4f7f\u7528\u7684\u6297\u8f90\u5c04 TriPad", "\u4e00\u5757\u6d51\u6d4a\u3001\u635f\u574f\u7684\u6570\u636e\u6676\u4f53", "\u4e00\u4e2a\u5c0f\u578b\u7535\u78c1\u5c4f\u853d\u4fdd\u9669\u7bb1", "\u4e00\u4e9b\u7eb8\u8d28\u8bfb\u7269", "\u4e00\u4e2a\u88c5\u6709\u5947\u7279\u5f2f\u9488\u7684\u7f1d\u7eab\u5305", "\u4e00\u6735\u653e\u7f6e\u5728\u5fae\u578b\u9759\u6ede\u529b\u573a\u4e2d\u7684\u73ab\u7470\u82b1", "\u4e00\u5c0f\u5305\u538b\u5370\u7740\u5362\u5fb7\u7b26\u53f7\u7684\u79cd\u5b50", "\u4e00\u6839\u8150\u673d\u626d\u66f2\u7684\u6728\u5934", "\u4e00\u5757\u88c5\u5728\u5c4f\u853d\u7bb1\u5185\u4e14\u6709\u8f90\u5c04\u75d5\u8ff9\u7684\u8239\u8231\u9694\u677f", "\u4e00\u5757\u4ea7\u81ea Volturn \u7684\u9ed1\u8272\u9f99\u867e\u58f3", "\u4e00\u4e2a\u7f6e\u4e8e\u5bc6\u5c01\u67f1\u72b6\u5bb9\u5668\u5185\u7684\u751f\u7269\u6837\u672c", "\u4e00\u5c0f\u74f6\u5947\u5f02\u7684\u8840\u6db2\u6837\u672c", "\u4e00\u4e9b\u7f6e\u4e8e\u4e09\u91cd\u5bc6\u5c01\u5bb9\u5668\u5185\u7684\u7c89\u72b6\u7269\u8d28", "\u4e00\u6839\u88ab\u771f\u7a7a\u5e72\u71e5\u540e\u7684\u624b\u6307", "\u4e00\u4e2a\u5c0f\u5c0f\u7684\u72ec\u89d2\u517d\u540a\u5760", "\u4e00\u4e2a\u7cbe\u81f4\u7684\u7eb8\u9e64", "\u4e00\u4e2a\u5e03\u6ee1\u5212\u75d5\u7684\u91d1\u6212\u6307", "\u4e00\u4e9b\u88ab\u91cd\u529b\u9677\u9631\u56f0\u4f4f\u7684\u53d1\u5149\u5c18\u57c3", "\u4e00\u53ea\u7834\u65e7\u7684\u9738\u4e3b\u519b\u5b98\u624b\u67aa", "\u4e00\u9897\u7cbe\u96d5\u7ec6\u7422\u7684\u5927\u94bb\u77f3", "\u4e00\u4e2a\u4ece\u8231\u58c1\u4e0a\u5207\u4e0b\u6765\u7684\u8230\u957f\u4fdd\u9669\u7bb1", "\u4e00\u5c0f\u5757\u5728\u5bc6\u5c01\u7ba1\u5185\u53d1\u5149\u7684\u84dd\u8272\u6676\u4f53");
        PersonAPI person = this.getPerson();
        if (person == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$ddro_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        this.requireSystemNot(createdAt.getStarSystem());
        this.requireSystemInterestingAndNotUnsafeOrCore();
        this.preferSystemInInnerSector();
        this.preferSystemUnexplored();
        this.preferSystemInDirectionOfOtherMissions();
        this.system = this.pickSystem();
        if (this.system == null) {
            return false;
        }
        this.target = this.spawnMissionNode(new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN_NOT_NEAR_STAR, null, this.system));
        if (!this.setEntityMissionRef(this.target, "$ddro_ref")) {
            return false;
        }
        this.makeImportant(this.target, "$ddro_target", Stage.DROP_OFF);
        this.setStartingStage((Object)Stage.DROP_OFF);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.target, "$ddro_completed");
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        this.setCreditReward(BaseHubMission.CreditReward.HIGH);
        if (this.rollProbability(PROB_COMPLICATIONS)) {
            this.triggerComplicationBegin((Object)Stage.DROP_OFF, HubMissionWithTriggers.ComplicationSpawn.APPROACHING_OR_ENTERING, this.system, "pirates", "\u5df2\u5c06 " + this.getWithoutArticle(this.thing), " \u9001\u81f3\u76ee\u7684\u5730", "\u5df2\u5c06 " + this.getWithoutArticle(this.thing) + " \u9001\u81f3 " + person.getNameString(), 0, true, HubMissionWithTriggers.ComplicationRepImpact.NONE, null);
            this.triggerComplicationEnd(true);
        }
        return true;
    }

    protected void notifyEnding() {
        super.notifyEnding();
        if (this.isSucceeded() && this.rollProbability(PROB_PATROL_AFTER)) {
            PersonAPI person = this.getPerson();
            if (person == null || person.getMarket() == null) {
                return;
            }
            String patrolFaction = person.getMarket().getFactionId();
            if (patrolFaction.equals(person.getFaction().getId()) || Misc.isPirateFaction(person.getMarket().getFaction()) || "player".equals(patrolFaction)) {
                return;
            }
            DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
            e.setDelayNone();
            e.setLocationInnerSector(true, patrolFaction);
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, patrolFaction, "patrolLarge", new Vector2f());
            e.setFleetWantsThing(patrolFaction, "\u8be5\u79d8\u5bc6\u60c5\u62a5\u4f20\u9012\u70b9\u7684\u5750\u6807", "\u4ed6\u4eec", "\u8be5\u79d8\u5bc6\u60c5\u62a5\u4f20\u9012\u70b9\u7684\u5750\u6807\u4f4d\u4e8e " + person.getNameString(), 0, true, HubMissionWithTriggers.ComplicationRepImpact.LOW, DelayedFleetEncounter.TRIGGER_REP_LOSS_MEDIUM, this.getPerson());
            e.triggerSetAdjustStrengthBasedOnQuality(true, this.getQuality());
            e.triggerMakeLowRepImpact();
            e.triggerSetPatrol();
            e.triggerSetStandardAggroInterceptFlags();
            e.endCreate();
        }
    }

    protected void updateInteractionDataImpl() {
        this.set("$ddro_barEvent", this.isBarEvent());
        this.set("$ddro_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$ddro_heOrShe", this.getPerson().getHeOrShe());
        this.set("$ddro_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$ddro_aOrAnThing", this.thing);
        this.set("$ddro_thing", this.getWithoutArticle(this.thing));
        this.set("$ddro_personName", this.getPerson().getNameString());
        this.set("$ddro_systemName", this.system.getNameWithLowercaseTypeShort());
        this.set("$ddro_dist", this.getDistanceLY(this.target));
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DROP_OFF) {
            info.addPara("\u5c06 " + this.thing + " \u9001" + "\u81f3 " + this.system.getNameWithLowercaseTypeShort() + " \u4e2d\u7684\u79d8\u5bc6\u60c5\u62a5\u4f20\u9012\u70b9\u5f53\u4e2d\u3002", opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DROP_OFF) {
            info.addPara("\u5c06 " + this.getWithoutArticle(this.thing) + " \u9001\u81f3 " + this.system.getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "\u4f20\u9012\u79d8\u5bc6\u60c5\u62a5";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        DROP_OFF,
        COMPLETED,
        FAILED;

    }
}

