/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class DisruptCompetitorMission
extends HubMissionWithBarEvent {
    public static float PROB_COMPLICATIONS = 0.25f;
    public static float MISSION_DAYS = 120.0f;
    public static MarketCMD.RaidDangerLevel RAID_DANGER = MarketCMD.RaidDangerLevel.MEDIUM;
    protected MarketAPI market;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            String post = this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_MERCHANT, Ranks.POST_INVESTOR, Ranks.POST_EXECUTIVE, Ranks.POST_SENIOR_EXECUTIVE, Ranks.POST_PORTMASTER);
            this.setGiverPost(post);
            if (post.equals(Ranks.POST_SENIOR_EXECUTIVE)) {
                this.setGiverImportance(this.pickHighImportance());
            } else {
                this.setGiverImportance(this.pickImportance());
            }
            this.setGiverTags("trade");
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$dcom_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        PersonImportance importance = person.getImportance();
        int minMarketSize = 3;
        int maxMarketSize = 9;
        switch (importance) {
            case VERY_LOW: {
                minMarketSize = 3;
                maxMarketSize = 4;
                break;
            }
            case LOW: {
                minMarketSize = 4;
                maxMarketSize = 4;
                break;
            }
            case MEDIUM: {
                minMarketSize = 5;
                maxMarketSize = 5;
                break;
            }
            case HIGH: {
                minMarketSize = 5;
                maxMarketSize = 6;
                break;
            }
            case VERY_HIGH: {
                minMarketSize = 6;
                maxMarketSize = 8;
            }
        }
        this.requireMarketIsNot(createdAt);
        this.requireMarketNotHidden();
        this.requireMarketFactionNotPlayer();
        this.requireMarketNotInHyperspace();
        this.preferMarketSizeAtLeast(minMarketSize);
        this.preferMarketSizeAtMost(maxMarketSize);
        this.market = this.pickMarket();
        if (this.market == null) {
            return false;
        }
        if (!this.setMarketMissionRef(this.market, "$dcom_ref")) {
            return false;
        }
        int marines = this.getMarinesRequiredForCustomObjective(this.market, RAID_DANGER);
        if (!this.isOkToOfferMissionRequiringMarines(marines)) {
            return false;
        }
        this.makeImportant(this.market, "$dcom_target", Stage.DISRUPT);
        this.setStartingStage((Object)Stage.DISRUPT);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.market, "$dcom_completed");
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        int bonus = this.getRewardBonusForMarines(this.getMarinesRequiredForCustomObjective(this.market, RAID_DANGER));
        this.setCreditRewardWithBonus(BaseHubMission.CreditReward.AVERAGE, bonus);
        return true;
    }

    protected void notifyEnding() {
        super.notifyEnding();
        if (this.isSucceeded() && this.rollProbability(PROB_COMPLICATIONS)) {
            DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
            e.setDelayMedium();
            e.setLocationInnerSector(false, "independent");
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_1, "mercenary", "patrolLarge", new Vector2f());
            e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
            e.triggerFleetSetFaction("independent");
            e.triggerSetAdjustStrengthBasedOnQuality(true, this.getQuality());
            e.triggerSetStandardAggroNonPirateFlags();
            e.triggerSetStandardAggroInterceptFlags();
            e.triggerSetFleetMemoryValue("$dcom_marketName", this.market.getName());
            e.triggerSetFleetMemoryValue("$dcom_marketOnOrAt", this.market.getOnOrAt());
            e.triggerSetFleetGenericHailPermanent("DCOMMercHail");
            e.endCreate();
        }
    }

    protected void updateInteractionDataImpl() {
        this.set("$dcom_barEvent", this.isBarEvent());
        this.set("$dcom_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$dcom_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$dcom_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$dcom_systemName", this.market.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$dcom_marketName", this.market.getName());
        this.set("$dcom_marketOnOrAt", this.market.getOnOrAt());
        this.set("$dcom_dist", this.getDistanceLY(this.market));
        this.set("$dcom_marketFactionArticle", this.market.getFaction().getPersonNamePrefixAOrAn());
        this.set("$dcom_marketFaction", this.market.getFaction().getPersonNamePrefix());
        this.set("$dcom_factionColor", this.market.getFaction().getBaseUIColor());
        this.set("$dcom_danger", (Object)RAID_DANGER);
        this.set("$dcom_marines", Misc.getWithDGS(this.getMarinesRequiredForCustomObjective(this.market, RAID_DANGER)));
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DISRUPT) {
            info.addPara("\u59d4\u6258\u4eba " + this.getPerson().getNameString() + " \u5e0c\u671b\u901a\u8fc7\u7a81\u88ad" + this.market.getOnOrAt() + " " + this.market.getName() + " \u7684\u4ed3\u5e93\uff0c\u4f4d\u4e8e " + this.market.getStarSystem().getNameWithLowercaseTypeShort() + " \u6765\u6270\u4e71\u5176\u7ade\u4e89\u5bf9\u624b\u3002", opad);
            this.addCustomRaidInfo(this.market, RAID_DANGER, info, opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DISRUPT) {
            info.addPara("\u7a81\u88ad" + this.market.getOnOrAt() + " " + this.market.getName() + " \u7684\u4ed3\u5e93\uff0c\u4f4d\u4e8e " + this.market.getStarSystem().getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "\u6076\u610f\u7ade\u4e89";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        DISRUPT,
        COMPLETED,
        FAILED;

    }
}

