/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class FleetCreatorMission
extends HubMissionWithTriggers {
    protected static Object STAGE = new Object();
    protected String fleetTypeSmall = "patrolSmall";
    protected String fleetTypeMedium = "patrolMedium";
    protected String fleetTypeLarge = "patrolLarge";

    public FleetCreatorMission(Random random) {
        this.setMissionId("fcm_" + Misc.genUID());
        this.setGenRandom(random);
    }

    public void beginFleet() {
        this.beginStageTrigger(STAGE);
        this.triggerMakeAllFleetFlagsPermanent();
    }

    public CampaignFleetAPI createFleet() {
        this.endTrigger();
        List<CampaignFleetAPI> fleets = this.runStageTriggersReturnFleets(STAGE);
        if (fleets.isEmpty()) {
            return null;
        }
        CampaignFleetAPI fleet = fleets.get(0);
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        return fleet;
    }

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        return false;
    }

    public void createFleet(FleetStyle style, int difficulty, String factionId, Vector2f locInHyper) {
        if (style == FleetStyle.STANDARD || style == null) {
            this.createStandardFleet(difficulty, factionId, locInHyper);
        } else if (style == FleetStyle.QUANTITY) {
            this.createQuantityFleet(difficulty, factionId, locInHyper);
        } else if (style == FleetStyle.QUALITY) {
            this.createQualityFleet(difficulty, factionId, locInHyper);
        }
    }

    public void createStandardFleet(int difficulty, String factionId, Vector2f locInHyper) {
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
        String type = this.fleetTypeMedium;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
        if (difficulty <= 0) {
            size = HubMissionWithTriggers.FleetSize.TINY;
            quality = HubMissionWithTriggers.FleetQuality.VERY_LOW;
            oQuality = HubMissionWithTriggers.OfficerQuality.LOWER;
            oNum = HubMissionWithTriggers.OfficerNum.FC_ONLY;
            type = this.fleetTypeSmall;
        } else if (difficulty == 1) {
            size = HubMissionWithTriggers.FleetSize.VERY_SMALL;
            quality = HubMissionWithTriggers.FleetQuality.VERY_LOW;
            oQuality = HubMissionWithTriggers.OfficerQuality.LOWER;
            oNum = HubMissionWithTriggers.OfficerNum.FC_ONLY;
            type = this.fleetTypeSmall;
        } else if (difficulty == 2) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.LOWER;
            oNum = HubMissionWithTriggers.OfficerNum.FEWER;
            type = this.fleetTypeSmall;
        } else if (difficulty == 3) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeMedium;
        } else if (difficulty == 4) {
            size = HubMissionWithTriggers.FleetSize.MEDIUM;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeMedium;
        } else if (difficulty == 5) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeLarge;
        } else if (difficulty == 6) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeLarge;
        } else if (difficulty == 7) {
            size = HubMissionWithTriggers.FleetSize.LARGER;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeLarge;
        } else if (difficulty == 8) {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeLarge;
        } else if (difficulty == 9) {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeLarge;
        } else {
            size = HubMissionWithTriggers.FleetSize.HUGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeLarge;
        }
        this.triggerCreateFleet(size, quality, factionId, type, locInHyper);
        this.triggerSetFleetOfficers(oNum, oQuality);
    }

    public void createQualityFleet(int difficulty, String factionId, Vector2f locInHyper) {
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
        String type = this.fleetTypeMedium;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
        if (difficulty <= 0) {
            size = HubMissionWithTriggers.FleetSize.TINY;
            quality = HubMissionWithTriggers.FleetQuality.VERY_HIGH;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.FC_ONLY;
            type = this.fleetTypeSmall;
        } else if (difficulty == 1) {
            size = HubMissionWithTriggers.FleetSize.VERY_SMALL;
            quality = HubMissionWithTriggers.FleetQuality.VERY_HIGH;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.FC_ONLY;
            type = this.fleetTypeSmall;
        } else if (difficulty == 2) {
            size = HubMissionWithTriggers.FleetSize.VERY_SMALL;
            quality = HubMissionWithTriggers.FleetQuality.VERY_HIGH;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeSmall;
        } else if (difficulty == 3) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            quality = HubMissionWithTriggers.FleetQuality.VERY_HIGH;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeSmall;
        } else if (difficulty == 4) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            quality = HubMissionWithTriggers.FleetQuality.VERY_HIGH;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeSmall;
        } else if (difficulty == 5) {
            size = HubMissionWithTriggers.FleetSize.MEDIUM;
            quality = HubMissionWithTriggers.FleetQuality.SMOD_1;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeMedium;
        } else if (difficulty == 6) {
            size = HubMissionWithTriggers.FleetSize.MEDIUM;
            quality = HubMissionWithTriggers.FleetQuality.SMOD_1;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeMedium;
        } else if (difficulty == 7) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.SMOD_1;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeMedium;
        } else if (difficulty == 8) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.SMOD_1;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeLarge;
        } else if (difficulty == 9) {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
            quality = HubMissionWithTriggers.FleetQuality.SMOD_1;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeLarge;
        } else {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
            quality = HubMissionWithTriggers.FleetQuality.SMOD_2;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeLarge;
        }
        this.triggerCreateFleet(size, quality, factionId, type, locInHyper);
        this.triggerSetFleetOfficers(oNum, oQuality);
    }

    public void createQuantityFleet(int difficulty, String factionId, Vector2f locInHyper) {
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
        String type = this.fleetTypeMedium;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
        if (difficulty <= 0) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            quality = HubMissionWithTriggers.FleetQuality.LOWER;
            oQuality = HubMissionWithTriggers.OfficerQuality.LOWER;
            oNum = HubMissionWithTriggers.OfficerNum.FC_ONLY;
            type = this.fleetTypeSmall;
        } else if (difficulty == 1) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeSmall;
        } else if (difficulty == 2) {
            size = HubMissionWithTriggers.FleetSize.MEDIUM;
            quality = HubMissionWithTriggers.FleetQuality.LOWER;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeMedium;
        } else if (difficulty == 3) {
            size = HubMissionWithTriggers.FleetSize.MEDIUM;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeMedium;
        } else if (difficulty == 4) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.LOWER;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeMedium;
        } else if (difficulty == 5) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeMedium;
        } else if (difficulty == 6) {
            size = HubMissionWithTriggers.FleetSize.LARGER;
            quality = HubMissionWithTriggers.FleetQuality.LOWER;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeLarge;
        } else if (difficulty == 7) {
            size = HubMissionWithTriggers.FleetSize.LARGER;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeLarge;
        } else if (difficulty == 8) {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeLarge;
        } else if (difficulty == 9) {
            size = HubMissionWithTriggers.FleetSize.HUGE;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = this.fleetTypeLarge;
        } else {
            size = HubMissionWithTriggers.FleetSize.MAXIMUM;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = this.fleetTypeLarge;
        }
        this.triggerCreateFleet(size, quality, factionId, type, locInHyper);
        this.triggerSetFleetOfficers(oNum, oQuality);
    }

    public void setFleetTypes(String small, String medium, String large) {
        this.fleetTypeSmall = small;
        this.fleetTypeMedium = medium;
        this.fleetTypeLarge = large;
    }

    public String getFleetTypeSmall() {
        return this.fleetTypeSmall;
    }

    public void setFleetTypeSmall(String fleetTypeSmall) {
        this.fleetTypeSmall = fleetTypeSmall;
    }

    public String getFleetTypeMedium() {
        return this.fleetTypeMedium;
    }

    public void setFleetTypeMedium(String fleetTypeMedium) {
        this.fleetTypeMedium = fleetTypeMedium;
    }

    public String getFleetTypeLarge() {
        return this.fleetTypeLarge;
    }

    public void setFleetTypeLarge(String fleetTypeLarge) {
        this.fleetTypeLarge = fleetTypeLarge;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FleetStyle {
        QUANTITY,
        STANDARD,
        QUALITY;

    }
}

