/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Voices;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseManager;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandMeDownFreighter
extends HubMissionWithBarEvent {
    public static float BASE_PRICE_MULT = 0.33f;
    public static WeightedRandomPicker<String> HULLS = new WeightedRandomPicker();
    protected FleetMemberAPI member;
    protected int price;

    static {
        HULLS.add("buffalo_Hull", 7.0f);
        HULLS.add("tarsus_Hull", 7.0f);
        HULLS.add("colossus_Hull", 5.0f);
        HULLS.add("atlas_Hull", 1.0f);
        HULLS.add("wayfarer_Hull", 5.0f);
        HULLS.add("gemini_Hull", 1.0f);
        HULLS.add("mule_d_pirates_Hull", 1.0f);
        HULLS.add("mule_Hull", 1.0f);
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        float probAbort = 0.75f * PirateBaseManager.getInstance().getStandardTimeFactor();
        if (this.rollProbability(probAbort)) {
            return false;
        }
        if (barEvent) {
            this.setGiverFaction("independent");
            this.setGiverPost(Ranks.POST_SPACER);
            this.setGiverVoice(Voices.SPACER);
            this.setGiverImportance(this.pickLowImportance());
            this.setGiverTags("underworld", "trade");
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        MarketAPI market = person.getMarket();
        if (market == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$hmdf_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        String variantId = HULLS.pick(this.genRandom);
        ShipVariantAPI variant = Global.getSettings().getVariant(variantId).clone();
        this.member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variant);
        this.assignShipName(this.member, "independent");
        int dMods = 2 + this.genRandom.nextInt(3);
        DModManager.addDMods(variant, true, dMods, this.genRandom);
        DModManager.removeDMod(variant, "comp_storage");
        this.member.getCrewComposition().setCrew(100000.0f);
        this.member.getRepairTracker().setCR(0.7f);
        this.price = HandMeDownFreighter.getRoundNumber(variant.getHullSpec().getBaseValue() * BASE_PRICE_MULT);
        this.setRepFactionChangesTiny();
        this.setRepPersonChangesVeryLow();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$hmdf_ref2", this);
        this.set("$hmdf_barEvent", this.isBarEvent());
        this.set("$hmdf_hullClass", this.member.getHullSpec().getHullNameWithDashClass());
        this.set("$hmdf_price", Misc.getWithDGS(this.price));
        this.set("$hmdf_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$hmdf_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$hmdf_member", this.member);
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("showShip".equals(action)) {
            dialog.getVisualPanel().showFleetMemberInfo(this.member, true);
            return true;
        }
        if ("showPerson".equals(action)) {
            dialog.getVisualPanel().showPersonInfo(this.getPerson(), true);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u4e8c\u624b\u8d27\u8230";
    }

    @Override
    public void accept(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        this.currentStage = new Object();
        this.abort();
        for (CampaignFleetAPI fleet : this.getPerson().getMarket().getContainingLocation().getFleets()) {
            if (fleet.getFaction().isPlayerFaction() || !Misc.isPatrol(fleet)) continue;
            fleet.getMemoryWithoutUpdate().set("$patrolExtraSuspicion", Float.valueOf(1.0f));
        }
    }
}

