/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.econ.impl.ShipQuality;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.SurplusShipHull;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HijackingMission
extends HubMissionWithBarEvent {
    public static float BASE_PRICE_MULT = 0.33f;
    protected FleetMemberAPI member;
    protected int price;
    protected int marines;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverPost(this.pickOne(Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
            this.setGiverImportance(this.pickImportance());
            this.setGiverFaction("pirates");
            this.setGiverTags("underworld");
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        MarketAPI market = person.getMarket();
        if (market == null) {
            return false;
        }
        if (market.isPlayerOwned()) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$hijack_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        FactionAPI.ShipPickParams params = new FactionAPI.ShipPickParams(FactionAPI.ShipPickMode.PRIORITY_THEN_ALL);
        String role = SurplusShipHull.pickRole(this.getQuality(), market.getFaction(), person.getImportance(), this.genRandom);
        ShipVariantAPI variant = null;
        int i = 0;
        while (i < 10) {
            List<ShipRolePick> picks = market.getFaction().pickShip(role, params, null, this.genRandom);
            if (picks.isEmpty()) {
                return false;
            }
            String variantId = picks.get((int)0).variantId;
            variant = Global.getSettings().getVariant(variantId);
            variant = Global.getSettings().getVariant(String.valueOf(variant.getHullSpec().getHullId()) + "_Hull").clone();
            if (!variant.getHullSpec().hasTag("no_sell")) break;
            variant = null;
            ++i;
        }
        if (variant == null) {
            return false;
        }
        this.member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variant);
        this.assignShipName(this.member, "independent");
        float quality = ShipQuality.getShipQuality(market, market.getFaction().getId());
        float averageDmods = DefaultFleetInflater.getAverageDmodsForQuality(quality);
        int addDmods = DefaultFleetInflater.getNumDModsToAdd(variant, averageDmods, this.genRandom);
        if (addDmods > 0) {
            DModManager.setDHull(variant);
            DModManager.addDMods(this.member, true, addDmods, this.genRandom);
        }
        this.price = HijackingMission.getRoundNumber(variant.getHullSpec().getBaseValue() * BASE_PRICE_MULT);
        this.setRepFactionChangesTiny();
        this.setRepPersonChangesVeryLow();
        switch (this.member.getHullSpec().getHullSize()) {
            case CAPITAL_SHIP: {
                this.marines = 100;
                this.setRepFactionChangesVeryLow();
                this.setRepPersonChangesLow();
                break;
            }
            case CRUISER: {
                this.marines = 50;
                break;
            }
            case DESTROYER: {
                this.marines = 20;
                break;
            }
            case FRIGATE: {
                this.marines = 10;
            }
        }
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$hijack_barEvent", this.isBarEvent());
        this.set("$hijack_hull", this.member.getHullSpec().getHullNameWithDashClass());
        this.set("$hijack_designation", this.member.getHullSpec().getDesignation());
        this.set("$hijack_price", Misc.getWithDGS(this.price));
        this.set("$hijack_marines", Misc.getWithDGS(this.marines));
        this.set("$hijack_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$hijack_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$hijack_member", this.member);
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("showShip".equals(action)) {
            dialog.getVisualPanel().showFleetMemberInfo(this.member, true);
            return true;
        }
        if ("showPerson".equals(action)) {
            dialog.getVisualPanel().showPersonInfo(this.getPerson(), true);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u52ab\u6301";
    }

    @Override
    public void accept(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        this.currentStage = new Object();
        this.abort();
    }
}

