/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class JailbreakMission
extends HubMissionWithBarEvent {
    public static float MISSION_DAYS = 120.0f;
    public static float PROB_COMPLICATIONS = 0.5f;
    protected MarketAPI market;
    protected MarketCMD.RaidDangerLevel danger;
    protected int storyCost = 0;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverPost(this.pickOne(Ranks.POST_AGENT, Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
            this.setGiverImportance(this.pickImportance());
            this.setGiverFaction("pirates");
            this.setGiverTags("underworld");
            this.findOrCreateGiver(createdAt, true, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$jabr_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        PersonImportance importance = person.getImportance();
        int minMarketSize = 3;
        int maxMarketSize = 9;
        switch (importance) {
            case VERY_LOW: {
                minMarketSize = 3;
                maxMarketSize = 4;
                this.danger = MarketCMD.RaidDangerLevel.MINIMAL;
                break;
            }
            case LOW: {
                minMarketSize = 4;
                maxMarketSize = 4;
                this.danger = MarketCMD.RaidDangerLevel.LOW;
                break;
            }
            case MEDIUM: {
                minMarketSize = 5;
                maxMarketSize = 5;
                this.danger = MarketCMD.RaidDangerLevel.MEDIUM;
                break;
            }
            case HIGH: {
                minMarketSize = 5;
                maxMarketSize = 6;
                this.danger = MarketCMD.RaidDangerLevel.HIGH;
                break;
            }
            case VERY_HIGH: {
                minMarketSize = 6;
                maxMarketSize = 8;
                this.danger = MarketCMD.RaidDangerLevel.EXTREME;
            }
        }
        this.requireMarketIsNot(createdAt);
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        this.requireMarketFactionNotPlayer();
        this.preferMarketSizeAtLeast(minMarketSize);
        this.preferMarketSizeAtMost(maxMarketSize);
        this.preferMarketInDirectionOfOtherMissions();
        this.market = this.pickMarket();
        if (this.market == null) {
            return false;
        }
        if (!this.setMarketMissionRef(this.market, "$jabr_ref")) {
            return false;
        }
        int marines = this.getMarinesRequiredForCustomObjective(this.market, this.danger);
        if (!this.isOkToOfferMissionRequiringMarines(marines)) {
            return false;
        }
        this.makeImportant(this.market, "$jabr_target", Stage.JAILBREAK);
        this.makeImportant(this.getPerson(), "$jabr_returnHere", Stage.RETURN);
        this.setStartingStage((Object)Stage.JAILBREAK);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.connectWithMemoryFlag((Object)Stage.JAILBREAK, (Object)Stage.RETURN, this.market, "$jabr_needToReturn");
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, person, "$jabr_completed");
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_DECIV});
        this.connectWithMarketDecivilized((Object)Stage.JAILBREAK, (Object)Stage.FAILED_DECIV, this.market);
        this.setStageOnMarketDecivilized((Object)Stage.FAILED_DECIV, createdAt);
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[]{Stage.RETURN});
        int bonus = this.getRewardBonusForMarines(this.getMarinesRequiredForCustomObjective(this.market, this.danger));
        this.setCreditRewardWithBonus(BaseHubMission.CreditReward.AVERAGE, bonus);
        this.storyCost = JailbreakMission.getRoundNumber(this.getCreditsReward() / 2);
        if (this.rollProbability(PROB_COMPLICATIONS)) {
            this.triggerComplicationBegin((Object)Stage.RETURN, HubMissionWithTriggers.ComplicationSpawn.APPROACHING_OR_ENTERING, createdAt.getStarSystem(), "mercenary", "\u8d8a\u72f1\u72af", "\u4ed6\u4eec", "\u8d8a\u72f1\u72af - " + this.market.getName(), 0, true, HubMissionWithTriggers.ComplicationRepImpact.NONE, null);
            this.triggerComplicationEnd(true);
        }
        return true;
    }

    protected void updateInteractionDataImpl() {
        this.set("$jabr_barEvent", this.isBarEvent());
        this.set("$jabr_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$jabr_heOrShe", this.getPerson().getHeOrShe());
        this.set("$jabr_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$jabr_HisOrHer", Misc.ucFirst(this.getPerson().getHisOrHer()));
        this.set("$jabr_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$jabr_storyCost", Misc.getWithDGS(this.storyCost));
        this.set("$jabr_systemName", this.market.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$jabr_marketName", this.market.getName());
        this.set("$jabr_marketOnOrAt", this.market.getOnOrAt());
        this.set("$jabr_marketFactionArticle", this.market.getFaction().getPersonNamePrefixAOrAn());
        this.set("$jabr_marketFaction", this.market.getFaction().getPersonNamePrefix());
        this.set("$jabr_factionColor", this.market.getFaction().getBaseUIColor());
        this.set("$jabr_dist", this.getDistanceLY(this.market));
        this.set("$jabr_danger", (Object)this.danger);
        this.set("$jabr_marines", Misc.getWithDGS(this.getMarinesRequiredForCustomObjective(this.market, this.danger)));
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.JAILBREAK) {
            JailbreakMission.addStandardMarketDesc("\u76ee\u6807 " + this.market.getOnOrAt(), this.market, info, opad);
            this.addCustomRaidInfo(this.market, this.danger, info, opad);
        } else if (this.currentStage == Stage.RETURN) {
            info.addPara(String.valueOf(this.getReturnText(this.getPerson().getMarket().getName())) + "\u3002", opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.JAILBREAK) {
            info.addPara("\u534f\u52a9\u76ee\u6807\u9003\u79bb " + this.market.getOnOrAt() + " " + this.market.getName() + " \u7684\u76d1\u72f1\uff0c\u800c\u6b64\u5904\u4f4d\u4e8e " + this.market.getStarSystem().getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN) {
            info.addPara(this.getReturnTextShort(this.getPerson().getMarket().getName()), tc, pad);
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "\u534f\u52a9\u8d8a\u72f1";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        JAILBREAK,
        RETURN,
        COMPLETED,
        FAILED,
        FAILED_DECIV;

    }
}

