/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirateSystemBounty
extends HubMissionWithBarEvent
implements FleetEventListener {
    public static float BOUNTY_DAYS = 120.0f;
    public static float BASE_BOUNTY = 1000.0f;
    protected StarSystemAPI system;
    protected MarketAPI market;
    protected FactionAPI faction;
    protected FactionAPI enemy;
    protected int baseBounty;
    protected BountyResult latestResult;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            String post = null;
            this.setGiverRank(Ranks.CITIZEN);
            post = this.pickOne(Ranks.POST_TRADER, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_MERCHANT, Ranks.POST_INVESTOR, Ranks.POST_EXECUTIVE, Ranks.POST_PORTMASTER, Ranks.POST_SENIOR_EXECUTIVE);
            this.setGiverTags("trade");
            this.setGiverPost(post);
            if (post.equals(Ranks.POST_SENIOR_EXECUTIVE)) {
                this.setGiverImportance(this.pickHighImportance());
            } else {
                this.setGiverImportance(this.pickImportance());
            }
            this.findOrCreateGiver(createdAt, false, false);
            this.setGiverIsPotentialContactOnSuccess();
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if ("pirates".equals(person.getFaction().getId())) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$psb_ref")) {
            return false;
        }
        this.requireMarketFactionCustom(ReqMode.ALL, "makesPirateBases");
        this.requireMarketMemoryFlag(PirateBaseIntel.MEM_FLAG, true);
        this.requireMarketFactionNot(person.getFaction().getId());
        this.requireMarketHidden();
        this.requireMarketIsMilitary();
        this.preferMarketInDirectionOfOtherMissions();
        this.market = this.pickMarket();
        if (this.market == null || this.market.getStarSystem() == null) {
            return false;
        }
        if (!this.setMarketMissionRef(this.market, "$psb_ref")) {
            return false;
        }
        this.makeImportant(this.market, "$psb_target", Stage.BOUNTY);
        this.system = this.market.getStarSystem();
        this.faction = person.getFaction();
        this.enemy = this.market.getFaction();
        this.baseBounty = PirateSystemBounty.getRoundNumber(BASE_BOUNTY * this.getRewardMult());
        this.setStartingStage((Object)Stage.BOUNTY);
        this.setSuccessStage((Object)Stage.DONE);
        this.setNoAbandon();
        this.setNoRepChanges();
        this.connectWithDaysElapsed((Object)Stage.BOUNTY, (Object)Stage.DONE, BOUNTY_DAYS);
        this.addTag("Bounties");
        int numPirates = 2 + this.genRandom.nextInt(3);
        HubMissionWithTriggers.FleetSize[] sizes = new HubMissionWithTriggers.FleetSize[]{HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetSize.VERY_LARGE};
        int i = 0;
        while (i < numPirates) {
            HubMissionWithTriggers.FleetSize size = sizes[i % sizes.length];
            this.beginWithinHyperspaceRangeTrigger(this.system, 3.0f, false, new Object[]{Stage.BOUNTY});
            this.triggerCreateFleet(size, HubMissionWithTriggers.FleetQuality.DEFAULT, this.market.getFactionId(), "patrolMedium", this.system);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerSetPirateFleet();
            this.triggerSpawnFleetNear(this.system.getCenter(), null, null);
            this.triggerOrderFleetPatrol(this.system, true, "station", "jump_point");
            this.endTrigger();
            ++i;
        }
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$psb_barEvent", this.isBarEvent());
        this.set("$psb_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$psb_baseBounty", Misc.getWithDGS(this.baseBounty));
        this.set("$psb_days", "" + (int)BOUNTY_DAYS);
        this.set("$psb_systemName", this.system.getNameWithLowercaseType());
        this.set("$psb_systemNameShort", this.system.getNameWithLowercaseTypeShort());
        this.set("$psb_baseName", this.market.getName());
        this.set("$psb_dist", this.getDistanceLY(this.market));
    }

    @Override
    public void addDescriptionForCurrentStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        Color tc = this.getBulletColorForMode(IntelInfoPlugin.ListInfoMode.IN_DESC);
        if (this.currentStage == Stage.BOUNTY) {
            float elapsed = this.getElapsedInCurrentStage();
            int d = Math.round(BOUNTY_DAYS - elapsed);
            PersonAPI person = this.getPerson();
            String locStr = ", \u4f4d\u4e8e " + this.market.getStarSystem().getNameWithLowercaseType();
            info.addPara("\u9002\u7528\u4e8e\u6d77\u76d7\u57fa\u5730\u9644\u8fd1\u6240\u6709\u7684 %s \u8230\u961f" + locStr + "\uff0c\u76ee\u6807\uff1a" + this.market.getName() + "\u3002", opad, this.enemy.getBaseUIColor(), this.enemy.getPersonNamePrefix());
            if (this.isEnding()) {
                info.addPara("\u8be5 \u8d4f\u91d1 \u5df2\u88ab\u64a4\u9500\u3002", opad);
                return;
            }
            this.bullet(info);
            info.addPara("\u6bcf\u51fb\u8d25\u4e00\u8258\u654c\u65b9\u62a4\u536b\u8230\u5c06\u83b7\u5f97 %s", opad, tc, h, Misc.getDGSCredits(this.baseBounty));
            this.addDays(info, "\u671f\u9650", d, tc);
            this.unindent(info);
            info.addPara("\u6240\u83b7\u5956\u52b1\u53d6\u51b3\u4e8e\u88ab\u6bc1\u8230\u8239\u7684\u6570\u91cf\u4e0e\u89c4\u683c\uff0c\u800c\u4e0e " + this.faction.getDisplayNameWithArticle() + " \u8230\u961f\u4e0e" + " " + person.getNameString() + " \u534f\u540c\u4f5c\u6218\u65f6\uff0c\u4e5f\u80fd\u83b7\u5f97\u90e8\u5206\u5956\u52b1\u3002", opad);
        } else if (this.currentStage == Stage.DONE) {
            info.addPara("\u8be5 \u8d4f\u91d1 \u5df2\u88ab\u64a4\u9500\u3002", opad);
        }
        if (this.latestResult != null) {
            info.addPara("\u6700\u8fd1\u6536\u83b7\uff1a", opad);
            this.bullet(info);
            info.addPara("%s \u5df2\u6536\u5230", pad, tc, h, Misc.getDGSCredits(this.latestResult.payment));
            if ((float)Math.round(this.latestResult.fraction * 100.0f) < 100.0f) {
                info.addPara("\u6839\u636e\u6240\u9020\u6210\u7684\u4f24\u5bb3\uff0c\u5c06\u83b7\u5f97\u4e86 %s \u7684\u916c\u52b3", 0.0f, tc, h, Math.round(this.latestResult.fraction * 100.0f) + "%");
            }
            if (this.latestResult.repPerson != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.repPerson.delta, null, this.getPerson(), null, null, info, tc, false, 0.0f);
            }
            if (this.latestResult.repFaction != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.repFaction.delta, this.faction, null, null, null, info, tc, false, 0.0f);
            }
            this.unindent(info);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (isUpdate && this.latestResult == this.getListInfoParam()) {
            info.addPara("%s \u5df2\u6536\u5230", pad, tc, h, Misc.getDGSCredits(this.latestResult.payment));
            if ((float)Math.round(this.latestResult.fraction * 100.0f) < 100.0f) {
                info.addPara("\u6839\u636e\u6240\u9020\u6210\u7684\u4f24\u5bb3\uff0c\u5c06\u83b7\u5f97\u4e86 %s \u7684\u916c\u52b3", 0.0f, tc, h, Math.round(this.latestResult.fraction * 100.0f) + "%");
            }
            if (this.latestResult.repPerson != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.repPerson.delta, null, this.getPerson(), null, null, info, tc, isUpdate, 0.0f);
            }
            if (this.latestResult.repFaction != null) {
                CoreReputationPlugin.addAdjustmentMessage(this.latestResult.repFaction.delta, this.faction, null, null, null, info, tc, isUpdate, 0.0f);
            }
            return true;
        }
        if (this.currentStage == Stage.BOUNTY) {
            float elapsed = this.getElapsedInCurrentStage();
            int d = Math.round(BOUNTY_DAYS - elapsed);
            info.addPara("\u6bcf\u51fb\u8d25\u4e00\u8258\u654c\u65b9\u62a4\u536b\u8230\u5c06\u83b7\u5f97 %s", pad, tc, h, Misc.getDGSCredits(this.baseBounty));
            this.addDays(info, "\u671f\u9650", d, tc);
            return true;
        }
        if (this.currentStage == Stage.DONE) {
            return false;
        }
        return false;
    }

    @Override
    public String getPostfixForState() {
        if (this.currentStage == Stage.DONE) {
            return " - \u7ed3\u675f";
        }
        return super.getPostfixForState();
    }

    @Override
    public String getBaseName() {
        return "\u6d77\u76d7\u8d4f\u91d1";
    }

    @Override
    protected String getMissionTypeNoun() {
        return "\u8d4f\u91d1";
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.getMapLocationFor(this.market.getPrimaryEntity());
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void notifyEnding() {
        Global.getSector().getListenerManager().removeListener(this);
        super.notifyEnding();
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (this.isEnded() || this.isEnding()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (!Misc.isNear(primaryWinner, this.market.getLocationInHyperspace())) {
            return;
        }
        int payment = 0;
        float fpDestroyed = 0.0f;
        for (CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
            if (this.enemy != otherFleet.getFaction()) continue;
            float \u8d4f\u91d1 = 0.0f;
            for (FleetMemberAPI loss : Misc.getSnapshotMembersLost(otherFleet)) {
                float mult = Misc.getSizeNum(loss.getHullSpec().getHullSize());
                \u8d4f\u91d1 += mult * (float)this.baseBounty;
                fpDestroyed += (float)loss.getFleetPointCost();
            }
            payment += (int)(\u8d4f\u91d1 * battle.getPlayerInvolvementFraction());
        }
        if (payment > 0) {
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep;
            Global.getSector().getPlayerFleet().getCargo().getCredits().add(payment);
            float repFP = (int)(fpDestroyed * battle.getPlayerInvolvementFraction());
            float fDelta = 0.0f;
            float pDelta = 0.0f;
            if (repFP < 30.0f) {
                fDelta = 0.01f;
                pDelta = 0.01f;
            } else if (repFP < 70.0f) {
                fDelta = 0.02f;
                pDelta = 0.02f;
            } else {
                fDelta = 0.02f;
                pDelta = 0.03f;
            }
            CoreReputationPlugin.MissionCompletionRep completionRepPerson = new CoreReputationPlugin.MissionCompletionRep(pDelta, this.getRewardLimitPerson(), 0.0f, null);
            CoreReputationPlugin.MissionCompletionRep completionRepFaction = new CoreReputationPlugin.MissionCompletionRep(fDelta, this.getRewardLimitFaction(), 0.0f, null);
            boolean addContacts = this.latestResult == null;
            this.latestResult = new BountyResult(payment, battle.getPlayerInvolvementFraction(), null, null);
            if (pDelta != 0.0f) {
                this.latestResult.repPerson = rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)completionRepPerson, null, true, false), this.getPerson());
            }
            if (completionRepFaction.successDelta != 0.0f) {
                this.latestResult.repFaction = rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)completionRepFaction, null, true, false), this.getPerson().getFaction().getId());
            }
            this.sendUpdateIfPlayerHasIntel((Object)this.latestResult, false);
            if (addContacts) {
                this.addPotentialContacts(null);
            }
        }
    }

    public static class BountyResult {
        public int payment;
        public float fraction;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult repFaction;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult repPerson;

        public BountyResult(int payment, float fraction, ReputationActionResponsePlugin.ReputationAdjustmentResult repPerson, ReputationActionResponsePlugin.ReputationAdjustmentResult repFaction) {
            this.payment = payment;
            this.fraction = fraction;
            this.repFaction = repFaction;
            this.repPerson = repPerson;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        BOUNTY,
        DONE;

    }
}

