/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaidSecretOutpostMission
extends HubMissionWithBarEvent {
    public static float MISSION_DAYS = 120.0f;
    public static int RAID_DIFFICULTY = 48;
    public static int MARINES_REQUIRED = RAID_DIFFICULTY / 2;
    public static float MIN_VALUE = 80000.0f;
    public static float MAX_VALUE = 140000.0f;
    protected MarketAPI market;
    protected PersonAPI person;
    protected PlanetAPI planet;
    protected int goodsAmount;
    protected CommodityOnMarketAPI com;
    protected int quantity;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$rsom_ref")) {
            return false;
        }
        this.resetSearch();
        this.requireSystemTags(ReqMode.ANY, "theme_remnant_suppressed", "theme_derelict", "theme_misc", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_special");
        this.requireSystemInInnerSector();
        this.requirePlanetNotGasGiant();
        this.requirePlanetConditions(ReqMode.NOT_ANY, "decivilized");
        this.requirePlanetUnpopulated();
        this.preferPlanetNotFullySurveyed();
        this.preferPlanetUnexploredRuins();
        this.preferPlanetInDirectionOfOtherMissions();
        this.planet = this.pickPlanet();
        if (this.planet == null) {
            return false;
        }
        this.person = this.getPerson();
        if (this.person == null) {
            return false;
        }
        this.market = this.person.getMarket();
        if (this.market == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_OUTPOST);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.makeImportant(this.planet, "$rsom_targetPlanet", Stage.GO_TO_OUTPOST);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_OUTPOST, (Object)Stage.COMPLETED, "$rsom_raidedOutpost");
        this.setNoAbandon();
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        this.requireCommodityIllegal();
        this.requireCommodityDemandAtLeast(1);
        this.com = this.pickCommodity();
        if (this.com == null) {
            return false;
        }
        float value = MIN_VALUE + this.getQuality() * (MAX_VALUE - MIN_VALUE);
        this.quantity = RaidSecretOutpostMission.getRoundNumber((value *= 0.9f + this.genRandom.nextFloat() * 0.2f) / this.com.getCommodity().getBasePrice());
        if (this.quantity < 10) {
            this.quantity = 10;
        }
        this.setRepFactionChangesNone();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$rsom_contactName", this.person.getNameString());
        this.set("$rsom_market", this.market.getName());
        this.set("$rsom_planetId", this.planet.getId());
        this.set("$rsom_planetName", this.planet.getName());
        this.set("$rsom_systemName", this.planet.getStarSystem().getNameWithLowercaseType());
        this.set("$rsom_dist", this.getDistanceLY(this.planet));
        this.set("$rsom_product", this.com.getCommodity().getLowerCaseName());
        this.set("$rsom_productID", this.com.getCommodity().getId());
        this.set("$rsom_quantity", this.quantity);
        this.set("$rsom_marinesReq", MARINES_REQUIRED);
        this.set("$rsom_raidDifficulty", RAID_DIFFICULTY);
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("giveOutpostPlunder".equals(action)) {
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_OUTPOST) {
            info.addPara(String.valueOf(this.getGoToPlanetTextPre(this.planet)) + "\uff0c\u4f7f\u7528\u8bc6\u522b\u7801\u7ed5\u8fc7\u5176\u9632\u5fa1\u7cfb\u7edf\u4ee5\u7a81\u88ad\u5e76\u63a0\u593a " + this.com.getCommodity().getLowerCaseName() + " \u5176\u4f4d\u4e8e\u4e00\u5904\u9690\u85cf\u7684\u524d\u54e8\u7ad9\u3002" + "\u643a\u5e26\u81f3\u5c11 %s \u540d\u9646\u6218\u961f\u5458\u4ee5\u786e\u4fdd\u6210\u529f\u3002", opad, h, Misc.getWithDGS(MARINES_REQUIRED));
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_OUTPOST) {
            info.addPara(this.getGoToPlanetTextShort(this.planet), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u7a81\u88ad\u79d8\u5bc6\u524d\u54e8\u7ad9";
    }

    @Override
    public String getBlurbText() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_OUTPOST,
        COMPLETED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        BASIC,
        DECIV;

    }
}

