/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.procgen.themes.MiscellaneousThemeGenerator;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoverAPlanetkiller
extends HubMissionWithSearch {
    public static boolean startedAtPather() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$pk_startedAtPather");
    }

    public static boolean startedAtNexus() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$pk_startedAtNexus");
    }

    public static boolean gotDataFromMysteryAI() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean("$pk_gotDataFromMysteryAI");
    }

    public static CampaignFleetAPI getNexus() {
        return (CampaignFleetAPI)Global.getSector().getPersistentData().get(MiscellaneousThemeGenerator.PK_NEXUS_KEY);
    }

    public StarSystemAPI getNexusSystem() {
        CampaignFleetAPI nexus = RecoverAPlanetkiller.getNexus();
        if (nexus != null && nexus.isAlive()) {
            return nexus.getStarSystem();
        }
        return null;
    }

    public static MarketAPI getTundraMarket() {
        PlanetAPI p = RecoverAPlanetkiller.getTundra();
        if (p == null) {
            return null;
        }
        return p.getMarket();
    }

    public static PlanetAPI getTundra() {
        return (PlanetAPI)Global.getSector().getPersistentData().get(MiscellaneousThemeGenerator.PK_PLANET_KEY);
    }

    public static StarSystemAPI getPKSystem() {
        return (StarSystemAPI)Global.getSector().getPersistentData().get(MiscellaneousThemeGenerator.PK_SYSTEM_KEY);
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        this.setPersonOverride(null);
        this.setStoryMission();
        this.setNoAbandon();
        if (!this.setGlobalReference("$pk_ref", "$pk_inProgress")) {
            return false;
        }
        CampaignFleetAPI nexus = RecoverAPlanetkiller.getNexus();
        if (nexus != null && nexus.isAlive()) {
            this.makeImportant(nexus, "$pk_nexus", Stage.GO_TO_NEXUS);
        }
        if (RecoverAPlanetkiller.startedAtNexus()) {
            this.setStartingStage((Object)Stage.RECOVER_PK);
        } else {
            if (nexus == null || !nexus.isAlive() || this.getNexusSystem() == null) {
                return false;
            }
            this.setStartingStage((Object)Stage.GO_TO_NEXUS);
        }
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setRepPenaltyFaction(Float.valueOf(0.0f));
        this.setRepPenaltyPerson(Float.valueOf(0.0f));
        this.connectWithGlobalFlag((Object)Stage.GO_TO_NEXUS, (Object)Stage.RECOVER_PK, "$pk_nexusDataGained");
        if (nexus != null) {
            this.connectWithEntityNotAlive((Object)Stage.GO_TO_NEXUS, (Object)Stage.RECOVER_PK, nexus);
        }
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$pk_completed");
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$pk_recovered", true);
        this.triggerSetGlobalMemoryValue("$pk_missionCompleted", true);
        this.endTrigger();
        return true;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map, Object currentStage) {
        if (currentStage == Stage.RECOVER_PK) {
            return RecoverAPlanetkiller.getPKSystem().getCenter();
        }
        return super.getMapLocation(map, currentStage);
    }

    @Override
    protected void endFailureImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
    }

    @Override
    protected void updateInteractionDataImpl() {
        CampaignFleetAPI nexus = RecoverAPlanetkiller.getNexus();
        StarSystemAPI ns = this.getNexusSystem();
        StarSystemAPI pks = RecoverAPlanetkiller.getPKSystem();
        if (this.getCurrentStage() != null) {
            this.set("$pk_stage", ((Enum)this.getCurrentStage()).name());
        }
        if (ns != null) {
            this.set("$pk_nexusSystemName", ns.getNameWithLowercaseTypeShort());
        }
        if (pks != null) {
            this.set("$pk_pkSystemName", pks.getNameWithLowercaseTypeShort());
        }
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        block1: {
            StarSystemAPI pks;
            float opad;
            block2: {
                block0: {
                    opad = 10.0f;
                    Color h = Misc.getHighlightColor();
                    if (this.currentStage != Stage.GO_TO_NEXUS) break block0;
                    StarSystemAPI ns = this.getNexusSystem();
                    if (ns == null) break block1;
                    info.addPara("\u6536\u96c6\u5173\u4e8e \u4e00\u767e\u591a\u661f\u5386\u5e74\u524d\uff0c\u5728 \u7b2c\u4e00\u6b21 AI \u6218\u4e89\u4e2d \u6d88\u5931\u5728 \u901f\u5b50\u79d1\u6280 \u63a7\u5236\u661f\u57df\u7684 \u9738\u4e3b \u8230\u961f\u7684\u4fe1\u606f\u3002\u4f20\u8a00\u8be5\u8230\u961f\u643a\u5e26\u7740\u4e00\u679a \u884c\u661f\u6740\u624b\u3002", opad);
                    info.addPara("\u6b64\u4fe1\u606f\u5e94\u8be5\u88ab\u5b58\u5728\u4e00\u4e2a \u4f59\u8f89\u4e2d\u67a2 \u7684\u6570\u636e\u5e93\u4e2d\uff0c\u8be5\u4e2d\u67a2\u4f4d\u4e8e" + ns.getNameWithLowercaseType() + "\u3002", opad);
                    break block1;
                }
                if (this.currentStage != Stage.RECOVER_PK) break block1;
                pks = RecoverAPlanetkiller.getPKSystem();
                if (pks == null) break block1;
                if (!RecoverAPlanetkiller.startedAtNexus()) break block2;
                info.addPara("\u4f60\u5df2\u7ecf\u6467\u6bc1\u4e86\u4e00\u4e2a\u4f59\u8f89\u4e2d\u67a2\uff0c\u4e14\u6062\u590d\u4e86\u67d0\u652f\u9738\u4e3b\u8230\u961f\u53ef\u80fd\u643a\u5e26\u7740\u4e00\u4e2a\u884c\u661f\u6740\u624b\u7684\u6570\u636e\u3002", opad);
                info.addPara("\u4e00\u6bb5\u65e5\u5fd7\u8bb0\u5f55\u5199\u9053\u4e00\u5f3a\u5927\u7684 \u4f59\u8f89\u79e9\u5e8f \u88ab\u6d3e\u51fa\u8fdb\u884c\u8ffd\u51fb\uff1b\u6700\u540e\u7684\u8d85\u6ce2\u8bb0\u5f55\u663e\u793a\u5176\u4f4d\u4e8e" + pks.getNameWithLowercaseTypeShort() + "\u3002 \u6b64\u65e5\u5fd7\u8bb0\u5f55\u6765\u81ea\u4e00\u767e\u591a\u661f\u5386\u5e74\u524d\u7684 \u7b2c\u4e00\u6b21 AI \u6218\u4e89 \u4e2d\u3002", opad);
                if (!RecoverAPlanetkiller.gotDataFromMysteryAI()) break block1;
                info.addPara("\u4e00\u4e2a\u795e\u79d8\u7684\u58f0\u97f3\uff0c\u6216\u8bb8\u662f\u67d0\u79cd AI\uff0c\u544a\u77e5\u4e86\u4f60" + pks.getNameWithLowercaseTypeShort() + "\u7684\u5730\u70b9\uff0c\u5e76\u6697\u793a \u884c\u661f\u6740\u624b \u4e5f\u53ef\u5728\u8be5\u5904\u627e\u5230\u3002", opad);
                info.addPara("\u6216\u8bb8\u8fd9 AI \u4e5f\u662f\u4e3a\u4e86 '\u66f4\u52a0\u6109\u60a6\uff01' \u800c\u6ca1\u6709\u63d0\u4f9b\u66f4\u591a\u5177\u4f53\u7ec6\u8282\u3002", opad);
                break block1;
            }
            info.addPara("\u4f59\u8f89\u4e2d\u67a2\u7ad9\u6570\u636e\u5e93\u5b58\u50a8\u6709\u636e\u4f20\u643a\u5e26\u4e86\u884c\u661f\u6740\u624b\u7684 \u9738\u4e3b \u8230\u961f\u7684\u76f8\u5173\u4fe1\u606f\u3002", opad);
            info.addPara("\u4e00\u6bb5\u65e5\u5fd7\u8bb0\u5f55\u5199\u9053\u4e00\u5f3a\u5927\u7684 \u4f59\u8f89\u79e9\u5e8f \u88ab\u6d3e\u51fa\u8fdb\u884c\u8ffd\u51fb\uff1b\u6700\u540e\u7684\u8d85\u6ce2\u8bb0\u5f55\u663e\u793a\u5176\u4f4d\u4e8e" + pks.getNameWithLowercaseTypeShort() + "\u3002 \u6b64\u65e5\u5fd7\u8bb0\u5f55\u6765\u81ea\u4e00\u767e\u591a\u661f\u5386\u5e74\u524d\u7684 \u7b2c\u4e00\u6b21 AI \u6218\u4e89 \u4e2d\u3002", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_NEXUS) {
            StarSystemAPI ns = this.getNexusSystem();
            if (ns != null) {
                info.addPara("\u4ece\u4f59\u8f89\u4e2d\u67a2\u56de\u6536\u6570\u636e\u3002\u5730\u70b9" + ns.getNameWithLowercaseTypeShort(), tc, pad);
            }
            return true;
        }
        if (this.currentStage == Stage.RECOVER_PK) {
            StarSystemAPI pks = RecoverAPlanetkiller.getPKSystem();
            if (pks != null) {
                info.addPara("\u8c03\u67e5" + pks.getNameWithLowercaseTypeShort(), tc, pad);
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getMissionTypeNoun() {
        return "task";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    @Override
    public String getBaseName() {
        return "\u730e\u6237\u5ea7\u4e4b\u9570";
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.acceptImpl(dialog, memoryMap);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (action.equals("showNexusSystem")) {
            StarSystemAPI system = this.getNexusSystem();
            if (system != null) {
                dialog.getVisualPanel().showMapMarker(system.getHyperspaceAnchor(), system.getNameWithLowercaseTypeShort(), this.getFactionForUIColors().getBaseUIColor(), true, this.getIcon(), null, this.getIntelTags(null));
            }
            return true;
        }
        if (action.equals("hideNexusSystem")) {
            dialog.getVisualPanel().removeMapMarkerFromPersonInfo();
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_NEXUS,
        RECOVER_PK,
        COMPLETED,
        FAILED;

    }
}

