/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class RuinsDataSwapMission
extends HubMissionWithBarEvent {
    public static float MISSION_DAYS = 120.0f;
    public static int RAID_DIFFICULTY = 60;
    public static int MARINES_REQUIRED = RAID_DIFFICULTY / 2;
    protected MarketAPI market;
    protected PersonAPI person;
    protected PlanetAPI planet;
    protected String targetWithArticle;
    protected String target;
    protected String megacorp;
    protected Variation variation;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$rdsm_ref")) {
            return false;
        }
        this.targetWithArticle = this.pickOne("\u4e00\u5904 \u6587\u5e93", "\u4e00\u5904 \u6570\u636e\u4e2d\u5fc3", "\u4e00\u5904 \u6863\u6848\u5e93", "\u4e00\u5904 \u5b9e\u9a8c\u5ba4");
        this.target = this.targetWithArticle.substring(this.targetWithArticle.indexOf(" ") + 1);
        this.megacorp = this.pickOne("\u8f68\u9053\u5de5\u5382\u5236\u9020\u516c\u53f8", "\u6bd4\u83b1\u7a7a\u95f4\u96c6\u56e2", "\u54c8\u65af\u6cf0\u4e4c\u65af\u5de5\u4e1a", "\u53cc\u5b50\u53f6\u7ec4\u7ec7", "\u5927\u718a\u5ea7\u96c6\u56e2");
        this.resetSearch();
        this.requireSystemTags(ReqMode.ANY, "theme_remnant_suppressed", "theme_derelict", "theme_misc", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_special");
        this.requirePlanetUnpopulated();
        this.requirePlanetWithRuins();
        this.preferPlanetNotFullySurveyed();
        this.preferPlanetUnexploredRuins();
        this.preferPlanetInDirectionOfOtherMissions();
        this.planet = this.pickPlanet();
        if (this.planet == null) {
            return false;
        }
        this.person = this.getPerson();
        if (this.person == null) {
            return false;
        }
        this.market = this.person.getMarket();
        if (this.market == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_RUINS);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.makeImportant(this.planet, "$rdsm_targetPlanet", Stage.GO_TO_RUINS);
        this.makeImportant(this.person, "$rdsm_contact", Stage.RETURN);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_RUINS, (Object)Stage.RETURN, "$rdsm_gotData");
        this.connectWithGlobalFlag((Object)Stage.RETURN, (Object)Stage.COMPLETED, "$rdsm_returnedData");
        this.setNoAbandon();
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[]{Stage.RETURN});
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.variation = this.planet.hasCondition("decivilized") ? Variation.DECIV : Variation.BASIC;
        return true;
    }

    protected void updateInteractionDataImpl() {
        this.set("$rdsm_contactName", this.person.getNameString());
        this.set("$rdsm_megacorpName", this.megacorp);
        this.set("$rdsm_market", this.market.getName());
        this.set("$rdsm_target", this.target);
        this.set("$rdsm_planetId", this.planet.getId());
        this.set("$rdsm_planetName", this.planet.getName());
        this.set("$rdsm_systemName", this.planet.getStarSystem().getNameWithLowercaseType());
        this.set("$rdsm_dist", this.getDistanceLY(this.planet));
        this.set("$rdsm_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$rdsm_variation", (Object)this.variation);
        if (this.variation == Variation.DECIV) {
            this.set("$rdsm_marinesReq", MARINES_REQUIRED);
            this.set("$rdsm_raidDifficulty", RAID_DIFFICULTY);
        }
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_RUINS) {
            if (this.variation == Variation.DECIV) {
                info.addPara(String.valueOf(this.getGoToPlanetTextPre(this.planet)) + "\uff0c\u5e76\u6389\u5305 " + this.megacorp + " " + this.target + " \u9057\u8ff9\u5185\u7684\u6570\u636e\u6838\u5fc3\u3002\u6b64\u5730" + "\u5df2\u6587\u660e\u4e27\u5931\uff0c\u56e0\u6b64\u4f60\u9700\u8981\u643a\u5e26\u81f3\u5c11 %s " + "\u540d\u9646\u6218\u961f\u5458\u4ee5\u786e\u4fdd\u6210\u529f\u3002", opad, h, Misc.getWithDGS(MARINES_REQUIRED));
            } else {
                String extra = "";
                info.addPara(String.valueOf(this.getGoToPlanetTextPre(this.planet)) + "\uff0c\u5e76\u6389\u5305 " + this.megacorp + " " + this.target + " \u9057\u8ff9\u5185\u7684\u6570\u636e\u6838\u5fc3\u3002" + extra, opad);
            }
        } else if (this.currentStage == Stage.RETURN) {
            info.addPara(this.getReturnText(this.market), opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_RUINS) {
            info.addPara(this.getGoToPlanetTextShort(this.planet), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN) {
            info.addPara(this.getReturnTextShort(this.market), tc, pad);
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "\u6389\u5305\u9057\u8ff9\u6570\u636e\u6838\u5fc3";
    }

    public String getBlurbText() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_RUINS,
        RETURN,
        COMPLETED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        BASIC,
        DECIV;

    }
}

