/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.listeners.MarineLossesStatModifier;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.graid.GroundRaidObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityCodes
extends HubMissionWithBarEvent
implements ColonyPlayerHostileActListener,
MarineLossesStatModifier {
    public static float MARINE_LOSSES_MULT = 0.05f;
    public static float PROB_COMPLICATIONS = 0.5f;
    public static float PROB_PATROL_ENCOUNTER_AFTER = 0.5f;
    public static float MIN_DAYS = 30.0f;
    public static float MAX_DAYS = 90.0f;
    public static float BASE_PRICE = 30000.0f;
    protected int price;
    protected FactionAPI faction;
    protected int days;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverPost(this.pickOne(Ranks.POST_AGENT, Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
            this.setGiverImportance(this.pickImportance());
            this.setGiverFaction("pirates");
            this.setGiverTags("underworld");
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$seco_ref")) {
            return false;
        }
        this.requireMarketFactionNotPlayer();
        this.requireMarketFactionCustom(ReqMode.NOT_ANY, "decentralized");
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        MarketAPI market = this.pickMarket();
        if (market == null) {
            return false;
        }
        this.faction = market.getFaction();
        if (this.faction == null) {
            return false;
        }
        if (!this.setFactionMissionRef(this.faction, "$seco_ref")) {
            return false;
        }
        this.price = SecurityCodes.getRoundNumber(BASE_PRICE * (this.getQuality() + 0.9f + 0.2f * this.genRandom.nextFloat()) / this.getRewardMult());
        this.setStartingStage((Object)Stage.ACTIVE);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setNoAbandon();
        this.setRepPersonChangesVeryLow();
        this.setRepFactionChangesTiny();
        this.days = Math.round(MIN_DAYS + (MAX_DAYS - MIN_DAYS) * this.getQuality());
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.faction, "$seco_completed");
        this.setTimeLimit((Object)Stage.COMPLETED, this.days, null, new Object[0]);
        if (this.rollProbability(PROB_COMPLICATIONS)) {
            this.triggerComplicationBegin((Object)Stage.ACTIVE, HubMissionWithTriggers.ComplicationSpawn.EXITING_SYSTEM, createdAt.getStarSystem(), "pirates", "\u8be5\u5b89\u5168\u7801", "they", "\u8be5 " + this.faction.getPersonNamePrefix() + " \u5b89\u5168\u7801", 0, true, HubMissionWithTriggers.ComplicationRepImpact.NONE, null);
            this.triggerComplicationEnd(true);
        }
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$seco_barEvent", this.isBarEvent());
        this.set("$seco_price", Misc.getWithDGS(this.price));
        this.set("$seco_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$seco_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$seco_heOrShe", this.getPerson().getHeOrShe());
        this.set("$seco_days", this.days);
        this.set("$seco_faction", this.faction.getPersonNamePrefix());
        this.set("$seco_factionColor", this.faction.getBaseUIColor());
    }

    @Override
    public void addDescriptionForCurrentStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.ACTIVE) {
            FactionAPI f = this.faction;
            String percent = Math.round((1.0f - MARINE_LOSSES_MULT) * 100.0f) + "%";
            LabelAPI label = info.addPara("\u4f60\u5df2\u83b7\u5f97 %s \u5730\u9762\u90e8\u961f\u7684\u5b89\u5168\u7801\uff0c\u8fd9\u610f\u5473\u7740\u4f60\u53ef\u66f4\u597d\u5730 \u5236\u5b9a\u7a81\u88ad\u8ba1\u5212\uff0c\u4ece\u800c\u964d\u4f4e %s \u9646\u6218\u961f\u7684\u4f24\u4ea1\u3002", opad, f.getBaseUIColor(), f.getDisplayNameWithArticle(), percent);
            label.setHighlight(f.getDisplayNameWithArticleWithoutArticle(), percent);
            label.setHighlightColors(f.getBaseUIColor(), h);
            info.addPara("\u4ec5\u9002\u7528\u4e00\u6b21\u7a81\u88ad\uff0c\u5373\u4fbf\u4e0d\u4f7f\u7528\uff0c\u4e5f\u4f1a\u5728\u4e00\u6bb5\u65f6\u95f4\u540e\u5931\u6548\u3002", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        return false;
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.acceptImpl(dialog, memoryMap);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    public String getBaseName() {
        return "\u5b89\u5168\u7801 - " + this.faction.getDisplayName();
    }

    @Override
    public String getPostfixForState() {
        if (this.isEnding()) {
            return " (\u5df2\u5931\u6548) ";
        }
        return "";
    }

    @Override
    protected String getMissionTypeNoun() {
        return "\u60c5\u62a5";
    }

    @Override
    protected String getToCompleteText() {
        return "\u671f\u9650";
    }

    protected void checkCodesUsed(MarketAPI market) {
        if (market.getFaction() == this.faction) {
            if ((!this.isEnded() || this.isEnding()) && this.rollProbability(PROB_PATROL_ENCOUNTER_AFTER)) {
                DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
                e.setDelayShort();
                e.setLocationCoreOnly(true, this.faction.getId());
                e.beginCreate();
                e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, this.faction.getId(), "patrolLarge", new Vector2f());
                e.triggerSetAdjustStrengthBasedOnQuality(true, this.getQuality());
                e.triggerSetPatrol();
                e.triggerSetStandardAggroInterceptFlags();
                e.triggerSetFleetMemoryValue("$seco_marketName", market.getName());
                e.triggerSetFleetGenericHailPermanent("SECOPatrolHail");
                e.endCreate();
            }
            Global.getSector().getListenerManager().removeListener(this);
            this.endAfterDelay();
        }
    }

    @Override
    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
        this.checkCodesUsed(market);
    }

    @Override
    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
        this.checkCodesUsed(market);
    }

    @Override
    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    @Override
    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    @Override
    public void modifyMarineLossesStatPreRaid(MarketAPI market, List<GroundRaidObjectivePlugin> objectives, MutableStat stat) {
        if (market.getFaction() == this.faction) {
            stat.modifyMult("seco_mult", MARINE_LOSSES_MULT, "\u5b89\u5168\u7801");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        ACTIVE,
        COMPLETED;

    }
}

