/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class SmugglingMission
extends HubMissionWithBarEvent {
    public static float MISSION_DAYS = 60.0f;
    public static float MIN_VALUE = 10000.0f;
    public static float MAX_VALUE = 100000.0f;
    protected MarketAPI market;
    protected CommodityOnMarketAPI com;
    protected int quantity;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person;
        if (barEvent) {
            this.setGiverRank(Ranks.CITIZEN);
            this.setGiverPost(this.pickOne(Ranks.POST_SMUGGLER, Ranks.POST_GANGSTER, Ranks.POST_FENCE, Ranks.POST_CRIMINAL));
            this.setGiverImportance(this.pickImportance());
            this.setGiverFaction("pirates");
            this.setGiverTags("underworld");
            this.findOrCreateGiver(createdAt, false, false);
        }
        if ((person = this.getPerson()) == null) {
            return false;
        }
        if (!this.setPersonMissionRef(person, "$smug_ref")) {
            return false;
        }
        if (barEvent) {
            this.setGiverIsPotentialContactOnSuccess();
        }
        this.requireMarketIsNot(createdAt);
        this.requireMarketFactionNotPlayer();
        this.requireMarketLocationNot(createdAt.getContainingLocation());
        this.requireMarketFactionCustom(ReqMode.NOT_ANY, "allowsTransponderOffTrade");
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        this.preferMarketInDirectionOfOtherMissions();
        this.requireCommodityIllegal();
        this.requireCommodityDemandAtLeast(1);
        this.com = this.pickCommodity();
        if (this.com == null) {
            return false;
        }
        this.market = this.com.getMarket();
        if (this.market == null) {
            return false;
        }
        float value = MIN_VALUE + this.getQuality() * (MAX_VALUE - MIN_VALUE);
        this.quantity = SmugglingMission.getRoundNumber((value *= 0.9f + this.genRandom.nextFloat() * 0.2f) / this.com.getCommodity().getBasePrice());
        if (this.quantity < 10) {
            this.quantity = 10;
        }
        if (!this.setMarketMissionRef(this.market, "$smug_ref")) {
            return false;
        }
        this.makeImportant(this.market, "$smug_target", Stage.SMUGGLE);
        this.setStartingStage((Object)Stage.SMUGGLE);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.market, "$smug_completed");
        this.setNoAbandon();
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        this.setCreditRewardWithBonus(BaseHubMission.CreditReward.LOW, (int)(value * 0.5f));
        this.triggerCreateMediumPatrolAroundMarket(this.market, (Object)Stage.SMUGGLE, 1.0f);
        return true;
    }

    protected void updateInteractionDataImpl() {
        this.set("$smug_barEvent", this.isBarEvent());
        this.set("$smug_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$smug_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$smug_commodityId", this.com.getId());
        this.set("$smug_commodityName", this.com.getCommodity().getLowerCaseName());
        this.set("$smug_quantity", Misc.getWithDGS(this.quantity));
        this.set("$smug_playerHasEnough", SmugglingMission.playerHasEnough(this.com.getId(), this.quantity));
        this.set("$smug_personName", this.getPerson().getNameString());
        this.set("$smug_systemName", this.market.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$smug_marketName", this.market.getName());
        this.set("$smug_marketOnOrAt", this.market.getOnOrAt());
        this.set("$smug_dist", this.getDistanceLY(this.market));
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.SMUGGLE) {
            info.addPara("\u5c06 %s \u5355\u4f4d\u7684 " + this.com.getCommodity().getLowerCaseName() + " \u5077\u8fd0\u5230 " + this.market.getName() + ", \u800c\u6b64\u5904\u4f4d\u4e8e " + this.market.getStarSystem().getNameWithLowercaseTypeShort() + ".", opad, h, Misc.getWithDGS(this.quantity));
            info.addPara("\u56e0\u76ee\u6807\u5f53\u5c40\u5df2\u7ecf\u5f97\u77e5\u8fd9\u6279\u6c34\u8d27\u5373\u5c06\u5165\u5883\uff0c\u6240\u4ee5\u5f53\u5730\u5de1\u903b\u961f\u5df2\u7ecf\u9ad8\u5ea6\u6212\u5907\u3002", opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.SMUGGLE) {
            info.addPara("\u5c06 %s \u5355\u4f4d\u7684 " + this.com.getCommodity().getLowerCaseName() + " \u5077\u8fd0\u5230 " + this.market.getName() + ", \u800c\u6b64\u5904\u4f4d\u4e8e " + this.market.getStarSystem().getNameWithLowercaseTypeShort(), pad, tc, h, Misc.getWithDGS(this.quantity));
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "\u8d70\u79c1 " + this.com.getCommodity().getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        SMUGGLE,
        COMPLETED,
        FAILED;

    }
}

