/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.eventide.DuelDialogDelegate;
import com.fs.starfarer.api.impl.campaign.eventide.DuelPanel;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwordOfEventide
extends HubMissionWithSearch {
    public static String SOE_MUSIC_STATE = "$soe_musicState";
    public static String SOE_STATE_PARTY = "party";
    public static String SOE_STATE_PRE_DUEL = "pre_duel";
    public static String SOE_STATE_DUEL = "duel";
    public static String SOE_STATE_POST_DUEL = "post_duel";
    public static String PARTY_CHATTER = "soe_party_chatter";
    public static String PARTY_MUSIC = "music_soe_party";
    public static String DUEL_MUSIC = "music_soe_fight";
    protected PersonAPI neriene_rao;
    protected PersonAPI caspian_sang;
    protected PersonAPI orcus_rao;
    protected MarketAPI eventide;
    public static float MISSION_DAYS = 120.0f;
    protected SOEMusicPlayer player = null;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$soe_ref", "$soe_inProgress")) {
            return false;
        }
        this.neriene_rao = this.getImportantPerson(People.NERIENE_RAO);
        if (this.neriene_rao == null) {
            return false;
        }
        this.caspian_sang = this.getImportantPerson(People.CASPIAN);
        if (this.caspian_sang == null) {
            return false;
        }
        this.orcus_rao = this.getImportantPerson(People.RAO);
        if (this.orcus_rao == null) {
            return false;
        }
        this.eventide = Global.getSector().getEconomy().getMarket("eventide");
        if (this.eventide == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_EVENTIDE);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setStoryMission();
        this.makeImportant(this.eventide, "$soe_invitedToBall", Stage.GO_TO_EVENTIDE);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$soe_completed");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        this.beginStageTrigger(new Object[]{Stage.GO_TO_EVENTIDE});
        this.triggerSetGlobalMemoryValuePermanent("$didEventideRaoBall", true);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("THEDUEL".equals(action)) {
            TextPanelAPI text = dialog.getTextPanel();
            text.addImage("misc", "THEDUEL");
            return true;
        }
        if ("addMusicPlayer".equals(action)) {
            if (!Global.getSector().hasTransientScript(SOEMusicPlayer.class)) {
                this.player = new SOEMusicPlayer();
                Global.getSector().addTransientScript(this.player);
                Global.getSector().getMemoryWithoutUpdate().set(SOE_MUSIC_STATE, SOE_STATE_PARTY);
            }
            return true;
        }
        if ("cleanUpMusicPlayer".equals(action)) {
            if (this.player != null) {
                this.player.stop();
            }
            return true;
        }
        if ("crowdGasp".equals(action)) {
            Global.getSoundPlayer().playUISound("soe_crowd_gasp", 1.0f, 1.0f);
            Global.getSector().getMemoryWithoutUpdate().set(SOE_MUSIC_STATE, SOE_STATE_PRE_DUEL);
            return true;
        }
        if ("postDuel".equals(action)) {
            Global.getSector().getMemoryWithoutUpdate().set(SOE_MUSIC_STATE, SOE_STATE_POST_DUEL);
            return true;
        }
        if ("beginDuel".equals(action)) {
            Global.getSector().getMemoryWithoutUpdate().set(SOE_MUSIC_STATE, SOE_STATE_DUEL);
            boolean playerSkilled = false;
            if (params.size() >= 2) {
                playerSkilled = params.get(1).getBoolean(memoryMap);
            }
            DuelPanel duelPanel = DuelPanel.createDefault(playerSkilled, true, "soe_ambience");
            dialog.showCustomVisualDialog(1024.0f, 700.0f, new DuelDialogDelegate(null, duelPanel, dialog, memoryMap, false));
            return true;
        }
        if ("beginTutorial".equals(action)) {
            boolean playerSkilled = false;
            if (params.size() >= 2) {
                playerSkilled = params.get(1).getBoolean(memoryMap);
            }
            DuelPanel duelPanel = DuelPanel.createTutorial(playerSkilled, "soe_ambience");
            dialog.showCustomVisualDialog(1024.0f, 700.0f, new DuelDialogDelegate(null, duelPanel, dialog, memoryMap, true));
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_EVENTIDE) {
            info.addPara("\u53bb Samarra \u661f\u7cfb\u5185\u7684 Eventide.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_EVENTIDE) {
            info.addPara("\u53bb Samarra \u661f\u7cfb\u5185\u7684 Eventide", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Princess of Persea";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    public static class SOEMusicPlayer
    implements EveryFrameScript {
        public boolean done = false;
        public String currState = null;

        public void advance(float amount) {
            String state = Global.getSector().getMemoryWithoutUpdate().getString(SOE_MUSIC_STATE);
            if (state != null && !state.equals(this.currState)) {
                if (SOE_STATE_PARTY.equals(state)) {
                    Global.getSoundPlayer().setSuspendDefaultMusicPlayback(true);
                    Global.getSoundPlayer().playCustomMusic(1, 1, PARTY_MUSIC, true);
                } else if (SOE_STATE_PRE_DUEL.equals(state)) {
                    Global.getSoundPlayer().setSuspendDefaultMusicPlayback(true);
                    Global.getSoundPlayer().pauseCustomMusic();
                } else if (SOE_STATE_DUEL.equals(state)) {
                    Global.getSoundPlayer().setSuspendDefaultMusicPlayback(true);
                    Global.getSoundPlayer().playCustomMusic(1, 1, DUEL_MUSIC, true);
                } else if (SOE_STATE_POST_DUEL.equals(state)) {
                    Global.getSoundPlayer().setSuspendDefaultMusicPlayback(true);
                    Global.getSoundPlayer().pauseCustomMusic();
                }
                this.currState = state;
            }
            if (SOE_STATE_PARTY.equals(state)) {
                Global.getSoundPlayer().playUILoop(PARTY_CHATTER, 1.0f, 1.0f);
            } else if (SOE_STATE_PRE_DUEL.equals(state)) {
                Global.getSoundPlayer().playUILoop(PARTY_CHATTER, 1.0f, 0.5f);
            }
            if (!Global.getSector().isPaused()) {
                this.stop();
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean runWhilePaused() {
            return true;
        }

        public void stop() {
            this.done = true;
            Global.getSoundPlayer().setSuspendDefaultMusicPlayback(false);
            Global.getSoundPlayer().restartCurrentMusic();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_EVENTIDE,
        COMPLETED;

    }
}

