/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.academy.GADepartments;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class BasicExampleGADataFromRuins
extends GABaseMission {
    public static float MISSION_DAYS = 120.0f;
    protected PlanetAPI planet;
    protected String target;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaData_ref")) {
            return false;
        }
        this.pickDepartment(GADepartments.INDUSTRIAL, GADepartments.SOCIAL);
        this.target = this.pickOne("library", "datavault", "archive", "laboratory");
        this.requireSystemTags(ReqMode.ANY, "theme_remnant_resurgent", "theme_remnant_suppressed", "theme_derelict", "theme_misc", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_remnant_secondary");
        this.requirePlanetUnpopulated();
        this.requirePlanetWithRuins();
        this.preferPlanetNotFullySurveyed();
        this.preferPlanetUnexploredRuins();
        this.planet = this.pickPlanet();
        if (this.planet == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_RUINS);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAIL_TIME});
        this.connectWithGlobalFlag((Object)Stage.GO_TO_RUINS, (Object)Stage.GET_IN_COMMS_RANGE, "$gaData_gotData");
        this.connectWithInRangeOfCommRelay((Object)Stage.GET_IN_COMMS_RANGE, (Object)Stage.COMPLETED);
        this.makeImportant(this.planet, "$gaData_targetPlanet", Stage.GO_TO_RUINS);
        this.setTimeLimit((Object)Stage.FAIL_TIME, MISSION_DAYS, this.planet.getStarSystem(), new Object[]{Stage.GET_IN_COMMS_RANGE});
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.beginWithinHyperspaceRangeTrigger(this.planet, 1.0f, false, new Object[]{Stage.GO_TO_RUINS});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolMedium", this.planet);
        this.triggerSetStandardAggroPirateFlags();
        this.triggerPickLocationAtInSystemJumpPoint(this.planet.getStarSystem());
        this.triggerSpawnFleetAtPickedLocation("$gaData_pirate", null);
        this.triggerOrderFleetPatrol(this.planet);
        this.endTrigger();
        return true;
    }

    protected void updateInteractionDataImpl() {
        this.set("$gaData_department", this.department);
        this.set("$gaData_target", this.target);
        this.set("$gaData_planetName", this.planet.getName());
        this.set("$gaData_systemName", this.planet.getStarSystem().getNameWithNoType());
        this.set("$gaData_dist", this.getDistanceLY(this.planet));
        this.set("$gaData_reward", Misc.getWithDGS(this.getCreditsReward()));
    }

    public void addDescriptionForCurrentStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_RUINS) {
            info.addPara("\u524d\u5f80 " + this.planet.getName() + " \u5e9f\u589f\u5e76\u627e\u56de\u6570\u636e\u3002", opad);
        } else if (this.currentStage == Stage.GET_IN_COMMS_RANGE) {
            info.addPara("\u53ea\u9700\u62b5\u8fbe\u4efb\u610f\u901a\u8baf\u4e2d\u7ee7\u5668\u7684\u6709\u6548\u8303\u56f4\u5373\u53ef\u83b7\u5f97\u5956\u52b1\u3002", opad);
        } else {
            super.addDescriptionForCurrentStage(info, width, height);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_RUINS) {
            info.addPara("\u524d\u5f80 " + this.planet.getName(), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GET_IN_COMMS_RANGE) {
            info.addPara("\u8fdb\u5165\u901a\u8baf\u4e2d\u7ee7\u5668\u7684\u6709\u6548\u8303\u56f4\u6765\u5b8c\u6210\u4efb\u52a1\u3002", tc, pad);
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "\u6570\u636e\u6062\u590d";
    }

    public String getBlurbText() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_RUINS,
        GET_IN_COMMS_RANGE,
        COMPLETED,
        FAIL_TIME;

    }
}

