/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.academy.GADepartments;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GABuyArtifact
extends GABaseMission {
    public static float RAID_DIFFICULTY = 100.0f;
    public static float MISSION_DAYS = 120.0f;
    public static float PROB_PIRATE_FLEET = 0.25f;
    public static float PROB_PATHER_FLEET = 0.33333334f;
    public static float PROB_TRITACH_FLEET = 0.5f;
    public static float PROB_PIRATE_VARIATION = 0.5f;
    protected MarketAPI market;
    protected Variation variation;
    protected PersonAPI contact;
    protected String item;
    protected int costNormal;
    protected int costHigh;
    protected int costVeryLow;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaBA_ref")) {
            return false;
        }
        if (this.getGlobalMemory().contains("$gaBA_playerOwes")) {
            return false;
        }
        this.pickDepartment(GADepartments.INDUSTRIAL, GADepartments.MILITARY, GADepartments.SCIENCE, GADepartments.WEIRD);
        this.variation = this.rollProbability(PROB_PIRATE_VARIATION) ? Variation.PIRATE : Variation.PATHER;
        this.resetSearch();
        if (this.variation == Variation.PIRATE) {
            this.requireMarketFaction("pirates");
        } else {
            this.requireMarketFaction("luddic_path", "luddic_church");
        }
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        this.requireMarketLocationNot("galatia");
        this.preferMarketInDirectionOfOtherMissions();
        this.market = this.pickMarket();
        if (this.market == null) {
            return false;
        }
        this.contact = this.variation == Variation.PIRATE ? this.findOrCreateCriminalTrader(this.market, true) : this.findOrCreateTrader("luddic_path", this.market, true);
        if (this.contact == null) {
            return false;
        }
        this.item = this.pickOne("\u4e00\u4e2a\u72ec\u7279\u7684 \u53ef\u518d\u751f\u7ed3\u6784\u5143\u4ef6", "\u4e00\u4e2a\u5148\u8fdb\u7684 \u76f8\u4f4d\u8f6c\u6362\u539f\u578b", "\u4e00\u4e2a\u5931\u4f20\u7684 \u6280\u672f\u5b9e\u4f8b", "\u4e00\u4e2a\u5b9e\u9a8c \u8239\u4f53 \u6750\u6599\u6837\u54c1", "\u4e00\u4e2a\u7f55\u89c1\u7684 \u7535\u529b\u7cfb\u7edf\u5143\u4ef6", "\u4e00\u4e2a \u4eba\u4e4b\u9886 \u65f6\u4ee3\u7684 \u953b\u9020\u7ec4\u4ef6", "\u4e00\u4e2a\u5c0f\u578b \u52a8\u91cf\u89e3\u8026\u5668", "\u4e00\u4e2a\u8ff7\u4eba\u7684 \u4f4e\u500d\u89c6\u91ce\u6295\u5f71\u4eea", "\u4e00\u4e2a\u5b9e\u9a8c\u6027\u7684 \u76f8\u4f4d\u8f6c\u6362\u5668\u5143\u4ef6", "\u4e00\u4e2a\u5206\u7c7b \u52d8\u63a2\u6837\u672c");
        this.setStartingStage((Object)Stage.GO_TO_MARKET);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_DECIV});
        this.makeImportant(this.contact, "$gaBA_contact", Stage.GO_TO_MARKET);
        this.makeImportant(this.getPerson(), "$gaBA_returnHere", Stage.RETURN_TO_ACADEMY);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_MARKET, (Object)Stage.RETURN_TO_ACADEMY, "$gaBA_needToReturn");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaBA_completed");
        this.setStageOnGlobalFlag((Object)Stage.FAILED, "$gaBA_failed");
        this.connectWithMarketDecivilized((Object)Stage.GO_TO_MARKET, (Object)Stage.FAILED_DECIV, this.market);
        if (WITH_TIME_LIMIT) {
            this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, this.market.getStarSystem(), new Object[]{Stage.RETURN_TO_ACADEMY});
        }
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.setDefaultGARepRewards();
        this.costNormal = this.genRoundNumber(40000, 50000);
        this.costHigh = this.genRoundNumber(70000, 80000);
        this.costVeryLow = this.genRoundNumber(5000, 8000);
        this.beginStageTrigger(new Object[]{Stage.FAILED, Stage.FAILED_DECIV});
        this.triggerSetGlobalMemoryValuePermanent("$gaBA_playerOwes", true);
        this.triggerSetGlobalMemoryValuePermanent("$gaBA_failedItem", this.getWithoutArticle(this.item));
        this.triggerSetGlobalMemoryValuePermanent("$gaBA_failedCredits", Misc.getWithDGS(this.costNormal));
        this.endTrigger();
        if (this.rollProbability(PROB_PIRATE_FLEET)) {
            this.beginWithinHyperspaceRangeTrigger(createdAt, 3.0f, true, new Object[]{Stage.RETURN_TO_ACADEMY});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolMedium", createdAt.getPrimaryEntity());
            this.triggerAutoAdjustFleetStrengthModerate();
            this.triggerSetStandardAggroPirateFlags();
            this.triggerFleetAllowLongPursuit();
            this.triggerSetFleetAlwaysPursue();
            this.triggerPickLocationTowardsPlayer(createdAt.getStarSystem().getHyperspaceAnchor(), 90.0f, GABuyArtifact.getUnits(1.5f));
            this.triggerSpawnFleetAtPickedLocation("$pwi_wantsItem", null);
            this.triggerSetFleetMemoryValue("$pwi_item", this.getWithoutArticle(this.item));
            this.triggerSetFleetMemoryValue("$pwi_credits", Misc.getWithDGS(this.genRoundNumber(10000, 15000)));
            this.triggerSetFleetMemoryValue("$pwi_missionFailTrigger", "GABAHandedOverItemFailMission");
            this.triggerOrderFleetInterceptPlayer();
            this.triggerFleetMakeImportant(null, Stage.RETURN_TO_ACADEMY);
            this.endTrigger();
        } else if (this.rollProbability(PROB_PATHER_FLEET)) {
            this.beginWithinHyperspaceRangeTrigger(createdAt, 3.0f, true, new Object[]{Stage.RETURN_TO_ACADEMY});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "luddic_path", "patrolMedium", createdAt.getPrimaryEntity());
            this.triggerAutoAdjustFleetStrengthModerate();
            this.triggerSetStandardAggroPirateFlags();
            this.triggerFleetAllowLongPursuit();
            this.triggerSetFleetAlwaysPursue();
            this.triggerPickLocationTowardsPlayer(createdAt.getStarSystem().getHyperspaceAnchor(), 90.0f, GABuyArtifact.getUnits(1.5f));
            this.triggerSpawnFleetAtPickedLocation("$pwi2_wantsItem", null);
            this.triggerSetFleetMemoryValue("$pwi2_item", this.getWithoutArticle(this.item));
            this.triggerSetFleetMemoryValue("$pwi2_missionFailTrigger", "GABAHandedOverItemFailMission");
            this.triggerOrderFleetInterceptPlayer();
            this.triggerFleetMakeImportant(null, Stage.RETURN_TO_ACADEMY);
            this.endTrigger();
        } else if (this.rollProbability(PROB_TRITACH_FLEET)) {
            this.beginWithinHyperspaceRangeTrigger(createdAt, 3.0f, true, new Object[]{Stage.RETURN_TO_ACADEMY});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "tritachyon", "taskForce", createdAt.getPrimaryEntity());
            this.triggerAutoAdjustFleetStrengthModerate();
            this.triggerFleetAllowLongPursuit();
            this.triggerPickLocationTowardsPlayer(createdAt.getStarSystem().getHyperspaceAnchor(), 90.0f, GABuyArtifact.getUnits(1.5f));
            this.triggerSpawnFleetAtPickedLocation("$ttwi_wantsItem", null);
            this.triggerSetFleetMemoryValue("$ttwi_item", this.getWithoutArticle(this.item));
            this.triggerSetFleetMemoryValue("$ttwi_credits", Misc.getWithDGS(this.genRoundNumber(120000, 150000)));
            this.triggerSetFleetMemoryValue("$ttwi_missionFailTrigger", "GABAHandedOverItemFailMission");
            this.triggerOrderFleetInterceptPlayer();
            this.triggerFleetMakeImportant(null, Stage.RETURN_TO_ACADEMY);
            this.endTrigger();
        }
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaBA_department", this.department);
        this.set("$gaBA_marketName", this.market.getName());
        this.set("$gaBA_onOrAt", this.market.getOnOrAt());
        this.set("$gaBA_contactName", this.contact.getNameString());
        this.set("$gaBA_raidDifficulty", Float.valueOf(RAID_DIFFICULTY));
        this.set("$gaBA_costVeryLow", Misc.getWithDGS(this.costVeryLow));
        this.set("$gaBA_costNormal", Misc.getWithDGS(this.costNormal));
        this.set("$gaBA_costHigh", Misc.getWithDGS(this.costHigh));
        this.set("$gaBA_systemName", this.market.getStarSystem().getNameWithNoType());
        this.set("$gaBA_dist", this.getDistanceLY(this.market));
        this.set("$gaBA_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaBA_variation", (Object)this.variation);
        this.set("$gaBA_aOrAnItem", this.item);
        this.set("$gaBA_item", this.getWithoutArticle(this.item));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_MARKET) {
            info.addPara(String.valueOf(this.getGoToMarketText(this.market)) + "\uff0c\u6765\u8d2d\u4e70 " + this.item + ", \u800c\u4f60\u9700\u8981\u8054\u7cfb\u7684\u76ee\u6807\u540d\u4e3a " + this.contact.getNameString() + ".", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara(String.valueOf(this.getReturnText("Galatia \u5b66\u9662")) + ".", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_MARKET) {
            info.addPara(this.getGoToMarketText(this.market), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara(this.getReturnTextShort("Galatia \u5b66\u9662"), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u8d2d\u4e70\u5236\u54c1";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_MARKET,
        RETURN_TO_ACADEMY,
        COMPLETED,
        FAILED,
        FAILED_DECIV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        PIRATE,
        PATHER;

    }
}

