/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GADeliverVIP
extends GABaseMission {
    public static float MISSION_DAYS = 60.0f;
    public static float PROB_KANTA = 0.1f;
    public static float PROB_MERC_KIDNAPPER = 0.5f;
    public static float PROB_PIRATE_KIDNAPPER = 0.5f;
    public static float SPECIFIC_FACTION_SUBJECT_EVENT_LIKELIHOOD = 2.0f;
    public static FactionData ALL_FACTIONS;
    public static Map<String, FactionData> FACTION_DATA;
    public static List<String> ALLOWED_FACTIONS;
    public static List<String> MERC_FACTIONS;
    protected StarSystemAPI system;
    protected MarketAPI destination;
    protected Variation variation;
    protected FactionAPI faction;
    protected String theMercFaction;
    protected String mercFactionId;
    protected String subjectRelation;
    protected String event;
    protected PersonAPI target;
    protected String kantaRelationFirstName;
    protected int piratePayment;
    protected int mercPayment;

    static {
        FACTION_DATA = new HashMap<String, FactionData>();
        ALLOWED_FACTIONS = new ArrayList<String>();
        MERC_FACTIONS = new ArrayList<String>();
        ALLOWED_FACTIONS.add("independent");
        ALLOWED_FACTIONS.add("persean");
        ALLOWED_FACTIONS.add("tritachyon");
        ALLOWED_FACTIONS.add("hegemony");
        ALLOWED_FACTIONS.add("luddic_church");
        MERC_FACTIONS.add("tritachyon");
        MERC_FACTIONS.add("hegemony");
        MERC_FACTIONS.add("sindrian_diktat");
        MERC_FACTIONS.add("luddic_church");
        ALL_FACTIONS = new FactionData();
        GADeliverVIP.ALL_FACTIONS.subjects = new String[]{"\u5b69\u5b50", "\u513f\u5b50", "\u5973\u513f", "\u4f84\u5973", "\u4f84\u5b50", "\u88ab\u76d1\u62a4\u4eba"};
        GADeliverVIP.ALL_FACTIONS.events = new String[]{"\u53c2\u52a0\u5a5a\u793c", "\u53c2\u52a0\u846c\u793c", "\u4f7f\u5176\u91cd\u805a", "\u53c2\u4e0e\u8bc9\u8bbc", "\u987a\u5229\u8fdb\u884c\u624b\u672f", "\u53c2\u4e0e\u5bb6\u5ead\u805a\u4f1a", "\u627f\u8ba4\u5176\u4e3a\u5ae1\u51fa"};
        FactionData luddic = new FactionData();
        FACTION_DATA.put("luddic_church", luddic);
        luddic.subjects = new String[]{"\u6559\u5b50", "\u6559\u5973", "\u6559\u5b50", "\u5b66\u5f92"};
        luddic.events = new String[]{"\u8fdb\u884c\u7cbe\u795e\u7597\u517b", "\u5fcf\u6094\u5e76\u9690\u5c45\u4ed6\u4e61", "\u6b65\u5165 '\u5362\u5fb7\u4e4b\u8def'", "\u6388\u4e88\u795e\u804c", "\u4f7f\u5176\u83b7\u5f97\u795d\u798f", "\u53c2\u4e0e\u51a5\u60f3", "\u8fdb\u884c\u795d\u5723", "\u8fdb\u884c\u7948\u7977", "\u89c1\u8bc1\u795e\u8ff9", "\u53c2\u4e0e\u4eea\u5f0f", "\u53c2\u4e0e\u6388\u6212\u4eea\u5f0f", "\u53c2\u4e0e\u658b\u6212"};
        FactionData hegemony = new FactionData();
        FACTION_DATA.put("hegemony", hegemony);
        hegemony.subjects = new String[]{"\u88ab\u76d1\u62a4\u4eba"};
        hegemony.events = new String[]{"\u8fdb\u884c\u5165\u804c\u57f9\u8bad", "\u53c2\u4e0e\u5b66\u5458\u57f9\u8bad", "\u53c2\u4e0e\u751f\u5b58\u8bad\u7ec3", "\u53c2\u89c2\u519b\u8230\u4e0b\u6c34", "\u53c2\u4e0e COMSEC \u7684\u9762\u8bd5", "\u53c2\u4e0e\u7eaa\u5ff5\u6d3b\u52a8", "\u53c2\u4e0e\u519b\u56e2\u7eaa\u5ff5\u65e5"};
        FactionData tritach = new FactionData();
        FACTION_DATA.put("tritachyon", tritach);
        tritach.subjects = new String[]{"\u88ab\u76d1\u62a4\u4eba"};
        tritach.events = new String[]{"\u8fdb\u884c\u63a7\u5236\u8bba\u589e\u5f3a\u624b\u672f", "\u8fdb\u884c\u57fa\u56e0\u6cbb\u7597", "\u8fdb\u884c\u4e00\u6b21\u5ea6\u5047\u4e4b\u65c5", "\u8fdb\u884c\u4f4e\u6e29\u4f11\u7720", "\u53c2\u4e0e\u5347\u804c\u5e86\u5178"};
        FactionData league = new FactionData();
        FACTION_DATA.put("persean", league);
        league.subjects = new String[]{"\u7ee7\u627f\u8005"};
        league.events = new String[]{"\u53c2\u4e0e\u52a0\u5195\u4eea\u5f0f", "\u89c2\u770b\u4e00\u573a\u620f\u5267\u7684\u9996\u6620", "\u53c2\u4e0e\u8054\u76df\u6295\u7968", "\u53c2\u4e0e\u7740\u9646\u7eaa\u5ff5\u4eea\u5f0f", "\u53c2\u4e0e\u4e00\u573a\u5e86\u5178\u4eea\u5f0f", "\u53c2\u4e0e\u4e00\u573a\u5927\u578b\u5e86\u5178", "\u53c2\u4e0e\u4e00\u573a\u5609\u5e74\u534e\u4f1a"};
        FactionData pirates = new FactionData();
        FACTION_DATA.put("pirates", pirates);
        pirates.subjects = new String[]{"\u65cf\u4eba", "\u514b\u9686\u53d8\u5f02\u4f53"};
        pirates.events = new String[]{"\u8fdb\u884c\u62bd\u8840\u5316\u9a8c", "\u529d\u8bf1\u5176\u52a0\u5165\u7ec4\u7ec7", "\u8fdb\u884c\u6539\u9020\u624b\u672f", "\u63a5\u53d7\u5bb6\u65cf\u7684\u60e9\u7f5a", "\u4e3a\u5176\u5206\u914d\u804c\u4f4d", "\"\u62c6\u89e3\""};
    }

    public String pickSubject(String factionId) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.genRandom);
        String[] stringArray = GADeliverVIP.ALL_FACTIONS.subjects;
        int n = GADeliverVIP.ALL_FACTIONS.subjects.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            picker.add(p, 1.0f);
            ++n2;
        }
        FactionData data = FACTION_DATA.get(factionId);
        if (data != null) {
            float w = Math.max(1.0f, (float)data.subjects.length) / Math.max(1.0f, picker.getTotal());
            w *= SPECIFIC_FACTION_SUBJECT_EVENT_LIKELIHOOD;
            String[] stringArray2 = data.subjects;
            int n3 = data.subjects.length;
            int n4 = 0;
            while (n4 < n3) {
                String p = stringArray2[n4];
                picker.add(p, w);
                ++n4;
            }
        }
        return (String)picker.pick();
    }

    public String pickEvent(String factionId) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.genRandom);
        String[] stringArray = GADeliverVIP.ALL_FACTIONS.events;
        int n = GADeliverVIP.ALL_FACTIONS.events.length;
        int n2 = 0;
        while (n2 < n) {
            String event = stringArray[n2];
            picker.add(event, 1.0f);
            ++n2;
        }
        FactionData data = FACTION_DATA.get(factionId);
        if (data != null) {
            float w = Math.max(1.0f, (float)data.events.length) / Math.max(1.0f, picker.getTotal());
            w *= SPECIFIC_FACTION_SUBJECT_EVENT_LIKELIHOOD;
            String[] stringArray2 = data.events;
            int n3 = data.events.length;
            int n4 = 0;
            while (n4 < n3) {
                String event = stringArray2[n4];
                picker.add(event, w);
                ++n4;
            }
        }
        return (String)picker.pick();
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        ImportantPeopleAPI.PersonDataAPI pd;
        MarketAPI kantasDen;
        if (!this.setGlobalReference("$gaVIP_ref")) {
            return false;
        }
        this.requireMarketFaction(ALLOWED_FACTIONS.toArray(new String[0]));
        this.requireMarketLocationNot("galatia");
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        this.preferMarketInDirectionOfOtherMissions();
        this.destination = this.pickMarket();
        this.variation = Variation.BASIC;
        if (this.rollProbability(PROB_KANTA) && (kantasDen = Global.getSector().getEconomy().getMarket("kantas_den")) != null) {
            this.destination = kantasDen;
            this.variation = Variation.KANTA;
            this.kantaRelationFirstName = Global.getSector().getFaction("pirates").createRandomPerson(this.genRandom).getName().getFirst();
        }
        if (this.destination == null) {
            return false;
        }
        this.faction = this.destination.getFaction();
        this.subjectRelation = this.pickSubject(this.faction.getId());
        if (this.subjectRelation == null) {
            return false;
        }
        this.event = this.pickEvent(this.faction.getId());
        if (this.event == null) {
            return false;
        }
        if (this.variation == Variation.BASIC) {
            this.target = this.findOrCreatePerson(this.faction.getId(), this.destination, true, Ranks.CITIZEN, Ranks.POST_ADMINISTRATOR, Ranks.POST_BASE_COMMANDER, Ranks.POST_STATION_COMMANDER, Ranks.POST_OUTPOST_COMMANDER, Ranks.POST_PORTMASTER, Ranks.POST_FACTION_LEADER);
        } else if (this.variation == Variation.KANTA && (pd = Global.getSector().getImportantPeople().getData("kanta")) != null) {
            this.target = pd.getPerson();
        }
        if (this.target == null) {
            return false;
        }
        this.system = this.destination.getStarSystem();
        this.setStartingStage((Object)Stage.DELIVER_VIP);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_DECIV});
        if (this.variation == Variation.KANTA) {
            this.setGlobalFlag("$gaVIP_workingForKanta", true, new Object[]{Stage.DELIVER_VIP});
        }
        this.makeImportant(this.destination, "$gaVIP_target", Stage.DELIVER_VIP);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaVIP_delivered");
        this.setStageOnGlobalFlag((Object)Stage.FAILED, "$gaVIP_failed");
        this.connectWithMarketDecivilized((Object)Stage.DELIVER_VIP, (Object)Stage.FAILED_DECIV, this.destination);
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        if (this.variation == Variation.BASIC) {
            this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
            this.setRepPenaltyPerson(Float.valueOf(0.07f));
            this.setRepPenaltyFaction(Float.valueOf(0.05f));
        } else {
            this.setCreditReward(BaseHubMission.CreditReward.HIGH);
            this.setRepPenaltyPerson(Float.valueOf(0.1f));
            this.setRepPenaltyFaction(Float.valueOf(0.05f));
        }
        this.setDefaultGARepRewards();
        this.piratePayment = this.genRoundNumber(40000, 60000);
        this.mercPayment = this.getCreditsReward() / 2;
        if (this.variation == Variation.BASIC && this.rollProbability(PROB_PIRATE_KIDNAPPER)) {
            this.beginWithinHyperspaceRangeTrigger(this.destination, 3.0f, false, new Object[]{Stage.DELIVER_VIP});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.HIGHER, "pirates", "patrolMedium", this.system);
            this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerSetStandardAggroPirateFlags();
            this.triggerFleetAllowLongPursuit();
            this.triggerSetFleetAlwaysPursue();
            this.triggerPickLocationTowardsPlayer(this.system.getHyperspaceAnchor(), 90.0f, GADeliverVIP.getUnits(1.5f));
            this.triggerSpawnFleetAtPickedLocation("$gaVIP_pirate", null);
            this.triggerOrderFleetInterceptPlayer();
            this.triggerFleetMakeImportant(null, Stage.DELIVER_VIP);
            this.endTrigger();
        }
        if (this.variation == Variation.KANTA && this.rollProbability(PROB_MERC_KIDNAPPER)) {
            this.mercFactionId = this.pickOne(MERC_FACTIONS.toArray(new String[0]));
            FactionAPI mercFaction = Global.getSector().getFaction(this.mercFactionId);
            this.theMercFaction = mercFaction.getDisplayNameWithArticle();
            this.beginWithinHyperspaceRangeTrigger(this.destination, 3.0f, true, new Object[]{Stage.DELIVER_VIP});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "patrolLarge", this.system);
            this.triggerSetFleetFaction("independent");
            this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerMakeHostileAndAggressive();
            this.triggerFleetMakeFaster(true, 2, true);
            this.triggerFleetAllowLongPursuit();
            this.triggerSetFleetAlwaysPursue();
            this.triggerPickLocationTowardsPlayer(this.system.getHyperspaceAnchor(), 90.0f, GADeliverVIP.getUnits(1.5f));
            this.triggerSpawnFleetAtPickedLocation("$gaVIP_merc", null);
            this.triggerOrderFleetInterceptPlayer();
            this.triggerFleetMakeImportant(null, Stage.DELIVER_VIP);
            this.endTrigger();
        }
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (action.equals("betrayal")) {
            DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
            e.setDelayMedium();
            e.setLocationInnerSector(false, "independent");
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_3, "mercenary", "patrolLarge", new Vector2f());
            e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.UNUSUALLY_HIGH);
            e.triggerFleetSetFaction("independent");
            e.triggerFleetMakeFaster(true, 2, true);
            e.triggerSetFleetFlag("$gaVIP_kantaConsequences");
            e.triggerMakeNoRepImpact();
            e.triggerSetStandardAggroInterceptFlags();
            e.endCreate();
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        if (this.getCurrentStage() != null) {
            this.set("$gaVIP_stage", ((Enum)this.getCurrentStage()).name());
        }
        this.set("$gaVIP_starName", this.system.getNameWithNoType());
        this.set("$gaVIP_marketName", this.destination.getName());
        this.set("$gaVIP_systemName", this.system.getNameWithLowercaseTypeShort());
        this.set("$gaVIP_subjectRelation", this.subjectRelation);
        this.set("$gaVIP_kantaRelationFirstName", this.kantaRelationFirstName);
        this.set("$gaVIP_VIP", this.target);
        this.set("$gaVIP_VIP_faction", this.target.getFaction().getId());
        this.set("$gaVIP_VIPName", this.target.getNameString());
        this.set("$gaVIP_VIPhisOrHer", this.target.getHisOrHer());
        this.set("$gaVIP_VIPPost", this.target.getPost().toLowerCase());
        this.set("$gaVIP_event", this.event);
        this.set("$gaVIP_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaVIP_piratePayment", Misc.getWithDGS(this.piratePayment));
        this.set("$gaVIP_mercPayment", Misc.getWithDGS(this.mercPayment));
        this.set("$gaVIP_theMercFaction", this.theMercFaction);
        this.set("$gaVIP_mercFactionId", this.mercFactionId);
        this.set("$gaVIP_timeLimit", (int)MISSION_DAYS);
        this.set("$gaVIP_variation", (Object)this.variation);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DELIVER_VIP) {
            if (this.variation == Variation.BASIC) {
                info.addPara("\u628a\u59d4\u6258\u4eba\u7684 " + this.subjectRelation + " \u62a4\u9001\u7ed9 " + this.target.getNameString() + ", \u4f4d\u7f6e\uff1a" + this.destination.getName() + ", \u4f4d\u4e8e " + this.system.getNameWithLowercaseTypeShort() + "\uff0c\u76ee\u7684\u662f" + this.event + "\u3002" + this.target.getNameString() + " \u662f\u4e00\u540d " + this.target.getPost().toLowerCase() + "\u3002", opad);
            } else if (this.variation == Variation.KANTA) {
                info.addPara("\u628a\u59d4\u6258\u4eba\u7684 " + this.subjectRelation + " \u62a4\u9001\u7ed9 " + this.kantaRelationFirstName + ", Kanta \u7684\u4f4d\u7f6e\uff1a" + this.destination.getName() + ", \u4f4d\u4e8e " + this.system.getNameWithLowercaseTypeShort() + "\uff0c\u76ee\u7684\u662f" + this.event + "\u3002" + this.kantaRelationFirstName + "\u662f Kanta \u5927\u4eba\u7684\u4eb2\u65cf\u4e4b\u4e00\u3002", opad);
            }
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.DELIVER_VIP) {
            info.addPara("\u62a4\u9001\u5b66\u751f\u5230 " + this.destination.getName() + ", \u4f4d\u4e8e " + this.system.getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u62a4\u9001 VIP";
    }

    public static class FactionData {
        public String[] subjects;
        public String[] events;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        DELIVER_VIP,
        COMPLETED,
        FAILED,
        FAILED_DECIV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        BASIC,
        KANTA;

    }
}

