/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GADepartments {
    public static String SOCIAL = "social";
    public static String INDUSTRIAL = "industrial";
    public static String MILITARY = "military";
    public static String SCIENCE = "science";
    public static String WEIRD = "weird";
    public static List<Department> departments = new ArrayList<Department>();

    static {
        GADepartments.add("\u53e4\u5730\u7403\u7814\u7a76\u5b66", SOCIAL);
        GADepartments.add("\u53e4\u5730\u7403\u4eba\u54f2\u5b66", SOCIAL);
        GADepartments.add("\u6b63\u4ea4\u51e0\u4f55\u5b66", SCIENCE, WEIRD);
        GADepartments.add("\u5168\u606f\u827a\u672f", SOCIAL);
        GADepartments.add("\u5929\u4f53\u5316\u5b66", INDUSTRIAL, SCIENCE);
        GADepartments.add("\u5929\u4f53\u6d4b\u91cf\u5b66", SCIENCE);
        GADepartments.add("AI \u9632\u5fa1\u7814\u7a76", SCIENCE, WEIRD, MILITARY);
        GADepartments.add("\u53e4\u4eba\u7c7b\u7814\u7a76", SOCIAL);
        GADepartments.add("\u7f51\u7edc\u533b\u7597\u6280\u672f", INDUSTRIAL, SOCIAL);
        GADepartments.add("\u63a7\u5236\u8bba\u751f\u7406\u5b66\u7814\u7a76", SCIENCE, SOCIAL);
        GADepartments.add("\u4eba\u53e3\u5fae\u79ef\u5206", SOCIAL);
        GADepartments.add("\u4eba\u4e4b\u9886\u793e\u4f1a\u5b66", SOCIAL);
        GADepartments.add("\u4eba\u4e4b\u9886\u5386\u53f2\u5b66", SOCIAL);
        GADepartments.add("\u73af\u5883\u5de5\u7a0b\u5b66", INDUSTRIAL);
        GADepartments.add("\u591a\u6837\u5316\u5de5\u7a0b\u5b66", INDUSTRIAL, WEIRD);
        GADepartments.add("\u91cd\u529b\u63a7\u5236\u5b66", INDUSTRIAL, SCIENCE, MILITARY);
        GADepartments.add("\u91cd\u529b\u52a8\u529b\u5b66", SCIENCE);
        GADepartments.add("\u5168\u606f\u827a\u672f\u7814\u7a76", SOCIAL);
        GADepartments.add("\u8d85\u7a7a\u95f4\u7269\u7406\u5b66", SCIENCE);
        GADepartments.add("LAMBDA - F \u7814\u7a76", SCIENCE, WEIRD);
        GADepartments.add("\u7eb3\u7c73\u6280\u672f\u5de5\u7a0b", INDUSTRIAL);
        GADepartments.add("\u7eb3\u7c73\u751f\u7269\u6280\u672f\u5b9e\u9a8c", INDUSTRIAL, SCIENCE, WEIRD);
        GADepartments.add("\u975e\u7ebf\u6027\u6570\u5b66", SCIENCE, WEIRD);
        GADepartments.add("\u8f68\u9053\u5efa\u7b51\u5b66", SOCIAL, INDUSTRIAL, MILITARY);
        GADepartments.add("\u6269\u5c55\u7eaa\u5143\u54f2\u5b66", SOCIAL);
        GADepartments.add("\u82f1\u4ed9\u5ea7\u793e\u4f1a\u5b66", SOCIAL);
        GADepartments.add("\u76f8\u4f4d\u7269\u7406\u5b66", SCIENCE);
        GADepartments.add("\u91cf\u5b50\u5316\u5b66", SCIENCE, WEIRD);
        GADepartments.add("N - \u7a7a\u95f4\u5171\u632f\u5b9e\u9a8c", SCIENCE, WEIRD);
        GADepartments.add("\u7279\u8272\u9986\u85cf\u5e93\u5efa\u8bbe\u7814\u7a76", SOCIAL, INDUSTRIAL, SCIENCE, WEIRD, MILITARY);
        GADepartments.add("Tau \u8d85\u7269\u7406\u5b66", SCIENCE, WEIRD);
        GADepartments.add("Talos \u6536\u5bb9\u65b9\u6848", WEIRD);
        GADepartments.add("Templeman \u8d85\u6ce2\u7406\u8bba", WEIRD);
        GADepartments.add("\u4eba\u7c7b\u751f\u7269\u5b66", SCIENCE);
        GADepartments.add("\u5b87\u5b99\u751f\u7269\u5b66", SCIENCE);
    }

    public static void add(String name, String ... tags) {
        departments.add(new Department(name, tags));
    }

    public static String pick(Random random, ReqMode mode, String ... tags) {
        Department d2;
        WeightedRandomPicker<Department> picker = new WeightedRandomPicker<Department>(random);
        HashSet<String> tagSet = new HashSet<String>();
        tagSet.addAll(Arrays.asList(tags));
        for (Department d2 : departments) {
            if (!GADepartments.matchesTags(mode, tagSet, d2.tags)) continue;
            picker.add(d2);
            break;
        }
        d2 = (Department)picker.pick();
        if (d2 == null) {
            d2 = departments.get(0);
        }
        return d2.name;
    }

    protected static boolean matchesTags(ReqMode mode, Collection<String> tags, Collection<String> set) {
        switch (mode) {
            case ALL: {
                for (String tag : tags) {
                    if (set.contains(tag)) continue;
                    return false;
                }
                return true;
            }
            case ANY: {
                for (String tag : tags) {
                    if (!set.contains(tag)) continue;
                    return true;
                }
                return false;
            }
            case NOT_ALL: {
                for (String tag : tags) {
                    if (set.contains(tag)) continue;
                    return true;
                }
                return false;
            }
            case NOT_ANY: {
                for (String tag : tags) {
                    if (!set.contains(tag)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static String pick(Random random, String ... tags) {
        Department d2;
        WeightedRandomPicker<Department> picker = new WeightedRandomPicker<Department>(random);
        block0: for (Department d2 : departments) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (d2.tags.contains(tag)) {
                    picker.add(d2);
                    continue block0;
                }
                ++n2;
            }
        }
        d2 = (Department)picker.pick();
        if (d2 == null) {
            d2 = departments.get(0);
        }
        return d2.name;
    }

    public static String pickWithAllTags(Random random, String ... tags) {
        Department d2;
        WeightedRandomPicker<Department> picker = new WeightedRandomPicker<Department>(random);
        block0: for (Department d2 : departments) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!d2.tags.contains(tag)) continue block0;
                ++n2;
            }
            picker.add(d2);
        }
        d2 = (Department)picker.pick();
        if (d2 == null) {
            d2 = departments.get(0);
        }
        return d2.name;
    }

    public static class Department {
        public String name;
        public Set<String> tags = new HashSet<String>();

        public Department(String name, String ... tags) {
            this.name = name;
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                this.tags.add(tag);
                ++n2;
            }
        }
    }
}

