/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.academy.GADepartments;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class GADerelictArtifact
extends GABaseMission {
    public static float MISSION_DAYS = 120.0f;
    public static float PROB_PIRATES = 0.33f;
    public static float PROB_SCAVENGER = 0.5f;
    protected StarSystemAPI system;
    protected SectorEntityToken entity;
    protected StarSystemAPI pirateSystem;
    protected String widget;
    protected Variation variation;
    protected int piratePayment;
    protected int piratePaymentLow;
    protected int scavPayment;
    protected int scavPaymentHigh;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaDA_ref")) {
            return false;
        }
        this.pickDepartment(GADepartments.INDUSTRIAL, GADepartments.SOCIAL, GADepartments.MILITARY, GADepartments.SCIENCE, GADepartments.WEIRD);
        this.widget = this.pickOne("\u4e00\u4e2a\u72ec\u7279\u7684\u8d85\u5bfc\u7ed3\u6784\u5143\u4ef6", "\u4e00\u4e2a\u5148\u8fdb\u7684\u529b\u573a\u8f6c\u6362\u539f\u578b", "\u4e00\u4e2a\u53cd\u5f0f\u53c2\u6570\u79ef\u5206\u5668", "\u4e00\u79cd\u6781\u5176\u7f55\u89c1\u7684\u6750\u6599\u6837\u672c", "\u4e00\u79cd\u7f55\u89c1\u7684\u7535\u529b\u7cfb\u7edf\u5143\u4ef6", "\u4e00\u4e2a\u4eba\u4e4b\u9886\u65f6\u4ee3\u7684\u953b\u9020\u7ec4\u4ef6", "\u4e00\u4e2a\u5c0f\u578b\u52a8\u91cf\u89e3\u8026\u5668", "\u4e00\u4e2a\u8ff7\u4eba\u7684\u4f4e\u500d\u89c6\u91ce\u6295\u5f71\u4eea");
        this.requireSystemTags(ReqMode.ANY, "theme_remnant_resurgent", "theme_remnant_suppressed", "theme_derelict", "theme_misc", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_remnant_secondary");
        this.preferSystemUnexplored();
        this.preferSystemInDirectionOfOtherMissions();
        this.system = this.pickSystem();
        if (this.system == null) {
            return false;
        }
        this.entity = this.spawnDerelictOfType(null, new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN, null, this.system, false));
        if (this.entity == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_DERELCIT);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.makeImportant(this.entity, "$gaDA_entity", Stage.GO_TO_DERELCIT);
        this.makeImportant(this.getPerson(), "$gaDA_returnHere", Stage.RETURN_TO_ACADEMY);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_DERELCIT, (Object)Stage.GET_IT_FROM_PIRATES, "$gaDA_piratesTookIt");
        this.connectWithGlobalFlag((Object)Stage.GO_TO_DERELCIT, (Object)Stage.GET_IT_FROM_SCAVENGER, "$gaDA_scavengerTookIt");
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, "$gaDA_gotWidget");
        this.connectWithGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, (Object)Stage.COMPLETED, "$gaDA_returnedWidget");
        if (WITH_TIME_LIMIT) {
            this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, this.entity.getStarSystem(), new Object[]{Stage.RETURN_TO_ACADEMY});
        }
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.setDefaultGARepRewards();
        if (this.system.hasTag("theme_remnant")) {
            this.variation = Variation.REMNANTS;
            this.setCreditReward(BaseHubMission.CreditReward.HIGH);
        } else {
            this.variation = this.rollProbability(PROB_PIRATES) ? Variation.PIRATES : (this.rollProbability(PROB_SCAVENGER) ? Variation.SCAVENGER : Variation.BASIC);
        }
        this.setMapMarkerNameColorBasedOnStar(this.system);
        if (this.variation == Variation.PIRATES) {
            this.requireSystemTags(ReqMode.ANY, "theme_misc_skip", "theme_derelict", "theme_misc", "theme_ruins");
            this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe");
            this.requireSystemNot(this.system);
            this.requireSystemWithinRangeOf(this.entity.getLocationInHyperspace(), 10.0f);
            this.pirateSystem = this.pickSystem();
            if (this.pirateSystem == null) {
                return false;
            }
            this.piratePayment = this.genRoundNumber(10000, 15000);
            this.piratePaymentLow = this.genRoundNumber(2000, 5000);
            this.beginStageTrigger(new Object[]{Stage.GET_IT_FROM_PIRATES});
            this.triggerSpawnEntity("supply_cache", new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN, null, this.pirateSystem, false));
            this.triggerSaveGlobalEntityRef("$gaDA_cache");
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolMedium", this.pirateSystem);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerSetStandardHostilePirateFlags();
            this.triggerPickLocationAtInSystemJumpPoint(this.pirateSystem);
            this.triggerSpawnFleetAtPickedLocation();
            this.triggerOrderFleetPatrolEntity(true);
            this.triggerFleetMakeImportant("$gaDA_pirate", Stage.GET_IT_FROM_PIRATES);
            this.triggerFleetAddDefeatTrigger("gaDAFleetWithWidgetDefeated");
            this.endTrigger();
        } else if (this.variation == Variation.SCAVENGER) {
            this.scavPayment = this.genRoundNumber(10000, 15000);
            this.scavPaymentHigh = this.genRoundNumber(20000, 25000);
            this.beginStageTrigger(new Object[]{Stage.GET_IT_FROM_SCAVENGER});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.LOWER, "scavengers", "scavengerMedium", this.system);
            this.triggerAutoAdjustFleetStrengthModerate();
            this.triggerSetFleetFaction("independent");
            this.triggerMakeLowRepImpact();
            this.triggerPickLocationAtClosestToPlayerJumpPoint(this.system);
            this.triggerSetEntityToPickedJumpPoint();
            this.triggerPickLocationAroundEntity(5000.0f);
            this.triggerSpawnFleetAtPickedLocation();
            this.triggerFleetSetTravelActionText("\u6b63\u5728\u63a2\u7d22\u661f\u7cfb");
            this.triggerFleetSetPatrolActionText("\u51c6\u5907\u79bb\u5f00\u661f\u7cfb");
            this.triggerOrderFleetPatrolEntity(false);
            this.triggerFleetMakeImportant("$gaDA_scavenger", Stage.GET_IT_FROM_SCAVENGER);
            this.triggerFleetAddDefeatTrigger("gaDAFleetWithWidgetDefeated");
            this.endTrigger();
        }
        return true;
    }

    protected void updateInteractionDataImpl() {
        this.set("$gaDA_department", this.department);
        this.set("$gaDA_widget", this.widget);
        this.set("$gaDA_widgetNoArticle", this.getWidgetWithoutArticle());
        this.set("$gaDA_starName", this.entity.getStarSystem().getNameWithNoType());
        this.set("$gaDA_systemName", this.entity.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$gaDA_dist", this.getDistanceLY(this.entity));
        this.set("$gaDA_fuel", this.getFuel(this.entity, true));
        this.set("$gaDA_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaDA_piratePayment", Misc.getWithDGS(this.piratePayment));
        this.set("$gaDA_piratePaymentLow", Misc.getWithDGS(this.piratePaymentLow));
        this.set("$gaDA_scavPayment", Misc.getWithDGS(this.scavPayment));
        this.set("$gaDA_scavPaymentHigh", Misc.getWithDGS(this.scavPaymentHigh));
        this.set("$gaDA_notRemnants", this.variation != Variation.REMNANTS);
        this.set("$gaDA_variation", (Object)this.variation);
    }

    protected String getWidgetWithoutArticle() {
        if (this.widget.startsWith(" ")) {
            return this.widget.replaceFirst(" ", "");
        }
        if (this.widget.startsWith(" ")) {
            return this.widget.replaceFirst(" ", "");
        }
        return this.widget;
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_DERELCIT) {
            String extra = "";
            if (this.variation == Variation.REMNANTS) {
                extra = " \u6ce8\u610f\uff1a\u5176\u4e2d\u7684 '\u81ea\u52a8\u6b66\u5668\u7cfb\u7edf' \u53ef\u80fd\u4f1a\u6784\u6210\u5371\u9669\u3002";
            }
            info.addPara("\u4ece\u4e00\u8258\u9057\u5f03\u8230\u4e2d\u627e\u5230 " + this.widget + "\uff0c\u76ee\u6807\uff1a" + this.getLocated(this.entity) + "." + extra, opad);
        } else if (this.currentStage == Stage.GET_IT_FROM_PIRATES) {
            SectorEntityToken cache = this.getEntityFromGlobal("$gaDA_cache");
            info.addPara("\u56de\u6536 " + this.getWidgetWithoutArticle() + "\uff0c\u76ee\u6807\u4e3a\u4e00\u652f\u5728\u9690\u85cf\u4ed3\u5e93 \u9644\u8fd1\u8865\u7ed9\u7684\u6d77\u76d7\u8230\u961f\uff0c\u5176\u4f4d\u4e8e " + this.getLocated(cache) + ".", opad);
        } else if (this.currentStage == Stage.GET_IT_FROM_SCAVENGER) {
            info.addPara("\u524d\u5f80\u6700\u8fd1\u7684\u8df3\u8dc3\u70b9\u9644\u8fd1\uff0c\u5e76\u56de\u6536 " + this.getWidgetWithoutArticle() + "\uff0c\u5728\u76ee\u6807\u62fe\u8352\u8005\u79bb\u5f00\u661f\u7cfb\u4e4b\u524d\u3002", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u5c06 " + this.getWidgetWithoutArticle() + " \u9001\u56de Galatia \u5b66\u9662\uff0c\u5e76\u8054\u7cfb " + this.getPerson().getNameString() + " \u5373\u53ef\u83b7\u5f97\u5956\u52b1\u3002", opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_DERELCIT) {
            if (this.system.isCurrentLocation()) {
                info.addPara("\u56de\u6536 " + this.getWidgetWithoutArticle() + "\uff0c\u76ee\u6807\uff1a\u5e9f\u5f03\u8230\u8239", tc, pad);
            } else {
                info.addPara(this.getGoToSystemTextShort(this.system), tc, pad);
            }
            return true;
        }
        if (this.currentStage == Stage.GET_IT_FROM_PIRATES) {
            info.addPara("\u56de\u6536 " + this.getWidgetWithoutArticle() + "\uff0c\u76ee\u6807\uff1a\u6d77\u76d7 - " + this.pirateSystem.getNameWithLowercaseType(), tc, pad);
        } else if (this.currentStage == Stage.GET_IT_FROM_SCAVENGER) {
            info.addPara("\u56de\u6536 " + this.getWidgetWithoutArticle() + "\uff0c\u76ee\u6807\u4e3a\u8df3\u8dc3\u70b9\u9644\u8fd1\u7684\u62fe\u8352\u8005", tc, pad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u56de\u5230 Galatia \u5b66\u9662\uff0c\u5e76\u8054\u7cfb " + this.getPerson().getNameString(), tc, pad);
            return true;
        }
        return false;
    }

    public String getBaseName() {
        return "\u5236\u54c1\u56de\u6536";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_DERELCIT,
        GET_IT_FROM_PIRATES,
        GET_IT_FROM_SCAVENGER,
        RETURN_TO_ACADEMY,
        COMPLETED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        BASIC,
        REMNANTS,
        PIRATES,
        SCAVENGER;

    }
}

