/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class GAKallichore
extends GABaseMission {
    protected PersonAPI baird;
    protected PersonAPI arroyo;
    protected PersonAPI gargoyle;
    protected PersonAPI loke;
    protected SectorEntityToken relay;

    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaKA_ref", "$gaKA_inProgress")) {
            return false;
        }
        this.setName("Kallichore \u7684\u6570\u636e\u6863\u6848");
        this.baird = this.getImportantPerson(People.BAIRD);
        this.arroyo = this.getImportantPerson(People.ARROYO);
        this.gargoyle = this.getImportantPerson(People.GARGOYLE);
        this.loke = this.getImportantPerson(People.CLONE_LOKE);
        if (this.baird == null) {
            return false;
        }
        if (this.arroyo == null) {
            return false;
        }
        if (this.gargoyle == null) {
            return false;
        }
        if (this.loke == null) {
            return false;
        }
        this.relay = Global.getSector().getEntityById("aztlan_relay");
        if (this.relay == null) {
            return false;
        }
        StarSystemAPI mayasura = this.gargoyle.getMarket().getStarSystem();
        StarSystemAPI galatia = this.baird.getMarket().getStarSystem();
        if (mayasura == null || galatia == null) {
            return false;
        }
        MarketAPI coatl = Global.getSector().getEconomy().getMarket("coatl");
        if (coatl == null) {
            return false;
        }
        this.setStoryMission();
        this.setStartingStage((Object)Stage.TALK_TO_ARROYO);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.makeImportant(this.arroyo, "$gaKA_contact", Stage.TALK_TO_ARROYO);
        this.makeImportant(this.arroyo.getMarket(), "$gaKA_visitChalet", Stage.VISIT_ARROYO);
        this.makeImportant(this.gargoyle, "$gaKA_contact", Stage.TALK_TO_GARGOYLE);
        this.makeImportant(this.loke.getMarket(), "$gaKA_getHack", Stage.GET_HACK_HARDWARE);
        this.makeImportant(this.relay, "$gaKA_installHack", Stage.INSTALL_HACK);
        this.makeImportant(this.gargoyle, "$gaKA_contactRetrieve", Stage.RETRIEVE_ARCHIVE);
        this.makeImportant(this.baird.getMarket(), "$gaKA_returnHere", Stage.RETURN_TO_ACADEMY);
        this.setStageOnGlobalFlag((Object)Stage.VISIT_ARROYO, "$gaKA_visitArroyo");
        this.setStageOnGlobalFlag((Object)Stage.TALK_TO_GARGOYLE, "$gaKA_talkToGargoyle");
        this.setStageOnGlobalFlag((Object)Stage.GET_HACK_HARDWARE, "$gaKA_getHackHardware");
        this.setStageOnGlobalFlag((Object)Stage.INSTALL_HACK, "$gaKA_installHack");
        this.setStageOnGlobalFlag((Object)Stage.RETRIEVE_ARCHIVE, "$gaKA_retrieveArchive");
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, "$gaKA_returnToAcademy");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaKA_completed");
        this.beginStageTrigger(new Object[]{Stage.TALK_TO_ARROYO});
        this.triggerUnhideCommListing(this.arroyo);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.TALK_TO_GARGOYLE});
        this.triggerUnhideCommListing(this.gargoyle);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.RETURN_TO_ACADEMY});
        this.triggerHideCommListing(this.gargoyle);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.RETURN_TO_ACADEMY});
        SectorEntityToken fleetLocation = this.gargoyle.getMarket().getPrimaryEntity();
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "hegemony", "taskForce", fleetLocation);
        this.triggerAutoAdjustFleetStrengthModerate();
        this.triggerMakeAllFleetFlagsPermanent();
        this.triggerMakeFleetIgnoreOtherFleets();
        this.triggerMakeFleetIgnoredByOtherFleets();
        this.triggerSetPatrol();
        this.triggerPickLocationAtClosestToEntityJumpPoint(mayasura, fleetLocation, 4000.0f);
        this.triggerPickLocationTowardsEntity(null, 30.0f, 5000.0f);
        this.triggerSpawnFleetAtPickedLocation(null, null);
        this.triggerFleetSetPatrolActionText("\u9a76\u79bb Port Tse \u7279\u8bb8\u7ecf\u8425\u7ad9");
        this.triggerFleetSetPatrolLeashRange(100.0f);
        this.triggerOrderFleetPatrol(fleetLocation);
        this.triggerOrderFleetEBurn(1.0f);
        this.triggerIncreaseMarketHostileTimeout(this.gargoyle.getMarket(), 90.0f);
        this.endTrigger();
        this.beginWithinHyperspaceRangeTrigger(this.gargoyle.getMarket(), 1.0f, true, new Object[]{Stage.RETURN_TO_ACADEMY});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_1, "hegemony", "taskForce", mayasura);
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerMakeHostileAndAggressive();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerSetPatrol();
        this.triggerPickLocationTowardsEntity(galatia.getHyperspaceAnchor(), 90.0f, GAKallichore.getUnits(0.5f));
        this.triggerSpawnFleetAtPickedLocation("$gaKA_patrol", null);
        this.triggerOrderFleetInterceptPlayer();
        this.triggerOrderFleetEBurn(1.0f);
        this.triggerFleetMakeImportant(null, Stage.RETURN_TO_ACADEMY);
        this.endTrigger();
        this.triggerCreateMediumPatrol(coatl, "hegemony", this.relay, (Object)Stage.INSTALL_HACK, 0.0f);
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerRemoveTags(this.relay, "story_critical");
        this.triggerMakeNonStoryCritical(this.gargoyle.getMarket(), this.arroyo.getMarket(), this.loke.getMarket(), coatl);
        this.triggerMovePersonToMarket(this.gargoyle, this.baird.getMarket(), true);
        this.triggerUnhideCommListing(this.gargoyle);
        this.endTrigger();
        float baseDelay = 90.0f;
        this.beginStageTrigger(new Object[]{Stage.RETRIEVE_ARCHIVE});
        this.triggerSetGlobalMemoryValueAfterDelay(this.genDelay(baseDelay), "$gaKA_triTachyonVisit", true);
        this.triggerSetGlobalMemoryValueAfterDelay(this.genDelay(baseDelay), "$gaKA_hegemonyVisit", true);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$gaKA_missionCompleted", true);
        this.endTrigger();
        return true;
    }

    protected void updateInteractionDataImpl() {
        this.set("$gaKA_stage", this.getCurrentStage());
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        FactionAPI heg = Global.getSector().getFaction("hegemony");
        if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u4f60\u627e\u56de\u4e86\u5b66\u9662\u524d\u4efb \u9662\u957fTomas Kallichore \u7684\u6570\u636e\u5e93\u3002\u6570\u636e\u5e93\u91cc\u5305\u62ec\u4e86\u4e00\u7cfb\u5217\u5931\u8d25\u7684\u661f\u95e8\u6fc0\u6d3b\u5b9e\u9a8c\u7684\u6570\u636e\u3002", opad);
        } else {
            info.addPara("\u4f60\u6062\u590d\u4e86\u524d\u4efb\u9662\u957f Tomas Kallichor \u7684\u6570\u636e\u6863\u6848\uff0c\u800c\u5176\u4e2d\u5c31\u5305\u542b\u4e86\u5931\u8d25\u7684\u661f\u95e8\u6fc0\u6d3b\u5b9e\u9a8c\u7ed3\u679c\u3002", opad);
            info.addPara("\u6863\u6848\u73b0\u5b58\u653e\u5728 \u9738\u4e3b \u79d1\u6280\u6807\u51c6\u90e8\u7684\u8d85\u7ea7\u5b89\u5168\u6570\u636e\u5e93\u4e2d\u3002", opad, heg.getBaseUIColor(), "Hegemony");
        }
        if (this.currentStage == Stage.TALK_TO_ARROYO) {
            info.addPara(String.valueOf(this.getGoTalkToPersonText(this.arroyo)) + "\u3002\u53ef\u5229\u7528\u4ed6\u4e0e Baird \u9662\u957f\u7684\u5173\u7cfb" + "\u6765\u4f7f\u5176\u5408\u4f5c\u3002", opad);
        } else if (this.currentStage == Stage.VISIT_ARROYO) {
            info.addPara("\u4eb2\u81ea\u524d\u5f80 " + this.arroyo.getNameString() + " \u7684\u5c0f\u5c4b\u3002", opad);
        } else if (this.currentStage == Stage.TALK_TO_GARGOYLE) {
            info.addPara(String.valueOf(this.getGoTalkToPersonText(this.gargoyle)) + " \u9ed1\u5ba2\uff0c\u5e76\u8ba9\u5176\u9a87\u5165\u6570\u636e\u5e93\u3002" + "\u5c3d\u7ba1 Arroyo \u8868\u793a\u8fd9\u662f\u4e00\u6b21\u6781\u5176\u611a\u8822\u7684\u884c\u52a8\uff0c" + "\u4f46\u4f60\u522b\u65e0\u9009\u62e9\u3002", opad);
        } else if (this.currentStage == Stage.GET_HACK_HARDWARE) {
            info.addPara(String.valueOf(this.getGoToMarketText(this.loke.getMarket())) + " \u7136\u540e\u4ece\u5b58\u50a8\u5355\u5143\u4e2d\u53d6\u51fa" + "\u9ed1\u5ba2\u8bbe\u5907\u3002", opad);
        } else if (this.currentStage == Stage.INSTALL_HACK) {
            info.addPara(String.valueOf(this.getGoToSystemTextShort(this.relay.getStarSystem())) + ", \u5e76\u4e8e\u4ee5\u4e0b\u8bbe\u65bd\u5b89\u88c5\u9ed1\u5ba2\u8bbe\u5907\uff1a" + "" + this.relay.getName() + ".", opad);
        } else if (this.currentStage == Stage.RETRIEVE_ARCHIVE) {
            info.addPara(String.valueOf(this.getGoToMarketText(this.gargoyle.getMarket())) + " \u7136\u540e\u4ece Gargoyle \u90a3\u4e2d\u627e\u5230 Kallichore \u7684\u6570\u636e\u6863\u6848\u3002", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u56de Galatia \u5b66\u9662\uff0c\u5e76\u4e0e Baird \u9662\u957f\u8c08\u8c08\u3002", opad);
        }
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TALK_TO_ARROYO) {
            info.addPara(this.getGoTalkToPersonText(this.arroyo), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.VISIT_ARROYO) {
            info.addPara("\u4eb2\u81ea\u524d\u5f80 " + this.arroyo.getNameString() + " \u7684\u5c0f\u5c4b", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.TALK_TO_GARGOYLE) {
            info.addPara(this.getGoTalkToPersonText(this.gargoyle), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GET_HACK_HARDWARE) {
            info.addPara(String.valueOf(this.getGoToMarketText(this.loke.getMarket())) + " \u7136\u540e\u62ff\u8d70\u9ed1\u5ba2\u8bbe\u5907", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.INSTALL_HACK) {
            info.addPara(String.valueOf(this.getGoToSystemTextShort(this.relay.getStarSystem())) + ", \u5e76\u4e8e\u4ee5\u4e0b\u8bbe\u65bd\u5b89\u88c5\u9ed1\u5ba2\u8bbe\u5907\uff1a" + "on the " + this.relay.getName(), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETRIEVE_ARCHIVE) {
            info.addPara(String.valueOf(this.getGoToMarketText(this.gargoyle.getMarket())) + " \u5e76\u627e\u5230 Kallichore \u7684\u6570\u636e\u6863\u6848", tc, pad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u56de Galatia \u5b66\u9662\uff0c\u5e76\u4e0e Baird \u9662\u957f\u8c08\u8c08", tc, pad);
        }
        return false;
    }

    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        TALK_TO_ARROYO,
        VISIT_ARROYO,
        TALK_TO_GARGOYLE,
        GET_HACK_HARDWARE,
        INSTALL_HACK,
        RETRIEVE_ARCHIVE,
        RETURN_TO_ACADEMY,
        COMPLETED;

    }
}

