/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.AICoreOfficerPluginImpl;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.academy.GADepartments;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAOutpost
extends GABaseMission {
    public static float MISSION_DAYS = 120.0f;
    public static float PROB_DESTROYED = 0.5f;
    public static float PROB_ROGUE_AI = 0.6f;
    public static float PROB_DESTROYED_PIRATES = 0.16666667f;
    public static float PROB_DESTROYED_PATHERS = 0.2f;
    public static float PROB_HOSTILE_FLEET = 0.5f;
    protected PlanetAPI planet;
    protected Variation variation;
    protected PersonAPI leader;
    protected PersonAPI core;
    protected int terribleEnd;
    protected int bizarreProject;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaOp_ref")) {
            return false;
        }
        this.pickDepartment(GADepartments.INDUSTRIAL, GADepartments.MILITARY, GADepartments.SCIENCE, GADepartments.WEIRD);
        if (this.rollProbability(PROB_DESTROYED)) {
            if (this.rollProbability(PROB_DESTROYED_PIRATES)) {
                this.variation = Variation.DESTROYED_PIRATES;
            } else if (this.rollProbability(PROB_DESTROYED_PATHERS)) {
                this.variation = Variation.DESTROYED_PATHERS;
            } else {
                this.variation = Variation.DESTROYED_OTHER;
                this.terribleEnd = this.genRandom.nextInt(4);
            }
        } else if (this.rollProbability(PROB_ROGUE_AI)) {
            this.variation = Variation.ROGUE_AI;
            this.bizarreProject = this.genRandom.nextInt(7);
        } else {
            this.variation = Variation.BASIC;
        }
        this.resetSearch();
        this.preferSystemInteresting();
        this.preferSystemOnFringeOfSector();
        this.preferSystemUnexplored();
        this.requirePlanetNotStar();
        this.requirePlanetUnpopulated();
        this.requirePlanetNotGasGiant();
        this.preferPlanetNotFullySurveyed();
        this.preferPlanetInDirectionOfOtherMissions();
        this.planet = this.pickPlanet();
        if (this.planet == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_OUTPOST);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.makeImportant(this.planet, "$gaOp_targetPlanet", Stage.GO_TO_OUTPOST);
        this.makeImportant(this.getPerson(), "$gaOp_returnHere", Stage.RETURN_TO_ACADEMY);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_OUTPOST, (Object)Stage.RETURN_TO_ACADEMY, "$gaOp_needToReturn");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaOp_completed");
        if (WITH_TIME_LIMIT) {
            this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, this.planet.getStarSystem(), new Object[]{Stage.RETURN_TO_ACADEMY});
        }
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.setDefaultGARepRewards();
        this.leader = Global.getSector().getFaction("independent").createRandomPerson(this.genRandom);
        this.leader.setRankId(Ranks.CITIZEN);
        this.leader.setPostId(Ranks.POST_ACADEMICIAN);
        this.core = new AICoreOfficerPluginImpl().createPerson("beta_core", "neutral", this.genRandom);
        if (this.variation == Variation.DESTROYED_PIRATES && this.rollProbability(PROB_HOSTILE_FLEET)) {
            this.beginStageTrigger(new Object[]{Stage.RETURN_TO_ACADEMY});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolMedium", this.planet);
            this.triggerAutoAdjustFleetStrengthModerate();
            this.triggerFleetAllowLongPursuit();
            this.triggerPickLocationAroundEntity(this.planet, 3000.0f);
            this.triggerSpawnFleetAtPickedLocation(null, null);
            this.triggerOrderFleetPatrol(this.planet);
            this.endTrigger();
        } else if (this.variation == Variation.DESTROYED_PATHERS && this.rollProbability(PROB_HOSTILE_FLEET)) {
            this.beginStageTrigger(new Object[]{Stage.RETURN_TO_ACADEMY});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "luddic_path", "patrolMedium", this.planet);
            this.triggerAutoAdjustFleetStrengthModerate();
            this.triggerFleetAllowLongPursuit();
            this.triggerFleetPatherNoDefaultTithe();
            this.triggerPickLocationAroundEntity(this.planet, 3000.0f);
            this.triggerSpawnFleetAtPickedLocation(null, null);
            this.triggerOrderFleetPatrol(this.planet);
            this.endTrigger();
        }
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog != null && action.equals("showLeader")) {
            this.showPersonInfo(this.leader, dialog, false, false);
            return true;
        }
        if (dialog != null && action.equals("showCore")) {
            this.showPersonInfo(this.core, dialog, false, false);
            return true;
        }
        if (dialog != null && action.equals("doubleReward")) {
            this.setCreditReward(this.getCreditsReward() * 2);
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaOp_department", this.department);
        this.set("$gaOp_planetId", this.planet.getId());
        this.set("$gaOp_planetName", this.planet.getName());
        this.set("$gaOp_systemName", this.planet.getStarSystem().getNameWithNoType());
        this.set("$gaOp_dist", this.getDistanceLY(this.planet));
        this.set("$gaOp_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaOp_leaderHeOrShe", this.leader.getHeOrShe());
        this.set("$gaOp_leaderHisOrHer", this.leader.getHisOrHer());
        this.set("$gaOp_variation", (Object)this.variation);
        this.set("$gaOp_terribleEnd", this.terribleEnd);
        this.set("$gaOp_bizarreProject", this.bizarreProject);
        this.set("$gaOp_destroyed", this.variation == Variation.DESTROYED_OTHER || this.variation == Variation.DESTROYED_PATHERS || this.variation == Variation.DESTROYED_PIRATES);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_OUTPOST) {
            info.addPara(String.valueOf(this.getGoToPlanetTextPre(this.planet)) + "\uff0c\u5e76\u5c06\u4e00\u5c0f\u961f\u79d1\u5b66\u5bb6\u9001\u5230 \u4f4d\u4e8e\u90a3\u91cc\u7684 \u4e00\u4e2a\u524d\u54e8\u7ad9\u4e2d\u3002", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u56de\u5230 Galatia \u5b66\u9662\uff0c\u5e76\u8054\u7cfb " + this.getPerson().getNameString() + " \u5373\u53ef\u83b7\u5f97\u5956\u52b1\u3002", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_OUTPOST) {
            info.addPara(this.getGoToPlanetTextShort(this.planet), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u56de\u5230 Galatia \u5b66\u9662\uff0c\u5e76\u8054\u7cfb " + this.getPerson().getNameString(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u8fd0\u9001\u79d1\u5b66\u5c0f\u7ec4";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_OUTPOST,
        RETURN_TO_ACADEMY,
        COMPLETED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        BASIC,
        DESTROYED_PATHERS,
        DESTROYED_PIRATES,
        DESTROYED_OTHER,
        ROGUE_AI;

    }
}

