/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.academy.GADepartments;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAProbePackage
extends GABaseMission {
    public static float MISSION_DAYS = 120.0f;
    public static float PROB_PATHERS = 0.5f;
    public static float PROB_NOT_ASTEROIDS = 0.5f;
    public static float PROB_IT_BLEW_UP = 0.33f;
    public static float PROB_MISSING = 0.5f;
    public static float PROB_SCAVENGER = 0.5f;
    protected StarSystemAPI system;
    protected Variation variation;
    protected CampaignTerrainAPI object;
    protected SectorEntityToken probe;
    protected int hazardPay;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaProbe_ref")) {
            return false;
        }
        this.pickDepartmentAllTags(GADepartments.SCIENCE, GADepartments.WEIRD);
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe", "theme_core");
        this.requireTerrainType(ReqMode.ANY, "asteroid_belt", "asteroid_field", "magnetic_field", "nebula", "ring");
        if (this.rollProbability(PROB_NOT_ASTEROIDS)) {
            this.preferTerrainType(ReqMode.NOT_ANY, "asteroid_belt", "asteroid_field");
        }
        this.preferSystemNotPulsar();
        this.preferSystemNotBlackHole();
        this.preferSystemUnexplored();
        this.preferTerrainInDirectionOfOtherMissions();
        this.object = this.pickTerrain();
        if (this.object == null) {
            return false;
        }
        this.system = this.object.getStarSystem();
        this.variation = this.rollProbability(PROB_IT_BLEW_UP) ? Variation.IT_BLEW_UP : (this.rollProbability(PROB_MISSING) ? Variation.PACKAGE_MISSING : (this.rollProbability(PROB_SCAVENGER) ? Variation.SCAVENGER : Variation.BASIC));
        this.setStartingStage((Object)Stage.GO_TO_PROBE);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.probe = this.spawnEntity("generic_probe", new BaseHubMission.LocData(this.object));
        if (this.probe == null) {
            return false;
        }
        this.probe.setId("gaProbe_probe");
        this.makeImportant(this.probe, "$gaProbe_probe", Stage.GO_TO_PROBE);
        this.makeImportant(this.getPerson(), "$gaProbe_returnHere", Stage.RETURN_TO_ACADEMY);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_PROBE, (Object)Stage.FIND_SCAVENGER, "$gaProbe_scavengerTookIt");
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, "$gaProbe_canReturn");
        this.connectWithGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, (Object)Stage.COMPLETED, "$gaProbe_finished");
        if (WITH_TIME_LIMIT) {
            this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, this.system, new Object[]{Stage.RETURN_TO_ACADEMY});
        }
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.setDefaultGARepRewards();
        if (this.variation == Variation.IT_BLEW_UP) {
            this.hazardPay = this.getCreditsReward() / 2;
            this.spawnDebrisField(DEBRIS_SMALL, DEBRIS_DENSE, new BaseHubMission.LocData(this.probe, false));
            this.spawnShipGraveyard("luddic_path", 3, 5, new BaseHubMission.LocData(this.probe, false));
            if (this.rollProbability(PROB_PATHERS)) {
                this.beginWithinHyperspaceRangeTrigger(this.object, 1.0f, false, new Object[]{Stage.GO_TO_PROBE});
                this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.TINY, HubMissionWithTriggers.FleetQuality.VERY_LOW, "luddic_path", "patrolSmall", this.object);
                this.triggerSetFleetSizeFraction(0.03f);
                this.triggerMakeNonHostile();
                this.triggerMakeLowRepImpact();
                this.triggerFleetNoJump();
                this.triggerFleetPatherNoDefaultTithe();
                this.triggerSetFleetMissionRef("$gaProbe_ref");
                this.triggerFleetSetPatrolActionText("\u7b49\u5f85\u4e2d");
                this.triggerOrderFleetPatrol(this.probe);
                this.triggerOrderFleetInterceptPlayer();
                this.triggerPickLocationAroundEntity(this.probe, 1000.0f);
                this.triggerSpawnFleetAtPickedLocation("$gaProbe_patherPermanentFlag", null);
                this.triggerFleetMakeImportant("$gaProbe_patherMissionInProgress", Stage.GO_TO_PROBE);
                this.endTrigger();
            }
        }
        if (this.variation == Variation.SCAVENGER) {
            this.beginWithinHyperspaceRangeTrigger(this.object, 1.0f, false, new Object[]{Stage.GO_TO_PROBE});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.LOWER, "scavengers", "scavengerMedium", this.system);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerSetFleetFaction("independent");
            this.triggerMakeLowRepImpact();
            this.triggerFleetSetAvoidPlayerSlowly();
            this.triggerMakeFleetIgnoredByOtherFleets();
            this.triggerPickLocationAtClosestToEntityJumpPoint(this.system, this.probe);
            this.triggerSetEntityToPickedJumpPoint();
            this.triggerPickLocationAroundEntity(5000.0f);
            this.triggerSpawnFleetAtPickedLocation("$gaProbe_scavenger", null);
            this.triggerFleetSetTravelActionText("\u6b63\u5728\u63a2\u7d22\u661f\u7cfb");
            this.triggerFleetSetPatrolActionText("\u51c6\u5907\u79bb\u5f00\u661f\u7cfb");
            this.triggerOrderFleetPatrolEntity(false);
            this.triggerFleetMakeImportant("$gaProbe_scavenger", Stage.FIND_SCAVENGER);
            this.triggerFleetAddDefeatTrigger("gaProbeScavengerDefeated");
            this.endTrigger();
        }
        this.setMapMarkerNameColorBasedOnStar(this.system);
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (action.equals("updateReward")) {
            this.setCreditReward(this.getCreditsReward() + this.hazardPay);
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaProbe_department", this.department);
        if (this.getCurrentStage() != null) {
            this.set("$gaProbe_stage", ((Enum)this.getCurrentStage()).name());
        }
        this.set("$gaProbe_celestialObjectNameWithType", this.getObjectNameWithType());
        this.set("$gaProbe_starName", this.system.getNameWithNoType());
        this.set("$gaProbe_systemName", this.system.getNameWithLowercaseTypeShort());
        this.set("$gaProbe_dist", this.getDistanceLY(this.object));
        this.set("$gaProbe_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaProbe_hazardPay", Misc.getWithDGS(this.hazardPay));
        this.set("$gaProbe_variation", (Object)this.variation);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_PROBE) {
            if (this.probe != null) {
                String loc = BreadcrumbSpecial.getLocatedString(this.probe, true);
                info.addPara("\u4ece\u63a2\u6d4b\u5668\u4e2d\u6253\u635e\u4eea\u5668\u5957\u4ef6\uff0c\u76ee\u6807" + loc + " \u4e2d\u7684\u63a2\u6d4b\u5668\u5185\u56de\u6536\u4eea\u5668\u5957\u4ef6\u3002", opad);
            } else {
                info.addPara("\u4ece\u63a2\u6d4b\u5668\u4e2d\u6253\u635e\u4eea\u5668\u5957\u4ef6\uff0c\u76ee\u6807\u4f4d\u4e8e " + this.system.getNameWithLowercaseTypeShort() + " \u4e2d\u7684\u63a2\u6d4b\u5668\u5185\u56de\u6536\u4eea\u5668\u5957\u4ef6\u3002", opad);
            }
        } else if (this.currentStage == Stage.FIND_SCAVENGER) {
            info.addPara("\u524d\u5f80\u6700\u8fd1\u7684\u8df3\u8dc3\u70b9\u9644\u8fd1\uff0c\u5e76\u5728\u62fe\u8352\u8005\u79bb\u5f00\u661f\u7cfb\u524d\uff0c\u4ece\u5176\u624b\u4e2d\u593a\u56de\u4eea\u5668\u5957\u4ef6\u3002", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u5c06\u4eea\u5668\u5957\u4ef6\u4ea4\u8fd8\u7ed9 Galatia \u5b66\u9662\uff0c\u5e76\u8054\u7cfb " + this.getPerson().getNameString() + " \u5373\u53ef\u83b7\u5f97\u5956\u52b1\u3002", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_PROBE) {
            if (this.system.isCurrentLocation()) {
                info.addPara("\u4ece\u63a2\u6d4b\u5668\u5185\u56de\u6536\u4eea\u5668\u5957\u4ef6", tc, pad);
            } else {
                info.addPara(this.getGoToSystemTextShort(this.system), tc, pad);
            }
            return true;
        }
        if (this.currentStage == Stage.FIND_SCAVENGER) {
            info.addPara("\u4ece\u4e00\u5904\u8df3\u8dc3\u70b9\u9644\u8fd1\u7684\u62fe\u8352\u8005\u624b\u4e2d\u593a\u56de\u4eea\u5668\u5957\u4ef6", tc, pad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u56de\u5230 Galatia \u5b66\u9662\uff0c\u5e76\u8054\u7cfb " + this.getPerson().getNameString(), tc, pad);
            return true;
        }
        return false;
    }

    protected String getObjectNameWithType() {
        if (GAProbePackage.hasSpecialName(this.object)) {
            return String.valueOf(GAProbePackage.getTerrainTypeAOrAn(this.object)) + " " + GAProbePackage.getTerrainType(this.object) + " \u4e3a " + GAProbePackage.getTerrainName(this.object);
        }
        return String.valueOf(GAProbePackage.getTerrainTypeAOrAn(this.object)) + " " + GAProbePackage.getTerrainType(this.object);
    }

    @Override
    public String getBaseName() {
        return "\u56de\u6536\u4eea\u5668\u5957\u4ef6";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GO_TO_PROBE,
        FIND_SCAVENGER,
        RETURN_TO_ACADEMY,
        COMPLETED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        BASIC,
        SCAVENGER,
        IT_BLEW_UP,
        PACKAGE_MISSING;

    }
}

