/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.impl.campaign.world.TTBlackSite;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAProjectZiggurat
extends GABaseMission {
    public static String SCANNED_ZIGGURAT = "$gaPZ_scannedZiggurat";
    protected PersonAPI callisto;
    protected MarketAPI culann;
    protected MarketAPI donn;
    protected PersonAPI baird;
    protected PersonAPI arroyo;
    protected PersonAPI gargoyle;
    protected PersonAPI culannAdmin;
    protected NascentGravityWellAPI well;
    protected StarSystemAPI relaySystem;
    protected StarSystemAPI alphaSite;
    protected CampaignFleetAPI zigFleet;
    protected SectorEntityToken relay;
    protected PlanetAPI baseRuins;
    protected boolean pointAtArroyo = false;
    protected boolean pointAtCulannAdmin = false;
    protected int culannBribe;
    protected int paymentForCommFakes;
    protected int paymentForCommFakesHigh;
    protected int rkTithe;
    private SectorEntityToken hamatsu;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaPZ_ref", "$gaPZ_inProgress")) {
            return false;
        }
        this.baird = this.getImportantPerson(People.BAIRD);
        if (this.baird == null) {
            return false;
        }
        this.callisto = this.getImportantPerson(People.IBRAHIM);
        if (this.callisto == null) {
            return false;
        }
        this.gargoyle = this.getImportantPerson(People.GARGOYLE);
        if (this.gargoyle == null) {
            return false;
        }
        this.culann = Global.getSector().getEconomy().getMarket("culann");
        if (this.culann == null) {
            return false;
        }
        this.donn = Global.getSector().getEconomy().getMarket("donn");
        if (this.donn == null) {
            return false;
        }
        this.arroyo = this.getImportantPerson(People.ARROYO);
        if (this.arroyo == null) {
            return false;
        }
        this.culannAdmin = this.getPersonAtMarketPost(this.culann, Ranks.POST_ADMINISTRATOR);
        if (this.culannAdmin == null) {
            return false;
        }
        this.well = (NascentGravityWellAPI)Global.getSector().getMemoryWithoutUpdate().get(TTBlackSite.NASCENT_WELL_KEY);
        if (this.well == null || !this.well.isAlive()) {
            return false;
        }
        float dir = Misc.getAngleInDegrees(this.culann.getLocationInHyperspace(), this.well.getLocationInHyperspace());
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe", "theme_core", "system_already_used_for_story");
        this.preferSystemInDirectionFrom(this.culann.getLocationInHyperspace(), dir, 30.0f);
        this.preferSystemWithinRangeOf(this.culann.getLocationInHyperspace(), 15.0f, 30.0f);
        this.preferSystemWithinRangeOf(this.culann.getLocationInHyperspace(), 15.0f, 40.0f);
        this.preferSystemUnexplored();
        this.preferSystemNotPulsar();
        this.requirePlanetNotGasGiant();
        this.requirePlanetNotStar();
        this.preferPlanetUnsurveyed();
        this.baseRuins = this.pickPlanet(true);
        if (this.baseRuins == null) {
            return false;
        }
        this.relaySystem = this.baseRuins.getStarSystem();
        if (this.relaySystem == null) {
            return false;
        }
        this.relay = this.spawnEntity("generic_probe", new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN, null, this.relaySystem));
        if (this.relay == null) {
            return false;
        }
        this.relay.setCustomDescriptionId("gaPZ_relay");
        this.alphaSite = (StarSystemAPI)this.well.getTarget().getContainingLocation();
        for (CampaignFleetAPI fleet : this.alphaSite.getFleets()) {
            if (!fleet.getMemoryWithoutUpdate().getBoolean("$ziggurat")) continue;
            this.zigFleet = fleet;
            break;
        }
        if (this.zigFleet == null) {
            return false;
        }
        this.requireSystemIs(this.alphaSite);
        this.requireEntityMemoryFlags("$hamatsu");
        this.hamatsu = this.pickEntity();
        this.paymentForCommFakes = this.genRoundNumber(10000, 15000);
        this.paymentForCommFakesHigh = this.genRoundNumber(40000, 60000);
        this.culannBribe = this.genRoundNumber(20000, 30000);
        this.rkTithe = this.genRoundNumber(80000, 120000);
        this.setStartingStage((Object)Stage.GET_KELISE_LEAD);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setStoryMission();
        this.connectWithGlobalFlag((Object)Stage.GET_KELISE_LEAD, (Object)Stage.SELL_BLACKMAIL_MATERIAL, "$gaPZ_sellBlackmail");
        this.connectWithGlobalFlag((Object)Stage.SELL_BLACKMAIL_MATERIAL, (Object)Stage.SOLD_BLACKMAIL_MATERIAL, "$gaPZ_soldBlackmail");
        this.connectWithGlobalFlag((Object)Stage.GET_KELISE_LEAD, (Object)Stage.TALK_TO_CALLISTO, "$gaPZ_talkToCallisto");
        this.connectWithGlobalFlag((Object)Stage.SOLD_BLACKMAIL_MATERIAL, (Object)Stage.TALK_TO_CALLISTO, "$gaPZ_talkToCallisto");
        this.connectWithGlobalFlag((Object)Stage.TALK_TO_CALLISTO, (Object)Stage.GO_TO_RELAY_SYSTEM, "$gaPZ_goToRelaySystem");
        this.connectWithGlobalFlag((Object)Stage.GO_TO_RELAY_SYSTEM, (Object)Stage.GO_TO_NASCENT_WELL, "$gaPZ_goToWell");
        this.setStageOnEnteredLocation((Object)Stage.INVESTIGATE_SITE, this.alphaSite);
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, SCANNED_ZIGGURAT);
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaPZ_completed");
        this.makeImportant(this.culann, null, Stage.GET_KELISE_LEAD);
        this.makeImportant(this.donn, null, Stage.SELL_BLACKMAIL_MATERIAL);
        this.makeImportant(this.arroyo, null, Stage.SOLD_BLACKMAIL_MATERIAL);
        this.makeImportant(this.callisto, null, Stage.TALK_TO_CALLISTO);
        this.makeImportant(this.relay, "$gaPZ_relayImportant", Stage.GO_TO_RELAY_SYSTEM);
        this.makeImportant(this.well, null, Stage.GO_TO_NASCENT_WELL);
        this.makeImportant(this.zigFleet, "$gaPZ_ziggurat", Stage.INVESTIGATE_SITE);
        this.makeImportant(this.baird, "$gaPZ_returnHere", Stage.RETURN_TO_ACADEMY);
        this.setFlag(this.relay, "$gaPZ_relay", false);
        this.setFlag(this.culannAdmin, "$gaPZ_culannAdmin", false, new Object[]{Stage.GET_KELISE_LEAD});
        this.setFlag(this.baseRuins, "$gaPZ_baseRuins", false, new Object[]{Stage.GO_TO_RELAY_SYSTEM, Stage.GO_TO_NASCENT_WELL});
        this.beginWithinHyperspaceRangeTrigger(this.callisto.getMarket(), 3.0f, true, new Object[]{Stage.TALK_TO_CALLISTO});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.HIGHER, "luddic_church", "patrolLarge", this.culann.getLocationInHyperspace());
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeLowRepImpact();
        this.triggerFleetMakeFaster(true, 2, true);
        this.triggerSetFleetAlwaysPursue();
        this.triggerPickLocationTowardsEntity(this.callisto.getMarket().getStarSystem().getHyperspaceAnchor(), 30.0f, GAProjectZiggurat.getUnits(1.5f));
        this.triggerSpawnFleetAtPickedLocation("$gaPZ_rogueKnight", null);
        this.triggerOrderFleetInterceptPlayer();
        this.triggerOrderFleetEBurn(1.0f);
        this.triggerFleetMakeImportant(null, Stage.TALK_TO_CALLISTO);
        this.endTrigger();
        this.beginEnteredLocationTrigger(this.relaySystem, new Object[]{Stage.GO_TO_RELAY_SYSTEM});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_2, "mercenary", "mercBountyHunter", this.culann.getLocationInHyperspace());
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerFleetAddCommanderSkill("phase_corps", 1);
        this.triggerSetFleetFaction("tritachyon");
        this.triggerMakeHostileAndAggressive();
        this.triggerMakeLowRepImpact();
        this.triggerSetFleetDoctrineComp(0, 0, 5);
        this.triggerFleetMakeFaster(true, 1, true);
        this.triggerPickLocationAtInSystemJumpPoint(this.relaySystem);
        this.triggerSpawnFleetAtPickedLocation("$gaPZ_ttMerc", null);
        this.triggerOrderFleetInterceptPlayer();
        this.triggerFleetMakeImportant(null, Stage.GO_TO_RELAY_SYSTEM);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$gaPZ_missionCompleted", true);
        this.triggerSetGlobalMemoryValue(SCANNED_ZIGGURAT, true);
        this.triggerMakeNonStoryCritical(this.culann, this.donn, this.callisto.getMarket(), this.arroyo.getMarket(), this.gargoyle.getMarket());
        this.endTrigger();
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("makeArroyoImportant".equals(action)) {
            if (!this.pointAtArroyo) {
                this.makeImportant(this.arroyo, null, Stage.GET_KELISE_LEAD);
                this.makePrimaryObjective(this.arroyo);
                this.makeUnimportant(this.culann);
                this.makeUnimportant(this.culannAdmin);
                this.pointAtArroyo = true;
            }
            return true;
        }
        if ("makeCulannAdminImportant".equals(action)) {
            if (!this.pointAtCulannAdmin) {
                this.makeImportant(this.culannAdmin, null, Stage.GET_KELISE_LEAD);
                this.makePrimaryObjective(this.culannAdmin);
                this.makeUnimportant(this.arroyo);
                this.pointAtCulannAdmin = true;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().getMemoryWithoutUpdate().unset("$gaPZ_pointedToCulannAdmin");
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaPZ_stage", this.getCurrentStage());
        this.set("$gaPZ_culannBribe", Misc.getWithDGS(this.culannBribe));
        this.set("$gaPZ_paymentForCommFakes", Misc.getWithDGS(this.paymentForCommFakes));
        this.set("$gaPZ_paymentForCommFakesHigh", Misc.getWithDGS(this.paymentForCommFakesHigh));
        this.set("$gaPZ_rkTithe", Misc.getWithDGS(this.rkTithe));
        this.set("$gaPZ_relaySystem", this.relaySystem.getNameWithNoType());
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GET_KELISE_LEAD || this.currentStage == Stage.SELL_BLACKMAIL_MATERIAL || this.currentStage == Stage.GO_TO_RELAY_SYSTEM || this.currentStage == Stage.TALK_TO_CALLISTO || this.currentStage == Stage.SOLD_BLACKMAIL_MATERIAL) {
            info.addPara("\u627e\u5230 Kelise Astraia \u7684\u4e0b\u843d\uff0c\u6b64\u4eba\u548c\u88ab\u79f0\u4e3a \"\u963f\u5c14\u6cd5\u7814\u7a76\u7ad9\"  \u7684 \u901f\u5b50\u79d1\u6280 \u79d8\u5bc6\u7814\u7a76\u57fa\u5730\u6709\u5173\u7cfb\u3002", opad);
        }
        if (this.currentStage == Stage.GET_KELISE_LEAD) {
            GAProjectZiggurat.addStandardMarketDesc("\u66fe\u662f\u6b66\u5668\u5de5\u7a0b\u5e08\u7684\u5979\u76ee\u524d\u5f88\u53ef\u80fd\u5728" + this.culann.getOnOrAt(), this.culann, info, opad);
            if (this.pointAtArroyo) {
                info.addPara("\u4f60\u5df2\u7ecf\u548c Gargoyle \u6c9f\u901a\u8fc7\u4e86\uff0c\u4ed6\u5efa\u8bae\u4f60\u627e Rayan Arroyo \u8c08\u8c08\u3002Rayan \u662f\u4e2a \"\u5f7b\u5934\u5f7b\u5c3e\u7684\u901f\u5b50\u8d70\u72d7\"\uff0c\u56e0\u6b64\u53ef\u80fd\u6709\u80fd\u591f\u534f\u52a9\u8c03\u67e5\u7684\u4eba\u8109\u3002", opad);
                GAProjectZiggurat.addStandardMarketDesc("Arroyo \u76ee\u524d\u4f4d\u4e8e " + this.arroyo.getMarket().getOnOrAt(), this.arroyo.getMarket(), info, opad);
            }
            if (this.pointAtCulannAdmin) {
                info.addPara("\u4f60\u5df2\u7ecf\u5f97\u77e5 Culann \u661f\u9645\u5de5\u5382\u5185\u7684\u884c\u653f\u5b98\u62e5\u6709\u8bbf\u95ee \u4eba\u4e8b\u8bb0\u5f55\u7684\u6743\u9650\uff0c\u90a3\u91cc\u5e94\u8be5\u80fd\u53d1\u73b0 Kelise \u7684\u4e0b\u843d\u3002", opad);
                GAProjectZiggurat.addStandardMarketDesc("", this.culannAdmin.getMarket(), info, opad);
            }
        } else if (this.currentStage == Stage.SELL_BLACKMAIL_MATERIAL) {
            info.addPara("Rayan Arroyo \u5df2\u7b54\u5e94\u5e2e\u4f60\u627e\u5979\uff0c\u4f46\u6709\u4e2a\u6761\u4ef6 \u2014\u2014 \u4f60\u8981\u5e2e\u4ed6\u51fa\u552e \u6709\u95ee\u9898\u7684\u5047\u901a\u8baf\u8bb0\u5f55 \u7ed9\u6bd4\u8f83\u9ad8\u4f4d\u7684\u6d77\u76d7\u5934\u76ee\uff0c\u8fd9\u80fd\u5b8c\u6210 Rayan \u5728\u4e00\u9020\u8c23\u6d3b\u52a8\u4e2d\u7684\u4efb\u52a1\u3002", opad);
            GAProjectZiggurat.addStandardMarketDesc("\u5408\u4e4e\u6761\u4ef6\u7684\u6d77\u76d7\u5934\u76ee\u5e94\u8be5\u5728 " + this.donn.getOnOrAt(), this.donn, info, opad);
        } else if (this.currentStage == Stage.SOLD_BLACKMAIL_MATERIAL) {
            info.addPara("\u56e0\u4f60\u6210\u529f\u628a\u52d2\u7d22\u6750\u6599\u5356\u7ed9\u4e86\u4e00\u540d\u6d77\u76d7\u5934\u76ee\uff0c\u800c\u4f5c\u4e3a \u4ea4\u6362\uff0cArroyo \u540c\u610f\u5e2e\u4f60\u627e\u5230 Kelise Astraia.", opad);
            info.addPara(String.valueOf(this.getGoTalkToPersonText(this.arroyo)) + ".", opad);
        } else if (this.currentStage == Stage.TALK_TO_CALLISTO) {
            info.addPara("\u4f60\u5f97\u77e5 Kelise \u96c7\u4f63\u4e86\u4e00\u8258 \u5386\u9669-\u7ea7 \u661f\u8230\uff0cISS Hamatsu \u2014\u2014 \u5e76\u82b1\u94b1\u4e3a\u5176\u505a\u4e86\u67d0\u79cd\u7279\u6b8a\u5347\u7ea7\uff0c\u7136\u540e\u5f00\u7740\u6b64\u8239\u79bb\u5f00\u4e86\u8be5\u661f\u7cfb\u3002\u8239\u4e3b\u53eb " + this.callisto.getNameString() + "\u3002\u8054\u7cfb\u6b64\u4eba\u4ee5\u4e86\u89e3\u66f4\u591a\u4fe1\u606f\u3002", opad);
            info.addPara(String.valueOf(this.getGoTalkToPersonText(this.callisto)) + ".", opad);
        } else if (this.currentStage == Stage.GO_TO_RELAY_SYSTEM) {
            info.addPara("\u4f60\u5df2\u7ecf\u5f97\u77e5 Kelise Astraia \u7684 ISS Hamatsu \u53f7\u7684\u98de\u884c\u8ba1\u5212\uff0c\u800c\u76ee\u6807\u5f88\u53ef\u80fd\u5728 " + this.relaySystem.getNameWithLowercaseTypeShort() + ".", opad);
        } else if (this.currentStage == Stage.GO_TO_NASCENT_WELL) {
            info.addPara("\u4f60\u5728 " + this.relaySystem.getNameWithLowercaseTypeShort() + " " + "\u4e2d\u53d1\u73b0\u4e86\u4e00\u5904 \u9690\u85cf\u7684\u4e2d\u7ee7\u5668\uff0c\u800c\u5b83\u5f88\u53ef\u80fd\u662f\u7528\u6765\u4e0e '\u963f\u5c14\u6cd5\u7814\u7a76\u7ad9' \u8fdb\u884c\u901a\u4fe1\u7684\u3002" + "\u4f60\u53ef\u8c03\u67e5\u8be5 \u4e2d\u7ee7\u5668\u6765\u83b7\u53d6 \u76ee\u6807\u7684\u8d85\u7a7a\u95f4\u5750\u6807\u3002", opad);
            if (this.well.isInCurrentLocation() && Misc.getDistanceToPlayerLY(this.well) < 0.2f) {
                info.addPara("\u7528 %s \u7a7f\u8d8a\u4f4d\u4e8e\u5750\u6807\u5904\u7684\u4e9a\u4e34\u754c\u91cd\u529b\u4e95\u3002", opad, Misc.getHighlightColor(), "\u6a2a\u8f74\u8df3\u8dc3");
            }
        } else if (this.currentStage == Stage.INVESTIGATE_SITE) {
            info.addPara("\u8bbe\u6cd5\u4e86\u89e3 \u901f\u5b50\u79d1\u6280 \u5728 \u963f\u5c14\u6cd5\u7814\u7a76\u7ad9 \u5de5\u4f5c\u7684\u76ee\u7684\u3002", opad);
            info.addPara("\u53ef\u9009\uff1a\u627e\u5230 ISS Hamatsu \u53f7\uff0c\u5e76\u5c06\u5176\u8fd8\u7ed9 " + this.callisto.getNameString() + ".", opad);
            info.addPara("\u53ef\u9009\uff1a\u627e\u5230 Kelise Astraia.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u5e26\u7740\u626b\u63cf\u6570\u636e\u56de\u5230 Galatia \u5b66\u9662\uff0c\u5e76\u8054\u7cfb " + this.getPerson().getNameString() + ".", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GET_KELISE_LEAD) {
            info.addPara("\u627e\u5230 Kelise Astraia \u7684\u4e0b\u843d", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.SELL_BLACKMAIL_MATERIAL) {
            info.addPara("\u628a Arroyo \u7684\u4f2a\u52a3\u901a\u8baf\u5668\u5356\u7ed9\u4e00\u540d\u6709\u5730\u4f4d\u7684\u6d77\u76d7", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.SOLD_BLACKMAIL_MATERIAL) {
            info.addPara(this.getGoTalkToPersonText(this.arroyo), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.TALK_TO_CALLISTO) {
            info.addPara(this.getGoTalkToPersonText(this.callisto), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GO_TO_RELAY_SYSTEM) {
            info.addPara(this.getGoToSystemTextShort(this.relaySystem), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GO_TO_NASCENT_WELL) {
            info.addPara("\u8c03\u67e5\u4e2d\u7ee7\u5668\u6765\u83b7\u53d6\u8d85\u7a7a\u95f4\u5750\u6807", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.INVESTIGATE_SITE) {
            info.addPara("\u8c03\u67e5 \u963f\u5c14\u6cd5\u7814\u7a76\u7ad9", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("\u8fd4\u56de Galatia \u5b66\u9662\uff0c\u5411 Baird \u9662\u957f\u62a5\u544a", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u901a\u7075\u5854\u8ba1\u5212";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    @Override
    public void setCurrentStage(Object next, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.setCurrentStage(next, dialog, memoryMap);
        if (next == Stage.RETURN_TO_ACADEMY) {
            Global.getSector().getMemoryWithoutUpdate().unset(SCANNED_ZIGGURAT);
        } else if (next == Stage.GO_TO_RELAY_SYSTEM && this.hamatsu != null) {
            Misc.makeImportant(this.hamatsu, this.getReason());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        GET_KELISE_LEAD,
        SELL_BLACKMAIL_MATERIAL,
        SOLD_BLACKMAIL_MATERIAL,
        TALK_TO_CALLISTO,
        GO_TO_RELAY_SYSTEM,
        GO_TO_NASCENT_WELL,
        INVESTIGATE_SITE,
        RETURN_TO_ACADEMY,
        COMPLETED;

    }
}

