/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.world.TTBlackSite;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAReturnHamatsu
extends GABaseMission {
    protected PersonAPI callisto;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaRH_ref", null)) {
            return false;
        }
        this.callisto = this.getImportantPerson(People.IBRAHIM);
        if (this.callisto == null) {
            return false;
        }
        this.setPersonOverride(this.callisto);
        this.setStartingStage((Object)Stage.RETURN_HAMATSU);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.connectWithGlobalFlag((Object)Stage.RETURN_HAMATSU, (Object)Stage.COMPLETED, "$gaRH_completed");
        this.connectWithGlobalFlag((Object)Stage.RETURN_HAMATSU, (Object)Stage.FAILED, "$gaRH_failed");
        this.makeImportant(this.callisto, "$gaRH_returnHere", Stage.RETURN_HAMATSU);
        this.setCreditReward(100000);
        this.setRepRewardPerson(Float.valueOf(0.1f));
        this.setRepRewardFaction(Float.valueOf(0.05f));
        this.setRepPenaltyPerson(Float.valueOf(0.0f));
        this.setRepPenaltyFaction(Float.valueOf(0.0f));
        this.setPersonIsPotentialContactOnSuccess(this.callisto, 1.0f);
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("refusedToReturn".equals(action)) {
            if (this.rollProbability(0.5f)) {
                DelayedFleetEncounter e = new DelayedFleetEncounter(this.genRandom, this.getMissionId());
                e.setDelayMedium();
                e.setLocationInnerSector(false, "independent");
                e.beginCreate();
                e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "patrolLarge", new Vector2f());
                e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
                e.triggerFleetSetFaction("independent");
                e.triggerSetFleetFlag("$gaRH_consequences");
                e.triggerMakeNoRepImpact();
                e.triggerSetStandardAggroInterceptFlags();
                e.endCreate();
            }
            return true;
        }
        if ("transferHamatsu".equals(action)) {
            FleetMemberAPI hamatsu = null;
            for (FleetMemberAPI member : Global.getSector().getPlayerFleet().getFleetData().getMembersListCopy()) {
                if (!member.getId().equals(TTBlackSite.HAMATSU_ID)) continue;
                hamatsu = member;
                break;
            }
            if (hamatsu != null) {
                AddRemoveCommodity.addFleetMemberLossText(hamatsu, dialog.getTextPanel());
                Global.getSector().getPlayerFleet().getFleetData().removeFleetMember(hamatsu);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaRH_stage", this.getCurrentStage());
        this.set("$gaRH_reward", Misc.getWithDGS(this.getCreditsReward()));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.RETURN_HAMATSU) {
            GAReturnHamatsu.addStandardMarketDesc("\u5c06 ISS Hamatsu \u53f7\u8fd8\u7ed9 " + this.callisto.getNameString() + " " + this.callisto.getMarket().getOnOrAt(), this.callisto.getMarket(), info, opad);
            info.addPara("\u7531\u4e8e Hamatsu \u53f7\u662f\u5979\u7b2c\u4e00\u8258\u6307\u6325\u7684\u65d7\u8230\uff0c\u56e0\u6b64\u5979\u613f\u610f\u7ed9\u5f52\u8fd8\u5b83\u7684\u4eba\u4e88\u4ee5\u5927\u7b14\u5956\u52b1\u3002", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.RETURN_HAMATSU) {
            info.addPara("\u5c06 ISS Hamatsu \u53f7\u8fd8\u7ed9 " + this.callisto.getNameString(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u5f52\u8fd8 ISS Hamatsu \u53f7";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        RETURN_HAMATSU,
        COMPLETED,
        FAILED;

    }
}

