/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.askonia;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddShip;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TheUsurpers
extends HubMissionWithSearch {
    public static float EXTACT_AGENT_RAID_DIFFICULTY = 200.0f;
    protected PersonAPI ram;
    protected PersonAPI hyder;
    protected PersonAPI caden;
    protected PersonAPI macario;
    protected PersonAPI patrolSecond;
    protected MarketAPI umbra;
    protected MarketAPI sindria;
    protected MarketAPI volturn;
    protected SectorEntityToken debris;
    protected int marineLosses;
    protected int marineLossesMin;
    protected int marineLossesMax;
    protected int xpRewardLow;
    protected int xpRewardMedium;
    protected int xpRewardHigh;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$sdtu_ref", "$sdtu_inProgress")) {
            return false;
        }
        this.setPersonOverride(null);
        this.ram = this.getImportantPerson(People.RAM);
        if (this.ram == null) {
            return false;
        }
        this.hyder = this.getImportantPerson(People.HYDER);
        if (this.hyder == null) {
            return false;
        }
        this.caden = this.getImportantPerson(People.CADEN);
        if (this.caden == null) {
            return false;
        }
        this.macario = this.getImportantPerson(People.MACARIO);
        if (this.macario == null) {
            return false;
        }
        this.umbra = this.getMarket("umbra");
        if (this.umbra == null) {
            return false;
        }
        if (!this.umbra.getFactionId().equals("pirates")) {
            return false;
        }
        this.volturn = this.getMarket("volturn");
        if (this.volturn == null) {
            return false;
        }
        if (!this.volturn.getFactionId().equals("sindrian_diktat")) {
            return false;
        }
        this.sindria = this.getMarket("sindria");
        if (this.sindria == null) {
            return false;
        }
        if (!this.sindria.getFactionId().equals("sindrian_diktat")) {
            return false;
        }
        this.setStoryMission();
        this.setStartingStage((Object)Stage.MEET_RAM);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.marineLossesMax = 4;
        this.marineLossesMin = 1;
        this.marineLosses = this.marineLossesMin + this.genRandom.nextInt(this.marineLossesMax - this.marineLossesMin + 1);
        this.xpRewardLow = 2000;
        this.xpRewardMedium = 5000;
        this.xpRewardHigh = 12000;
        this.patrolSecond = Global.getSector().getFaction("sindrian_diktat").createRandomPerson(this.genRandom);
        this.patrolSecond.setRankId(Ranks.SPACE_LIEUTENANT);
        this.patrolSecond.setPostId(Ranks.POST_FLEET_COMMANDER);
        this.makeImportant(this.volturn, "$sdtu_meetRamOnVolturn", Stage.MEET_RAM);
        this.makeImportant(this.hyder, "$sdtu_meetHyder", Stage.MEET_HYDER);
        this.makeImportant(this.macario, "$sdtu_didHyderMeeting", Stage.RETURN_TO_MACARIO);
        this.makeImportant(this.umbra, "$sdtu_extractAgent", Stage.EXTRACT_AGENT);
        this.makeImportant(this.caden, "$sdtu_meetCaden", Stage.MEET_CADEN);
        this.makeImportant(this.macario, "$sdtu_didCadenMeeting", Stage.AGAIN_WTH_MACARIO);
        this.makeImportant(this.macario, "$sdtu_deliverNews", Stage.DELIVER_NEWS);
        this.connectWithGlobalFlag((Object)Stage.MEET_RAM, (Object)Stage.INTERCEPT_FLEET, "$sdtu_interceptFleet");
        this.connectWithGlobalFlag((Object)Stage.INTERCEPT_FLEET, (Object)Stage.MEET_HYDER, "$sdtu_meetHyder");
        this.connectWithGlobalFlag((Object)Stage.MEET_HYDER, (Object)Stage.RETURN_TO_MACARIO, "$sdtu_reportToMacario1");
        this.connectWithGlobalFlag((Object)Stage.RETURN_TO_MACARIO, (Object)Stage.EXTRACT_AGENT, "$sdtu_extractAgent");
        this.connectWithGlobalFlag((Object)Stage.EXTRACT_AGENT, (Object)Stage.MEET_CADEN, "$sdtu_meetCaden");
        this.connectWithGlobalFlag((Object)Stage.MEET_CADEN, (Object)Stage.AGAIN_WTH_MACARIO, "$sdtu_reportToMacario2");
        this.connectWithGlobalFlag((Object)Stage.AGAIN_WTH_MACARIO, (Object)Stage.EMERGENCY_INTERCEPT, "$sdtu_emergencyIntercept");
        this.connectWithGlobalFlag((Object)Stage.EMERGENCY_INTERCEPT, (Object)Stage.DELIVER_NEWS, "$sdtu_deliverNews");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$sdtu_completed");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        this.beginStageTrigger(new Object[]{Stage.INTERCEPT_FLEET});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.DEFAULT, "sindrian_diktat", "patrolMedium", this.sindria.getStarSystem());
        this.triggerMakeNonHostile();
        this.triggerMakeNoRepImpact();
        this.triggerMakeFleetIgnoredByOtherFleets();
        this.triggerMakeFleetIgnoreOtherFleetsExceptPlayer();
        this.triggerMakeFleetIgnoreOtherFleetsExceptPlayer();
        this.triggerPickLocationAroundEntity(this.volturn.getPlanetEntity(), 800.0f);
        this.triggerSetFleetMissionRef("$sdtu_ref");
        this.triggerFleetMakeImportant(null, Stage.INTERCEPT_FLEET);
        this.triggerFleetAddDefeatTrigger("sdtuPatrolDefeated");
        this.triggerSaveGlobalFleetRef("$sdtu_traitorPatrol");
        this.triggerSetPatrol();
        this.triggerOrderFleetPatrol(this.sindria.getStarSystem());
        this.triggerSpawnFleetAtPickedLocation("$sdtu_interceptFleet", null);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.EXTRACT_AGENT});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolMedium", this.umbra.getPlanetEntity());
        this.triggerFleetSetName("Askonia \u9769\u547d\u8005\u59d4\u5458\u4f1a \u88ad\u51fb\u8230\u961f");
        this.triggerSetFleetFaction("pirates");
        this.triggerAutoAdjustFleetStrengthMajor();
        this.triggerSetStandardAggroPirateFlags();
        this.triggerPickLocationTowardsPlayer(this.umbra.getPlanetEntity(), 90.0f, TheUsurpers.getUnits(0.25f));
        this.triggerPickLocationAroundEntity(this.umbra.getPlanetEntity(), 200.0f);
        this.triggerSpawnFleetAtPickedLocation("$sdtu_antisFleet", null);
        this.triggerSetFleetMissionRef("$sdtu_ref");
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.MEET_CADEN});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGER, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolLarge", this.umbra.getPlanetEntity());
        this.triggerFleetSetName("Askonia \u9769\u547d\u8005\u59d4\u5458\u4f1a \u88ad\u51fb\u8005\u5de1\u903b\u961f");
        this.triggerSetFleetFaction("pirates");
        this.triggerAutoAdjustFleetStrengthMajor();
        this.triggerSetStandardAggroPirateFlags();
        this.triggerPickLocationAroundEntity(this.umbra.getPlanetEntity(), 500.0f);
        this.triggerSpawnFleetAtPickedLocation("$sdtu_antisRevengeFleet", null);
        this.triggerSetFleetMissionRef("$sdtu_ref");
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$sdtu_missionCompleted", true);
        this.triggerMakeNonStoryCritical(this.volturn, this.umbra, this.sindria);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$sdtu_stage", this.getCurrentStage());
        this.set("$sdtu_extractAgentRaidDifficulty", Float.valueOf(EXTACT_AGENT_RAID_DIFFICULTY));
        this.set("$sdtu_marineLosses", this.marineLosses);
        this.set("$sdtu_patrolSecond", this.patrolSecond);
        this.set("$sdtu_xpRewardLow", this.xpRewardLow);
        this.set("$sdtu_xpRewardMedium", this.xpRewardMedium);
        this.set("$sdtu_xpRewardHigh", this.xpRewardHigh);
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("spawnDebris".equals(action)) {
            StarSystemAPI system = this.sindria.getStarSystem();
            DebrisFieldTerrainPlugin.DebrisFieldParams p = new DebrisFieldTerrainPlugin.DebrisFieldParams(150.0f, -1.0f, 1.0E7f, 0.0f);
            p.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
            p.baseSalvageXP = 500L;
            this.debris = Misc.addDebrisField(system, p, StarSystemGenerator.random);
            SalvageSpecialAssigner.assignSpecialForDebrisField(this.debris);
            this.debris.getMemoryWithoutUpdate().set("$sdtuAgentDebris", true);
            List<SectorEntityToken> jumpPoints = system.getJumpPoints();
            this.debris.setCircularOrbit(jumpPoints.get(jumpPoints.size() - 1), 90.0f, 200.0f, 100.0f);
            Misc.makeImportant(this.debris, this.getMissionId());
            this.beginStageTrigger(new Object[]{Stage.EMERGENCY_INTERCEPT});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.VERY_HIGH, "mercenary", "mercPrivateer", system);
            this.triggerSetFleetFaction("independent");
            this.triggerFleetSetName("\u8d4f\u91d1\u730e\u4eba\u96c7\u4f63\u5175");
            this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
            this.triggerMakeHostileAndAggressive();
            this.triggerMakeNoRepImpact();
            this.triggerPickLocationAroundEntity(this.debris, 500.0f);
            this.triggerSpawnFleetAtPickedLocation("$sdtu_merc", null);
            this.triggerOrderFleetPatrol(true, this.debris);
            this.endTrigger();
            return true;
        }
        if ("makeDerbisUnimportant".equals(action)) {
            if (this.debris != null) {
                Misc.makeUnimportant(this.debris, this.getMissionId());
            }
            return true;
        }
        if ("shootEm".equals(action)) {
            Global.getSoundPlayer().playSound("storyevent_diktat_execution", 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
            return true;
        }
        if ("endMusic".equals(action)) {
            Global.getSoundPlayer().setSuspendDefaultMusicPlayback(true);
            Global.getSoundPlayer().pauseMusic();
            return true;
        }
        if ("playMusicMacario".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_diktat_market_hostile", true);
            return true;
        }
        if ("playMusicCaden".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_diktat_encounter_hostile", true);
            return true;
        }
        if ("playMusicHyder".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_diktat_encounter_friendly", true);
            return true;
        }
        if ("playMusicSons".equals(action)) {
            Global.getSoundPlayer().playCustomMusic(1, 1, "music_diktat_market_friendly", true);
            return true;
        }
        if ("resumeMusic".equals(action)) {
            Global.getSoundPlayer().setSuspendDefaultMusicPlayback(false);
            Global.getSoundPlayer().restartCurrentMusic();
            return true;
        }
        if ("giveKineticBlasters".equals(action)) {
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            cargo.addWeapons("kineticblaster", 3);
            CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, "ship_weapons", cargo);
            AddRemoveCommodity.addStackGainText(stack, dialog.getTextPanel());
            return true;
        }
        if ("giveGigacannon".equals(action)) {
            CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
            cargo.addWeapons("gigacannon", 2);
            CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, "ship_weapons", cargo);
            AddRemoveCommodity.addStackGainText(stack, dialog.getTextPanel());
            return true;
        }
        if ("giveExecutor".equals(action)) {
            String variantId = "executor_Hull";
            ShipVariantAPI variant = Global.getSettings().getVariant(variantId).clone();
            FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variant);
            Global.getSector().getPlayerFleet().getFleetData().addFleetMember(member);
            AddShip.addShipGainText(member, dialog.getTextPanel());
            return true;
        }
        if ("replacePatrolLeader".equals(action)) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
            fleet.setCommander(this.patrolSecond);
            fleet.getAI().addAssignmentAtStart(FleetAssignment.STANDING_DOWN, fleet, 0.5f + 0.5f * (float)Math.random(), null);
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            BattleAPI b = pf.getBattle();
            if (b != null) {
                b.leave(pf, false);
            }
            return true;
        }
        if ("tryMakeHyderImportant".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getName().equals("Askonia \u661f\u7cfb\u9632\u5fa1\u65e0\u654c\u8230\u961f")) continue;
                Misc.makeImportant(fleet, "$sdtu_ref");
            }
            return true;
        }
        if ("tryMakeHyderUnimportant".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getName().equals("Askonia \u661f\u7cfb\u9632\u5fa1\u65e0\u654c\u8230\u961f")) continue;
                Misc.makeUnimportant(fleet, "$sdtu_ref");
            }
            return true;
        }
        if ("tryMakeCadenImportant".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getName().equals("\u72ee\u5fc3\u536b\u961f\u5927\u65e0\u654c\u8230\u961f")) continue;
                Misc.makeImportant(fleet, "$sdtu_ref");
            }
            return true;
        }
        if ("tryMakeCadenUnimportant".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getName().equals("\u72ee\u5fc3\u536b\u961f\u5927\u65e0\u654c\u8230\u961f")) continue;
                Misc.makeUnimportant(fleet, "$sdtu_ref");
            }
            return true;
        }
        if ("makeMercHostile".equals(action)) {
            for (CampaignFleetAPI fleet : this.volturn.getStarSystem().getFleets()) {
                if (!fleet.getMemoryWithoutUpdate().contains("$sdtu_merc")) continue;
                fleet.getMemoryWithoutUpdate().set("$cfai_longPursuit", true);
                Misc.makeHostile(fleet);
                AbilityPlugin eb = fleet.getAbility("emergency_burn");
                if (eb == null || !eb.isUsable()) continue;
                eb.activate();
            }
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.MEET_RAM) {
            info.addPara("\u5728 Volturn \u7684\u5b89\u5168\u5c4b\u4f1a\u89c1 Yannick Ram \u3002\u4ed6\u6709\u4e2a\u80fd\u591f\u4ece \u8f9b\u8fbe\u5f3a\u6743 \u81ea\u8eab\u4e2d\u89e3\u6551 \u5f3a\u6743\u7684\u8ba1\u5212\u3002", opad);
            TheUsurpers.addStandardMarketDesc("Ram \u7ed9\u4e86\u4f60\u4ed6\u7684\u5b89\u5168\u5c4b\u7684\u4f4d\u7f6e" + this.volturn.getOnOrAt(), this.volturn, info, opad);
        } else if (this.currentStage == Stage.INTERCEPT_FLEET) {
            info.addPara("\u627e\u5230\u5e76\u62e6\u622a\u7531 \"\u53db\u56fd\" \u519b\u5b98\u9886\u5bfc\u7684\u8f9b\u8fbe\u5f3a\u6743\u5de1\u903b\u961f\u3002\u53ef\u4ee5\u5728 Askonia \u661f\u7cfb\u4e2d\u627e\u5230\u3002", opad);
        } else if (this.currentStage == Stage.MEET_HYDER) {
            info.addPara("\u5229\u7528 \"\u53db\u56fd\" \u519b\u5b98\u4f5c\u4e3a\u7a81\u7834\u53e3\uff0c\u63a5\u8fd1 \u526f\u661f\u9645\u5143\u5e05 Hyder\u3002\u5979\u6307\u6325\u7740 Askonia \u661f\u7cfb\u9632\u5fa1\u65e0\u654c\u8230\u961f\uff0c\u8fd9\u662f\u4e00\u652f\u5728 Askonia \u661f\u7cfb\u5185\u5de1\u903b\u7684\u5927\u578b\u8230\u961f\u3002", opad);
        } else if (this.currentStage == Stage.RETURN_TO_MACARIO) {
            info.addPara("\u628a\u4f60\u8ddf Hyder \u7684\u8c08\u8bdd\u6c47\u62a5\u7ed9 Macario\u3002", opad);
            TheUsurpers.addStandardMarketDesc("\u6700\u9ad8\u68c0\u5bdf\u957f Macario \u4f4d\u4e8e " + this.sindria.getOnOrAt(), this.sindria, info, opad);
        } else if (this.currentStage == Stage.EXTRACT_AGENT) {
            info.addPara("\u89e3\u6551\u4e00\u4f4d\u66ff Horacio Caden \u529e\u4e8b\u7684\u540c\u65f6\u80cc\u53db\u4e86 \u8f9b\u8fbe\u5f3a\u6743 \u7684\u53cc\u9762\u95f4\u8c0d\u3002", opad);
            TheUsurpers.addStandardMarketDesc("\u90a3\u4f4d '\u53db\u56fd' \u53cc\u9762\u95f4\u8c0d\u4f4d\u4e8e " + this.umbra.getOnOrAt(), this.umbra, info, opad);
        } else if (this.currentStage == Stage.MEET_CADEN) {
            info.addPara("\u5229\u7528 \"\u53db\u56fd\" \u7279\u5de5\u4f5c\u4e3a\u7a81\u7834\u53e3\uff0c\u63a5\u8fd1 \u536b\u961f\u526f\u9996\u957f Caden \u3002\u4ed6\u6307\u6325\u7740\u72ee\u5fc3\u536b\u961f\u5927\u65e0\u654c\u8230\u961f\uff0c\u8fd9\u662f\u4e00\u652f\u5728 Askonia \u661f\u7cfb\u5185\u5de1\u903b\u7684\u5927\u578b\u8230\u961f\u3002", opad);
        } else if (this.currentStage == Stage.AGAIN_WTH_MACARIO) {
            info.addPara("\u628a\u4f60\u8ddf Caden \u7684\u8c08\u8bdd\u6c47\u62a5\u7ed9 Macario\u3002", opad);
            TheUsurpers.addStandardMarketDesc("\u6700\u9ad8\u68c0\u5bdf\u957f Macario \u4f4d\u4e8e " + this.sindria.getOnOrAt(), this.sindria, info, opad);
        } else if (this.currentStage == Stage.EMERGENCY_INTERCEPT) {
            info.addPara("\u524d\u5f80 Askonia \u7684\u8fb9\u7f18\u8df3\u8dc3\u70b9\u62e6\u622a\u5e76\u6293\u6355\u6216\u534f\u52a9 Macario \u7684\u7279\u5de5\u3002", opad);
        } else if (this.currentStage == Stage.DELIVER_NEWS) {
            info.addPara("\u5411 Macario \u6c47\u62a5\u4ed6\u7684\u7279\u5de5\u5df2\u7ecf\u8eab\u4ea1\u3002", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.MEET_RAM) {
            info.addPara("\u5728 Volturn \u7684\u5b89\u5168\u5c4b\u4f1a\u89c1 Yannick Ram \u3002", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.INTERCEPT_FLEET) {
            info.addPara("\u5728 Askonia \u661f\u7cfb\u62e6\u622a\u53db\u5f92\u7684\u5de1\u903b\u8230\u961f\u3002", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.MEET_HYDER) {
            info.addPara("\u548c Oxana Hyder \u4ea4\u8c08\u3002\u5979\u6307\u6325 Askonia \u661f\u7cfb\u7684\u9632\u5fa1\u8230\u961f\u3002", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_MACARIO) {
            info.addPara("\u5230 Sindria \u548c Macario \u8ba8\u8bba Hyder\u3002", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.EXTRACT_AGENT) {
            info.addPara("\u4ece Umbra \u56de\u6536 \u53cc\u9762\u7279\u5de5\u3002", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.MEET_CADEN) {
            info.addPara("\u4e0e Horacio Caden \u5bf9\u8bdd\u3002\u4ed6\u6307\u6325\u7740\u72ee\u5fc3\u536b\u961f\u5927\u65e0\u654c\u8230\u961f\u3002", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.AGAIN_WTH_MACARIO) {
            info.addPara("\u5230 Sindria \u548c Macario \u8ba8\u8bba Caden\u3002", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.EMERGENCY_INTERCEPT) {
            info.addPara("\u5230\u6307\u5b9a\u5730\u70b9\u62e6\u622a Macario \u7684\u7279\u5de5", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.DELIVER_NEWS) {
            info.addPara("\u56de\u5230 Sindria \u5411 Macario \u6c47\u62a5\u4ed6\u7684\u7279\u5de5\u5df2\u7ecf\u8eab\u4ea1\u3002", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "\u7be1\u4f4d\u8005\u4eec";
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        MEET_RAM,
        INTERCEPT_FLEET,
        MEET_HYDER,
        RETURN_TO_MACARIO,
        EXTRACT_AGENT,
        MEET_CADEN,
        AGAIN_WTH_MACARIO,
        EMERGENCY_INTERCEPT,
        DELIVER_NEWS,
        COMPLETED;

    }
}

