/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;

public class CBDerelict
extends BaseCustomBountyCreator {
    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        return super.getFrequency(mission, difficulty) * CBStats.DERELICT_FREQ;
    }

    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - \u5931\u843d\u8230\u961f";
    }

    public String getIconName() {
        return Global.getSettings().getSpriteName("campaignMissions", "derelict_bounty");
    }

    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        StarSystemAPI system;
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        mission.requireSystemTags(ReqMode.NOT_ANY, "theme_core");
        mission.requireSystemNotHasPulsar();
        mission.preferSystemBlackHoleOrNebula();
        mission.preferSystemOnFringeOfSector();
        data.system = system = mission.pickSystem();
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.AI_GAMMA;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.ALL_SHIPS;
        if (difficulty <= 5) {
            size = HubMissionWithTriggers.FleetSize.MEDIUM;
        } else if (difficulty == 6) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
        } else if (difficulty == 7) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
        } else if (difficulty == 8) {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
        } else if (difficulty == 9) {
            size = HubMissionWithTriggers.FleetSize.HUGE;
        } else if (difficulty >= 10) {
            size = HubMissionWithTriggers.FleetSize.MAXIMUM;
        }
        this.beginFleet(mission, data);
        mission.triggerCreateFleet(size, quality, "derelict", "patrolMedium", data.system);
        mission.triggerSetFleetOfficers(oNum, oQuality);
        mission.triggerAutoAdjustFleetSize(size, size.next());
        mission.triggerSetRemnantConfigActive();
        mission.triggerSetFleetFaction("derelict");
        mission.triggerFleetSetName("\u5931\u843d\u8230\u961f");
        mission.triggerFleetAddTags("neutrino_high");
        mission.triggerFleetAddCommanderSkill("derelict_contingent", 1);
        mission.triggerMakeHostileAndAggressive();
        mission.triggerMakeNoRepImpact();
        mission.triggerDoNotShowFleetDesc();
        mission.triggerFleetForceAutofitOnAllShips();
        mission.triggerFleetSetAllWeapons();
        mission.triggerPickLocationAtInSystemJumpPoint(data.system);
        mission.triggerSpawnFleetAtPickedLocation(null, null);
        mission.triggerFleetSetPatrolActionText("\u6b63\u5728\u83b7\u53d6\u6570\u636e");
        mission.triggerOrderFleetPatrol(data.system, true, "jump_point", "neutrino", "neutrino_high", "gas_giant");
        data.fleet = this.createFleet(mission, data);
        if (data.fleet == null) {
            return null;
        }
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.DERELICT_MULT, mission);
        return data;
    }

    public int getMaxDifficulty() {
        return super.getMaxDifficulty();
    }

    public int getMinDifficulty() {
        return 5;
    }
}

