/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;

public class CBDeserter
extends BaseCustomBountyCreator {
    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        if ("pirates".equals(mission.getPerson().getFaction().getId())) {
            return 0.0f;
        }
        return super.getFrequency(mission, difficulty) * CBStats.DESERTER_FREQ;
    }

    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - \u9003\u5175";
    }

    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        StarSystemAPI system;
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        mission.requireSystemInterestingAndNotUnsafeOrCore();
        mission.requireSystemNotHasPulsar();
        data.system = system = mission.pickSystem();
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
        String type = "patrolMedium";
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
        FactionAPI faction = mission.getPerson().getFaction();
        if (difficulty <= 4) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = "patrolSmall";
        } else if (difficulty <= 5) {
            size = HubMissionWithTriggers.FleetSize.MEDIUM;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = "patrolMedium";
        } else if (difficulty == 6) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = "patrolLarge";
        } else if (difficulty == 7) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = "patrolLarge";
        } else if (difficulty == 8) {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = "patrolLarge";
        } else if (difficulty == 9) {
            size = HubMissionWithTriggers.FleetSize.HUGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = "patrolLarge";
        } else {
            size = HubMissionWithTriggers.FleetSize.MAXIMUM;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = "patrolLarge";
        }
        this.beginFleet(mission, data);
        mission.triggerCreateFleet(size, quality, faction.getId(), type, data.system);
        mission.triggerSetFleetOfficers(oNum, oQuality);
        mission.triggerAutoAdjustFleetSize(size, size.next());
        mission.triggerSetFleetFaction("pirates");
        mission.triggerFleetSetShipPickMode(FactionAPI.ShipPickMode.PRIORITY_THEN_ALL);
        mission.triggerFleetSetNoFactionInName();
        if (faction.getEntityNamePrefix() == null || faction.getEntityNamePrefix().isEmpty()) {
            mission.triggerFleetSetName("\u9003\u5175");
        } else {
            mission.triggerFleetSetName(String.valueOf(faction.getEntityNamePrefix()) + " \u9003\u5175");
        }
        mission.triggerSetStandardAggroPirateFlags();
        mission.triggerPickLocationAtInSystemJumpPoint(data.system);
        mission.triggerSpawnFleetAtPickedLocation(null, null);
        mission.triggerOrderFleetPatrol(data.system, true, "jump_point", "salvageable", "planet");
        data.fleet = this.createFleet(mission, data);
        if (data.fleet == null) {
            return null;
        }
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.DESERTER_MULT, mission);
        return data;
    }

    public int getMaxDifficulty() {
        return super.getMaxDifficulty();
    }

    public int getMinDifficulty() {
        return 4;
    }
}

