/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.econ.impl.OrbitalStation;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBounty;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBEnemyStation
extends BaseCustomBountyCreator {
    @Override
    public float getBountyDays() {
        return CBStats.ENEMY_STATION_DAYS;
    }

    @Override
    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        if (this.getStations(mission, difficulty).isEmpty()) {
            return 0.0f;
        }
        return super.getFrequency(mission, difficulty) * CBStats.ENEMY_STATION_FREQ;
    }

    @Override
    public void addIntelAssessment(TextPanelAPI text, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        float opad = 10.0f;
        ArrayList<FleetMemberAPI> list = new ArrayList<FleetMemberAPI>();
        List<FleetMemberAPI> members = data.fleet.getFleetData().getMembersListCopy();
        int max = 7;
        int cols = 7;
        float iconSize = 440 / cols;
        Color h = Misc.getHighlightColor();
        for (FleetMemberAPI member : members) {
            if (list.size() >= max) break;
            if (member.isFighterWing()) continue;
            FleetMemberAPI copy = Global.getFactory().createFleetMember(FleetMemberType.SHIP, member.getVariant());
            if (member.isFlagship()) {
                copy.setCaptain(data.fleet.getCommander());
            }
            list.add(copy);
        }
        if (!list.isEmpty()) {
            TooltipMakerAPI info = text.beginTooltip();
            info.setParaSmallInsignia();
            info.addPara(String.valueOf(Misc.ucFirst(mission.getPerson().getHeOrShe())) + "\u4e0d\u52a8\u58f0\u8272\u5730\u5c06\u4efb\u52a1\u8be6\u60c5" + "\u4f20\u9001\u5230\u4f60\u7684 TriPad \u4e0a\u3002", 0.0f);
            info.addShipList(cols, 1, iconSize, data.fleet.getFaction().getBaseUIColor(), list, opad);
            FactionAPI f = data.fleet.getFaction();
            info.addPara("\u8be5\u7a7a\u95f4\u7ad9\u76ee\u524d\u7531 " + f.getDisplayNameWithArticle() + " \u63a7\u5236\uff0c\u5e76\u5f88\u53ef\u80fd\u5f97\u5230" + " \u4e00\u4e9b\u5de1\u903b\u961f\u7684\u652f\u63f4\u3002", opad, f.getBaseUIColor(), f.getDisplayNameWithArticleWithoutArticle());
            text.addTooltip();
        }
    }

    @Override
    public void addFleetDescription(TooltipMakerAPI info, float width, float height, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        PersonAPI person = data.fleet.getCommander();
        FactionAPI faction = person.getFaction();
        int cols = 7;
        float iconSize = width / (float)cols;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        boolean deflate = false;
        if (!data.fleet.isInflated()) {
            data.fleet.inflateIfNeeded();
            deflate = true;
        }
        ArrayList<FleetMemberAPI> list = new ArrayList<FleetMemberAPI>();
        List<FleetMemberAPI> members = data.fleet.getFleetData().getMembersListCopy();
        int max = 7;
        for (FleetMemberAPI member : members) {
            if (list.size() >= max) break;
            if (member.isFighterWing()) continue;
            FleetMemberAPI copy = Global.getFactory().createFleetMember(FleetMemberType.SHIP, member.getVariant());
            if (member.isFlagship()) {
                copy.setCaptain(person);
            }
            list.add(copy);
        }
        if (!list.isEmpty()) {
            info.addPara("\u8be5\u8d4f\u91d1\u4fe1\u606f\u4e2d\u5305\u542b\u6709\u6b64\u7a7a\u95f4\u7ad9\u7684\u90e8\u5206\u60c5\u62a5\u3002", opad);
            info.addShipList(cols, 1, iconSize, faction.getBaseUIColor(), list, opad);
            int num = members.size() - list.size();
            num = num < 5 ? 0 : (num < 10 ? 5 : (num < 20 ? 10 : 20));
            FactionAPI f = data.fleet.getFaction();
            info.addPara("\u8be5\u7a7a\u95f4\u7ad9\u76ee\u524d\u7531 " + f.getDisplayNameWithArticle() + " \u63a7\u5236\uff0c\u5e76\u5f88\u53ef\u80fd\u5f97\u5230" + " \u4e00\u4e9b\u5de1\u903b\u961f\u7684\u652f\u63f4\u3002", opad, f.getBaseUIColor(), f.getDisplayNameWithArticleWithoutArticle());
        }
        if (deflate) {
            data.fleet.deflate();
        }
    }

    public List<CampaignFleetAPI> getStations(HubMissionWithBarEvent mission, int difficulty) {
        ArrayList<CampaignFleetAPI> stations = new ArrayList<CampaignFleetAPI>();
        String faction = mission.getPerson().getFaction().getId();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            CampaignFleetAPI fleet;
            OrbitalStation os;
            Industry ind;
            if (market.isHidden() || market.isPlayerOwned() || market.hasCondition("decivilized") || !market.getFaction().isHostileTo(faction) || !((ind = Misc.getStationIndustry(market)) instanceof OrbitalStation) || (os = (OrbitalStation)ind).getDisruptedDays() > 0.0f) continue;
            boolean battlestation = os.getSpec().hasTag("battlestation");
            boolean starfortress = os.getSpec().hasTag("starfortress");
            if (difficulty == 10 && !starfortress || (difficulty == 8 || difficulty == 9) && !battlestation || !battlestation && !starfortress && difficulty >= 8 || (fleet = Misc.getStationFleet(market)) == null) continue;
            stations.add(fleet);
        }
        return stations;
    }

    @Override
    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - " + data.fleet.getName();
    }

    @Override
    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        WeightedRandomPicker<CampaignFleetAPI> picker = new WeightedRandomPicker<CampaignFleetAPI>(mission.getGenRandom());
        picker.addAll(this.getStations(mission, difficulty));
        data.fleet = (CampaignFleetAPI)picker.pick();
        if (data.fleet == null) {
            return null;
        }
        MarketAPI market = Misc.getStationMarket(data.fleet);
        if (market == null) {
            return null;
        }
        data.market = market;
        data.custom2 = bountyStage;
        data.system = data.fleet.getStarSystem();
        if (data.system == null) {
            return null;
        }
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.ENEMY_STATION_MULT, mission);
        return data;
    }

    @Override
    public void notifyAccepted(MarketAPI createdAt, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        MarketAPI market = data.market;
        Object stage = data.custom2;
        if (data.difficulty <= 7) {
            mission.triggerCreateLargePatrolAroundMarket(market, stage, 0.0f);
            mission.triggerCreateSmallPatrolAroundMarket(market, stage, 0.0f);
        } else if (data.difficulty <= 9) {
            mission.triggerCreateLargePatrolAroundMarket(market, stage, 0.0f);
            mission.triggerCreateMediumPatrolAroundMarket(market, stage, 0.0f);
            mission.triggerCreateSmallPatrolAroundMarket(market, stage, 0.0f);
        } else {
            mission.triggerCreateLargePatrolAroundMarket(market, stage, 0.0f);
            mission.triggerCreateLargePatrolAroundMarket(market, stage, 0.0f);
            mission.triggerCreateMediumPatrolAroundMarket(market, stage, 0.0f);
            mission.triggerCreateSmallPatrolAroundMarket(market, stage, 0.0f);
        }
        mission.connectWithHostilitiesEnded((Object)BaseCustomBounty.Stage.BOUNTY, (Object)BaseCustomBounty.Stage.FAILED_NO_PENALTY, mission.getPerson(), market);
        mission.setStageOnHostilitiesEnded((Object)BaseCustomBounty.Stage.FAILED_NO_PENALTY, mission.getPerson(), market);
    }

    @Override
    public String getIconName() {
        return Global.getSettings().getSpriteName("campaignMissions", "station_bounty");
    }

    @Override
    public int getMaxDifficulty() {
        return super.getMaxDifficulty();
    }

    @Override
    public int getMinDifficulty() {
        return 6;
    }
}

