/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBRemnantStation
extends BaseCustomBountyCreator {
    @Override
    public float getBountyDays() {
        return CBStats.REMNANT_STATION_DAYS;
    }

    @Override
    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        String faction = mission.getPerson().getFaction().getId();
        if (!("hegemony".equals(faction) || "luddic_path".equals(faction) || "luddic_church".equals(faction))) {
            return 0.0f;
        }
        if (this.getStations(mission, difficulty).isEmpty()) {
            return 0.0f;
        }
        return super.getFrequency(mission, difficulty) * CBStats.REMNANT_STATION_FREQ;
    }

    @Override
    public void addIntelAssessment(TextPanelAPI text, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        float opad = 10.0f;
        ArrayList<FleetMemberAPI> list = new ArrayList<FleetMemberAPI>();
        List<FleetMemberAPI> members = data.fleet.getFleetData().getMembersListCopy();
        int max = 7;
        int cols = 7;
        float iconSize = 440 / cols;
        Color h = Misc.getHighlightColor();
        for (FleetMemberAPI member : members) {
            if (list.size() >= max) break;
            if (member.isFighterWing()) continue;
            FleetMemberAPI copy = Global.getFactory().createFleetMember(FleetMemberType.SHIP, member.getVariant());
            if (member.isFlagship()) {
                copy.setCaptain(data.fleet.getCommander());
            }
            list.add(copy);
        }
        if (!list.isEmpty()) {
            TooltipMakerAPI info = text.beginTooltip();
            info.setParaSmallInsignia();
            info.addPara(String.valueOf(Misc.ucFirst(mission.getPerson().getHeOrShe())) + "\u4e0d\u52a8\u58f0\u8272\u5730\u5c06\u4efb\u52a1\u8be6\u60c5" + "\u4f20\u9001\u5230\u4f60\u7684 TriPad \u4e0a\u3002", 0.0f);
            info.addShipList(cols, 1, iconSize, data.fleet.getFaction().getBaseUIColor(), list, opad);
            if (data.difficulty >= 9) {
                info.addPara("\u7ecf\u8bc4\u4f30\uff0c\u8be5\u6bcd\u8230\u529f\u80fd\u9f50\u5168\uff0c\u6781\u5ea6\u5371\u9669\u3002", opad);
            } else {
                info.addPara("\u7ecf\u8bc4\u4f30\uff0c\u8be5\u6bcd\u8230\u5df2\u7ecf\u53d7\u635f\uff0c\u4f46\u4ecd\u9ad8\u5ea6\u5371\u9669\u3002", opad);
            }
            text.addTooltip();
        }
    }

    @Override
    public void addFleetDescription(TooltipMakerAPI info, float width, float height, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        PersonAPI person = data.fleet.getCommander();
        FactionAPI faction = person.getFaction();
        int cols = 7;
        float iconSize = width / (float)cols;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        boolean deflate = false;
        if (!data.fleet.isInflated()) {
            data.fleet.inflateIfNeeded();
            deflate = true;
        }
        ArrayList<FleetMemberAPI> list = new ArrayList<FleetMemberAPI>();
        Random random = new Random(person.getNameString().hashCode() * 170000);
        List<FleetMemberAPI> members = data.fleet.getFleetData().getMembersListCopy();
        int max = 7;
        for (FleetMemberAPI member : members) {
            if (list.size() >= max) break;
            if (member.isFighterWing()) continue;
            float prob = (float)member.getFleetPointCost() / 20.0f;
            prob += (float)max / (float)members.size();
            if (member.isFlagship()) {
                prob = 1.0f;
            }
            if (random.nextFloat() > prob) continue;
            FleetMemberAPI copy = Global.getFactory().createFleetMember(FleetMemberType.SHIP, member.getVariant());
            if (member.isFlagship()) {
                copy.setCaptain(person);
            }
            list.add(copy);
        }
        if (!list.isEmpty()) {
            info.addPara("\u8be5\u8d4f\u91d1\u4fe1\u606f\u4e2d\u5305\u542b\u6709\u6b64\u6bcd\u8230\u7684\u90e8\u5206\u60c5\u62a5\u3002", opad);
            info.addShipList(cols, 1, iconSize, faction.getBaseUIColor(), list, opad);
            int num = members.size() - list.size();
            num = num < 5 ? 0 : (num < 10 ? 5 : (num < 20 ? 10 : 20));
            if (data.difficulty >= 9) {
                info.addPara("\u7ecf\u8bc4\u4f30\uff0c\u8be5\u6bcd\u8230\u529f\u80fd\u9f50\u5168\uff0c\u6781\u5ea6\u5371\u9669\u3002", opad);
            } else {
                info.addPara("\u7ecf\u8bc4\u4f30\uff0c\u8be5\u6bcd\u8230\u5df2\u7ecf\u53d7\u635f\uff0c\u4f46\u4ecd\u9ad8\u5ea6\u5371\u9669\u3002", opad);
            }
        }
        if (deflate) {
            data.fleet.deflate();
        }
    }

    public List<CampaignFleetAPI> getStations(HubMissionWithBarEvent mission, int difficulty) {
        ArrayList<CampaignFleetAPI> stations = new ArrayList<CampaignFleetAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            if (!system.hasTag("theme_remnant_main") || system.hasTag("theme_remnant_destroyed")) continue;
            for (CampaignFleetAPI fleet : system.getFleets()) {
                if (!fleet.isStationMode() || !"remnant".equals(fleet.getFaction().getId())) continue;
                boolean damaged = fleet.getMemoryWithoutUpdate().getBoolean("$damagedStation");
                if ((difficulty == 7 || difficulty == 8) && damaged) {
                    stations.add(fleet);
                    continue;
                }
                if (damaged || difficulty <= 8) continue;
                stations.add(fleet);
            }
        }
        return stations;
    }

    @Override
    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - \u4f59\u8f89\u4e2d\u67a2";
    }

    @Override
    public String getIconName() {
        return Global.getSettings().getSpriteName("campaignMissions", "remnant_bounty");
    }

    @Override
    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        WeightedRandomPicker<CampaignFleetAPI> picker = new WeightedRandomPicker<CampaignFleetAPI>(mission.getGenRandom());
        picker.addAll(this.getStations(mission, difficulty));
        data.fleet = (CampaignFleetAPI)picker.pick();
        if (data.fleet == null) {
            return null;
        }
        data.system = data.fleet.getStarSystem();
        if (data.system == null) {
            return null;
        }
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.REMNANT_STATION_MULT, mission);
        return data;
    }

    @Override
    public int getMaxDifficulty() {
        return super.getMaxDifficulty();
    }

    @Override
    public int getMinDifficulty() {
        return 7;
    }
}

