/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;

public class CBTrader
extends BaseCustomBountyCreator {
    public static float PROB_IN_SYSTEM_WITH_BASE = 0.5f;

    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        return super.getFrequency(mission, difficulty) * CBStats.TRADER_FREQ;
    }

    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - \u8d38\u6613\u8230\u961f";
    }

    public float getBountyDays() {
        return 30.0f;
    }

    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        StarSystemAPI system;
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        data.stage = bountyStage;
        mission.requireMarketSizeAtLeast(4);
        mission.requireMarketNotHidden();
        mission.requireMarketHasSpaceport();
        mission.requireMarketNotInHyperspace();
        mission.requireMarketFactionCustom(ReqMode.NOT_ANY, "decentralized");
        mission.requireMarketFactionNot("pirates");
        mission.requireMarketFactionNotPlayer();
        mission.requireMarketLocationNot(createdAt.getContainingLocation());
        MarketAPI target = mission.pickMarket();
        if (target == null || target.getStarSystem() == null) {
            return null;
        }
        data.system = system = target.getStarSystem();
        data.market = target;
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.SMALL;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.LOWER;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.FEWER;
        String type = "trade";
        if (difficulty <= 3) {
            size = HubMissionWithTriggers.FleetSize.TINY;
            type = "smallTrader";
        }
        this.beginFleet(mission, data);
        mission.triggerCreateFleet(size, quality, "independent", type, data.system);
        mission.triggerSetFleetOfficers(oNum, oQuality);
        mission.triggerSetFleetNoCommanderSkills();
        mission.triggerSetFleetComposition(1.0f, 0.2f, 0.0f, 0.0f, 0.0f);
        mission.triggerSetFleetProbabilityCombatFreighters(0.0f);
        mission.triggerPickLocationAtInSystemJumpPoint(data.system);
        mission.triggerSpawnFleetAtPickedLocation(null, null);
        String expensive = mission.pickOne("luxury_goods", "rare_metals", "volatiles", "lobster");
        String cheap = mission.pickOne("domestic_goods", "food", "organics");
        mission.triggerAddCommodityFractionDrop(expensive, 0.25f);
        mission.triggerAddCommodityFractionDrop(cheap, 0.25f);
        mission.triggerFleetSetPatrolActionText("\u6b63\u7b49\u5019\u6d77\u5173\u68c0\u67e5");
        mission.triggerOrderFleetPatrol(data.system, true, target.getPrimaryEntity());
        mission.triggerFleetSetPatrolLeashRange(800.0f);
        data.fleet = this.createFleet(mission, data);
        if (data.fleet == null) {
            return null;
        }
        data.custom1 = target;
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.TRADER_MULT, mission);
        return data;
    }

    public void notifyAccepted(MarketAPI createdAt, HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.SMALL;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
        String type = "patrolMedium";
        int difficulty = data.difficulty;
        int num = 1;
        if (difficulty > 6) {
            num = 2;
        }
        int i = 0;
        while (i < num) {
            if (difficulty <= 2) {
                size = HubMissionWithTriggers.FleetSize.TINY;
                type = "patrolSmall";
            } else if (difficulty <= 3) {
                size = HubMissionWithTriggers.FleetSize.VERY_SMALL;
                type = "patrolSmall";
            } else if (difficulty <= 4) {
                size = HubMissionWithTriggers.FleetSize.SMALL;
                type = "patrolSmall";
            } else if (difficulty <= 5) {
                size = HubMissionWithTriggers.FleetSize.MEDIUM;
                type = "patrolMedium";
            } else {
                size = HubMissionWithTriggers.FleetSize.LARGE;
                type = "patrolLarge";
            }
            MarketAPI market = (MarketAPI)data.custom1;
            mission.beginWithinHyperspaceRangeTrigger(market, 1.0f, false, data.stage);
            mission.triggerCreateFleet(size, quality, market.getFactionId(), type, market.getPrimaryEntity());
            mission.triggerSetFleetOfficers(oNum, oQuality);
            mission.triggerSetPatrol();
            mission.triggerSpawnFleetNear(data.fleet, null, null);
            mission.triggerFleetSetPatrolActionText("\u6b63\u5728\u4fdd\u62a4 " + data.fleet.getName().toLowerCase());
            mission.triggerFleetSetPatrolLeashRange(100.0f);
            mission.triggerOrderFleetPatrol(data.system, true, data.fleet);
            mission.endTrigger();
            difficulty -= 4;
            ++i;
        }
    }

    public int getMaxDifficulty() {
        return 10;
    }

    public int getMinDifficulty() {
        return 0;
    }
}

