/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainPlugin;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.HasMemory;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.missions.CheapCommodityMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseMissionHub;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionHub;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionTrigger;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHubMission
extends BaseIntelPlugin
implements HubMission {
    public static float DEBRIS_SMALL = 200.0f;
    public static float DEBRIS_MEDIUM = 350.0f;
    public static float DEBRIS_LARGE = 500.0f;
    public static float DEBRIS_SPARSE = 0.25f;
    public static float DEBRIS_AVERAGE = 0.5f;
    public static float DEBRIS_DENSE = 1.0f;
    public static float GLOBAL_MISSION_REWARD_MULT = 1.0f;
    public static int EXTRA_REWARD_PER_MARINE = 50;
    public static String BUTTON_ABANDON = "\u653e\u5f03";
    public static String REMOVE_ON_MISSION_OVER = "remove_on_mission_over";
    protected Object currentStage = null;
    protected LinkedHashMap<Object, StageData> stages = new LinkedHashMap();
    protected Boolean stageTransitionsRepeatable = null;
    protected List<Object> successStages = new ArrayList<Object>();
    protected List<Object> failStages = new ArrayList<Object>();
    protected List<Object> noPenaltyFailStages = new ArrayList<Object>();
    protected Object abandonStage = Abandon.ABANDON;
    protected List<StageConnection> connections = new ArrayList<StageConnection>();
    protected List<MissionTrigger> triggers = new ArrayList<MissionTrigger>();
    protected List<Abortable> changes = new ArrayList<Abortable>();
    protected List<FlagData> flags = new ArrayList<FlagData>();
    protected transient Object startingStage;
    protected transient CargoAPI cargoOnAccept = Global.getFactory().createCargo(true);
    protected CargoAPI cargoOnSuccess = null;
    protected float elapsed = 0.0f;
    protected TimeLimitData timeLimit;
    protected HubMissionResult result;
    protected MissionHub hub;
    protected PersonAPI personOverride = null;
    protected HubMissionCreator creator;
    protected Random genRandom = null;
    protected IntervalUtil tracker = new IntervalUtil(0.09f, 0.11f);
    protected Float repRewardPerson = null;
    protected Float repPenaltyPerson = null;
    protected Float repRewardFaction = null;
    protected Float repPenaltyFaction = null;
    protected Integer creditReward = null;
    protected Integer xpReward = null;
    protected String iconName;
    protected RepLevel rewardLimitPerson = null;
    protected RepLevel rewardLimitFaction = null;
    protected RepLevel penaltyLimitPerson = null;
    protected RepLevel penaltyLimitFaction = null;
    protected String missionId;
    protected float rewardMult = 1.0f;
    protected float quality = 0.0f;
    protected IntelInfoPlugin.IntelSortTier sortTier = null;
    protected List<PotentialContactData> potentialContactsOnMissionSuccess = null;
    protected Boolean doNotAutoAddPotentialContactsOnSuccess = null;
    protected boolean isBarEvent = false;
    protected String baseName = null;
    protected transient boolean aborted = false;
    protected transient MemoryAPI interactionMemory = null;
    protected transient boolean doNotEndMission = false;
    protected Boolean adjustedRep;
    protected Set<String> addedTags = null;
    public static String NEXT_STEP_UPDATE = "next_step_update";
    public static String END_MISSION_UPDATE = "end_mission_update";
    protected Boolean largeTitleFont;
    protected transient String giverFactionId;
    protected transient String giverRank = Ranks.CITIZEN;
    protected transient String giverPost = Ranks.POST_CITIZEN;
    protected transient String giverVoice = null;
    protected transient String giverPortrait;
    protected transient PersonImportance giverImportance = PersonImportance.MEDIUM;
    protected transient String[] giverTags;
    protected transient FullName.Gender giverGender = FullName.Gender.ANY;
    protected String completedKey = null;
    protected Color mapMarkerNameColor = null;

    public void setStageTransitionsRepeatable() {
        this.stageTransitionsRepeatable = true;
    }

    public void setDoNotAutoAddPotentialContactsOnSuccess() {
        this.doNotAutoAddPotentialContactsOnSuccess = true;
    }

    public void setGiverIsPotentialContactOnSuccess() {
        this.setPersonIsPotentialContactOnSuccess(this.getPerson());
    }

    public void setGiverIsPotentialContactOnSuccess(float probability) {
        this.setPersonIsPotentialContactOnSuccess(this.getPerson(), probability);
    }

    public void setPersonIsPotentialContactOnSuccess(PersonAPI person) {
        this.setPersonIsPotentialContactOnSuccess(person, -1.0f);
    }

    public void setPersonIsPotentialContactOnSuccess(PersonAPI person, float probability) {
        PotentialContactData data2;
        if (person == null) {
            return;
        }
        if (this.potentialContactsOnMissionSuccess == null) {
            this.potentialContactsOnMissionSuccess = new ArrayList<PotentialContactData>();
        }
        for (PotentialContactData data2 : this.potentialContactsOnMissionSuccess) {
            if (data2.contact != person) continue;
            return;
        }
        data2 = new PotentialContactData();
        data2.contact = person;
        data2.probability = probability;
        this.potentialContactsOnMissionSuccess.add(data2);
    }

    @Override
    public void setGenRandom(Random random) {
        this.genRandom = random;
    }

    @Override
    public void setMissionId(String missionId) {
        this.missionId = missionId;
    }

    @Override
    public String getMissionId() {
        return this.missionId;
    }

    public boolean isBarEvent() {
        return this.isBarEvent;
    }

    @Override
    public void createAndAbortIfFailed(MarketAPI market, boolean barEvent) {
        this.isBarEvent = barEvent;
        if (this.getPerson() != null) {
            this.genMissionRewardMultAndQuality();
        }
        if (!this.create(market, barEvent)) {
            this.abort();
        }
    }

    protected abstract boolean create(MarketAPI var1, boolean var2);

    public String getBaseName() {
        if (this.baseName != null) {
            return this.baseName;
        }
        return "Call setName(<name>) to set mission name";
    }

    public void setName(String name) {
        this.baseName = name;
    }

    @Override
    public String getBlurbText() {
        return null;
    }

    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        String text = this.getNextStepText();
        if (text != null) {
            info.addPara(text, tc, pad);
            return true;
        }
        return false;
    }

    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
    }

    public void addDescriptionForCurrentStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        String text = this.getStageDescriptionText();
        if (text != null) {
            info.addPara(text, opad);
        } else {
            String noun = this.getMissionTypeNoun();
            String verb = this.getMissionCompletionVerb();
            if (this.isSucceeded()) {
                info.addPara("\u4f60\u5df2\u6210\u529f" + verb + " \u8be5 " + noun + ".", opad);
            } else if (this.isFailed()) {
                info.addPara("\u4f60\u672a\u80fd" + noun + ".", opad);
            } else if (this.isAbandoned()) {
                info.addPara("\u4f60\u653e\u5f03\u4e86\u8be5 " + noun + ".", opad);
            } else {
                this.addDescriptionForNonEndStage(info, width, height);
            }
        }
    }

    public String getStageDescriptionText() {
        return null;
    }

    public String getNextStepText() {
        return null;
    }

    @Override
    protected void advanceImpl(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        StageData stage = this.getData(this.currentStage);
        if (stage != null) {
            stage.elapsed += days;
        }
        this.elapsed += days;
        if (this.timeLimit != null && this.timeLimit.days < this.elapsed && (this.timeLimit.noLimitWhileInSystem == null || this.timeLimit.noLimitWhileInSystem != Global.getSector().getCurrentLocation())) {
            this.setCurrentStage(this.timeLimit.failStage, null, null);
            this.timeLimit = null;
            this.runTriggers();
        }
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed()) {
            this.checkStageChangesAndTriggers(null, null);
        }
    }

    public float getElapsedInCurrentStage() {
        StageData stage = this.getData(this.currentStage);
        if (stage != null) {
            return stage.elapsed;
        }
        return 0.0f;
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    @Override
    public void accept(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        TextPanelAPI text;
        this.setImportant(true);
        if (this.startingStage == null) {
            throw new RuntimeException("startingStage can not be null. Use setStartingStage()");
        }
        this.setCurrentStage(this.startingStage, null, null);
        this.acceptImpl(dialog, memoryMap);
        TextPanelAPI textPanelAPI = text = dialog != null ? dialog.getTextPanel() : null;
        if (this.cargoOnAccept != null) {
            this.cargoOnAccept.sort();
            for (CargoStackAPI stack : this.cargoOnAccept.getStacksCopy()) {
                Global.getSector().getPlayerFleet().getCargo().addItems(stack.getType(), stack.getData(), stack.getSize());
                if (text == null) continue;
                AddRemoveCommodity.addStackGainText(stack, text);
            }
            this.cargoOnAccept.clear();
        }
        Global.getSector().getIntelManager().addIntel(this, false, text);
        Global.getSector().addScript(this);
        this.startingStage = null;
        this.runTriggers();
    }

    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
    }

    @Override
    public void abort() {
        boolean missionWasAccepted = this.currentStage != null;
        for (Abortable curr : this.changes) {
            curr.abort(this, missionWasAccepted);
        }
        this.changes.clear();
        if (!missionWasAccepted) {
            this.aborted = true;
        }
    }

    @Override
    public boolean isMissionCreationAborted() {
        return this.aborted;
    }

    @Override
    public String getTriggerPrefix() {
        return this.getMissionId();
    }

    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        return false;
    }

    protected void addPotentialContacts(InteractionDialogAPI dialog) {
        if (this.potentialContactsOnMissionSuccess != null) {
            for (PotentialContactData curr : this.potentialContactsOnMissionSuccess) {
                PersonAPI p = curr.contact;
                MarketAPI m = curr.contact.getMarket();
                if (m == null) {
                    m = this.getPerson().getMarket();
                }
                if (m == null) continue;
                if (curr.probability < 0.0f) {
                    ContactIntel.addPotentialContact(p, m, dialog != null ? dialog.getTextPanel() : null);
                    continue;
                }
                ContactIntel.addPotentialContact(curr.probability, p, m, dialog != null ? dialog.getTextPanel() : null);
            }
            this.potentialContactsOnMissionSuccess = null;
        }
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        if ("endFailure".equals(action)) {
            Object stage = null;
            if (!this.failStages.isEmpty()) {
                stage = this.failStages.get(0);
            }
            if (stage == null && !this.noPenaltyFailStages.isEmpty()) {
                stage = this.noPenaltyFailStages.get(0);
            }
            if (stage != null) {
                this.setCurrentStage(stage, dialog, memoryMap);
                this.runTriggers();
            }
            return true;
        }
        if ("makeUnimportant".equals(action)) {
            SectorEntityToken target = dialog.getInteractionTarget();
            if (target != null) {
                this.makeUnimportant(target, (Enum)this.currentStage);
                if (target.getMarket() != null) {
                    this.makeUnimportant(target.getMarket(), (Enum)this.currentStage);
                }
                if (target.getActivePerson() != null) {
                    this.makeUnimportant(target.getActivePerson(), (Enum)this.currentStage);
                }
            }
            return true;
        }
        if ("showMap".equals(action)) {
            SectorEntityToken mapLoc = this.getMapLocation(null, this.startingStage);
            if (mapLoc != null) {
                PlanetAPI planet;
                String title = params.get(1).getStringWithTokenReplacement(ruleId, dialog, memoryMap);
                String text = "";
                Set<String> tags = this.getIntelTags(null);
                tags.remove("Accepted");
                String icon = this.getIcon();
                Color color = this.getFactionForUIColors().getBaseUIColor();
                if (mapLoc != null && mapLoc.getFaction() != null && !mapLoc.getFaction().isNeutralFaction()) {
                    color = mapLoc.getFaction().getBaseUIColor();
                } else if (mapLoc instanceof PlanetAPI && (planet = (PlanetAPI)mapLoc).getStarSystem() != null && planet.getFaction().isNeutralFaction()) {
                    StarSystemAPI system = planet.getStarSystem();
                    if (system.getStar() == planet || system.getCenter() == planet) {
                        if (planet.getMarket() != null) {
                            color = planet.getMarket().getTextColorForFactionOrPlanet();
                        } else {
                            color = Misc.setAlpha(planet.getSpec().getIconColor(), 255);
                            color = Misc.setBrightness(color, 235);
                        }
                    } else {
                        color = Misc.setAlpha(planet.getSpec().getIconColor(), 255);
                        color = Misc.setBrightness(color, 235);
                    }
                }
                if (this.mapMarkerNameColor != null) {
                    color = this.mapMarkerNameColor;
                }
                dialog.getVisualPanel().showMapMarker(mapLoc, title, color, true, icon, text, tags);
            }
            return true;
        }
        if ("hideMap".equals(action)) {
            dialog.getVisualPanel().removeMapMarkerFromPersonInfo();
            return true;
        }
        if (action.equals("updateStage")) {
            this.checkStageChangesAndTriggers(dialog, memoryMap);
        } else if (action.equals("updateData")) {
            this.checkStageChangesAndTriggers(dialog, memoryMap);
            this.updateInteractionData(dialog, memoryMap);
        } else if (action.equals("addContacts")) {
            this.addPotentialContacts(dialog);
        } else if (action.equals("repSuccess")) {
            this.adjustRep(dialog.getTextPanel(), null, CoreReputationPlugin.RepActions.MISSION_SUCCESS);
        } else if (action.equals("repFailure")) {
            this.adjustRep(dialog.getTextPanel(), null, CoreReputationPlugin.RepActions.MISSION_FAILURE);
        } else if (!this.callAction(action, ruleId, dialog, params, memoryMap)) {
            throw new RuntimeException("Unhandled action [" + action + "] in " + this.getClass().getSimpleName() + " for rule [" + ruleId + "], params:[" + params + "]");
        }
        return true;
    }

    protected void showPersonInfo(PersonAPI person, InteractionDialogAPI dialog, boolean withFaction, boolean withRelBar) {
        dialog.getInteractionTarget().setActivePerson(person);
        dialog.getVisualPanel().showPersonInfo(person, !withFaction, withRelBar);
    }

    @Override
    public void updateInteractionData(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        this.interactionMemory = memoryMap.get("local");
        if (this.interactionMemory == null) {
            this.interactionMemory = dialog.getInteractionTarget().getActivePerson() != null ? dialog.getInteractionTarget().getActivePerson().getMemoryWithoutUpdate() : dialog.getInteractionTarget().getMemoryWithoutUpdate();
        }
        if (this.isBarEvent() || !memoryMap.containsKey("entity")) {
            this.setPersonTokens(this.interactionMemory);
        }
        if (this.getCurrentStage() != null) {
            this.set("$" + this.getMissionId() + "_stage", ((Enum)this.getCurrentStage()).name());
        }
        this.updateInteractionDataImpl();
    }

    protected void updateInteractionDataImpl() {
    }

    protected void setPersonTokens(MemoryAPI mem) {
        PersonAPI person = this.getPerson();
        if (person == null) {
            return;
        }
        if (person.isMale()) {
            mem.set("$hisOrHer", "\u4ed6", 0.0f);
            mem.set("$HisOrHer", "\u4ed6", 0.0f);
            mem.set("$himOrHer", "\u4ed6", 0.0f);
            mem.set("$HimOrHer", "\u4ed6", 0.0f);
            mem.set("$heOrShe", "\u4ed6", 0.0f);
            mem.set("$HeOrShe", "\u4ed6", 0.0f);
            mem.set("$himOrHerself", "\u4ed6", 0.0f);
            mem.set("$HimOrHerself", "\u4ed6", 0.0f);
            mem.set("$manOrWoman", "\u7537\u4eba", 0.0f);
            mem.set("$ManOrWoman", "\u7537\u4eba", 0.0f);
        } else {
            mem.set("$hisOrHer", "\u5979", 0.0f);
            mem.set("$HisOrHer", "\u5979", 0.0f);
            mem.set("$himOrHer", "\u5979", 0.0f);
            mem.set("$HimOrHer", "\u5979", 0.0f);
            mem.set("$heOrShe", "\u5979", 0.0f);
            mem.set("$HeOrShe", "\u5979", 0.0f);
            mem.set("$himOrHerself", "\u5979", 0.0f);
            mem.set("$HimOrHerself", "\u5979", 0.0f);
            mem.set("$manOrWoman", "\u5973\u4eba", 0.0f);
            mem.set("$ManOrWoman", "\u5973\u4eba", 0.0f);
        }
        if (person.getRank() != null) {
            mem.set("$personRankAOrAn", person.getRankArticle(), 0.0f);
            mem.set("$personRank", person.getRank().toLowerCase(), 0.0f);
            mem.set("$PersonRank", Misc.ucFirst(person.getRank()), 0.0f);
        }
        if (person.getPost() != null) {
            mem.set("$personPostAOrAn", person.getPostArticle().toLowerCase(), 0.0f);
            mem.set("$personPost", person.getPost().toLowerCase(), 0.0f);
            mem.set("$PersonPost", Misc.ucFirst(person.getPost()), 0.0f);
        }
        mem.set("$PersonName", person.getName().getFullName(), 0.0f);
        mem.set("$personName", person.getName().getFullName(), 0.0f);
        mem.set("$personFirstName", person.getName().getFirst(), 0.0f);
        mem.set("$personLastName", person.getName().getLast(), 0.0f);
        if (person.getVoice() != null) {
            mem.set("$voice", person.getVoice());
        }
        if (person.getImportance() != null) {
            mem.set("$importance", person.getImportance().name());
        }
    }

    public void set(String key, Object value) {
        if (value instanceof Enum) {
            value = ((Enum)value).name();
        }
        this.interactionMemory.set(key, value, 0.0f);
    }

    public void unset(String key) {
        this.interactionMemory.unset(key);
    }

    public StageData getData(Object id) {
        if (id == null) {
            return null;
        }
        StageData data = this.stages.get(id);
        if (data == null) {
            data = new StageData();
            data.id = id;
            this.stages.put(id, data);
        }
        return data;
    }

    protected boolean shouldSendUpdateForStage(Object id) {
        return true;
    }

    public void checkStageChangesAndTriggers(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        if (this.isEnding()) {
            return;
        }
        boolean changed = false;
        block0: do {
            changed = false;
            for (StageConnection conn : this.connections) {
                if (conn.from != this.currentStage && conn.from != null || conn.to == this.currentStage || !conn.checker.conditionsMet()) continue;
                this.setCurrentStage(conn.to, dialog, memoryMap);
                changed = true;
                if (this.stageTransitionsRepeatable != null && this.stageTransitionsRepeatable.booleanValue()) continue block0;
                this.connections.remove(conn);
                continue block0;
            }
        } while (changed);
        this.runTriggers();
    }

    protected void runTriggers() {
        Iterator<MissionTrigger> iter = this.triggers.iterator();
        while (iter.hasNext()) {
            MissionTrigger trigger = iter.next();
            if (!trigger.getStages().contains(this.currentStage) || !trigger.getCondition().conditionsMet()) continue;
            MissionTrigger.TriggerActionContext context = new MissionTrigger.TriggerActionContext(this);
            for (MissionTrigger.TriggerAction curr : trigger.getActions()) {
                curr.doAction(context);
            }
            iter.remove();
        }
    }

    public List<CampaignFleetAPI> runStageTriggersReturnFleets(Object stage) {
        ArrayList<CampaignFleetAPI> result = new ArrayList<CampaignFleetAPI>();
        Iterator<MissionTrigger> iter = this.triggers.iterator();
        while (iter.hasNext()) {
            MissionTrigger trigger = iter.next();
            if (!trigger.getStages().contains(stage) || !trigger.getCondition().conditionsMet()) continue;
            MissionTrigger.TriggerActionContext context = new MissionTrigger.TriggerActionContext(this);
            for (MissionTrigger.TriggerAction curr : trigger.getActions()) {
                curr.doAction(context);
            }
            iter.remove();
            result.addAll(context.allFleets);
        }
        return result;
    }

    public void setCurrentStage(Object next, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        StageData data;
        if (this.currentStage == next) {
            return;
        }
        if (this.currentStage != null) {
            data = this.getData(this.currentStage);
            for (ImportanceData curr : data.important) {
                Misc.makeUnimportant(curr.memory, this.getReason());
                this.removeImportanceChanges(curr.memory);
                if (curr.flag == null) continue;
                curr.memory.unset(curr.flag);
                this.removeMemoryFlagChanges(curr.memory, curr.flag);
            }
        }
        this.currentStage = next;
        if (this.timeLimit != null && this.timeLimit.endLimitStages != null && this.timeLimit.endLimitStages.contains(this.currentStage)) {
            this.timeLimit = null;
        }
        data = this.getData(this.currentStage);
        data.elapsed = 0.0f;
        for (ImportanceData curr : data.important) {
            Misc.makeImportant(curr.memory, this.getReason());
            this.changes.add(new MadeImportant(curr.memory, this.getReason()));
            if (curr.flag == null) continue;
            curr.memory.set(curr.flag, true);
            this.changes.add(new VariableSet(curr.memory, curr.flag, true));
        }
        for (FlagData fd : this.flags) {
            if (fd.stages.contains(this.currentStage)) {
                this.removeMemoryFlagChanges(fd.memory, fd.flag);
                fd.memory.set(fd.flag, true);
                this.changes.add(new VariableSet(fd.memory, fd.flag, true));
                continue;
            }
            fd.memory.unset(fd.flag);
            this.removeMemoryFlagChanges(fd.memory, fd.flag);
        }
        if (!this.doNotEndMission) {
            if (this.successStages.contains(this.currentStage)) {
                this.endSuccess(dialog, memoryMap);
            } else if (this.failStages.contains(this.currentStage)) {
                this.endFailure(dialog, memoryMap);
            } else if (this.currentStage != null && this.currentStage == this.abandonStage) {
                this.endAbandon();
            } else if (this.shouldSendUpdateForStage(this.currentStage)) {
                this.sendUpdateForNextStep(NEXT_STEP_UPDATE, dialog == null ? null : dialog.getTextPanel());
            }
        }
        this.runTriggers();
    }

    protected void endSuccess(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        int reward;
        int xp;
        this.setImportant(false);
        this.result = new HubMissionResult();
        this.result.success = true;
        TextPanelAPI textPanel = null;
        if (dialog != null) {
            textPanel = dialog.getTextPanel();
        }
        if ((xp = this.getXPReward()) > 0) {
            Global.getSector().getPlayerStats().addXP(xp, textPanel);
        }
        if ((reward = this.getCreditsReward()) > 0) {
            Global.getSector().getPlayerFleet().getCargo().getCredits().add(reward);
        }
        if (textPanel != null && reward > 0) {
            AddRemoveCommodity.addCreditsGainText(reward, dialog.getTextPanel());
        }
        this.result.reward = reward;
        this.result.xp = xp;
        this.adjustRep(textPanel, this.result, CoreReputationPlugin.RepActions.MISSION_SUCCESS);
        this.endSuccessImpl(dialog, memoryMap);
        if (this.cargoOnSuccess != null) {
            this.cargoOnSuccess.sort();
            for (CargoStackAPI stack : this.cargoOnSuccess.getStacksCopy()) {
                Global.getSector().getPlayerFleet().getCargo().addItems(stack.getType(), stack.getData(), stack.getSize());
                if (textPanel == null) continue;
                AddRemoveCommodity.addStackGainText(stack, textPanel);
            }
            this.cargoOnSuccess.clear();
        }
        this.endAfterDelay();
        this.sendUpdateForNextStep(END_MISSION_UPDATE, dialog == null ? null : dialog.getTextPanel());
        if (this.creator != null) {
            this.creator.incrCompleted();
        }
        if (!(this.potentialContactsOnMissionSuccess == null || this.doNotAutoAddPotentialContactsOnSuccess != null && this.doNotAutoAddPotentialContactsOnSuccess.booleanValue())) {
            for (PotentialContactData curr : this.potentialContactsOnMissionSuccess) {
                PersonAPI p = curr.contact;
                MarketAPI m = curr.contact.getMarket();
                if (m == null) {
                    m = this.getPerson().getMarket();
                }
                if (curr.probability < 0.0f) {
                    ContactIntel.addPotentialContact(p, m, dialog != null ? dialog.getTextPanel() : null);
                    continue;
                }
                ContactIntel.addPotentialContact(curr.probability, p, m, dialog != null ? dialog.getTextPanel() : null);
            }
            this.potentialContactsOnMissionSuccess = null;
            this.doNotAutoAddPotentialContactsOnSuccess = null;
        }
        this.abort();
        if (this.completedKey != null) {
            Global.getSector().getMemoryWithoutUpdate().set(this.completedKey, true);
        }
    }

    protected void endFailure(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        this.setImportant(false);
        this.result = new HubMissionResult();
        this.result.success = false;
        TextPanelAPI textPanel = null;
        if (dialog != null) {
            textPanel = dialog.getTextPanel();
        }
        if (!this.noPenaltyFailStages.contains(this.currentStage)) {
            this.adjustRep(textPanel, this.result, CoreReputationPlugin.RepActions.MISSION_FAILURE);
        }
        this.endFailureImpl(dialog, memoryMap);
        this.endAfterDelay();
        this.sendUpdateForNextStep(END_MISSION_UPDATE, dialog == null ? null : dialog.getTextPanel());
        if (this.creator != null) {
            this.creator.incrFailed();
        }
        this.abort();
    }

    protected void endAbandon() {
        this.result = new HubMissionResult();
        this.result.success = false;
        if (!this.canAbandonWithoutPenalty()) {
            this.adjustRep(null, this.result, CoreReputationPlugin.RepActions.MISSION_FAILURE);
            if (this.creator != null) {
                this.creator.incrFailed();
            }
        }
        this.endAbandonImpl();
        this.endAfterDelay();
        this.abort();
    }

    protected void endSuccessImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
    }

    protected void endFailureImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
    }

    protected void endAbandonImpl() {
    }

    protected void adjustRep(TextPanelAPI textPanel, HubMissionResult result, CoreReputationPlugin.RepActions action) {
        boolean adjustFactionRep;
        boolean adjustPersonRep;
        if (this.adjustedRep != null) {
            return;
        }
        this.adjustedRep = true;
        CoreReputationPlugin.MissionCompletionRep completionRepPerson = new CoreReputationPlugin.MissionCompletionRep(this.getRepRewardSuccessPerson(), this.getRewardLimitPerson(), -this.getRepPenaltyFailurePerson(), this.getPenaltyLimitPerson());
        CoreReputationPlugin.MissionCompletionRep completionRepFaction = new CoreReputationPlugin.MissionCompletionRep(this.getRepRewardSuccessFaction(), this.getRewardLimitFaction(), -this.getRepPenaltyFailureFaction(), this.getPenaltyLimitFaction());
        boolean withMessage = textPanel != null;
        boolean bl = adjustPersonRep = action == CoreReputationPlugin.RepActions.MISSION_SUCCESS && completionRepPerson.successDelta != 0.0f || action == CoreReputationPlugin.RepActions.MISSION_FAILURE && completionRepPerson.failureDelta != 0.0f;
        if (adjustPersonRep && this.getPerson() != null) {
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(action, (Object)completionRepPerson, textPanel, true, withMessage), this.getPerson());
            if (result != null) {
                result.repPerson = rep;
            }
            completionRepPerson.successDelta = 0.0f;
        }
        boolean bl2 = adjustFactionRep = action == CoreReputationPlugin.RepActions.MISSION_SUCCESS && completionRepFaction.successDelta != 0.0f || action == CoreReputationPlugin.RepActions.MISSION_FAILURE && completionRepFaction.failureDelta != 0.0f;
        if (adjustFactionRep && this.getPerson() != null) {
            ReputationActionResponsePlugin.ReputationAdjustmentResult rep = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(action, (Object)completionRepFaction, textPanel, true, withMessage), this.getPerson().getFaction().getId());
            if (result != null) {
                result.repFaction = rep;
            }
            completionRepFaction.successDelta = 0.0f;
        }
    }

    public void setSuccessStage(Object id) {
        this.addSuccessStages(id);
    }

    public void addSuccessStages(Object ... ids) {
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            this.successStages.add(id);
            ++n2;
        }
    }

    public void setFailureStage(Object id) {
        this.addFailureStages(id);
    }

    public void addFailureStages(Object ... ids) {
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            this.failStages.add(id);
            ++n2;
        }
    }

    public void setNoPenaltyFailureStage(Object id) {
        this.addNoPenaltyFailureStages(id);
    }

    public void addNoPenaltyFailureStages(Object ... ids) {
        this.addFailureStages(ids);
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            this.noPenaltyFailStages.add(id);
            ++n2;
        }
    }

    protected void removeImportanceChanges(MemoryAPI memory) {
        Iterator<Abortable> iter = this.changes.iterator();
        while (iter.hasNext()) {
            Abortable curr = iter.next();
            if (!(curr instanceof MadeImportant)) continue;
            MadeImportant mi = (MadeImportant)curr;
            if (mi.memory != memory) continue;
            iter.remove();
        }
    }

    protected void removeMemoryFlagChanges(MemoryAPI memory, String flag) {
        Iterator<Abortable> iter = this.changes.iterator();
        while (iter.hasNext()) {
            Abortable curr = iter.next();
            if (!(curr instanceof VariableSet)) continue;
            VariableSet vs = (VariableSet)curr;
            if (vs.memory != memory || !flag.equals(vs.key)) continue;
            iter.remove();
        }
    }

    public String getReason() {
        return this.getMissionId();
    }

    public int getCreditsReward() {
        if (this.creditReward != null) {
            return this.creditReward;
        }
        return 0;
    }

    public int getXPReward() {
        if (this.xpReward != null) {
            return this.xpReward;
        }
        return 0;
    }

    public float getRepRewardSuccessPerson() {
        if (this.repRewardPerson != null) {
            return this.repRewardPerson.floatValue();
        }
        return 0.05f;
    }

    public float getRepPenaltyFailurePerson() {
        if (this.repPenaltyPerson != null) {
            return this.repPenaltyPerson.floatValue();
        }
        return 0.02f;
    }

    public float getRepRewardSuccessFaction() {
        if (this.repRewardFaction != null) {
            return this.repRewardFaction.floatValue();
        }
        return 0.03f;
    }

    public float getRepPenaltyFailureFaction() {
        if (this.repPenaltyFaction != null) {
            return this.repPenaltyFaction.floatValue();
        }
        return 0.01f;
    }

    public RepLevel getRewardLimitPerson() {
        return this.rewardLimitPerson != null ? this.rewardLimitPerson : RepLevel.COOPERATIVE;
    }

    public RepLevel getRewardLimitFaction() {
        return this.rewardLimitFaction != null ? this.rewardLimitFaction : RepLevel.COOPERATIVE;
    }

    public RepLevel getPenaltyLimitPerson() {
        return this.penaltyLimitPerson != null ? this.penaltyLimitPerson : RepLevel.VENGEFUL;
    }

    public RepLevel getPenaltyLimitFaction() {
        return this.penaltyLimitFaction != null ? this.penaltyLimitFaction : RepLevel.VENGEFUL;
    }

    @Override
    public MissionHub getHub() {
        return this.hub;
    }

    @Override
    public void setHub(MissionHub hub) {
        this.hub = hub;
    }

    @Override
    public PersonAPI getPerson() {
        if (this.personOverride != null) {
            return this.personOverride;
        }
        if (this.hub == null) {
            return null;
        }
        return this.hub.getPerson();
    }

    @Override
    public HubMissionCreator getCreator() {
        return this.creator;
    }

    @Override
    public void setCreator(HubMissionCreator creator) {
        this.creator = creator;
    }

    public void setStartingStage(Object startingStage) {
        this.startingStage = startingStage;
    }

    public void setPersonDoGenericPortAuthorityCheck(PersonAPI person) {
        if (person.getMemoryWithoutUpdate().getBoolean("$doGenericPortAuthorityCheck")) {
            return;
        }
        this.setFlag(person, "$doGenericPortAuthorityCheck", false);
    }

    public void setFlagWithReason(SectorEntityToken entity, String flag, boolean permanent) {
        this.setFlag(entity.getMemoryWithoutUpdate(), flag, null, permanent, null);
        String reason = this.getReason();
        Misc.setFlagWithReason(entity.getMemoryWithoutUpdate(), flag, reason, true, -1.0f);
        if (!permanent) {
            String requiredKey = String.valueOf(flag) + "_" + reason;
            this.changes.add(new VariableSet(entity.getMemoryWithoutUpdate(), requiredKey, true));
        }
    }

    public void setFlag(SectorEntityToken entity, String flag, boolean permanent) {
        this.setFlag(entity.getMemoryWithoutUpdate(), flag, null, permanent, null);
    }

    public void setFlag(PersonAPI person, String flag, boolean permanent) {
        this.setFlag(person.getMemoryWithoutUpdate(), flag, null, permanent, null);
    }

    public void setFlag(SectorEntityToken entity, String flag, boolean permanent, Object ... stages) {
        this.setFlag(entity.getMemoryWithoutUpdate(), flag, null, permanent, stages);
    }

    public void setFlag(PersonAPI person, String flag, boolean permanent, Object ... stages) {
        this.setFlag(person.getMemoryWithoutUpdate(), flag, null, permanent, stages);
    }

    public void setGlobalFlag(String flag, Object value, Object ... stages) {
        this.setFlag(this.getGlobalMemory(), flag, value, false, stages);
    }

    public void setFlag(MemoryAPI memory, String flag, Object value, boolean permanent) {
        this.setFlag(memory, flag, value, permanent, null);
    }

    public void setFlag(MemoryAPI memory, String flag, Object value, boolean permanent, Object ... stages) {
        if (stages != null && stages.length > 0) {
            FlagData fd = new FlagData();
            fd.memory = memory;
            fd.flag = flag;
            fd.stages.addAll(Arrays.asList(stages));
            this.flags.add(fd);
            if (fd.stages.contains(this.currentStage)) {
                this.removeMemoryFlagChanges(fd.memory, fd.flag);
                fd.memory.set(fd.flag, true);
                this.changes.add(new VariableSet(fd.memory, fd.flag, true));
            }
        } else {
            if (value == null) {
                memory.set(flag, true);
            } else {
                memory.set(flag, value);
            }
            this.changes.add(new VariableSet(memory, flag, !permanent));
        }
    }

    public boolean setGlobalReference(String key) {
        if (this.getGlobalMemory().contains(key)) {
            return false;
        }
        this.getGlobalMemory().set(key, this);
        this.changes.add(new VariableSet(this.getGlobalMemory(), key, true));
        return true;
    }

    public boolean setGlobalReference(String refKey, String inProgressFlag) {
        if (this.getGlobalMemory().contains(refKey)) {
            return false;
        }
        this.getGlobalMemory().set(refKey, this);
        this.changes.add(new VariableSet(this.getGlobalMemory(), refKey, true));
        if (inProgressFlag != null) {
            this.getGlobalMemory().set(inProgressFlag, true);
            this.changes.add(new VariableSet(this.getGlobalMemory(), inProgressFlag, true));
        }
        return true;
    }

    public boolean setPersonMissionRef(PersonAPI person, String key) {
        if (person == null) {
            return false;
        }
        if (person.getMemoryWithoutUpdate().contains(key)) {
            return false;
        }
        person.getMemoryWithoutUpdate().set(key, this);
        this.changes.add(new VariableSet(person.getMemoryWithoutUpdate(), key, true));
        return true;
    }

    public boolean setFactionMissionRef(FactionAPI faction, String key) {
        if (faction == null) {
            return false;
        }
        if (faction.getMemoryWithoutUpdate().contains(key)) {
            return false;
        }
        faction.getMemoryWithoutUpdate().set(key, this);
        this.changes.add(new VariableSet(faction.getMemoryWithoutUpdate(), key, true));
        return true;
    }

    public boolean setMarketMissionRef(MarketAPI market, String key) {
        if (market == null) {
            return false;
        }
        if (market.getMemoryWithoutUpdate().contains(key)) {
            return false;
        }
        market.getMemoryWithoutUpdate().set(key, this);
        this.changes.add(new VariableSet(market.getMemoryWithoutUpdate(), key, true));
        return true;
    }

    public boolean setEntityMissionRef(SectorEntityToken entity, String key) {
        if (entity == null) {
            return false;
        }
        if (entity.getMemoryWithoutUpdate().contains(key)) {
            return false;
        }
        entity.getMemoryWithoutUpdate().set(key, this);
        this.changes.add(new VariableSet(entity.getMemoryWithoutUpdate(), key, true));
        return true;
    }

    public MemoryAPI getGlobalMemory() {
        return Global.getSector().getMemoryWithoutUpdate();
    }

    public void makeImportantDoNotShowAsIntelMapLocation(PersonAPI person, String flag, Enum ... stages) {
        this.makeImportant(person.getMemoryWithoutUpdate(), flag, null, person, stages);
    }

    public void makeImportantDoNotShowAsIntelMapLocation(SectorEntityToken entity, String flag, Enum ... stages) {
        this.makeImportant(entity.getMemoryWithoutUpdate(), flag, null, entity, stages);
    }

    public void makeImportantDoNotShowAsIntelMapLocation(MarketAPI market, String flag, Enum ... stages) {
        this.makeImportant(market.getMemoryWithoutUpdate(), flag, null, market, stages);
    }

    public void makeImportant(PersonAPI person, String flag, Enum ... stages) {
        this.makeImportant(person.getMemoryWithoutUpdate(), flag, MapLocationType.NORMAL, person, stages);
    }

    public void makeImportant(SectorEntityToken entity, String flag, Enum ... stages) {
        this.makeImportant(entity.getMemoryWithoutUpdate(), flag, MapLocationType.NORMAL, entity, stages);
    }

    public void makeImportant(MarketAPI market, String flag, Enum ... stages) {
        this.makeImportant(market.getMemoryWithoutUpdate(), flag, MapLocationType.NORMAL, market, stages);
    }

    public void makeImportant(MemoryAPI memory, String flag, MapLocationType type, Object personOrEntityOrMarket, Enum ... stages) {
        boolean inCurrentStage = false;
        if (stages != null) {
            Enum[] enumArray = stages;
            int n = stages.length;
            int n2 = 0;
            while (n2 < n) {
                Enum id = enumArray[n2];
                if (this.currentStage != null && id == this.currentStage) {
                    inCurrentStage = true;
                }
                ImportanceData data = new ImportanceData();
                data.memory = memory;
                data.flag = flag;
                data.locType = type;
                if (personOrEntityOrMarket instanceof PersonAPI) {
                    data.person = (PersonAPI)personOrEntityOrMarket;
                } else if (personOrEntityOrMarket instanceof SectorEntityToken) {
                    data.entity = (SectorEntityToken)personOrEntityOrMarket;
                } else if (personOrEntityOrMarket instanceof MarketAPI) {
                    data.market = (MarketAPI)personOrEntityOrMarket;
                }
                this.getData((Object)id).important.add(data);
                ++n2;
            }
        } else {
            inCurrentStage = true;
        }
        if (inCurrentStage) {
            Misc.makeImportant(memory, this.getReason());
            if (stages != null) {
                this.changes.add(new MadeImportant(memory, this.getReason()));
            }
            if (flag != null) {
                memory.set(flag, true);
                if (stages != null) {
                    this.changes.add(new VariableSet(memory, flag, true));
                }
            }
        }
    }

    public void makeUnimportant(PersonAPI person, Enum ... stages) {
        if (person == null) {
            return;
        }
        this.makeUnimportant(person.getMemoryWithoutUpdate(), person, stages);
    }

    public void makeUnimportant(SectorEntityToken entity, Enum ... stages) {
        if (entity == null) {
            return;
        }
        this.makeUnimportant(entity.getMemoryWithoutUpdate(), entity, stages);
    }

    public void makeUnimportant(MarketAPI market, Enum ... stages) {
        if (market == null) {
            return;
        }
        this.makeUnimportant(market.getMemoryWithoutUpdate(), market, stages);
    }

    public void makeUnimportant(PersonAPI person) {
        if (person == null) {
            return;
        }
        this.makeUnimportant(person.getMemoryWithoutUpdate(), person, null);
    }

    public void makeUnimportant(SectorEntityToken entity) {
        if (entity == null) {
            return;
        }
        this.makeUnimportant(entity.getMemoryWithoutUpdate(), entity, null);
    }

    public void makeUnimportant(MarketAPI market) {
        if (market == null) {
            return;
        }
        this.makeUnimportant(market.getMemoryWithoutUpdate(), market, null);
    }

    public void makeUnimportant(MemoryAPI memory, Object personOrEntityOrMarket) {
        this.makeUnimportant(memory, personOrEntityOrMarket, null);
    }

    public void makeUnimportant(MemoryAPI memory, Object personOrEntityOrMarket, Enum ... stages) {
        ArrayList<StageData> list = new ArrayList<StageData>();
        if (stages != null) {
            Enum[] enumArray = stages;
            int n = stages.length;
            int n2 = 0;
            while (n2 < n) {
                Enum id = enumArray[n2];
                StageData stageData = this.getData(id);
                list.add(stageData);
                ++n2;
            }
        } else {
            list.addAll(this.stages.values());
        }
        for (StageData stageData : list) {
            Iterator<ImportanceData> iter = stageData.important.iterator();
            while (iter.hasNext()) {
                ImportanceData data = iter.next();
                if (data.memory != memory && data.person != personOrEntityOrMarket && data.entity != personOrEntityOrMarket && data.market != personOrEntityOrMarket) continue;
                iter.remove();
            }
        }
        Misc.makeUnimportant(memory, this.getReason());
    }

    public void setTimeLimit(Object failStage, float days, StarSystemAPI noLimitWhileInSystem, Object ... noLimitAfterStages) {
        this.timeLimit = new TimeLimitData();
        this.timeLimit.days = days;
        this.timeLimit.failStage = failStage;
        this.timeLimit.noLimitWhileInSystem = noLimitWhileInSystem;
        if (noLimitAfterStages != null) {
            Object[] objectArray = noLimitAfterStages;
            int n = noLimitAfterStages.length;
            int n2 = 0;
            while (n2 < n) {
                Object stage = objectArray[n2];
                this.timeLimit.endLimitStages.add(stage);
                ++n2;
            }
        }
    }

    public HubMissionResult getResult() {
        return this.result;
    }

    public int genRoundNumber(int min, int max) {
        int result = min + this.genRandom.nextInt(max - min + 1);
        return BaseHubMission.getRoundNumber(result);
    }

    public static int getRoundNumber(float num) {
        int num2 = (int)num;
        int i = 1;
        while (i < 10) {
            int threshold = (int)Math.pow(10.0, i);
            int base = threshold / 10;
            if (num2 > threshold) {
                num2 = num2 / base * base;
            }
            ++i;
        }
        return num2;
    }

    public void setCreditReward(int min, int max) {
        this.setCreditReward(min, max, true);
    }

    public void setCreditReward(int min, int max, boolean withMult) {
        int reward = min + this.genRandom.nextInt(max - min + 1);
        if (withMult) {
            reward = BaseHubMission.getRoundNumber((float)reward * this.rewardMult);
        }
        if ((reward = reward / 1000 * 1000) > 100000) {
            reward = reward / 10000 * 10000;
        }
        this.setCreditReward(reward);
    }

    public void setCreditReward(Integer creditReward) {
        this.creditReward = creditReward;
    }

    public void setCreditRewardApplyRelMult(Integer creditReward) {
        this.creditReward = creditReward = Integer.valueOf(BaseHubMission.getRoundNumber((float)creditReward.intValue() * this.rewardMult));
    }

    public void setCreditReward(CreditReward reward) {
        this.setCreditReward(reward.min, reward.max);
    }

    public void setCreditReward(CreditReward reward, int marketSize) {
        this.setCreditReward(reward.min / 2 + reward.perMarketSize * Math.max(0, marketSize - 3), reward.max / 2 + reward.perMarketSize * Math.max(0, marketSize - 3));
    }

    public void setCreditRewardWithBonus(CreditReward reward, int bonus) {
        this.setCreditReward(reward.min + bonus, reward.max + bonus);
    }

    public int getRewardBonusForMarines(int marines) {
        return marines * EXTRA_REWARD_PER_MARINE;
    }

    public void setXPReward(int xpReward) {
        this.xpReward = xpReward;
        if (this.xpReward <= 0) {
            this.xpReward = null;
        }
    }

    public void setRepPersonChangesNone() {
        this.setRepRewardPerson(Float.valueOf(0.0f));
        this.setRepPenaltyPerson(Float.valueOf(0.0f));
    }

    public void setRepFactionChangesNone() {
        this.setRepRewardFaction(Float.valueOf(0.0f));
        this.setRepPenaltyFaction(Float.valueOf(0.0f));
    }

    public void setRepPersonChangesTiny() {
        this.setRepRewardPerson(Float.valueOf(0.01f));
        this.setRepPenaltyPerson(Float.valueOf(0.0f));
    }

    public void setRepFactionChangesTiny() {
        this.setRepRewardFaction(Float.valueOf(0.01f));
        this.setRepPenaltyFaction(Float.valueOf(0.0f));
    }

    public void setRepPersonChangesVeryLow() {
        this.setRepRewardPerson(Float.valueOf(0.02f));
        this.setRepPenaltyPerson(Float.valueOf(0.01f));
    }

    public void setRepFactionChangesVeryLow() {
        this.setRepRewardFaction(Float.valueOf(0.02f));
        this.setRepPenaltyFaction(Float.valueOf(0.01f));
    }

    public void setRepPersonChangesLow() {
        this.setRepRewardPerson(Float.valueOf(0.03f));
        this.setRepPenaltyPerson(Float.valueOf(0.01f));
    }

    public void setRepFactionChangesLow() {
        this.setRepRewardFaction(Float.valueOf(0.03f));
        this.setRepPenaltyFaction(Float.valueOf(0.01f));
    }

    public void setRepPersonChangesMedium() {
        this.setRepRewardPerson(Float.valueOf(0.05f));
        this.setRepPenaltyPerson(Float.valueOf(0.02f));
    }

    public void setRepFactionChangesMedium() {
        this.setRepRewardFaction(Float.valueOf(0.05f));
        this.setRepPenaltyFaction(Float.valueOf(0.02f));
    }

    public void setRepPersonChangesHigh() {
        this.setRepRewardPerson(Float.valueOf(0.07f));
        this.setRepPenaltyPerson(Float.valueOf(0.03f));
    }

    public void setRepFactionChangesHigh() {
        this.setRepRewardFaction(Float.valueOf(0.07f));
        this.setRepPenaltyFaction(Float.valueOf(0.03f));
    }

    public void setRepPersonChangesVeryHigh() {
        this.setRepRewardPerson(Float.valueOf(0.1f));
        this.setRepPenaltyPerson(Float.valueOf(0.03f));
    }

    public void setRepFactionChangesVeryHigh() {
        this.setRepRewardFaction(Float.valueOf(0.1f));
        this.setRepPenaltyFaction(Float.valueOf(0.03f));
    }

    public void setRepChanges(float repRewardPerson, float repPenaltyPerson, float repRewardFaction, float repPenaltyFaction) {
        this.setRepRewardPerson(Float.valueOf(repRewardPerson));
        this.setRepPenaltyPerson(Float.valueOf(repPenaltyPerson));
        this.setRepRewardFaction(Float.valueOf(repRewardFaction));
        this.setRepPenaltyFaction(Float.valueOf(repPenaltyFaction));
    }

    public void setNoRepChanges() {
        this.setRepChanges(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void setRepRewardPerson(Float repRewardPerson) {
        this.repRewardPerson = repRewardPerson;
    }

    public void setRepPenaltyPerson(Float repPenaltyPerson) {
        this.repPenaltyPerson = repPenaltyPerson;
    }

    public void setRepRewardFaction(Float repRewardFaction) {
        this.repRewardFaction = repRewardFaction;
    }

    public void setRepPenaltyFaction(Float repPenaltyFaction) {
        this.repPenaltyFaction = repPenaltyFaction;
    }

    public void setPenaltyLimitPerson(RepLevel penaltyLimitPerson) {
        this.penaltyLimitPerson = penaltyLimitPerson;
    }

    public void setPenaltyLimitFaction(RepLevel penaltyLimitFaction) {
        this.penaltyLimitFaction = penaltyLimitFaction;
    }

    public static boolean playerLevelIsAtLeast(int level) {
        return Global.getSector().getPlayerStats().getLevel() >= level;
    }

    public static boolean playerLevelIsMaxed() {
        int max = Global.getSettings().getLevelupPlugin().getMaxLevel();
        return Global.getSector().getPlayerStats().getLevel() >= max;
    }

    public static int getMaxPlayerLevel() {
        return Global.getSettings().getLevelupPlugin().getMaxLevel();
    }

    public static boolean isDevMode() {
        return Global.getSettings().isDevMode();
    }

    public void addTag(String tag) {
        if (this.addedTags == null) {
            this.addedTags = new HashSet<String>();
        }
        this.addedTags.add(tag);
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Missions");
        tags.add("Accepted");
        if (this.getFactionForUIColors() != null && !this.getFactionForUIColors().isPlayerFaction()) {
            tags.add(this.getFactionForUIColors().getId());
        }
        if (this.addedTags != null) {
            tags.addAll(this.addedTags);
        }
        return tags;
    }

    public SectorEntityToken getMapLocationFor(SectorEntityToken entity) {
        if ((entity.isDiscoverable() || entity instanceof CampaignFleetAPI && !((CampaignFleetAPI)entity).isVisibleToPlayerFleet()) && entity.getStarSystem() != null) {
            return entity.getStarSystem().getCenter();
        }
        return entity;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.currentStage == null) {
            return null;
        }
        return this.getMapLocation(map, this.currentStage);
    }

    public void makePrimaryObjective(Object personOrMarketOrEntity) {
        StageData stage = this.getData(this.currentStage);
        ImportanceData data = null;
        for (ImportanceData curr : stage.important) {
            if (curr.locType == null || curr.entity != personOrMarketOrEntity && curr.market != personOrMarketOrEntity && curr.person != personOrMarketOrEntity) continue;
            data = curr;
            break;
        }
        if (data != null) {
            stage.important.remove(data);
            stage.important.add(0, data);
        }
    }

    public SectorEntityToken getMapLocation(SectorMapAPI map, Object currentStage) {
        if (currentStage == null) {
            currentStage = this.startingStage;
        }
        StageData stage = this.getData(currentStage);
        ImportanceData data = null;
        for (ImportanceData curr : stage.important) {
            if (curr.locType == null || curr.entity != null && !curr.entity.isAlive()) continue;
            data = curr;
            break;
        }
        if (data == null || data.locType == null) {
            return null;
        }
        SectorEntityToken entity = data.entity;
        if (entity == null && data.person != null && data.person.getMarket() != null) {
            entity = data.person.getMarket().getPrimaryEntity();
        }
        if (entity == null && data.market != null) {
            entity = data.market.getPrimaryEntity();
        }
        if (entity == null) {
            return null;
        }
        if (data.locType == MapLocationType.NORMAL) {
            if ((entity.isDiscoverable() || entity instanceof CampaignFleetAPI && !((CampaignFleetAPI)entity).isVisibleToPlayerFleet()) && entity.getStarSystem() != null) {
                return entity.getStarSystem().getCenter();
            }
            return entity;
        }
        if (data.locType == MapLocationType.CONSTELLATION) {
            Constellation c = entity.getConstellation();
            SectorEntityToken result = null;
            if (c != null && map != null) {
                result = map.getConstellationLabelEntity(c);
            }
            if (result == null) {
                result = entity;
            }
            return result;
        }
        return entity;
    }

    @Override
    public String getSortString() {
        return this.getBaseName();
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public void setIconName(String category, String id) {
        this.iconName = Global.getSettings().getSpriteName(category, id);
    }

    public String getPostfixForState() {
        if (this.isEnding()) {
            if (this.isSucceeded()) {
                return " - \u5b8c\u6210";
            }
            if (this.isFailed()) {
                return " - \u5931\u8d25";
            }
            if (this.isAbandoned()) {
                return " - \u653e\u5f03";
            }
            return " - \u5df2\u7ed3\u675f";
        }
        if (this.startingStage != null) {
            return " - \u5df2\u63a5\u53d7";
        }
        return "";
    }

    @Override
    public String getName() {
        return String.valueOf(this.getBaseName()) + (this.getPostfixForState() == null ? "" : this.getPostfixForState());
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        if (this.getPerson() == null) {
            return Global.getSector().getPlayerFaction();
        }
        return this.getPerson().getFaction();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    protected boolean isSucceeded() {
        return this.successStages.contains(this.currentStage);
    }

    protected boolean isFailed() {
        return this.failStages.contains(this.currentStage);
    }

    protected boolean isAbandoned() {
        return this.abandonStage == this.currentStage;
    }

    @Override
    public String getIcon() {
        if (this.iconName != null) {
            return this.iconName;
        }
        return this.getPerson().getPortraitSprite();
    }

    @Override
    public String getImportantIcon() {
        if (!this.isEnding() && !this.isEnded()) {
            return Global.getSettings().getSpriteName("intel", "important_accepted_mission");
        }
        return super.getImportantIcon();
    }

    protected void addResultBulletsAssumingAlreadyIndented(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        if (this.result == null) {
            return;
        }
        if (mode == IntelInfoPlugin.ListInfoMode.INTEL) {
            return;
        }
        Color h = Misc.getHighlightColor();
        Color tc = this.getBulletColorForMode(mode);
        PersonAPI person = this.getPerson();
        FactionAPI faction = this.getFactionForUIColors();
        boolean isUpdate = this.getListInfoParam() != null;
        float initPad = 3.0f;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = 10.0f;
        }
        if (this.result.reward > 0) {
            info.addPara("%s \u5df2\u6536\u5230", initPad, tc, h, Misc.getDGSCredits(this.result.reward));
            initPad = 0.0f;
        }
        if (this.result.repPerson != null) {
            CoreReputationPlugin.addAdjustmentMessage(this.result.repPerson.delta, null, person, null, info, tc, isUpdate, initPad);
            initPad = 0.0f;
        }
        if (this.result.repFaction != null) {
            CoreReputationPlugin.addAdjustmentMessage(this.result.repFaction.delta, faction, null, null, info, tc, isUpdate, initPad);
            initPad = 0.0f;
        }
    }

    public void sendUpdateForNextStep(String listInfoParam, TextPanelAPI textPanel) {
        if (textPanel == null) {
            this.sendUpdateIfPlayerHasIntel((Object)listInfoParam, false);
        } else {
            this.listInfoParam = listInfoParam;
            Global.getSector().getIntelManager().addIntelToTextPanel(this, textPanel);
            this.listInfoParam = null;
        }
    }

    public void sendUpdateToTextPanel(String listInfoParam, TextPanelAPI textPanel) {
        this.listInfoParam = listInfoParam;
        Global.getSector().getIntelManager().addIntelToTextPanel(this, textPanel);
        this.listInfoParam = null;
    }

    protected void addBulletPointsPre(TooltipMakerAPI info, Color tc, float initPad, IntelInfoPlugin.ListInfoMode mode) {
    }

    protected void addBulletPointsPost(TooltipMakerAPI info, Color tc, float initPad, IntelInfoPlugin.ListInfoMode mode) {
    }

    protected String getToCompleteText() {
        return "\u671f\u9650";
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        this.addBulletPointsPre(info, tc, initPad, mode);
        boolean isUpdate = this.getListInfoParam() != null;
        PersonAPI person = this.getPerson();
        FactionAPI faction = this.getFactionForUIColors();
        if (isUpdate) {
            if (this.getListInfoParam() == NEXT_STEP_UPDATE) {
                if (this.addNextStepText(info, tc, initPad)) {
                    initPad = 0.0f;
                }
            } else if (this.isFailed()) {
                this.addResultBulletsAssumingAlreadyIndented(info, mode);
                this.addNextStepText(info, tc, initPad);
            } else if (this.isSucceeded()) {
                this.addResultBulletsAssumingAlreadyIndented(info, mode);
                this.addNextStepText(info, tc, initPad);
            } else {
                this.addNextStepText(info, tc, initPad);
            }
        } else if (this.result != null) {
            if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
                this.addResultBulletsAssumingAlreadyIndented(info, mode);
            }
        } else if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            int reward = this.getCreditsReward();
            if (reward > 0) {
                info.addPara("%s \u5956\u52b1", initPad, tc, h, Misc.getDGSCredits(reward));
                initPad = 0.0f;
            }
            if (this.timeLimit != null) {
                this.addDays(info, this.getToCompleteText(), this.timeLimit.days - this.elapsed, tc, initPad);
                initPad = 0.0f;
            }
        } else {
            if (this.addNextStepText(info, tc, initPad)) {
                initPad = 0.0f;
            }
            if (this.timeLimit != null) {
                this.addDays(info, this.getToCompleteText(), this.timeLimit.days - this.elapsed, tc, initPad);
                initPad = 0.0f;
            }
        }
        this.addBulletPointsPost(info, tc, initPad, mode);
        this.unindent(info);
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        if (this.sortTier == null || this.isEnding() || this.isEnded()) {
            return super.getSortTier();
        }
        return this.sortTier;
    }

    public void setUseLargeFontInMissionList() {
        this.largeTitleFont = true;
        this.sortTier = IntelInfoPlugin.IntelSortTier.TIER_2;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean large;
        Color c = this.getTitleColor(mode);
        boolean bl = large = this.largeTitleFont != null && this.largeTitleFont != false;
        if (large) {
            info.setParaSmallInsignia();
        }
        info.addPara(this.getName(), c, 0.0f);
        if (large) {
            info.setParaFontDefault();
        }
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        FactionAPI faction = this.getFactionForUIColors();
        PersonAPI person = this.getPerson();
        if (person != null) {
            info.addImages(width, 128.0f, opad, opad, person.getPortraitSprite(), faction.getCrest());
            String post = "one";
            if (person.getPost() != null) {
                post = person.getPost().toLowerCase();
            }
            if (post == null && person.getRank() != null) {
                post = person.getRank().toLowerCase();
            }
            info.addPara(String.valueOf(Misc.ucFirst(this.getMissionTypeNoun())) + "\u63d0\u4f9b\u8005\uff1a{" + post + " " + person.getNameString() + "\uff0c\u6240\u5c5e\u52bf\u529b\uff1a{" + faction.getDisplayNameWithArticle() + ".", opad, faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
        }
        this.addDescriptionForCurrentStage(info, width, height);
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        if (!(this.abandonStage == null || this.isAbandoned() || this.isSucceeded() || this.isFailed())) {
            this.addAbandonButton(info, width);
        }
    }

    public void setAbandonStage(Object abandonStage) {
        this.abandonStage = abandonStage;
    }

    public void setNoAbandon() {
        this.abandonStage = null;
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_ABANDON) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    protected void addAbandonButton(TooltipMakerAPI info, float width) {
        this.addAbandonButton(info, width, "\u653e\u5f03");
    }

    protected void addAbandonButton(TooltipMakerAPI info, float width, String abandon) {
        float opad = 10.0f;
        ButtonAPI button = info.addButton(abandon, BUTTON_ABANDON, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 2.0f);
        button.setShortcut(22, true);
    }

    public boolean canAbandonWithoutPenalty() {
        return this.elapsed < this.getNoPenaltyAbandonDays();
    }

    protected float getNoPenaltyAbandonDays() {
        return 1.0f;
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_ABANDON) {
            this.setImportant(false);
            this.setCurrentStage(this.abandonStage, null, null);
            this.runTriggers();
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        FactionAPI faction = this.getFactionForUIColors();
        if (buttonId == BUTTON_ABANDON) {
            boolean loseRepPerson;
            boolean loseRepFaction = this.getRepPenaltyFailureFaction() > 0.0f;
            boolean bl = loseRepPerson = this.getRepPenaltyFailurePerson() > 0.0f;
            if (!loseRepFaction && !loseRepPerson) {
                prompt.addPara("\u4f60\u53ef\u4ee5\u653e\u5f03\u8be5 " + this.getMissionTypeNoun() + " \u6765\u907f\u514d\u60e9\u7f5a\u3002", 0.0f);
            } else if (this.canAbandonWithoutPenalty()) {
                prompt.addPara("\u7531\u4e8e\u8ddd\u63a5\u5230\u6b64\u4efb\u52a1\u624d\u8fc7\u53bb\u4e0d\u5230\u4e00\u5929\u7684\u65f6\u95f4\uff0c\u56e0\u6b64\u4f60\u5927\u53ef\u653e\u5f03\u8be5 " + this.getMissionTypeNoun() + " \u6765\u907f\u514d\u60e9\u7f5a\u3002", 0.0f);
            } else if (loseRepFaction && !loseRepPerson) {
                prompt.addPara("\u4f60\u53ef\u4ee5\u653e\u5f03\u8be5 " + this.getMissionTypeNoun() + "\uff0c\u4f46\u5fc5\u5c06\u5f71\u54cd\u4f60\u4e0e\u4efb\u52a1\u63d0\u4f9b\u8005" + "\u7684\u5173\u7cfb - " + faction.getDisplayNameWithArticle() + ".", 0.0f, Misc.getTextColor(), faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
            } else if (!loseRepFaction && loseRepPerson) {
                prompt.addPara("\u4f60\u53ef\u4ee5\u653e\u5f03\u8be5 " + this.getMissionTypeNoun() + "\uff0c\u4f46\u5fc5\u5c06\u5f71\u54cd\u4f60\u4e0e\u4efb\u52a1\u63d0\u4f9b\u8005" + "\u7684\u5173\u7cfb - " + this.getPerson().getNameString() + ".", Misc.getTextColor(), 0.0f);
            } else {
                prompt.addPara("\u4f60\u53ef\u4ee5\u653e\u5f03\u8be5 " + this.getMissionTypeNoun() + "\uff0c\u4f46\u5fc5\u5c06\u5f71\u54cd\u4f60\u4e0e\u4efb\u52a1\u63d0\u4f9b\u8005" + "\u4e0e\u76f8\u5173\u52bf\u529b\u7684\u5173\u7cfb - " + this.getPerson().getNameString() + " \u548c " + faction.getDisplayNameWithArticle() + ".", 0.0f, Misc.getTextColor(), faction.getBaseUIColor(), faction.getDisplayNameWithArticleWithoutArticle());
            }
        } else {
            super.createConfirmationPrompt(buttonId, prompt);
        }
    }

    protected String getMissionTypeNoun() {
        return "\u4efb\u52a1";
    }

    protected String getMissionCompletionVerb() {
        return "\u5b8c\u6210";
    }

    public int getDistanceLY(MarketAPI market) {
        return this.getDistanceLY(market.getPrimaryEntity());
    }

    public int getDistanceLY(SectorEntityToken entity) {
        int dist = 0;
        if (this.getPerson() != null && this.getPerson().getMarket() != null) {
            dist = Math.round(Misc.getDistanceLY(this.getPerson().getMarket().getLocationInHyperspace(), entity.getLocationInHyperspace()));
        }
        return dist;
    }

    public int getDistanceLY(StarSystemAPI system) {
        int dist = 0;
        if (this.getPerson() != null && this.getPerson().getMarket() != null) {
            dist = Math.round(Misc.getDistanceLY(this.getPerson().getMarket().getLocationInHyperspace(), system.getLocation()));
        }
        return dist;
    }

    public int getFuel(SectorEntityToken entity, boolean bothWays) {
        int dist = this.getDistanceLY(entity);
        float fuel = Global.getSector().getPlayerFleet().getLogistics().getFuelCostPerLightYear();
        fuel *= (float)dist;
        if (bothWays) {
            fuel *= 2.0f;
        }
        return Math.round(fuel);
    }

    public Object pickOneObject(List options) {
        WeightedRandomPicker picker = new WeightedRandomPicker(this.genRandom);
        for (Object option : options) {
            picker.add(option);
        }
        return picker.pick();
    }

    public String pickOne(List<String> options) {
        return this.pickOne(options.toArray(new String[0]));
    }

    public String pickOne(String ... options) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.genRandom);
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            picker.add(option);
            ++n2;
        }
        return (String)picker.pick();
    }

    protected String getWithoutArticle(String item) {
        if (item.startsWith(" ")) {
            return item.replaceFirst(" ", "");
        }
        if (item.startsWith(" ")) {
            return item.replaceFirst(" ", "");
        }
        if (item.startsWith(" ")) {
            return item.replaceFirst(" ", "");
        }
        return item;
    }

    public void setStageOnGlobalFlag(Object to, String flag) {
        this.connectWithGlobalFlag(null, to, flag);
    }

    public void setStageOnEntityNotAlive(Object to, SectorEntityToken entity) {
        this.connectWithEntityNotAlive(null, to, entity);
    }

    public void setStageOnDaysElapsed(Object to, float days) {
        this.connectWithDaysElapsed(null, to, days);
    }

    public void setStageOnInRangeOfCommRelay(Object to) {
        this.connectWithInRangeOfCommRelay(null, to);
    }

    public void setStageOnEnteredLocation(Object to, LocationAPI location) {
        this.connectWithEnteredLocation(null, to, location);
    }

    public void setStageInRangeOfEntity(Object to, SectorEntityToken entity, float range) {
        this.connectWithInRangeOfEntity(null, to, entity, range);
    }

    public void setStageOnWithinHyperspaceRange(Object to, SectorEntityToken entity, float rangeLY) {
        this.connectWithWithinHyperspaceRange(null, to, entity, rangeLY);
    }

    public void setStageOnCustomCondition(Object to, ConditionChecker custom) {
        this.connections.add(new StageConnection(null, to, custom));
    }

    public void connectWithGlobalFlag(Object from, Object to, String flag) {
        this.connections.add(new StageConnection(from, to, new GlobalBooleanChecker(flag)));
        this.changes.add(new VariableSet(this.getGlobalMemory(), flag, true));
    }

    public void setStageOnMemoryFlag(Object to, HasMemory withMemory, String flag) {
        this.setStageOnMemoryFlag(to, withMemory.getMemoryWithoutUpdate(), flag);
    }

    public void connectWithMemoryFlag(Object from, Object to, HasMemory withMemory, String flag) {
        this.connectWithMemoryFlag(from, to, withMemory.getMemoryWithoutUpdate(), flag);
    }

    public void setStageOnMemoryFlag(Object to, MemoryAPI memory, String flag) {
        this.connectWithMemoryFlag(null, to, memory, flag);
    }

    public void connectWithMemoryFlag(Object from, Object to, MemoryAPI memory, String flag) {
        this.connections.add(new StageConnection(from, to, new MemoryBooleanChecker(memory, flag)));
        this.changes.add(new VariableSet(memory, flag, true));
    }

    public void connectWithEntityNotAlive(Object from, Object to, SectorEntityToken entity) {
        this.connections.add(new StageConnection(from, to, new EntityNotAliveChecker(entity)));
    }

    public void connectWithMarketDecivilized(Object from, Object to, MarketAPI market) {
        this.connections.add(new StageConnection(from, to, new MarketDecivChecker(market)));
    }

    public void setStageOnMarketDecivilized(Object to, MarketAPI market) {
        this.connections.add(new StageConnection(null, to, new MarketDecivChecker(market)));
    }

    public void connectWithHostilitiesEnded(Object from, Object to, PersonAPI person, MarketAPI market) {
        this.connections.add(new StageConnection(from, to, new HostilitiesEndedChecker(person, market)));
    }

    public void setStageOnHostilitiesEnded(Object to, PersonAPI person, MarketAPI market) {
        this.connections.add(new StageConnection(null, to, new HostilitiesEndedChecker(person, market)));
    }

    public void connectWithHostilitiesStarted(Object from, Object to, PersonAPI person, MarketAPI market) {
        this.connections.add(new StageConnection(from, to, new HostilitiesStartedChecker(person, market)));
    }

    public void setStageOnHostilitiesStarted(Object to, PersonAPI person, MarketAPI market) {
        this.connections.add(new StageConnection(null, to, new HostilitiesStartedChecker(person, market)));
    }

    public void connectWithDaysElapsed(Object from, Object to, float days) {
        this.connections.add(new StageConnection(from, to, new DaysElapsedChecker(days, this.getData(from))));
    }

    public void connectWithInRangeOfCommRelay(Object from, Object to) {
        this.connections.add(new StageConnection(from, to, new InCommRelayRangeChecker()));
    }

    public void connectWithEnteredLocation(Object from, Object to, LocationAPI location) {
        this.connections.add(new StageConnection(from, to, new EnteredLocationChecker(location)));
    }

    public void connectWithInRangeOfEntity(Object from, Object to, SectorEntityToken entity, float range) {
        this.connections.add(new StageConnection(from, to, new InRangeOfEntityChecker(entity, range)));
    }

    public void connectWithWithinHyperspaceRange(Object from, Object to, SectorEntityToken entity, float rangeLY) {
        this.connectWithWithinHyperspaceRange(from, to, entity, rangeLY, false);
    }

    public void connectWithWithinHyperspaceRange(Object from, Object to, SectorEntityToken entity, float rangeLY, boolean requirePlayerInHyperspace) {
        this.connections.add(new StageConnection(from, to, new InHyperRangeOfEntityChecker(entity, rangeLY, requirePlayerInHyperspace)));
    }

    public void connectWithCustomCondition(Object from, Object to, ConditionChecker custom) {
        this.connections.add(new StageConnection(from, to, custom));
    }

    public boolean rollProbability(float p) {
        return this.genRandom.nextFloat() < p;
    }

    public SectorEntityToken spawnDebrisField(float radius, float density, LocData data) {
        DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(radius, density, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
        params.baseSalvageXP = (long)radius;
        if (!data.updateLocIfNeeded(this, null)) {
            return null;
        }
        SectorEntityToken debris = Misc.addDebrisField(data.system, params, this.genRandom);
        data.placeEntity(debris);
        this.changes.add(new EntityAdded(debris));
        return debris;
    }

    public SectorEntityToken spawnMissionNode(LocData data) {
        return this.spawnEntity("mission_location", data);
    }

    public void makeMissionNodeDiscoverable(SectorEntityToken node) {
        this.makeDiscoverable(node, 1000.0f, 200.0f);
    }

    public void makeDiscoverable(SectorEntityToken entity, float range, float xp) {
        entity.setDiscoveryXP(Float.valueOf(xp));
        entity.setSensorProfile(Float.valueOf(1.0f));
        entity.setDiscoverable(true);
        entity.getDetectedRangeMod().modifyFlat("gen", range);
    }

    public BaseThemeGenerator.EntityLocation generateLocation(String entityId, EntityLocationType locType, SectorEntityToken param, LocationAPI system) {
        BaseThemeGenerator.EntityLocation loc = null;
        float gap = 100.0f;
        if (system instanceof StarSystemAPI) {
            if (locType == EntityLocationType.HIDDEN) {
                loc = BaseThemeGenerator.pickHiddenLocation(this.genRandom, (StarSystemAPI)system, gap, null);
            } else if (locType == EntityLocationType.HIDDEN_NOT_NEAR_STAR) {
                loc = BaseThemeGenerator.pickHiddenLocationNotNearStar(this.genRandom, (StarSystemAPI)system, gap, null);
            } else if (locType == EntityLocationType.ORBITING_PLANET) {
                loc = BaseThemeGenerator.pickCommonLocation(this.genRandom, (StarSystemAPI)system, gap, false, null);
            } else if (locType == EntityLocationType.ORBITING_PLANET_OR_STAR) {
                loc = BaseThemeGenerator.pickCommonLocation(this.genRandom, (StarSystemAPI)system, gap, true, null);
            } else if (locType == EntityLocationType.UNCOMMON) {
                loc = BaseThemeGenerator.pickUncommonLocation(this.genRandom, (StarSystemAPI)system, gap, null);
            } else if (locType == EntityLocationType.ANY) {
                loc = BaseThemeGenerator.pickAnyLocation(this.genRandom, (StarSystemAPI)system, gap, null);
            }
        }
        if (locType == EntityLocationType.ORBITING_PARAM && (loc = BaseThemeGenerator.createLocationAtRandomGap(this.genRandom, param, gap)) == null) {
            float radius = 75.0f;
            if (entityId != null) {
                CustomEntitySpecAPI spec = Global.getSettings().getCustomEntitySpec(entityId);
                radius = spec.getDefaultRadius();
            }
            loc = new BaseThemeGenerator.EntityLocation();
            loc.type = BaseThemeGenerator.LocationType.PLANET_ORBIT;
            loc.orbit = Global.getFactory().createCircularOrbitWithSpin(param, this.genRandom.nextFloat() * 360.0f, param.getRadius() + radius + 100.0f, 20.0f + 20.0f * this.genRandom.nextFloat(), this.genRandom.nextFloat() * 10.0f + 1.0f);
        }
        if (loc == null) {
            if (system instanceof StarSystemAPI) {
                loc = new BaseThemeGenerator.EntityLocation();
                loc.type = BaseThemeGenerator.LocationType.STAR_ORBIT;
                loc.orbit = Global.getFactory().createCircularOrbitWithSpin(((StarSystemAPI)system).getCenter(), this.genRandom.nextFloat() * 360.0f, 5000.0f, 20.0f + 20.0f * this.genRandom.nextFloat(), this.genRandom.nextFloat() * 10.0f + 1.0f);
            } else {
                loc = new BaseThemeGenerator.EntityLocation();
                loc.type = BaseThemeGenerator.LocationType.OUTER_SYSTEM;
                loc.location = new Vector2f();
            }
        }
        return loc;
    }

    public SectorEntityToken spawnEntity(String entityId, LocData data) {
        if (!data.updateLocIfNeeded(this, entityId)) {
            return null;
        }
        BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addEntityAutoDetermineType(this.genRandom, data.system, data.loc, entityId, "neutral");
        if (added == null) {
            return null;
        }
        if (data.removeOnMissionOver) {
            added.entity.addTag(REMOVE_ON_MISSION_OVER);
        }
        added.entity.addTag("not_random_mission_target");
        this.changes.add(new EntityAdded(added.entity));
        return added.entity;
    }

    public SectorEntityToken spawnEntityToken(LocData data) {
        if (!data.updateLocIfNeeded(this, null)) {
            return null;
        }
        SectorEntityToken token = data.system.createToken(0.0f, 0.0f);
        data.system.addEntity(token);
        data.placeEntity(token);
        this.changes.add(new EntityAdded(token));
        return token;
    }

    public SectorEntityToken spawnDerelictHull(String hullId, LocData data) {
        if (hullId == null) {
            return this.spawnDerelictOfType(null, data);
        }
        DerelictShipEntityPlugin.DerelictShipData shipData = DerelictShipEntityPlugin.createHull(hullId, this.genRandom, DerelictShipEntityPlugin.getDefaultSModProb());
        return this.spawnDerelict(shipData, data);
    }

    public SectorEntityToken spawnDerelict(String factionId, DerelictShipEntityPlugin.DerelictType type, LocData data) {
        if (factionId == null) {
            return this.spawnDerelictOfType(type, data);
        }
        DerelictShipEntityPlugin.DerelictShipData shipData = DerelictShipEntityPlugin.createRandom(factionId, type, this.genRandom, DerelictShipEntityPlugin.getDefaultSModProb());
        return this.spawnDerelict(shipData, data);
    }

    public SectorEntityToken spawnDerelictOfType(DerelictShipEntityPlugin.DerelictType type, LocData data) {
        WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(this.genRandom, data.system.getLocation(), 15.0f, 10.0f, 10.0f);
        DerelictShipEntityPlugin.DerelictShipData shipData = DerelictShipEntityPlugin.createRandom(factions.pick(), type, this.genRandom, DerelictShipEntityPlugin.getDefaultSModProb());
        return this.spawnDerelict(shipData, data);
    }

    public SectorEntityToken spawnDerelict(DerelictShipEntityPlugin.DerelictShipData shipData, LocData data) {
        if (shipData == null) {
            return null;
        }
        if (!data.updateLocIfNeeded(this, "wreck")) {
            return null;
        }
        SectorEntityToken entity = BaseThemeGenerator.addSalvageEntity(this.genRandom, data.system, "wreck", "neutral", shipData);
        entity.setDiscoverable(true);
        data.placeEntity(entity);
        this.changes.add(new EntityAdded(entity));
        return entity;
    }

    public void spawnShipGraveyard(String factionId, int minShips, int maxShips, LocData data) {
        SectorEntityToken focus = this.spawnEntityToken(data);
        int numShips = minShips + this.genRandom.nextInt(maxShips - minShips + 1);
        WeightedRandomPicker<Float> bands = new WeightedRandomPicker<Float>(this.genRandom);
        int i = 0;
        while (i < numShips + 5) {
            bands.add(new Float(120.0f + (float)i * 20.0f), ((float)i + 1.0f) * ((float)i + 1.0f));
            ++i;
        }
        i = 0;
        while (i < numShips) {
            float r = ((Float)bands.pickAndRemove()).floatValue();
            BaseThemeGenerator.EntityLocation loc = new BaseThemeGenerator.EntityLocation();
            loc.type = BaseThemeGenerator.LocationType.OUTER_SYSTEM;
            float orbitDays = r / (5.0f + this.genRandom.nextFloat() * 10.0f);
            loc.orbit = Global.getFactory().createCircularOrbit(focus, this.genRandom.nextFloat() * 360.0f, r, orbitDays);
            LocData curr = new LocData(loc, data.system, data.removeOnMissionOver);
            this.spawnDerelict(factionId, null, curr);
            ++i;
        }
    }

    protected PersonAPI findOrCreateTrader(String factionId, MarketAPI market, boolean cleanUpOnMissionOverIfWasNewPerson) {
        if (CheapCommodityMission.SAME_CONTACT_DEBUG) {
            return this.findOrCreatePerson(factionId, market, cleanUpOnMissionOverIfWasNewPerson, Ranks.CITIZEN, Ranks.POST_MERCHANT);
        }
        return this.findOrCreatePerson(factionId, market, cleanUpOnMissionOverIfWasNewPerson, Ranks.CITIZEN, Ranks.POST_MERCHANT, Ranks.POST_COMMODITIES_AGENT, Ranks.POST_INVESTOR, Ranks.POST_TRADER);
    }

    protected PersonAPI findOrCreateCriminal(MarketAPI market, boolean cleanUpOnMissionOverIfWasNewPerson) {
        return this.findOrCreatePerson("pirates", market, cleanUpOnMissionOverIfWasNewPerson, Ranks.CITIZEN, Ranks.POST_GANGSTER, Ranks.POST_SMUGGLER, Ranks.POST_FENCE);
    }

    protected PersonAPI findOrCreateCriminalTrader(MarketAPI market, boolean cleanUpOnMissionOverIfWasNewPerson) {
        return this.findOrCreatePerson("pirates", market, cleanUpOnMissionOverIfWasNewPerson, Ranks.CITIZEN, Ranks.POST_SMUGGLER, Ranks.POST_FENCE);
    }

    protected PersonAPI findOrCreatePerson(String factionId, MarketAPI market, boolean cleanUpOnMissionOverIfWasNewPerson, String defaultRank, String ... posts) {
        boolean createdNewPerson;
        String reason = this.getReason();
        PersonAPI person = null;
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        FactionAPI faction = null;
        if (market != null) {
            faction = market.getFaction();
        }
        if (factionId != null) {
            faction = Global.getSector().getFaction(factionId);
        }
        person = ip.getPerson(this.genRandom, faction, market, reason, defaultRank, posts).getPerson();
        boolean bl = createdNewPerson = !ip.isLastGetPersonResultWasExistingPerson();
        if (person != null && !createdNewPerson && Misc.flagHasReason(person.getMemoryWithoutUpdate(), "$requiredForMissions", this.getReason())) {
            person = null;
        }
        if (person == null) {
            person = faction.createRandomPerson(this.genRandom);
            WeightedRandomPicker<String> postPicker = new WeightedRandomPicker<String>(this.genRandom);
            String[] stringArray = posts;
            int n = posts.length;
            int n2 = 0;
            while (n2 < n) {
                String post = stringArray[n2];
                postPicker.add(post);
                ++n2;
            }
            person.setPostId((String)postPicker.pick());
            person.setRankId(defaultRank);
            person.setMarket(market);
            if (market != null) {
                market.addPerson(person);
            }
            ip.addPerson(person);
            ip.getData(person).getLocation().setMarket(market);
        }
        if (this.isBarEvent() || createdNewPerson) {
            ip.excludeFromGetPerson(person);
        }
        boolean addedToComms = false;
        if (market != null && market.getCommDirectory().getEntryForPerson(person) == null) {
            market.getCommDirectory().addPerson(person);
            addedToComms = true;
        }
        boolean willBeRemoved = false;
        if (createdNewPerson || addedToComms) {
            if (cleanUpOnMissionOverIfWasNewPerson) {
                person.addTag(REMOVE_ON_MISSION_OVER);
            }
            PersonAdded added = new PersonAdded(market, person, !createdNewPerson);
            this.changes.add(added);
            willBeRemoved = true;
        }
        this.makePersonRequired(person);
        if (!willBeRemoved && person.hasTag(REMOVE_ON_MISSION_OVER)) {
            PersonAdded added = new PersonAdded(market, person, false);
            this.changes.add(added);
        }
        person.setMarket(market);
        return person;
    }

    public void makePersonRequired(PersonAPI person) {
        PersonMadeRequired req = new PersonMadeRequired(person);
        this.changes.add(0, req);
        Misc.setFlagWithReason(person.getMemoryWithoutUpdate(), "$requiredForMissions", this.getReason(), true, -1.0f);
    }

    protected void ensurePersonIsInCommDirectory(MarketAPI market, PersonAPI person) {
        boolean addedToComms = false;
        if (market != null && market.getCommDirectory().getEntryForPerson(person) == null) {
            market.getCommDirectory().addPerson(person);
            addedToComms = true;
        }
        if (addedToComms) {
            PersonAdded added = new PersonAdded(market, person, true);
            this.changes.add(added);
        }
    }

    public void setGiverVoice(String giverVoice) {
        this.giverVoice = giverVoice;
    }

    public void setGiverFaction(String factionId) {
        this.giverFactionId = factionId;
    }

    public FullName.Gender getGiverGender() {
        return this.giverGender;
    }

    public void setGiverRank(String giverRank) {
        this.giverRank = giverRank;
    }

    public void setGiverPost(String giverPost) {
        this.giverPost = giverPost;
    }

    public void setGiverPortrait(String giverPortrait) {
        this.giverPortrait = giverPortrait;
    }

    public void setGiverImportance(PersonImportance giverImportance) {
        this.giverImportance = giverImportance;
    }

    public void setGiverTags(String ... giverTags) {
        this.giverTags = giverTags;
    }

    public void findOrCreateGiver(MarketAPI market, boolean addToCommDirectory, boolean cleanUpOnMissionOverIfWasNewPerson) {
        boolean createdNewPerson;
        String factionId = this.giverFactionId;
        if (factionId == null) {
            factionId = market.getFactionId();
        }
        PersonAPI person = this.findOrCreatePerson(factionId, market, cleanUpOnMissionOverIfWasNewPerson, this.giverRank, this.giverPost);
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        boolean bl = createdNewPerson = !ip.isLastGetPersonResultWasExistingPerson();
        if (person != null) {
            if (createdNewPerson) {
                person.setRankId(this.giverRank);
                person.setPostId(this.giverPost);
                person.setImportanceAndVoice(this.giverImportance, this.genRandom);
                if (this.giverVoice != null) {
                    person.setVoice(this.giverVoice);
                }
                if (this.giverPortrait != null) {
                    person.setPortraitSprite(this.giverPortrait);
                }
            }
            if (this.giverTags != null) {
                String[] stringArray = this.giverTags;
                int n = this.giverTags.length;
                int n2 = 0;
                while (n2 < n) {
                    String tag = stringArray[n2];
                    person.addTag(tag);
                    ++n2;
                }
            }
            if (createdNewPerson && !addToCommDirectory) {
                market.getCommDirectory().removePerson(person);
            }
            person.setMarket(market);
            this.personOverride = person;
        }
    }

    @Override
    public PersonAPI getPersonOverride() {
        return this.personOverride;
    }

    @Override
    public void setPersonOverride(PersonAPI personOverride) {
        this.personOverride = personOverride;
    }

    public PersonImportance pickImportance() {
        WeightedRandomPicker<PersonImportance> picker = new WeightedRandomPicker<PersonImportance>(this.genRandom);
        picker.add(PersonImportance.VERY_LOW, 1.0f);
        picker.add(PersonImportance.LOW, 5.0f);
        picker.add(PersonImportance.MEDIUM, 10.0f);
        picker.add(PersonImportance.HIGH, 5.0f);
        picker.add(PersonImportance.VERY_HIGH, 1.0f);
        return (PersonImportance)((Object)picker.pick());
    }

    public PersonImportance pickMediumImportance() {
        WeightedRandomPicker<PersonImportance> picker = new WeightedRandomPicker<PersonImportance>(this.genRandom);
        picker.add(PersonImportance.LOW, 5.0f);
        picker.add(PersonImportance.MEDIUM, 10.0f);
        picker.add(PersonImportance.HIGH, 5.0f);
        return (PersonImportance)((Object)picker.pick());
    }

    public PersonImportance pickHighImportance() {
        WeightedRandomPicker<PersonImportance> picker = new WeightedRandomPicker<PersonImportance>(this.genRandom);
        picker.add(PersonImportance.MEDIUM, 10.0f);
        picker.add(PersonImportance.HIGH, 5.0f);
        picker.add(PersonImportance.VERY_HIGH, 1.0f);
        return (PersonImportance)((Object)picker.pick());
    }

    public PersonImportance pickLowImportance() {
        WeightedRandomPicker<PersonImportance> picker = new WeightedRandomPicker<PersonImportance>(this.genRandom);
        picker.add(PersonImportance.VERY_LOW, 10.0f);
        picker.add(PersonImportance.LOW, 5.0f);
        picker.add(PersonImportance.MEDIUM, 1.0f);
        return (PersonImportance)((Object)picker.pick());
    }

    public void createGiver(MarketAPI market, boolean addToCommDirectory, boolean removeOnMissionOver) {
        String factionId = this.giverFactionId;
        if (factionId == null) {
            factionId = market.getFactionId();
        }
        PersonAPI person = Global.getSector().getFaction(factionId).createRandomPerson(this.giverGender, this.genRandom);
        person.setRankId(this.giverRank);
        person.setPostId(this.giverPost);
        person.setImportanceAndVoice(this.giverImportance, this.genRandom);
        if (this.giverVoice != null) {
            person.setVoice(this.giverVoice);
        }
        if (this.giverPortrait != null) {
            person.setPortraitSprite(this.giverPortrait);
        }
        if (this.giverTags != null) {
            String[] stringArray = this.giverTags;
            int n = this.giverTags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                person.addTag(tag);
                ++n2;
            }
        }
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        market.addPerson(person);
        ip.addPerson(person);
        ip.getData(person).getLocation().setMarket(market);
        if (addToCommDirectory) {
            market.getCommDirectory().addPerson(person);
        }
        if (removeOnMissionOver) {
            person.addTag(REMOVE_ON_MISSION_OVER);
        }
        PersonAdded added = new PersonAdded(market, person, false);
        this.changes.add(added);
        this.makePersonRequired(person);
        this.personOverride = person;
        this.genMissionRewardMultAndQuality();
    }

    public void genMissionRewardMultAndQuality() {
        PersonAPI person = this.getPerson();
        if (person == null) {
            return;
        }
        float rel = person.getRelToPlayer().getRel();
        if (rel > 0.0f) {
            this.rewardMult = 1.0f + rel * (Global.getSettings().getFloat("missionMaxRewardMultFromRel") - 1.0f);
        } else if (rel < 0.0f) {
            this.rewardMult = 1.0f + rel * (1.0f - Global.getSettings().getFloat("missionMinRewardMultFromRel"));
        }
        float importance = person.getImportance().getValue();
        float min = this.getMinQuality();
        float maxRelBonus = Global.getSettings().getFloat("missionMaxPossibleQualityAboveImportance");
        this.quality = Math.min(Math.max(0.0f, rel), importance);
        if (rel > importance && importance < 1.0f) {
            this.quality += (rel - importance) / (1.0f - importance) * maxRelBonus;
        }
        if (person.getMemoryWithoutUpdate().contains(BaseMissionHub.MISSION_QUALITY_BONUS)) {
            this.quality += person.getMemoryWithoutUpdate().getFloat(BaseMissionHub.MISSION_QUALITY_BONUS);
        }
        if (this.quality < min) {
            this.quality = min;
        }
        if (this.quality > 1.0f) {
            this.quality = 1.0f;
        }
    }

    public float getBaseQuality() {
        PersonAPI person = this.getPerson();
        if (person == null) {
            return 0.5f;
        }
        float importance = person.getImportance().getValue();
        return importance;
    }

    public float getMaxQuality() {
        PersonAPI person = this.getPerson();
        if (person == null) {
            return 0.0f;
        }
        float maxRelBonus = Global.getSettings().getFloat("missionMaxPossibleQualityAboveImportance");
        float importance = person.getImportance().getValue();
        return Math.min(1.0f, importance + maxRelBonus);
    }

    public float getMinQuality() {
        PersonAPI person = this.getPerson();
        if (person == null) {
            return 0.0f;
        }
        float importance = person.getImportance().getValue();
        float min = importance - Global.getSettings().getFloat("missionMinPossibleQualityBelowImportance");
        if (min < 0.0f) {
            min = 0.0f;
        }
        return min;
    }

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float quality) {
        this.quality = quality;
    }

    public float getRewardMult() {
        return this.rewardMult;
    }

    public float getRewardMultFraction() {
        float max = Global.getSettings().getFloat("missionMaxRewardMultFromRel");
        return Math.min(1.0f, Math.max(0.0f, (this.rewardMult - 1.0f) / (max - 1.0f)));
    }

    public void setRewardMult(float rewardMult) {
        this.rewardMult = rewardMult;
    }

    public Object getCurrentStage() {
        return this.currentStage;
    }

    public void addFleetDefeatTrigger(CampaignFleetAPI fleet, String trigger, boolean permanent) {
        Misc.addDefeatTrigger(fleet, trigger);
        this.changes.add(new DefeatTriggerAdded(fleet, trigger, permanent));
    }

    public String getLocated(SectorEntityToken entity) {
        return BreadcrumbSpecial.getLocatedString(entity, true);
    }

    public String getLocatedUnclear(SectorEntityToken entity) {
        return BreadcrumbSpecial.getLocatedString(entity, false);
    }

    public String getGetWithinCommsRangeText() {
        return "\u53ea\u9700\u62b5\u8fbe\u4efb\u610f\u901a\u8baf\u4e2d\u7ee7\u5668\u7684\u6709\u6548\u8303\u56f4\u5373\u53ef\u83b7\u5f97\u5956\u52b1\u3002";
    }

    public String getGetWithinCommsRangeTextShort() {
        return "\u8fdb\u5165\u901a\u8baf\u4e2d\u7ee7\u5668\u7684\u6709\u6548\u8303\u56f4\u6765\u5b8c\u6210\u4efb\u52a1\u3002";
    }

    public String getGoToSystemTextShort(StarSystemAPI system) {
        return "\u524d\u5f80 " + system.getNameWithLowercaseTypeShort();
    }

    public String getGoToPlanetTextShort(PlanetAPI planet) {
        if (planet.getStarSystem() != null) {
            return "\u524d\u5f80 " + planet.getName() + ", \u4f4d\u4e8e " + planet.getStarSystem().getNameWithLowercaseTypeShort();
        }
        return "\u524d\u5f80 " + planet.getName();
    }

    public String getGoToPlanetTextPre(PlanetAPI planet) {
        String a = planet.getSpec().getAOrAn();
        String world = planet.getTypeNameWithWorld().toLowerCase();
        if (planet.getStarSystem() != null) {
            return "\u524d\u5f80 " + planet.getName() + "\uff0c" + a + " " + world + ", \u4f4d\u4e8e " + planet.getStarSystem().getNameWithLowercaseType();
        }
        return "\u524d\u5f80 " + planet.getName() + "\uff0c" + a + " " + world + " \u800c\u6b64\u5904\u53ef\u80fd\u4f4d\u4e8e\u8d85\u7a7a\u95f4\u5185";
    }

    public String getGoToMarketText(MarketAPI market) {
        if (market.getStarSystem() != null) {
            return "\u524d\u5f80 " + market.getName() + ", \u4f4d\u4e8e " + market.getStarSystem().getNameWithLowercaseTypeShort();
        }
        return "\u524d\u5f80 " + market.getName();
    }

    public String getGoTalkToPersonText(PersonAPI person) {
        MarketAPI market = person.getMarket();
        if (market != null) {
            return String.valueOf(this.getGoToMarketText(market)) + " \u5e76\u8054\u7cfb " + person.getNameString();
        }
        return "\u8054\u7cfb " + person.getNameString();
    }

    public String getReturnText(MarketAPI market) {
        return this.getReturnText(market.getName());
    }

    public String getReturnText(String locationName) {
        return "\u56de\u5230 " + locationName + " \u5e76\u8054\u7cfb " + this.getPerson().getNameString() + " \u5373\u53ef\u83b7\u5f97\u5956\u52b1";
    }

    public String getReturnTextShort(MarketAPI market) {
        return this.getReturnTextShort(market.getName());
    }

    public String getReturnTextShort(String locationName) {
        return "\u56de\u5230 " + locationName + " \u5e76\u8054\u7cfb " + this.getPerson().getNameString();
    }

    public BaseThemeGenerator.EntityLocation generateLocationInsideTerrain(CampaignTerrainAPI terrain) {
        CampaignTerrainPlugin plugin = terrain.getPlugin();
        boolean found = false;
        float orbitAngle = 0.0f;
        float orbitRadius = 0.0f;
        float orbitPeriod = 0.0f;
        SectorEntityToken orbitFocus = terrain;
        Vector2f forceLoc = null;
        if (plugin instanceof BaseTiledTerrain) {
            BaseTiledTerrain tiles = (BaseTiledTerrain)plugin;
            float maxRadius = plugin.getRenderRange();
            if (maxRadius < 100.0f) {
                maxRadius = 100.0f;
            }
            WeightedRandomPicker<Pair<Integer, Integer>> picker = new WeightedRandomPicker<Pair<Integer, Integer>>(this.genRandom);
            WeightedRandomPicker<Pair<Integer, Integer>> pickerPref = new WeightedRandomPicker<Pair<Integer, Integer>>(this.genRandom);
            int i = 0;
            while (i < tiles.getTiles().length) {
                int j = 0;
                while (j < tiles.getTiles()[0].length) {
                    if (tiles.getTiles()[i][j] >= 0) {
                        float[] f = tiles.getTileCenter(i, j);
                        Vector2f loc = new Vector2f(f[0], f[1]);
                        float dist = Misc.getDistance(terrain.getLocation(), loc);
                        float weight = (float)Math.pow(dist / maxRadius, 3.0);
                        if (dist < 16000.0f) {
                            pickerPref.add(new Pair<Integer, Integer>(i, j), weight);
                        } else if (pickerPref.isEmpty()) {
                            picker.add(new Pair<Integer, Integer>(i, j), weight);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            Pair pick = (Pair)pickerPref.pick();
            if (pick == null) {
                pick = (Pair)picker.pick();
            }
            if (pick != null) {
                float[] f = tiles.getTileCenter((Integer)pick.one, (Integer)pick.two);
                Vector2f loc = new Vector2f(f[0], f[1]);
                if (terrain.getOrbit() == null || terrain.getCircularOrbitRadius() <= 0.0f || terrain.getOrbitFocus() == null) {
                    forceLoc = loc;
                } else {
                    orbitFocus = terrain.getOrbitFocus();
                    orbitAngle = Misc.getAngleInDegrees(orbitFocus.getLocation(), loc);
                    orbitRadius = Misc.getDistance(orbitFocus.getLocation(), loc);
                    orbitPeriod = terrain.getCircularOrbitPeriod();
                }
                found = true;
            }
        } else if (plugin instanceof BaseRingTerrain) {
            BaseRingTerrain ring = (BaseRingTerrain)plugin;
            SectorEntityToken atCenter = ring.getRingParams().relatedEntity;
            float centerRadius = 0.0f;
            if (atCenter != null) {
                centerRadius = atCenter.getRadius();
            }
            float ringMiddle = ring.getRingParams().middleRadius;
            float ringMin = ring.getRingParams().middleRadius - ring.getRingParams().bandWidthInEngine / 2.0f;
            float ringMax = ring.getRingParams().middleRadius + ring.getRingParams().bandWidthInEngine / 2.0f;
            float min = Math.max(centerRadius, ringMin);
            orbitRadius = min + (ringMax - min) * (0.1f + 0.8f * this.genRandom.nextFloat());
            orbitAngle = this.genRandom.nextFloat() * 360.0f;
            found = true;
        }
        if (!found) {
            orbitRadius = 100.0f + 100.0f * this.genRandom.nextFloat();
            orbitAngle = 360.0f * this.genRandom.nextFloat();
        }
        BaseThemeGenerator.EntityLocation eLoc = new BaseThemeGenerator.EntityLocation();
        eLoc.type = BaseThemeGenerator.LocationType.OUTER_SYSTEM;
        if (forceLoc != null) {
            eLoc.location = forceLoc;
        } else {
            if (orbitPeriod <= 0.0f) {
                orbitPeriod = orbitRadius / (5.0f + 5.0f * this.genRandom.nextFloat());
            }
            eLoc.orbit = Global.getFactory().createCircularOrbit(orbitFocus, orbitAngle, orbitRadius, orbitPeriod);
        }
        return eLoc;
    }

    public static String getTerrainName(CampaignTerrainAPI terrain) {
        String name = terrain.getPlugin().getTerrainName();
        if (name == null) {
            name = "";
        }
        if (name.contains(" L4") || name.contains(" L5")) {
            name = BaseHubMission.getTerrainType(terrain);
        }
        return name;
    }

    public static boolean hasSpecialName(CampaignTerrainAPI terrain) {
        return !BaseHubMission.getTerrainName(terrain).toLowerCase().equals(BaseHubMission.getTerrainType(terrain).toLowerCase());
    }

    public static String getTerrainNameAOrAn(CampaignTerrainAPI terrain) {
        String name = BaseHubMission.getTerrainName(terrain);
        if (name != null) {
            return Misc.getAOrAnFor(name);
        }
        return terrain.getPlugin().getNameAOrAn();
    }

    public static String getTerrainTypeAOrAn(CampaignTerrainAPI terrain) {
        String type = BaseHubMission.getTerrainType(terrain);
        if (type != null) {
            return Misc.getAOrAnFor(type);
        }
        return terrain.getPlugin().getNameAOrAn();
    }

    public static String getTerrainType(CampaignTerrainAPI terrain) {
        return terrain.getPlugin().getNameForTooltip().toLowerCase();
    }

    public static float getUnits(float lightYears) {
        return lightYears * Misc.getUnitsPerLightYear();
    }

    public static boolean playerHasEnough(String comId, int quantity) {
        return Global.getSector().getPlayerFleet().getCargo().getCommodityQuantity(comId) >= (float)quantity;
    }

    public void assignShipName(FleetMemberAPI member, String factionId) {
        CampaignFleetAPI fleet = Global.getFactory().createEmptyFleet(factionId, null, true);
        fleet.getFleetData().setShipNameRandom(this.genRandom);
        fleet.getFleetData().addFleetMember(member);
        fleet.getFleetData().removeFleetMember(member);
    }

    public String getDayOrDays(float days) {
        int d = Math.round(days);
        String daysStr = "days";
        if (d == 1) {
            daysStr = "day";
        }
        return daysStr;
    }

    public List<Abortable> getChanges() {
        return this.changes;
    }

    public Random getGenRandom() {
        return this.genRandom;
    }

    public void addOnAcceptCommodity(String commodityId, int quantity) {
        this.cargoOnAccept.addCommodity(commodityId, quantity);
    }

    public void addOnAcceptWeaponDrop(String weaponId, int quantity) {
        this.cargoOnAccept.addWeapons(weaponId, quantity);
    }

    public void addOnAcceptFighterLPCDrop(String wingId, int quantity) {
        this.cargoOnAccept.addFighters(wingId, quantity);
    }

    public void addOnAcceptHullmodDrop(String hullmodId) {
        this.cargoOnAccept.addHullmods(hullmodId, 1);
    }

    public void addOnAcceptSpecialItemDrop(String itemId, String data) {
        this.cargoOnAccept.addSpecial(new SpecialItemData(itemId, data), 1.0f);
    }

    public void addOnSuccessCommodity(String commodityId, int quantity) {
        if (this.cargoOnSuccess == null) {
            this.cargoOnSuccess = Global.getFactory().createCargo(true);
        }
        this.cargoOnSuccess.addCommodity(commodityId, quantity);
    }

    public void addOnSuccessWeaponDrop(String weaponId, int quantity) {
        if (this.cargoOnSuccess == null) {
            this.cargoOnSuccess = Global.getFactory().createCargo(true);
        }
        this.cargoOnSuccess.addWeapons(weaponId, quantity);
    }

    public void addOnSuccessFighterLPCDrop(String wingId, int quantity) {
        if (this.cargoOnSuccess == null) {
            this.cargoOnSuccess = Global.getFactory().createCargo(true);
        }
        this.cargoOnSuccess.addFighters(wingId, quantity);
    }

    public void addOnSuccessHullmodDrop(String hullmodId) {
        if (this.cargoOnSuccess == null) {
            this.cargoOnSuccess = Global.getFactory().createCargo(true);
        }
        this.cargoOnSuccess.addHullmods(hullmodId, 1);
    }

    public void addOnSuccessSpecialItemDrop(String itemId, String data) {
        if (this.cargoOnSuccess == null) {
            this.cargoOnSuccess = Global.getFactory().createCargo(true);
        }
        this.cargoOnSuccess.addSpecial(new SpecialItemData(itemId, data), 1.0f);
    }

    public int getMarinesRequiredToDisrupt(MarketAPI market, Industry industry, int daysRequired) {
        int daysPerToken = MarketCMD.getDisruptDaysPerToken(market, industry);
        int tokens = (int)Math.ceil((float)(daysRequired -= (int)industry.getDisruptedDays()) / (float)daysPerToken);
        if (tokens < 1) {
            tokens = 1;
        }
        int marinesRequired = MarketCMD.getMarinesFor(market, tokens);
        marinesRequired = BaseHubMission.getAdjustedMarinesRequired(marinesRequired);
        return marinesRequired;
    }

    public void addDisruptRaidInfo(MarketAPI market, Industry industry, int daysRequired, TooltipMakerAPI info, float pad) {
        int marinesRequired = this.getMarinesRequiredToDisrupt(market, industry, daysRequired);
        MarketCMD.RaidDangerLevel danger = industry.getSpec().getDisruptDanger();
        Color h = Misc.getHighlightColor();
        LabelAPI label = info.addPara(String.valueOf(industry.getCurrentName()) + " \u5fc5\u987b\u88ab\u762b\u75ea %s \u5929\u3002" + "\u672c\u6b21\u884c\u52a8\u53ef\u80fd\u9700\u8981\u7ea6 %s \u540d\u9646\u6218\u961f\u5458\u3002" + "\u4e14\u76ee\u6807\u5371\u9669\u7a0b\u5ea6\u4e3a %s.", pad, h, "" + daysRequired, Misc.getWithDGS(marinesRequired), danger.name.toLowerCase());
        label.setHighlightColors(h, h, danger.color);
    }

    public int getMarinesRequiredForCustomObjective(MarketAPI market, MarketCMD.RaidDangerLevel danger) {
        int marinesRequired = MarketCMD.getMarinesFor(market, Math.max(1, danger.marineTokens));
        marinesRequired = BaseHubMission.getAdjustedMarinesRequired(marinesRequired);
        return marinesRequired;
    }

    public int getMarinesRequiredForCustomDefenderStrength(int defenderStrength, MarketCMD.RaidDangerLevel danger) {
        int marinesRequired = MarketCMD.getMarinesFor(defenderStrength, Math.max(1, danger.marineTokens));
        marinesRequired = BaseHubMission.getAdjustedMarinesRequired(marinesRequired);
        return marinesRequired;
    }

    public void addCustomRaidInfo(MarketAPI market, MarketCMD.RaidDangerLevel danger, TooltipMakerAPI info, float pad) {
        int marinesRequired = this.getMarinesRequiredForCustomObjective(market, danger);
        Color h = Misc.getHighlightColor();
        LabelAPI label = info.addPara("\u9700\u8981\u7ea6 %s \u540d\u9646\u6218\u961f\uff0c\u4e14\u76ee\u6807\u5371\u9669\u7b49\u7ea7\u4e3a %s.", pad, h, Misc.getWithDGS(marinesRequired), danger.name.toLowerCase());
        label.setHighlightColors(h, danger.color);
    }

    public void addCustomRaidInfo(int defenderStrength, MarketCMD.RaidDangerLevel danger, TooltipMakerAPI info, float pad) {
        int marinesRequired = MarketCMD.getMarinesFor(defenderStrength, Math.max(1, danger.marineTokens));
        marinesRequired = BaseHubMission.getAdjustedMarinesRequired(marinesRequired);
        Color h = Misc.getHighlightColor();
        LabelAPI label = info.addPara("\u9700\u8981\u7ea6 %s \u540d\u9646\u6218\u961f\uff0c\u4e14\u76ee\u6807\u5371\u9669\u7b49\u7ea7\u4e3a %s.", pad, h, Misc.getWithDGS(marinesRequired), danger.name.toLowerCase());
        label.setHighlightColors(h, danger.color);
    }

    public static int getAdjustedMarinesRequired(int marinesRequired) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        float support = Misc.getFleetwideTotalMod(playerFleet, "ground_support", 0.0f);
        StatBonus stat = playerFleet.getStats().getDynamic().getMod("ground_attack_mod");
        int min = 0;
        int max = 0;
        int i = 1;
        while (i < marinesRequired * 2) {
            float currSupport = Math.round(Math.min(support, (float)i));
            float strength = (float)i + currSupport;
            if ((strength = stat.computeEffective(strength)) >= (float)marinesRequired) {
                min = i / 2;
                max = i;
                break;
            }
            i *= 2;
        }
        if (max > 0) {
            int iter = Math.max(1, (max - min) / 100);
            int i2 = min;
            while (i2 <= max) {
                float currSupport = (int)Math.min(support, (float)i2);
                float strength = (float)i2 + currSupport;
                if ((strength = stat.computeEffective(strength)) >= (float)marinesRequired) {
                    marinesRequired = Math.round(strength);
                    break;
                }
                i2 += iter;
            }
        }
        int base = 10;
        if (marinesRequired > 100) {
            base = 50;
        }
        if (marinesRequired > 500) {
            base = 100;
        }
        if (marinesRequired > 1000) {
            base = 250;
        }
        if (marinesRequired > 2000) {
            base = 500;
        }
        if (marinesRequired > 5000) {
            base = 1000;
        }
        int i3 = 0;
        while (i3 < 10) {
            if (marinesRequired <= (i3 + 1) * base) {
                marinesRequired = (i3 + 1) * base;
                break;
            }
            ++i3;
        }
        marinesRequired = BaseHubMission.getRoundNumber(marinesRequired);
        return marinesRequired;
    }

    public static void addStandardMarketDesc(String prefix, MarketAPI market, TooltipMakerAPI info, float pad) {
        Color h = Misc.getHighlightColor();
        FactionAPI f = market.getFaction();
        if (Misc.isHiddenBase(market)) {
            String a = f.getPersonNamePrefixAOrAn();
            if (prefix == null || prefix.isEmpty()) {
                if (market.isInHyperspace()) {
                    LabelAPI label = info.addPara(String.valueOf(market.getName()) + " \u662f" + a + " " + f.getPersonNamePrefix() + " \u4e14\u4f4d\u4e8e\u8d85\u7a7a\u95f4\u3002", pad);
                    label.setHighlight(market.getName(), f.getPersonNamePrefix());
                    label.setHighlightColors(f.getBaseUIColor(), f.getBaseUIColor());
                } else {
                    LabelAPI label = info.addPara(String.valueOf(market.getName()) + " \u662f" + a + " " + f.getPersonNamePrefix() + " \u4e14\u4f4d\u4e8e " + market.getStarSystem().getNameWithLowercaseTypeShort() + ".", pad);
                    label.setHighlight(market.getName(), f.getPersonNamePrefix());
                    label.setHighlightColors(f.getBaseUIColor(), f.getBaseUIColor());
                }
            } else if (market.isInHyperspace()) {
                LabelAPI label = info.addPara(String.valueOf(prefix) + " " + market.getName() + "\uff0c" + a + " " + f.getPersonNamePrefix() + " \u4e14\u4f4d\u4e8e\u8d85\u7a7a\u95f4\u3002", pad);
                label.setHighlight(market.getName(), f.getDisplayNameWithArticleWithoutArticle());
                label.setHighlightColors(f.getBaseUIColor(), f.getBaseUIColor());
            } else {
                LabelAPI label = info.addPara(String.valueOf(prefix) + " " + market.getName() + "\uff0c" + a + " " + f.getPersonNamePrefix() + " \u4e14\u4f4d\u4e8e " + market.getStarSystem().getNameWithLowercaseTypeShort() + ".", pad);
                label.setHighlight(market.getName(), f.getPersonNamePrefix());
                label.setHighlightColors(f.getBaseUIColor(), f.getBaseUIColor());
            }
            return;
        }
        if (prefix == null || prefix.isEmpty()) {
            if (market.isInHyperspace()) {
                LabelAPI label = info.addPara(String.valueOf(market.getName()) + " \u89c4\u6a21\uff1a%s" + ", \u4e14\u76ee\u524d\u96b6\u5c5e\u4e8e " + f.getDisplayNameWithArticle() + ".", pad, f.getBaseUIColor(), "" + market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
                label.setHighlight(market.getName(), "" + market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
                label.setHighlightColors(f.getBaseUIColor(), h, f.getBaseUIColor());
            } else {
                LabelAPI label = info.addPara(String.valueOf(market.getName()) + " \u89c4\u6a21\uff1a%s" + "\u4f4d\u4e8e " + market.getStarSystem().getNameWithLowercaseTypeShort() + ", \u4e14\u76ee\u524d\u96b6\u5c5e\u4e8e " + f.getDisplayNameWithArticle() + ".", pad, f.getBaseUIColor(), "" + market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
                label.setHighlight(market.getName(), "" + market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
                label.setHighlightColors(f.getBaseUIColor(), h, f.getBaseUIColor());
            }
        } else if (market.isInHyperspace()) {
            LabelAPI label = info.addPara(String.valueOf(prefix) + " " + market.getName() + "\uff0c\u89c4\u6a21\uff1a%s}\uff0c" + ", \u4e14\u76ee\u524d\u96b6\u5c5e\u4e8e " + f.getDisplayNameWithArticle() + ".", pad, f.getBaseUIColor(), "" + market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
            label.setHighlight(market.getName(), "" + market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
            label.setHighlightColors(f.getBaseUIColor(), h, f.getBaseUIColor());
        } else {
            LabelAPI label = info.addPara(String.valueOf(prefix) + " " + market.getName() + "\uff0c\u89c4\u6a21\uff1a%s}\uff0c" + "\u4f4d\u4e8e " + market.getStarSystem().getNameWithLowercaseTypeShort() + ", \u4e14\u76ee\u524d\u96b6\u5c5e\u4e8e " + f.getDisplayNameWithArticle() + ".", pad, f.getBaseUIColor(), "" + market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
            label.setHighlight(market.getName(), "" + market.getSize(), f.getDisplayNameWithArticleWithoutArticle());
            label.setHighlightColors(f.getBaseUIColor(), h, f.getBaseUIColor());
        }
    }

    public int getBombardmentFuel(MarketAPI market) {
        int fuel = MarketCMD.getBombardmentCost(market, Global.getSector().getPlayerFleet());
        fuel = BaseHubMission.getRoundNumber(fuel);
        return fuel;
    }

    public void addBombardmentInfo(MarketAPI market, TooltipMakerAPI info, float pad) {
        int fuel = this.getBombardmentFuel(market);
        Color h = Misc.getHighlightColor();
        info.addPara("\u5bf9\u76ee\u6807\u5b9e\u65bd\u6709\u6548\u8f70\u70b8\u9700\u8981\u7ea6 %s \u5355\u4f4d\u7684\u71c3\u6599\u3002", pad, h, Misc.getWithDGS(fuel));
    }

    public void addSpecialItemDropOnlyUseInAcceptImplNotUndoneOnAbort(SectorEntityToken entity, SpecialItemData data) {
        CargoAPI cargo = Global.getFactory().createCargo(true);
        cargo.addSpecial(data, 1.0f);
        BaseSalvageSpecial.addExtraSalvage(entity, cargo);
    }

    public PersonAPI getImportantPerson(String id) {
        return Global.getSector().getImportantPeople().getData(id).getPerson();
    }

    public ImportantPeopleAPI.PersonDataAPI getImportantPersonData(String id) {
        return Global.getSector().getImportantPeople().getData(id);
    }

    public void setMemoryValuePermanent(HasMemory withMemory, String key, Object value) {
        withMemory.getMemoryWithoutUpdate().set(key, value);
    }

    public void setStoryMission() {
        this.setNoAbandon();
        this.addTag("Story");
        this.setUseLargeFontInMissionList();
    }

    public void setCompletedKey() {
        this.completedKey = "$" + this.getMissionId() + "_missionCompleted";
    }

    public boolean isOkToOfferMissionRequiringMarines(int marines) {
        PlaythroughLog log = PlaythroughLog.getInstance();
        long crew = log.getPrevValue("crew");
        long credits = log.getPrevValue("credits");
        return crew > (long)(marines * 2) || credits > (long)(marines * 400);
    }

    public Object getStartingStage() {
        return this.startingStage;
    }

    public PersonAPI getPersonAtMarketPost(MarketAPI market, String ... postIds) {
        String[] stringArray = postIds;
        int n = postIds.length;
        int n2 = 0;
        while (n2 < n) {
            String postId = stringArray[n2];
            for (PersonAPI person : market.getPeopleCopy()) {
                if (!postId.equals(person.getPostId())) continue;
                return person;
            }
            ++n2;
        }
        return null;
    }

    public MarketAPI getMarket(String id) {
        return Global.getSector().getEconomy().getMarket(id);
    }

    public void setMapMarkerNameColor(Color mapMarkerColor) {
        this.mapMarkerNameColor = mapMarkerColor;
    }

    public void setMapMarkerNameColorBasedOnStar(StarSystemAPI system) {
        if (system.getCenter() instanceof PlanetAPI) {
            Color color = Misc.setAlpha(((PlanetAPI)system.getCenter()).getSpec().getIconColor(), 255);
            color = Misc.setBrightness(color, 235);
            this.setMapMarkerNameColor(color);
        }
    }

    public List<MissionTrigger> getTriggers() {
        return this.triggers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Abandon {
        ABANDON;

    }

    public static interface Abortable {
        public void abort(HubMission var1, boolean var2);
    }

    public static class AlwaysTrueChecker
    implements ConditionChecker {
        public boolean conditionsMet() {
            return true;
        }
    }

    public static interface ConditionChecker {
        public boolean conditionsMet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreditReward {
        VERY_LOW(20000, 25000, 2000),
        LOW(30000, 40000, 5000),
        AVERAGE(50000, 60000, 10000),
        HIGH(70000, 80000, 15000),
        VERY_HIGH(90000, 100000, 20000);

        public int min;
        public int max;
        public int perMarketSize;

        private CreditReward(int min, int max, int perMarketSize) {
            this.min = (int)((float)min * GLOBAL_MISSION_REWARD_MULT);
            this.max = (int)((float)max * GLOBAL_MISSION_REWARD_MULT);
            this.perMarketSize = (int)((float)perMarketSize * GLOBAL_MISSION_REWARD_MULT);
        }
    }

    public static class DaysElapsedChecker
    implements ConditionChecker {
        public float days;
        public StageData stage;
        public BaseHubMission mission;

        public DaysElapsedChecker(float days, StageData stage) {
            this.days = days;
            this.stage = stage;
        }

        public DaysElapsedChecker(float days, BaseHubMission mission) {
            this.days = days;
            this.mission = mission;
        }

        public boolean conditionsMet() {
            if (this.mission != null) {
                return this.mission.elapsed >= this.days;
            }
            return this.stage.elapsed >= this.days;
        }
    }

    public static class DefeatTriggerAdded
    implements Abortable {
        protected CampaignFleetAPI fleet;
        protected String trigger;
        protected boolean permanent;

        public DefeatTriggerAdded(CampaignFleetAPI fleet, String trigger, boolean permanent) {
            this.fleet = fleet;
            this.trigger = trigger;
            this.permanent = permanent;
        }

        public void abort(HubMission mission, boolean missionOver) {
            if (!this.permanent || !missionOver) {
                Misc.removeDefeatTrigger(this.fleet, this.trigger);
            }
        }
    }

    public static class EnteredLocationChecker
    implements ConditionChecker {
        public LocationAPI location;

        public EnteredLocationChecker(LocationAPI location) {
            this.location = location;
        }

        public boolean conditionsMet() {
            return Global.getSector().getCurrentLocation() == this.location;
        }
    }

    public static class EntityAdded
    implements Abortable {
        public SectorEntityToken entity;

        public EntityAdded(SectorEntityToken entity) {
            this.entity = entity;
        }

        public void abort(HubMission mission, boolean missionOver) {
            if (missionOver) {
                if (!this.entity.hasTag(REMOVE_ON_MISSION_OVER)) {
                    return;
                }
                if (this.entity.hasTag("fading_out_and_expiring")) {
                    return;
                }
            }
            if (this.entity.getContainingLocation() != null) {
                this.entity.getContainingLocation().removeEntity(this.entity);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityLocationType {
        HIDDEN,
        HIDDEN_NOT_NEAR_STAR,
        ORBITING_PLANET,
        ORBITING_PLANET_OR_STAR,
        UNCOMMON,
        ANY,
        ORBITING_PARAM;

    }

    public static class EntityNotAliveChecker
    implements ConditionChecker {
        public SectorEntityToken entity;

        public EntityNotAliveChecker(SectorEntityToken entity) {
            this.entity = entity;
        }

        public boolean conditionsMet() {
            return !this.entity.isAlive();
        }
    }

    public static class FlagData {
        public MemoryAPI memory;
        public String flag;
        public LinkedHashSet<Object> stages = new LinkedHashSet();
    }

    public static class GlobalBooleanChecker
    implements ConditionChecker {
        public String flag;

        public GlobalBooleanChecker(String flag) {
            this.flag = flag;
        }

        public boolean conditionsMet() {
            return Global.getSector().getMemoryWithoutUpdate().getBoolean(this.flag);
        }
    }

    public static class HostilitiesEndedChecker
    implements ConditionChecker {
        public PersonAPI person;
        public MarketAPI market;

        public HostilitiesEndedChecker(PersonAPI person, MarketAPI market) {
            this.person = person;
            this.market = market;
        }

        public boolean conditionsMet() {
            return !this.person.getFaction().isHostileTo(this.market.getFaction());
        }
    }

    public static class HostilitiesStartedChecker
    implements ConditionChecker {
        public PersonAPI person;
        public MarketAPI market;

        public HostilitiesStartedChecker(PersonAPI person, MarketAPI market) {
            this.person = person;
            this.market = market;
        }

        public boolean conditionsMet() {
            return this.person.getFaction().isHostileTo(this.market.getFaction());
        }
    }

    public static class HubMissionResult {
        public boolean success;
        public int reward;
        public int xp;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult repPerson;
        public ReputationActionResponsePlugin.ReputationAdjustmentResult repFaction;
        public Object custom;
    }

    public static class ImportanceData {
        public MemoryAPI memory;
        public String flag;
        public MapLocationType locType = null;
        public SectorEntityToken entity;
        public MarketAPI market;
        public PersonAPI person;
    }

    public static class InCommRelayRangeChecker
    implements ConditionChecker {
        public boolean conditionsMet() {
            return Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay();
        }
    }

    public static class InHyperRangeOfEntityChecker
    implements ConditionChecker {
        public SectorEntityToken entity;
        public float rangeLY;
        public boolean requirePlayerInHyperspace;

        public InHyperRangeOfEntityChecker(SectorEntityToken entity, float rangeLY, boolean requirePlayerInHyperspace) {
            this.entity = entity;
            this.rangeLY = rangeLY;
            this.requirePlayerInHyperspace = requirePlayerInHyperspace;
        }

        public boolean conditionsMet() {
            if (this.requirePlayerInHyperspace && !Global.getSector().getPlayerFleet().isInHyperspace()) {
                return false;
            }
            return Misc.getDistanceLY(Global.getSector().getPlayerFleet(), this.entity) < this.rangeLY;
        }
    }

    public static class InRangeOfEntityChecker
    implements ConditionChecker {
        public SectorEntityToken entity;
        public float range;

        public InRangeOfEntityChecker(SectorEntityToken entity, float range) {
            this.entity = entity;
            this.range = range;
        }

        public boolean conditionsMet() {
            return Global.getSector().getCurrentLocation() == this.entity.getContainingLocation() && Misc.getDistance(Global.getSector().getPlayerFleet(), this.entity) < this.range;
        }
    }

    public static class LocData {
        public CampaignTerrainAPI terrain;
        public BaseThemeGenerator.EntityLocation loc;
        public EntityLocationType type;
        public SectorEntityToken centerOn;
        public LocationAPI system;
        public boolean removeOnMissionOver;

        public LocData(BaseThemeGenerator.EntityLocation loc, LocationAPI system, boolean removeOnMissionOver) {
            this.loc = loc;
            this.removeOnMissionOver = removeOnMissionOver;
            this.system = system;
        }

        public LocData(EntityLocationType type, SectorEntityToken centerOn, LocationAPI system, boolean removeOnMissionOver) {
            this.type = type;
            this.centerOn = centerOn;
            this.system = system;
            this.removeOnMissionOver = removeOnMissionOver;
        }

        public LocData(SectorEntityToken centerOn, boolean removeOnMissionOver) {
            if (centerOn instanceof CampaignTerrainAPI) {
                this.centerOn = centerOn;
            } else {
                this.loc = new BaseThemeGenerator.EntityLocation();
                this.loc.type = BaseThemeGenerator.LocationType.OUTER_SYSTEM;
                this.loc.orbit = Global.getFactory().createCircularOrbit(centerOn, 0.0f, 0.0f, 1000.0f);
            }
            this.system = centerOn.getContainingLocation();
            this.removeOnMissionOver = removeOnMissionOver;
        }

        public LocData(Vector2f loc, LocationAPI system, boolean removeOnMissionOver) {
            this.loc = new BaseThemeGenerator.EntityLocation();
            this.loc.type = BaseThemeGenerator.LocationType.OUTER_SYSTEM;
            this.loc.location = loc;
            this.system = system;
            this.removeOnMissionOver = removeOnMissionOver;
        }

        public LocData(BaseThemeGenerator.EntityLocation loc, LocationAPI system) {
            this(loc, system, true);
        }

        public LocData(EntityLocationType type, SectorEntityToken centerOn, LocationAPI system) {
            this(type, centerOn, system, true);
        }

        public LocData(SectorEntityToken centerOn) {
            this(centerOn, true);
        }

        public LocData(Vector2f loc, LocationAPI system) {
            this(loc, system, true);
        }

        public boolean updateLocIfNeeded(BaseHubMission mission, String entityId) {
            if (this.centerOn instanceof CampaignTerrainAPI) {
                CampaignTerrainAPI terrain = (CampaignTerrainAPI)this.centerOn;
                this.loc = mission.generateLocationInsideTerrain(terrain);
                if (this.loc == null) {
                    return false;
                }
            } else if (this.type != null) {
                this.loc = mission.generateLocation(entityId, this.type, this.centerOn, this.system);
                if (this.loc == null) {
                    return false;
                }
            }
            return true;
        }

        public void placeEntity(SectorEntityToken entity) {
            if (this.loc.orbit != null) {
                entity.setOrbit(this.loc.orbit);
                this.loc.orbit.setEntity(entity);
            } else {
                entity.setOrbit(null);
                entity.getLocation().set((ReadableVector2f)this.loc.location);
            }
            if (this.removeOnMissionOver) {
                entity.addTag(REMOVE_ON_MISSION_OVER);
            }
        }
    }

    public static class MadeImportant
    implements Abortable {
        public MemoryAPI memory;
        public String reason;

        public MadeImportant(MemoryAPI memory, String reason) {
            this.memory = memory;
            this.reason = reason;
        }

        public void abort(HubMission mission, boolean missionOver) {
            Misc.makeUnimportant(this.memory, this.reason);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MapLocationType {
        NORMAL,
        CONSTELLATION;

    }

    public static class MarketDecivChecker
    implements ConditionChecker {
        public MarketAPI market;

        public MarketDecivChecker(MarketAPI market) {
            this.market = market;
        }

        public boolean conditionsMet() {
            return this.market.isPlanetConditionMarketOnly() || this.market.getPrimaryEntity() != null && !this.market.getPrimaryEntity().isAlive();
        }
    }

    public static class MemoryBooleanChecker
    implements ConditionChecker {
        public String flag;
        public MemoryAPI memory;

        public MemoryBooleanChecker(MemoryAPI memory, String flag) {
            this.memory = memory;
            this.flag = flag;
        }

        public boolean conditionsMet() {
            return this.memory.getBoolean(this.flag);
        }
    }

    public static class PersonAdded
    implements Abortable {
        public MarketAPI market;
        public PersonAPI person;
        public boolean wasOnlyAddedToCommDirectory;

        public PersonAdded(MarketAPI market, PersonAPI person, boolean wasOnlyAddedToCommDirectory) {
            this.market = market;
            this.person = person;
            this.wasOnlyAddedToCommDirectory = wasOnlyAddedToCommDirectory;
        }

        public void abort(HubMission mission, boolean missionOver) {
            if (missionOver && !this.person.hasTag(REMOVE_ON_MISSION_OVER)) {
                return;
            }
            if (mission instanceof BaseHubMission) {
                BaseHubMission bhm = (BaseHubMission)mission;
                if (Misc.setFlagWithReason(this.person.getMemoryWithoutUpdate(), "$requiredForMissions", bhm.getReason(), false, -1.0f)) {
                    return;
                }
            }
            if (!this.wasOnlyAddedToCommDirectory) {
                if (this.market != null) {
                    this.market.removePerson(this.person);
                }
                Global.getSector().getImportantPeople().removePerson(this.person);
            }
            if (this.market != null) {
                this.market.getCommDirectory().removePerson(this.person);
            }
        }
    }

    public static class PersonMadeRequired
    implements Abortable {
        public PersonAPI person;

        public PersonMadeRequired(PersonAPI person) {
            this.person = person;
        }

        public void abort(HubMission mission, boolean missionOver) {
            if (mission instanceof BaseHubMission) {
                BaseHubMission bhm = (BaseHubMission)mission;
                if (Misc.setFlagWithReason(this.person.getMemoryWithoutUpdate(), "$requiredForMissions", bhm.getReason(), false, -1.0f)) {
                    return;
                }
            }
        }
    }

    public static class PotentialContactData {
        public PersonAPI contact;
        public float probability = -1.0f;
    }

    public static class StageConnection {
        public Object from;
        public Object to;
        public ConditionChecker checker;

        public StageConnection(Object from, Object to, ConditionChecker checker) {
            this.from = from;
            this.to = to;
            this.checker = checker;
        }
    }

    public static class StageData {
        public Object id;
        public float elapsed = 0.0f;
        public List<ImportanceData> important = new ArrayList<ImportanceData>();
    }

    public static class TimeLimitData {
        public float days;
        public Object failStage;
        public LinkedHashSet<Object> endLimitStages = new LinkedHashSet();
        public StarSystemAPI noLimitWhileInSystem;
    }

    public static class VariableSet
    implements Abortable {
        public MemoryAPI memory;
        public String key;
        public boolean removeOnMissionOver;

        public VariableSet(MemoryAPI memory, String key, boolean removeOnMissionOver) {
            this.memory = memory;
            this.key = key;
            this.removeOnMissionOver = removeOnMissionOver;
        }

        public void abort(HubMission mission, boolean missionOver) {
            if (!this.removeOnMissionOver && missionOver) {
                return;
            }
            this.memory.unset(this.key);
        }
    }
}

