/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionHub;
import com.fs.starfarer.api.loading.PersonMissionSpec;
import java.util.Random;

public class BaseHubMissionCreator
implements HubMissionCreator {
    protected int numCompleted = 0;
    protected int numFailed = 0;
    protected long seed;
    protected transient Random genRandom = null;
    protected transient PersonMissionSpec spec = null;
    protected String specId = null;
    protected boolean wasAutoAdded = false;
    protected boolean isActive = true;

    public BaseHubMissionCreator(PersonMissionSpec spec) {
        this.spec = spec;
        if (spec != null) {
            this.specId = spec.getMissionId();
        }
    }

    protected Object readResolve() {
        this.spec = Global.getSettings().getMissionSpec(this.specId);
        return this;
    }

    public PersonMissionSpec getSpec() {
        return this.spec;
    }

    public String getSpecId() {
        return this.specId;
    }

    public HubMission createHubMission(MissionHub hub) {
        return this.spec.createMission();
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void updateRandom() {
        this.genRandom = new Random(this.seed);
    }

    public void incrCompleted() {
        ++this.numCompleted;
    }

    public int getNumCompleted() {
        return this.numCompleted;
    }

    public void setNumCompleted(int numCompleted) {
        this.numCompleted = numCompleted;
    }

    public void incrFailed() {
        ++this.numFailed;
    }

    public int getNumFailed() {
        return this.numFailed;
    }

    public void setNumFailed(int numFailed) {
        this.numFailed = numFailed;
    }

    public float getFrequencyWeight() {
        return this.spec.getFreq();
    }

    public float getWasShownTimeoutDuration() {
        return 0.0f;
    }

    public float getAcceptedTimeoutDuration() {
        return this.spec.getMinTimeout() + (float)Math.random() * (this.spec.getMaxTimeout() - this.spec.getMinTimeout());
    }

    public float getCompletedTimeoutDuration() {
        return this.spec.getMinTimeout() + (float)Math.random() * (this.spec.getMaxTimeout() - this.spec.getMinTimeout());
    }

    public float getFailedTimeoutDuration() {
        return this.spec.getMinTimeout() + (float)Math.random() * (this.spec.getMaxTimeout() - this.spec.getMinTimeout());
    }

    public boolean isPriority() {
        return this.spec.hasTag("priority");
    }

    public boolean matchesRep(float rep) {
        RepLevel level = RepLevel.getLevelFor(rep);
        if (this.spec.getMinRep() != null && !level.isAtWorst(this.spec.getMinRep())) {
            return false;
        }
        return this.spec.getMaxRep() == null || level.isAtBest(this.spec.getMaxRep());
    }

    public Random getGenRandom() {
        return this.genRandom;
    }

    public boolean wasAutoAdded() {
        return this.wasAutoAdded;
    }

    public void setWasAutoAdded(boolean wasAutoAdded) {
        this.wasAutoAdded = wasAutoAdded;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

