/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMissionCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionHub;
import com.fs.starfarer.api.impl.campaign.rulecmd.CallEvent;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.loading.PersonMissionSpec;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMissionHub
implements MissionHub,
CallEvent.CallableEvent {
    public static float UPDATE_INTERVAL = Global.getSettings().getFloat("contactMissionUpdateIntervalDays");
    public static int MIN_TO_SHOW = Global.getSettings().getInt("contactMinMissions");
    public static int MAX_TO_SHOW = Global.getSettings().getInt("contactMaxMissions");
    public static int MAX_TO_SHOW_WITH_BONUS = Global.getSettings().getInt("contactMaxMissionsWithPriorityBonus");
    public static String CONTACT_SUSPENDED = "$mHub_contactSuspended";
    public static String NUM_BONUS_MISSIONS = "$mHub_numBonusMissions";
    public static String MISSION_QUALITY_BONUS = "$mHub_missionQualityBonus";
    public static String LAST_OPENED = "$mHub_lastOpenedTimestamp";
    public static String KEY = "$mHub";
    protected TimeoutTracker<String> timeout = new TimeoutTracker();
    protected TimeoutTracker<String> recentlyAcceptedTimeout = new TimeoutTracker();
    protected List<HubMissionCreator> creators = new ArrayList<HubMissionCreator>();
    protected transient List<HubMission> offered = new ArrayList<HubMission>();
    protected PersonAPI person;
    protected transient Random missionGenRandom = new Random();
    protected long seed = 0L;
    protected long lastUpdated = Long.MIN_VALUE;
    protected long lastUpdatedSeeds = 0L;
    protected float daysSinceLastUpdate = 0.0f;
    public static String MISSION_ANGLE_KEY = "$core_missionAngle";

    public static void set(PersonAPI person, MissionHub hub) {
        if (hub == null) {
            person.getMemoryWithoutUpdate().unset(KEY);
        } else {
            person.getMemoryWithoutUpdate().set(KEY, hub);
        }
    }

    public static MissionHub get(PersonAPI person) {
        if (person == null) {
            return null;
        }
        if (person.getMemoryWithoutUpdate().contains(KEY)) {
            return (MissionHub)person.getMemoryWithoutUpdate().get(KEY);
        }
        return null;
    }

    public static float getDaysSinceLastOpened(PersonAPI person) {
        if (!person.getMemoryWithoutUpdate().contains(LAST_OPENED)) {
            return -1.0f;
        }
        long ts = person.getMemoryWithoutUpdate().getLong(LAST_OPENED);
        return Global.getSector().getClock().getElapsedDaysSince(ts);
    }

    public static long getLastOpenedTimestamp(PersonAPI person) {
        if (!person.getMemoryWithoutUpdate().contains(LAST_OPENED)) {
            return Long.MIN_VALUE;
        }
        return person.getMemoryWithoutUpdate().getLong(LAST_OPENED);
    }

    public static void setDaysSinceLastOpened(PersonAPI person) {
        person.getMemoryWithoutUpdate().set(LAST_OPENED, Global.getSector().getClock().getTimestamp());
    }

    public BaseMissionHub(PersonAPI person) {
        this.person = person;
        this.readResolve();
    }

    public void updateMissionCreatorsFromSpecs() {
        List<PersonMissionSpec> specs = BaseMissionHub.getMissionsForPerson(this.person);
        HashSet<String> validMissions = new HashSet<String>();
        HashSet<String> alreadyHaveCreatorsFor = new HashSet<String>();
        for (PersonMissionSpec spec : specs) {
            validMissions.add(spec.getMissionId());
        }
        for (HubMissionCreator curr : this.creators) {
            if (!curr.wasAutoAdded()) continue;
            if (!validMissions.contains(curr.getSpecId())) {
                curr.setActive(false);
                continue;
            }
            curr.setActive(true);
            alreadyHaveCreatorsFor.add(curr.getSpecId());
        }
        for (PersonMissionSpec spec : specs) {
            if (alreadyHaveCreatorsFor.contains(spec.getMissionId())) continue;
            BaseHubMissionCreator curr = new BaseHubMissionCreator(spec);
            curr.setWasAutoAdded(true);
            curr.setActive(true);
            this.creators.add(curr);
        }
    }

    protected Object readResolve() {
        if (this.recentlyAcceptedTimeout == null) {
            this.recentlyAcceptedTimeout = new TimeoutTracker();
        }
        return this;
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        if (action.equals("setMHOptionText")) {
            this.person.getMemoryWithoutUpdate().set("$mh_openOptionText", this.getOpenOptionText(), 0.0f);
        } else if (action.equals("prepare")) {
            this.prepare(dialog, memoryMap);
        } else if (action.equals("listMissions")) {
            this.listMissions(dialog, memoryMap, true);
        } else if (action.equals("returnToList")) {
            this.listMissions(dialog, memoryMap, false);
        } else if (action.equals("doCleanup")) {
            this.doCleanup(dialog, memoryMap);
        } else if (action.equals("accept")) {
            String missionId = params.get(1).getString(memoryMap);
            this.accept(dialog, memoryMap, missionId);
        } else {
            throw new RuntimeException("Unhandled action [" + action + "] in " + this.getClass().getSimpleName() + " for rule [" + ruleId + "], params:[" + params + "]");
        }
        return true;
    }

    public void accept(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap, String missionId) {
        for (HubMission curr : this.getOfferedMissions()) {
            if (!curr.getMissionId().equals(missionId)) continue;
            curr.accept(dialog, memoryMap);
            this.getOfferedMissions().remove(curr);
            float dur = curr.getCreator().getAcceptedTimeoutDuration();
            this.timeout.add(curr.getCreator().getSpecId(), dur);
            this.recentlyAcceptedTimeout.add(curr.getCreator().getSpecId(), this.getUpdateInterval());
            break;
        }
    }

    public void prepare(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        BaseMissionHub.setDaysSinceLastOpened(this.getPerson());
        this.updateOfferedMissions(dialog, memoryMap);
        this.updateCountAndFirstInlineBlurb(dialog, memoryMap);
    }

    public void doCleanup(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        for (HubMission curr : this.getOfferedMissions()) {
            curr.abort();
        }
        this.offered = new ArrayList<HubMission>();
    }

    protected void updateCountAndFirstInlineBlurb(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        MemoryAPI pMem = dialog.getInteractionTarget().getActivePerson().getMemoryWithoutUpdate();
        int count = 0;
        String firstInlineBlurb = null;
        for (HubMission curr : this.getOfferedMissions()) {
            ++count;
            if (firstInlineBlurb != null) continue;
            firstInlineBlurb = curr.getBlurbText();
        }
        pMem.set("$mh_firstInlineBlurb", firstInlineBlurb, 0.0f);
        pMem.set("$mh_count", count, 0.0f);
    }

    public void listMissions(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap, boolean withBlurbs) {
        if (dialog != null && dialog.getVisualPanel() != null) {
            dialog.getVisualPanel().removeMapMarkerFromPersonInfo();
        }
        MemoryAPI pMem = dialog.getInteractionTarget().getActivePerson().getMemoryWithoutUpdate();
        this.updateCountAndFirstInlineBlurb(dialog, memoryMap);
        if (pMem.getFloat("$mh_count") <= 0.0f) {
            FireAll.fire(null, dialog, memoryMap, "PopulateOptions");
            return;
        }
        dialog.getOptionPanel().clearOptions();
        String blurb = "\"";
        boolean hasCommonBlurb = false;
        int count = 0;
        int skipped = 0;
        for (HubMission curr : this.getOfferedMissions()) {
            if (curr.getBlurbText() != null) {
                blurb = String.valueOf(blurb) + curr.getBlurbText() + " ";
                FireBest.fire(null, dialog, memoryMap, String.valueOf(curr.getTriggerPrefix()) + "_option true");
                hasCommonBlurb = true;
            } else {
                ++skipped;
            }
            ++count;
        }
        count -= skipped;
        for (HubMission curr : this.getOfferedMissions()) {
            ++count;
            if (curr.getBlurbText() != null) continue;
            if (withBlurbs && !FireBest.fire(null, dialog, memoryMap, String.valueOf(curr.getTriggerPrefix()) + "_blurb true")) {
                dialog.getTextPanel().addPara("No blurb found for " + curr.getTriggerPrefix(), Misc.getNegativeHighlightColor());
            }
            if (FireBest.fire(null, dialog, memoryMap, String.valueOf(curr.getTriggerPrefix()) + "_option true")) continue;
            dialog.getTextPanel().addPara("No option found for " + curr.getTriggerPrefix(), Misc.getNegativeHighlightColor());
        }
        FireBest.fire(null, dialog, memoryMap, "AddMHCloseOption true");
        if (withBlurbs && hasCommonBlurb && !pMem.getBoolean("$mh_doNotPrintBlurbs")) {
            blurb = blurb.trim();
            blurb = String.valueOf(blurb) + "\"";
            dialog.getTextPanel().addPara(blurb);
        }
        if (withBlurbs) {
            FireBest.fire(null, dialog, memoryMap, "MHPostMissionListText");
        }
        if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(dialog);
        }
    }

    @Override
    public String getOpenOptionText() {
        return "\"\u4f60\u6709\u4ec0\u4e48\u5de5\u4f5c\u7ed9\u6211\u5417\uff1f\"";
    }

    protected float getUpdateInterval() {
        return UPDATE_INTERVAL;
    }

    public List<HubMission> getOfferedMissions() {
        return this.offered;
    }

    public void updateOfferedMissions(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        int num;
        this.updateMissionCreatorsFromSpecs();
        float daysElapsed = Global.getSector().getClock().getElapsedDaysSince(this.lastUpdated);
        if (this.lastUpdated <= Long.MIN_VALUE) {
            daysElapsed = this.getUpdateInterval();
        }
        this.daysSinceLastUpdate += daysElapsed;
        this.lastUpdated = Global.getSector().getClock().getTimestamp();
        this.timeout.advance(daysElapsed);
        if (this.daysSinceLastUpdate > this.getUpdateInterval() || this.seed == 0L) {
            this.daysSinceLastUpdate = 0.0f;
            this.seed = BarEventManager.getInstance().getSeed(null, this.person, "" + this.lastUpdatedSeeds);
            this.recentlyAcceptedTimeout.clear();
            for (HubMissionCreator creator : this.creators) {
                creator.setSeed(BarEventManager.getInstance().getSeed(null, this.person, String.valueOf(creator.getSpecId()) + this.lastUpdatedSeeds));
            }
            this.lastUpdatedSeeds = Global.getSector().getClock().getTimestamp();
        }
        this.missionGenRandom = new Random(this.seed);
        WeightedRandomPicker<HubMissionCreator> picker = new WeightedRandomPicker<HubMissionCreator>(this.missionGenRandom);
        WeightedRandomPicker<HubMissionCreator> priority = new WeightedRandomPicker<HubMissionCreator>(this.missionGenRandom);
        float rel = this.person.getRelToPlayer().getRel();
        LinkedHashSet<String> completed = new LinkedHashSet<String>();
        for (HubMissionCreator creator : this.creators) {
            if (creator.getNumCompleted() <= 0) continue;
            completed.add(creator.getSpecId());
        }
        for (HubMissionCreator creator : this.creators) {
            if (this.timeout.contains(creator.getSpecId()) && !this.recentlyAcceptedTimeout.contains(creator.getSpecId()) || !creator.isActive() || creator.getSpec().hasTag("non_repeatable") && creator.getNumCompleted() > 0 || !DebugFlags.ALLOW_ALL_CONTACT_MISSIONS && !creator.getSpec().completedMissionsMatch(completed) || !DebugFlags.ALLOW_ALL_CONTACT_MISSIONS && (!creator.matchesRep(rel) || !DebugFlags.ALLOW_ALL_CONTACT_MISSIONS && this.person.getImportance().ordinal() < creator.getSpec().getImportance().ordinal())) continue;
            float w = creator.getFrequencyWeight();
            if (creator.isPriority()) {
                priority.add(creator, w);
                continue;
            }
            picker.add(creator, w);
        }
        int bonusMissions = 0;
        if (this.person.getMemoryWithoutUpdate().contains(NUM_BONUS_MISSIONS)) {
            float bonus = this.person.getMemoryWithoutUpdate().getFloat(NUM_BONUS_MISSIONS);
            float rem = bonus - (float)((int)bonus);
            bonusMissions = (int)bonus;
            if (this.missionGenRandom.nextFloat() < rem) {
                ++bonusMissions;
            }
        }
        if ((num = MIN_TO_SHOW + this.missionGenRandom.nextInt(MAX_TO_SHOW - MIN_TO_SHOW + 1) + bonusMissions) > MAX_TO_SHOW_WITH_BONUS) {
            num = MAX_TO_SHOW_WITH_BONUS;
        }
        if (num < 1 && MIN_TO_SHOW > 0) {
            num = 1;
        }
        if (DebugFlags.BAR_DEBUG) {
            num = 8;
        }
        if (this.person.getMemoryWithoutUpdate().getBoolean(CONTACT_SUSPENDED)) {
            num = 0;
        }
        this.offered = new ArrayList<HubMission>();
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        ip.resetExcludeFromGetPerson();
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(ContactIntel.class)) {
            ip.excludeFromGetPerson(((ContactIntel)intel).getPerson());
        }
        while (!(picker.isEmpty() && priority.isEmpty() || this.offered.size() >= num)) {
            HubMissionCreator creator = (HubMissionCreator)priority.pickAndRemove();
            if (creator == null) {
                creator = (HubMissionCreator)picker.pickAndRemove();
            }
            if (this.recentlyAcceptedTimeout.contains(creator.getSpecId())) {
                --num;
                continue;
            }
            creator.updateRandom();
            HubMission mission = creator.createHubMission(this);
            if (mission != null) {
                mission.setHub(this);
                mission.setCreator(creator);
                mission.setGenRandom(creator.getGenRandom());
                mission.createAndAbortIfFailed(this.getPerson().getMarket(), false);
            }
            if (mission == null || mission.isMissionCreationAborted()) continue;
            this.offered.add(mission);
            mission.updateInteractionData(dialog, memoryMap);
            float dur = creator.getWasShownTimeoutDuration();
            this.timeout.add(creator.getSpecId(), dur);
        }
        ip.resetExcludeFromGetPerson();
    }

    @Override
    public PersonAPI getPerson() {
        return this.person;
    }

    @Override
    public void setPerson(PersonAPI person) {
        this.person = person;
    }

    public static List<PersonMissionSpec> getMissionsForPerson(PersonAPI person) {
        ArrayList<PersonMissionSpec> result = new ArrayList<PersonMissionSpec>();
        HashSet<String> personTags = new HashSet<String>(person.getTags());
        personTags.add(person.getFaction().getId());
        for (PersonMissionSpec spec : Global.getSettings().getAllMissionSpecs()) {
            if (spec.getPersonId() != null && !spec.getPersonId().equals(person.getId()) || !spec.tagsMatch(personTags) || spec.getPersonId() == null && spec.getTagsAll().isEmpty() && spec.getTagsAny().isEmpty() && spec.getTagsNotAny().isEmpty()) continue;
            result.add(spec);
        }
        return result;
    }

    public static float getMissionAngle(PersonAPI person, MarketAPI market) {
        float angle;
        MemoryAPI mem;
        if (market != null) {
            mem = market.getMemoryWithoutUpdate();
        } else if (person != null) {
            mem = person.getMemoryWithoutUpdate();
        } else {
            Random random = Misc.getRandom(BarEventManager.getInstance().getSeed(null, null, null), 11);
            return random.nextFloat() * 360.0f;
        }
        if (mem.contains(MISSION_ANGLE_KEY)) {
            angle = mem.getFloat(MISSION_ANGLE_KEY);
        } else {
            HubMissionWithSearch.StarSystemUnexploredReq unexplored = new HubMissionWithSearch.StarSystemUnexploredReq();
            Vector2f loc = Global.getSector().getPlayerFleet().getLocationInHyperspace();
            SectorEntityToken entity = null;
            if (market != null) {
                entity = market.getPrimaryEntity();
            }
            if (entity == null && person != null && person.getMarket() != null) {
                entity = person.getMarket().getPrimaryEntity();
            }
            Random random = Misc.getRandom(BarEventManager.getInstance().getSeed(entity, person, null), 11);
            WeightedRandomPicker<Float> picker = new WeightedRandomPicker<Float>(random);
            for (StarSystemAPI system : Global.getSector().getStarSystems()) {
                float dir = Misc.getAngleInDegrees(loc, system.getLocation());
                if (unexplored.systemMatchesRequirement(system)) {
                    picker.add(Float.valueOf(dir), 1.0f);
                    continue;
                }
                float days = system.getDaysSinceLastPlayerVisit();
                float weight = days / 1000.0f;
                if (weight < 0.01f) {
                    weight = 0.01f;
                }
                if (weight > 1.0f) {
                    weight = 1.0f;
                }
                picker.add(Float.valueOf(dir), weight * 0.01f);
            }
            angle = ((Float)picker.pick()).floatValue();
            mem.set(MISSION_ANGLE_KEY, Float.valueOf(angle), 0.0f);
        }
        return angle;
    }
}

