/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.loading.BarEventSpec;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HubMissionBarEventWrapper
extends BaseBarEvent {
    protected long seed;
    protected transient BarEventSpec spec = null;
    protected String specId = null;
    protected transient Random genRandom;
    protected transient HubMissionWithBarEvent mission;

    public HubMissionBarEventWrapper(String specId) {
        this.specId = specId;
        this.seed = Misc.genRandomSeed();
        this.readResolve();
    }

    protected Object readResolve() {
        this.spec = Global.getSettings().getBarEventSpec(this.specId);
        return this;
    }

    @Override
    public String getBarEventId() {
        return this.specId;
    }

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (this.shownAt != null && this.shownAt != market) {
            return false;
        }
        this.abortMission();
        this.genRandom = new Random(this.seed + (long)market.getId().hashCode() * 181783497276652981L);
        if (this.genRandom.nextFloat() > this.spec.getProb()) {
            return false;
        }
        this.mission = this.spec.createMission();
        this.mission.setMissionId(this.specId);
        this.mission.setGenRandom(this.genRandom);
        return this.mission.shouldShowAtMarket(market);
    }

    public String getSpecId() {
        return this.specId;
    }

    public HubMission getMission() {
        return this.mission;
    }

    public void abortMission() {
        if (this.mission != null) {
            this.mission.abort();
            this.mission = null;
        }
    }

    @Override
    public void addPromptAndOption(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        MarketAPI market = dialog.getInteractionTarget().getMarket();
        this.mission.createAndAbortIfFailed(market, true);
        if (this.mission.isMissionCreationAborted()) {
            this.mission = null;
            return;
        }
        MemoryAPI prev = memoryMap.get("local");
        if (this.mission.getPerson() != null) {
            memoryMap.put("entity", prev);
            memoryMap.put("local", this.mission.getPerson().getMemoryWithoutUpdate());
            memoryMap.put("personFaction", this.mission.getPerson().getFaction().getMemory());
        }
        this.mission.updateInteractionData(dialog, memoryMap);
        FireBest.fire(null, dialog, memoryMap, String.valueOf(this.mission.getTriggerPrefix()) + "_blurbBar true");
        FireBest.fire(null, dialog, memoryMap, String.valueOf(this.mission.getTriggerPrefix()) + "_optionBar true");
        memoryMap.put("local", prev);
        memoryMap.remove("entity");
        memoryMap.remove("personFaction");
    }
}

