/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMission;
import com.fs.starfarer.api.util.Misc;

public class MissionFleetAutoDespawn
implements EveryFrameScript {
    protected CampaignFleetAPI fleet;
    protected float elapsedWaitingForDespawn = 0.0f;
    protected float elapsed = 0.0f;
    protected HubMission mission;
    protected int framesWithNoAssignment = 0;

    public MissionFleetAutoDespawn(HubMission mission, CampaignFleetAPI fleet) {
        this.mission = mission;
        this.fleet = fleet;
    }

    public void advance(float amount) {
        this.elapsed += amount;
        boolean missionImportant = this.fleet.getMemoryWithoutUpdate().getBoolean("$missionImportant");
        FleetAssignmentDataAPI ad = this.fleet.getCurrentAssignment();
        if (ad != null && (ad.getAssignment() == FleetAssignment.INTERCEPT || ad.getAssignment() == FleetAssignment.FOLLOW) && ad.getTarget() == Global.getSector().getPlayerFleet() && !missionImportant && this.elapsed > 10.0f) {
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            if (!this.fleet.isInCurrentLocation()) {
                float dist = Misc.getDistanceLY(this.fleet, Global.getSector().getPlayerFleet());
                if (dist > 4.0f) {
                    this.fleet.removeFirstAssignment();
                    if (this.fleet.getCurrentAssignment() == null) {
                        Misc.giveStandardReturnToSourceAssignments(this.fleet);
                    }
                }
            } else if (this.fleet.isHostileTo(pf) && this.fleet.getFaction() != null && !this.fleet.getFaction().isHostileTo("player") && !(this.mission instanceof DelayedFleetEncounter)) {
                this.fleet.removeFirstAssignment();
                if (this.fleet.getCurrentAssignment() == null) {
                    Misc.giveStandardReturnToSourceAssignments(this.fleet);
                }
            }
        }
        if (this.isMissionEnded()) {
            if (this.fleet.getCurrentAssignment() == null) {
                Misc.giveStandardReturnToSourceAssignments(this.fleet);
            }
            if (!this.fleet.isInCurrentLocation() && Misc.getDistanceToPlayerLY(this.fleet) > 3.0f) {
                this.elapsedWaitingForDespawn += Global.getSector().getClock().convertToDays(amount);
                if (this.elapsedWaitingForDespawn > 30.0f && this.fleet.getBattle() == null) {
                    this.fleet.despawn(CampaignEventListener.FleetDespawnReason.PLAYER_FAR_AWAY, null);
                    this.elapsedWaitingForDespawn = 0.0f;
                }
            } else {
                this.elapsedWaitingForDespawn = 0.0f;
            }
        } else if (this.fleet.isInCurrentLocation() && this.fleet.getCurrentAssignment() == null) {
            ++this.framesWithNoAssignment;
            if (this.framesWithNoAssignment >= 10) {
                Misc.giveStandardReturnToSourceAssignments(this.fleet);
            }
        } else {
            this.framesWithNoAssignment = 0;
        }
    }

    public boolean isMissionEnded() {
        return this.mission instanceof IntelInfoPlugin && (((IntelInfoPlugin)((Object)this.mission)).isEnded() || ((IntelInfoPlugin)((Object)this.mission)).isEnding());
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

