/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class TriggerFleetAssignmentAI
implements EveryFrameScript {
    protected CampaignFleetAPI fleet;
    protected LocationAPI system;
    protected List<SectorEntityToken> patrolPoints = new ArrayList<SectorEntityToken>();
    protected float elapsedWaitingForDespawn = 0.0f;
    protected HubMission mission;
    protected String patrolText;
    protected String travelText;
    protected SectorEntityToken currTarget;

    public TriggerFleetAssignmentAI(String travelText, String patrolText, HubMission mission, LocationAPI system, boolean randomLocation, CampaignFleetAPI fleet, SectorEntityToken ... patrolPoints) {
        this.travelText = travelText;
        this.patrolText = patrolText;
        this.mission = mission;
        this.fleet = fleet;
        this.system = system;
        if (patrolPoints != null) {
            SectorEntityToken[] sectorEntityTokenArray = patrolPoints;
            int n = patrolPoints.length;
            int n2 = 0;
            while (n2 < n) {
                SectorEntityToken curr = sectorEntityTokenArray[n2];
                if (curr != null && curr != fleet) {
                    this.patrolPoints.add(curr);
                }
                ++n2;
            }
        }
        if (!fleet.hasScriptOfClass(MissionFleetAutoDespawn.class)) {
            fleet.addScript(new MissionFleetAutoDespawn(mission, fleet));
        }
        this.giveInitialAssignments(randomLocation);
    }

    protected void giveInitialAssignments(boolean randomLocation) {
        if (randomLocation) {
            SectorEntityToken target = this.pickPatrolPoint();
            if (target != null) {
                Vector2f loc = Misc.getPointAtRadius(target.getLocation(), target.getRadius() + 100.0f);
                this.fleet.setLocation(loc.x, loc.y);
            } else {
                Vector2f loc = Misc.getPointAtRadius(new Vector2f(), 5000.0f);
                this.fleet.setLocation(loc.x, loc.y);
            }
        }
        this.pickNext();
    }

    protected SectorEntityToken pickPatrolPoint() {
        if (this.patrolPoints != null) {
            Random random = null;
            if (this.mission instanceof BaseHubMission) {
                random = ((BaseHubMission)this.mission).getGenRandom();
            }
            WeightedRandomPicker<SectorEntityToken> picker = new WeightedRandomPicker<SectorEntityToken>(random);
            for (SectorEntityToken curr : this.patrolPoints) {
                if (!curr.isAlive()) continue;
                picker.addAll(this.patrolPoints);
            }
            return (SectorEntityToken)picker.pick();
        }
        return null;
    }

    protected void pickNext() {
        this.currTarget = this.pickPatrolPoint();
        if (this.currTarget != null) {
            float speed = Misc.getSpeedForBurnLevel(8.0f);
            float dist = Misc.getDistance(this.fleet.getLocation(), this.currTarget.getLocation());
            float seconds = dist / speed;
            float days = seconds / Global.getSector().getClock().getSecondsPerDay();
            this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, this.currTarget, days += 5.0f + 5.0f * (float)Math.random(), this.patrolText == null ? "\u6b63\u5728\u5de1\u903b" : this.patrolText);
            return;
        }
        if (this.system instanceof StarSystemAPI) {
            float days = 5.0f + 5.0f * (float)Math.random();
            this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, ((StarSystemAPI)this.system).getCenter(), days, this.patrolText == null ? "\u6b63\u5728\u5de1\u903b" : this.patrolText);
        }
    }

    public void advance(float amount) {
        if (this.fleet.getCurrentAssignment() == null) {
            this.pickNext();
        } else {
            String travel = this.travelText;
            if (travel == null) {
                travel = Misc.isPatrol(this.fleet) ? "\u6b63\u5728\u5de1\u903b" : "\u884c\u52a8\u4e2d";
            }
            if (this.fleet.getAI() != null && travel != null && this.currTarget != null && this.fleet.getCurrentAssignment().getTarget() == this.currTarget && this.fleet.getCurrentAssignment().getAssignment() == FleetAssignment.PATROL_SYSTEM) {
                float dist = Misc.getDistance(this.fleet, this.currTarget);
                if (dist > 1500.0f || this.fleet.getContainingLocation() != this.currTarget.getContainingLocation()) {
                    boolean standingDown;
                    boolean bl = standingDown = this.fleet.getAI() instanceof ModularFleetAIAPI && ((ModularFleetAIAPI)this.fleet.getAI()).getTacticalModule() != null && ((ModularFleetAIAPI)this.fleet.getAI()).getTacticalModule().isStandingDown();
                    if (standingDown) {
                        this.fleet.getAI().setActionTextOverride(null);
                    } else {
                        this.fleet.getAI().setActionTextOverride(travel);
                    }
                } else {
                    this.fleet.getAI().setActionTextOverride(null);
                }
            } else if (this.fleet.getAI() != null) {
                this.fleet.getAI().setActionTextOverride(null);
            }
        }
    }

    public boolean isMissionEnded() {
        return this.mission instanceof IntelInfoPlugin && ((IntelInfoPlugin)((Object)this.mission)).isEnded();
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

