/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.plog;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyInteractionListener;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.campaign.listeners.PlayerColonizationListener;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.plog.OfficerSkillGainRecord;
import com.fs.starfarer.api.impl.campaign.plog.PLEntry;
import com.fs.starfarer.api.impl.campaign.plog.PLSnapshot;
import com.fs.starfarer.api.impl.campaign.plog.PLStat;
import com.fs.starfarer.api.impl.campaign.plog.PLStatCargo;
import com.fs.starfarer.api.impl.campaign.plog.PLStatColonies;
import com.fs.starfarer.api.impl.campaign.plog.PLStatCredits;
import com.fs.starfarer.api.impl.campaign.plog.PLStatCrew;
import com.fs.starfarer.api.impl.campaign.plog.PLStatFleet;
import com.fs.starfarer.api.impl.campaign.plog.PLStatFuel;
import com.fs.starfarer.api.impl.campaign.plog.PLStatLevel;
import com.fs.starfarer.api.impl.campaign.plog.PLStatMarines;
import com.fs.starfarer.api.impl.campaign.plog.PLStatSupplies;
import com.fs.starfarer.api.impl.campaign.plog.PLTextEntry;
import com.fs.starfarer.api.impl.campaign.plog.SModRecord;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.plugins.SurveyPlugin;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaythroughLog
implements EconomyTickListener,
ColonyInteractionListener,
PlayerColonizationListener,
ColonyPlayerHostileActListener {
    public static final String KEY = "$core_playthroughLog";
    protected List<PLEntry> entries = new ArrayList<PLEntry>();
    protected Map<String, PLStat> stats = new LinkedHashMap<String, PLStat>();
    protected PLIntelUIData uiData = new PLIntelUIData();
    protected transient List<PLSnapshot> data = new ArrayList<PLSnapshot>();
    protected String saved = "";
    protected List<SModRecord> smodsInstalled = new ArrayList<SModRecord>();
    protected List<OfficerSkillGainRecord> officerSkillsLearned = new ArrayList<OfficerSkillGainRecord>();
    protected ShipAPI.HullSize biggestBought = ShipAPI.HullSize.FIGHTER;

    public static PlaythroughLog getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        if (test == null) {
            test = new PlaythroughLog();
            Global.getSector().getMemoryWithoutUpdate().set(KEY, test);
            Global.getSector().getListenerManager().addListener(test);
        }
        return (PlaythroughLog)test;
    }

    public PlaythroughLog() {
        this.initStats();
    }

    @Override
    public void reportPlayerClosedMarket(MarketAPI market) {
        this.reportEconomyTick(-1);
    }

    @Override
    public void reportPlayerOpenedMarket(MarketAPI market) {
        this.reportEconomyTick(-1);
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
        if (Global.getSector().isInNewGameAdvance() || Global.getSector().getPlayerFleet() == null) {
            return;
        }
        for (String key : this.stats.keySet()) {
            PLStat stat = this.stats.get(key);
            stat.accrueValue();
        }
    }

    @Override
    public void reportEconomyMonthEnd() {
        if (Global.getSector().isInNewGameAdvance() || Global.getSector().getPlayerFleet() == null) {
            return;
        }
        this.takeSnapshot(false);
    }

    @Override
    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
        if (this.biggestBought == null) {
            this.biggestBought = ShipAPI.HullSize.FIGHTER;
        }
        for (PlayerMarketTransaction.ShipSaleInfo info : transaction.getShipsBought()) {
            ShipAPI.HullSize size = info.getMember().getHullSpec().getHullSize();
            if (size.ordinal() <= this.biggestBought.ordinal()) continue;
            this.biggestBought = size;
            this.addEntry("\u8d2d\u4e70\u4e86 " + info.getMember().getVariant().getHullSpec().getNameWithDesignationWithDashClass());
        }
    }

    @Override
    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        this.addEntry("\u9971\u548c\u8f70\u70b8\u4e86 " + market.getName() + " (" + "\u89c4\u6a21\u4e3a " + (market.getSize() + 1) + " " + market.getFaction().getEntityNamePrefix() + " \u6b96\u6c11\u5730) ");
    }

    @Override
    public void reportPlayerAbandonedColony(MarketAPI colony) {
        String extra = "";
        if (colony.getPlanetEntity() != null) {
            SurveyPlugin plugin = (SurveyPlugin)Global.getSettings().getNewPluginInstance("surveyPlugin");
            String cid = plugin.getSurveyDataType(colony.getPlanetEntity());
            CommoditySpecAPI pClass = Global.getSettings().getCommoditySpec(cid);
            extra = " (" + pClass.getName() + " " + colony.getPlanetEntity().getTypeNameWithLowerCaseWorld() + ")";
        }
        this.addEntry("\u9057\u5f03\u4e86\u89c4\u6a21\u4e3a " + colony.getSize() + " \u7684\u6b96\u6c11\u5730 " + colony.getOnOrAt() + " " + colony.getName() + extra);
    }

    @Override
    public void reportPlayerColonizedPlanet(PlanetAPI planet) {
        SurveyPlugin plugin = (SurveyPlugin)Global.getSettings().getNewPluginInstance("surveyPlugin");
        String cid = plugin.getSurveyDataType(planet);
        CommoditySpecAPI pClass = Global.getSettings().getCommoditySpec(cid);
        this.addEntry("\u5728\u4ee5\u4e0b\u5730\u70b9\u5efa\u7acb\u4e86\u6b96\u6c11\u5730\uff1a" + planet.getName() + " (" + pClass.getName().replaceAll(" \u8c03\u67e5\u6570\u636e", "") + " " + planet.getTypeNameWithLowerCaseWorld() + ")");
    }

    public void takeSnapshot(boolean debug) {
        PLSnapshot snapshot = new PLSnapshot();
        for (String key : this.stats.keySet()) {
            PLStat stat = this.stats.get(key);
            long value = stat.getValueForAllAccrued();
            if (debug) {
                value += (long)((int)((float)Math.random() * 500.0f));
                if ((value -= (long)((int)((float)Math.random() * 500.0f))) < 0L) {
                    value = 0L;
                }
            }
            snapshot.getData().put(key, value);
        }
        this.data.add(snapshot);
    }

    public List<SModRecord> getSModsInstalled() {
        return this.smodsInstalled;
    }

    public void addSModsInstalled(SModRecord record) {
        this.smodsInstalled.add(record);
    }

    public List<OfficerSkillGainRecord> getOfficerSkillsLearned() {
        return this.officerSkillsLearned;
    }

    public void addOfficerSkillRecord(OfficerSkillGainRecord record) {
        this.officerSkillsLearned.add(record);
    }

    public void removeOfficerSkillRecord(String personId, String skillId, boolean elite) {
        Iterator<OfficerSkillGainRecord> iter = this.officerSkillsLearned.iterator();
        while (iter.hasNext()) {
            OfficerSkillGainRecord record = iter.next();
            if (!record.personId.equals(personId) || !record.skillId.equals(skillId) || record.elite != elite) continue;
            iter.remove();
        }
    }

    protected Object readResolve() throws DataFormatException, UnsupportedEncodingException {
        String[] parts;
        if (this.stats == null) {
            this.stats = new LinkedHashMap<String, PLStat>();
            this.initStats();
        }
        if (this.data == null) {
            this.data = new ArrayList<PLSnapshot>();
        }
        if (this.smodsInstalled == null) {
            this.smodsInstalled = new ArrayList<SModRecord>();
        }
        if (this.officerSkillsLearned == null) {
            this.officerSkillsLearned = new ArrayList<OfficerSkillGainRecord>();
        }
        byte[] input = BaseTiledTerrain.toByteArray(this.saved);
        Inflater decompressor = new Inflater();
        decompressor.setInput(input);
        StringBuilder result = new StringBuilder();
        byte[] temp = new byte[100];
        while (!decompressor.finished()) {
            int read = decompressor.inflate(temp);
            result.append(new String(temp, 0, read, "UTF-8"));
        }
        decompressor.end();
        this.saved = result.toString();
        this.data.clear();
        if (this.saved == null) {
            this.saved = "";
        }
        String[] stringArray = parts = this.saved.split("\n");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (!p.isEmpty()) {
                PLSnapshot next = new PLSnapshot(p);
                this.data.add(next);
            }
            ++n2;
        }
        return this;
    }

    protected Object writeReplace() throws UnsupportedEncodingException {
        this.saved = "";
        for (PLSnapshot s : this.data) {
            this.saved = String.valueOf(this.saved) + s.getString() + "\n";
        }
        if (!this.saved.isEmpty()) {
            this.saved = this.saved.substring(0, this.saved.length() - 1);
        }
        Deflater compressor = new Deflater();
        compressor.setInput(this.saved.getBytes("UTF-8"));
        compressor.finish();
        StringBuilder result = new StringBuilder();
        byte[] temp = new byte[100];
        while (!compressor.finished()) {
            int read = compressor.deflate(temp);
            result.append(BaseTiledTerrain.toHexString(Arrays.copyOf(temp, read)));
        }
        compressor.end();
        this.saved = result.toString();
        return this;
    }

    protected void initStats() {
        this.addStat(new PLStatLevel());
        this.addStat(new PLStatFleet());
        this.addStat(new PLStatCredits());
        this.addStat(new PLStatSupplies());
        this.addStat(new PLStatFuel());
        this.addStat(new PLStatCargo());
        this.addStat(new PLStatCrew());
        this.addStat(new PLStatMarines());
        this.addStat(new PLStatColonies());
    }

    public CampaignClockAPI getDateForIndex(int index) {
        if (index < 0 || index >= this.data.size()) {
            return Global.getSector().getClock();
        }
        PLSnapshot s = this.data.get(index);
        CampaignClockAPI clock = Global.getSector().getClock().createClock(s.getTimestamp());
        return clock;
    }

    public void addStat(PLStat stat) {
        this.stats.put(stat.getId(), stat);
    }

    public Map<String, PLStat> getStats() {
        return this.stats;
    }

    public long getPrevValue(String key) {
        if (this.data.isEmpty()) {
            return 0L;
        }
        Long val = this.data.get(this.data.size() - 1).getData().get(key);
        if (val == null) {
            return 0L;
        }
        return val;
    }

    public List<PLSnapshot> getData() {
        return this.data;
    }

    public List<PLEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(PLEntry entry) {
        this.entries.add(entry);
    }

    public void addEntry(String text) {
        this.entries.add(new PLTextEntry(text));
    }

    public void addEntry(String text, boolean story) {
        this.entries.add(new PLTextEntry(text, story));
    }

    public PLIntelUIData getUIData() {
        if (this.uiData == null) {
            this.uiData = new PLIntelUIData();
        }
        return this.uiData;
    }

    @Override
    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
    }

    @Override
    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
    }

    @Override
    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    @Override
    public void reportPlayerOpenedMarketAndCargoUpdated(MarketAPI market) {
    }

    public static class PLIntelUIData {
        public LinkedHashSet<String> selectedGraphs = new LinkedHashSet();
    }
}

