/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.RingBandAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.RingSystemTerrainPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;

public class AccretionDiskGenPlugin
implements TerrainGenPlugin {
    protected TexAndIndex getTexAndIndex(TerrainGenDataSpec data) {
        TexAndIndex result = new TexAndIndex();
        WeightedRandomPicker<Integer> indexPicker = new WeightedRandomPicker<Integer>(StarSystemGenerator.random);
        WeightedRandomPicker<String> ringSet = new WeightedRandomPicker<String>(StarSystemGenerator.random);
        ringSet.add("ring_ice", 10.0f);
        ringSet.add("ring_dust", 10.0f);
        String set = (String)ringSet.pick();
        if (set.equals("ring_ice")) {
            result.tex = "rings_ice0";
            indexPicker.add(0);
            indexPicker.add(1);
        } else if (set.equals("ring_dust")) {
            result.tex = "rings_dust0";
            indexPicker.add(0);
            indexPicker.add(1);
        }
        result.index = (Integer)indexPicker.pick();
        return result;
    }

    public StarSystemGenerator.GenResult generate(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        StarSystemAPI system = context.system;
        SectorEntityToken parent = context.center;
        if (context.parent != null) {
            parent = context.parent;
        }
        float orbitRadius = context.currentRadius * (2.0f + 1.0f * StarSystemGenerator.random.nextFloat());
        float bandWidth = 256.0f;
        int numBands = 8;
        float spiralFactor = 3.0f + StarSystemGenerator.random.nextFloat() * 2.0f;
        numBands += (int)spiralFactor;
        numBands = 12;
        float i = 0.0f;
        while (i < (float)numBands) {
            float radius = orbitRadius - i * bandWidth * 0.25f - i * bandWidth * 0.1f;
            TexAndIndex tex = this.getTexAndIndex(terrainData);
            float orbitDays = radius / (30.0f + 10.0f * StarSystemGenerator.random.nextFloat());
            Color color = StarSystemGenerator.getColor(terrainData.getMinColor(), terrainData.getMaxColor());
            RingBandAPI visual = system.addRingBand(parent, "misc", tex.tex, 256.0f, tex.index, color, bandWidth, radius + bandWidth / 2.0f, -orbitDays);
            spiralFactor = 2.0f + StarSystemGenerator.random.nextFloat() * 5.0f;
            visual.setSpiral(true);
            visual.setMinSpiralRadius(0.0f);
            visual.setSpiralFactor(spiralFactor);
            i += 1.0f;
        }
        ArrayList<SectorEntityToken> rings = new ArrayList<SectorEntityToken>();
        SectorEntityToken ring = system.addTerrain("ring", new BaseRingTerrain.RingParams(orbitRadius, orbitRadius / 2.0f, parent, null));
        ring.addTag("accretion_disk");
        if (((CampaignTerrainAPI)ring).getPlugin() instanceof RingSystemTerrainPlugin) {
            ((RingSystemTerrainPlugin)((CampaignTerrainAPI)ring).getPlugin()).setNameForTooltip("\u5438\u79ef\u76d8");
        }
        ring.setCircularOrbit(parent, 0.0f, 0.0f, -100.0f);
        rings.add(ring);
        StarSystemGenerator.GenResult result = new StarSystemGenerator.GenResult();
        result.onlyIncrementByWidth = false;
        result.orbitalWidth = orbitRadius;
        result.entities.addAll(rings);
        return result;
    }

    public boolean wantsToHandle(TerrainGenDataSpec terrainData, StarSystemGenerator.GenContext context) {
        return terrainData != null && terrainData.getId().equals("accretion_disk");
    }

    public static class TexAndIndex {
        public String tex;
        public int index;
    }
}

