/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.campaign.AbyssalLightEntityPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.eventide.DuelDialogDelegate;
import com.fs.starfarer.api.impl.campaign.eventide.DuelPanel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HTScanFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ht.HyperspaceTopographyEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HegemonyInspectionManager;
import com.fs.starfarer.api.impl.campaign.intel.misc.LuddicShrineIntel;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PunitiveExpeditionManager;
import com.fs.starfarer.api.impl.campaign.plog.PLEntry;
import com.fs.starfarer.api.impl.campaign.plog.PLIntel;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.impl.campaign.population.CoreImmigrationPluginImpl;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTestPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected PlanetAPI planet;
    protected PunitiveExpeditionManager.PunExData punExData = null;
    protected boolean sendInspection = false;
    protected static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    protected OptionId lastOptionMousedOver = null;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.planet = (PlanetAPI)dialog.getInteractionTarget();
        this.visual.setVisualFade(0.25f, 0.25f);
        this.visual.showLargePlanet(Global.getSector().getEntityById("mazalot"));
        dialog.setOptionOnEscape("Leave", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        if (optionData instanceof Integer) {
            DebugFlags.FAST_RAIDS = true;
            Integer str = (Integer)optionData;
            if (this.punExData != null) {
                PunitiveExpeditionManager.getInstance().createExpedition(this.punExData, str);
            } else if (this.sendInspection) {
                HegemonyInspectionManager.getInstance().createInspection(str);
            }
            this.optionSelected(null, (Object)OptionId.LEAVE);
            return;
        }
        if (optionData instanceof PunitiveExpeditionManager.PunExData) {
            this.punExData = (PunitiveExpeditionManager.PunExData)optionData;
            this.optionSelected(null, (Object)OptionId.PICK_STRENGTH);
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.createInitialOptions();
                PersonAPI player = Global.getSector().getPlayerPerson();
                MutableCharacterStatsAPI stats = player.getStats();
                break;
            }
            case TUTORIAL: {
                DuelPanel duelPanel = DuelPanel.createTutorial(true, "soe_ambience");
                this.dialog.showCustomVisualDialog(1024.0f, 700.0f, new DuelDialogDelegate(null, duelPanel, this.dialog, null, true));
                break;
            }
            case FIGHT: {
                DuelPanel duelPanel2 = DuelPanel.createDefault(true, true, "soe_ambience");
                this.dialog.showCustomVisualDialog(1024.0f, 700.0f, new DuelDialogDelegate("music_soe_fight", duelPanel2, this.dialog, null, true));
                break;
            }
            case PIRATE_RAID: {
                MarketAPI market = this.getNearestMarket(false);
                PirateBaseIntel base = this.findPirateBase();
                if (base == null || market == null || market.getStarSystem() == null) break;
                base.startRaid(market.getStarSystem(), 500.0f);
                base.makeKnown(this.textPanel);
                this.optionSelected(null, (Object)OptionId.LEAVE);
                break;
            }
            case INCREASE_COLONY_SIZE: {
                MarketAPI market = this.getNearestMarket(false);
                if (market == null) break;
                int was = market.getSize();
                CoreImmigrationPluginImpl plugin = new CoreImmigrationPluginImpl(market);
                plugin.increaseMarketSize();
                this.textPanel.addPara("Size of " + market.getName() + " increased from " + was + " to " + market.getSize());
                break;
            }
            case FINISH_CONSTRUCTION: {
                MarketAPI market = this.getNearestMarket(false);
                if (market == null) break;
                for (Industry curr : new ArrayList<Industry>(market.getIndustries())) {
                    if (!curr.isBuilding()) continue;
                    curr.finishBuildingOrUpgrading();
                    this.textPanel.addPara("Finished building or upgrading " + curr.getCurrentName());
                }
                break;
            }
            case PUNITIVE_EXPEDITION: {
                this.options.clearOptions();
                for (PunitiveExpeditionManager.PunExData data : PunitiveExpeditionManager.getInstance().getData().values()) {
                    if (PunitiveExpeditionManager.getInstance().getExpeditionReasons(data).isEmpty()) continue;
                    this.options.addOption("Punitive expedition: " + data.faction.getDisplayName(), data);
                }
                this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
                break;
            }
            case INSPECTION: {
                this.sendInspection = true;
                this.optionSelected(null, (Object)OptionId.PICK_STRENGTH);
                break;
            }
            case PICK_STRENGTH: {
                this.textPanel.addPara("Select strength");
                this.options.clearOptions();
                this.options.addOption("100", 100);
                this.options.addOption("200", 200);
                this.options.addOption("300", 300);
                this.options.addOption("400", 400);
                this.options.addOption("500", 500);
                this.options.addOption("600", 600);
                this.options.addOption("800", 800);
                this.options.addOption("1000", 1000);
                this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
                break;
            }
            case TOPOGRAPHY_POINTS: {
                HyperspaceTopographyEventIntel.addFactorCreateIfNecessary(new HTScanFactor("Dev mode point increase", 50), this.dialog);
                break;
            }
            case HAEI_POINTS: {
                if (HostileActivityEventIntel.get() == null) break;
                HostileActivityEventIntel intel = HostileActivityEventIntel.get();
                intel.setRandom(new Random());
                int p = intel.getProgress();
                p = p < 500 || p == 599 ? 500 : (p < 550 ? 550 : 599);
                intel.setProgress(p);
                this.textPanel.addPara("Progress set to " + p);
                break;
            }
            case PRINT_LOG: {
                Object loc;
                int i = 0;
                while (i < 10) {
                    loc = Misc.getPointWithinRadius(this.playerFleet.getLocation(), 10000.0f);
                    if (Misc.getAbyssalDepth((Vector2f)loc) >= 1.0f) {
                        AbyssalLightEntityPlugin.AbyssalLightParams params = new AbyssalLightEntityPlugin.AbyssalLightParams();
                        CustomCampaignEntityAPI e2 = Global.getSector().getHyperspace().addCustomEntity(Misc.genUID(), null, "abyssal_light", "neutral", params);
                        e2.setLocation(((Vector2f)loc).x, ((Vector2f)loc).y);
                    }
                    ++i;
                }
                this.checkFactionUseOfStuff();
                this.textPanel.addPara("Player log:");
                String log = "";
                for (PLEntry e : PlaythroughLog.getInstance().getEntries()) {
                    CampaignClockAPI clock = Global.getSector().getClock().createClock(e.getTimestamp());
                    log = String.valueOf(log) + clock.getShortDate() + " " + e.getText() + "\n";
                }
                this.textPanel.setFontVictor();
                this.textPanel.addPara(log);
                this.textPanel.setFontInsignia();
                loc = Global.getSector().getCurrentLocation();
                String tags = "";
                for (String tag : Global.getSector().getCurrentLocation().getTags()) {
                    tags = String.valueOf(tags) + "    " + tag + "\n";
                }
                this.textPanel.addPara("\nTags for " + loc.getName() + ":\n" + tags);
                if (!(loc instanceof StarSystemAPI)) break;
                this.textPanel.addPara("\nSystem type: " + (Object)((Object)((StarSystemAPI)loc).getType()));
                break;
            }
            case ADD_LOG_INTEL: {
                PLIntel intel = new PLIntel();
                Global.getSector().getIntelManager().addIntel(intel, false, this.textPanel);
                LuddicShrineIntel.addShrineIntelIfNeeded("beholder_station", this.textPanel);
                LuddicShrineIntel.addShrineIntelIfNeeded("chicomoztoc", this.textPanel);
                LuddicShrineIntel.addShrineIntelIfNeeded("gilead", this.textPanel);
                LuddicShrineIntel.addShrineIntelIfNeeded("jangala", this.textPanel);
                LuddicShrineIntel.addShrineIntelIfNeeded("killa", this.textPanel);
                LuddicShrineIntel.addShrineIntelIfNeeded("volturn", this.textPanel);
                break;
            }
            case LEAVE: {
                this.dialog.dismiss();
            }
        }
    }

    protected MarketAPI getNearestMarket(boolean playerOnly) {
        MarketAPI nearest = null;
        float minDist = Float.MAX_VALUE;
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            boolean nearer;
            if (curr.isHidden() || playerOnly && !curr.isPlayerOwned()) continue;
            float dist = Misc.getDistanceLY(pf, curr.getPrimaryEntity());
            boolean bl = nearer = dist < minDist;
            if (dist == minDist && dist == 0.0f && nearest != null) {
                float d2;
                float d1 = Misc.getDistance(pf, curr.getPrimaryEntity());
                boolean bl2 = nearer = d1 < (d2 = Misc.getDistance(pf, nearest.getPrimaryEntity()));
            }
            if (!nearer) continue;
            nearest = curr;
            minDist = dist;
        }
        return nearest;
    }

    protected void print(String str) {
        this.textPanel.appendToLastParagraph("\n" + str);
        System.out.println(str);
    }

    protected void createInitialOptions() {
        this.options.clearOptions();
        this.options.addOption("Fight!", (Object)OptionId.FIGHT);
        MarketAPI market = this.getNearestMarket(false);
        if (market != null) {
            this.options.addOption("Send pirate raid to " + market.getContainingLocation().getName(), (Object)OptionId.PIRATE_RAID, null);
        }
        this.options.addOption("Send a punitive expedition", (Object)OptionId.PUNITIVE_EXPEDITION);
        this.options.addOption("Send an AI inspection", (Object)OptionId.INSPECTION);
        this.options.addOption("Hyperspace Topography +50 points", (Object)OptionId.TOPOGRAPHY_POINTS);
        this.options.addOption("Hostile Activity: reseed RNG and cycle progress through 400/450/499", (Object)OptionId.HAEI_POINTS);
        this.options.addOption("Print player log", (Object)OptionId.PRINT_LOG);
        this.options.addOption("Add player log intel", (Object)OptionId.ADD_LOG_INTEL);
        if (market != null) {
            this.options.addOption("Increase size of " + market.getName() + " to " + (market.getSize() + 1), (Object)OptionId.INCREASE_COLONY_SIZE);
            this.options.addOption("Finish construction on " + market.getName(), (Object)OptionId.FINISH_CONSTRUCTION);
        }
        this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    public PirateBaseIntel findPirateBase() {
        for (IntelInfoPlugin p : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            PirateBaseIntel intel = (PirateBaseIntel)p;
            if (intel.isEnded() || intel.isEnding()) continue;
            return intel;
        }
        return null;
    }

    public void checkFactionUseOfStuff() {
        String id;
        List<FactionAPI> factions = Global.getSector().getAllFactions();
        System.out.println();
        System.out.println("----------------------- FIGHTERS -----------------------");
        System.out.println();
        LinkedHashMap<String, String> oneFactionFighters = new LinkedHashMap<String, String>();
        for (FighterWingSpecAPI fighterWingSpecAPI : Global.getSettings().getAllFighterWingSpecs()) {
            if (fighterWingSpecAPI.hasTag("restricted")) continue;
            int count = 0;
            id = fighterWingSpecAPI.getId();
            String fId = null;
            ArrayList<String> all = new ArrayList<String>();
            for (FactionAPI factionAPI : factions) {
                if (factionAPI.isPlayerFaction() || !factionAPI.getKnownFighters().contains(id)) continue;
                ++count;
                fId = factionAPI.getId();
                all.add(fId);
            }
            if (count == 0) {
                System.out.println("FIGHTER WING [" + id + "] IS NOT USED BY ANY FACTION");
            }
            if (count == 1) {
                oneFactionFighters.put(id, fId);
            }
            if (count == 0) continue;
            System.out.println("Fighter wing [" + id + "] is known by: [" + Misc.getAndJoined(all) + "]");
        }
        System.out.println();
        System.out.println("----------------------- WEAPONS -----------------------");
        System.out.println();
        for (WeaponSpecAPI weaponSpecAPI : Global.getSettings().getAllWeaponSpecs()) {
            if (weaponSpecAPI.hasTag("restricted") || weaponSpecAPI.hasTag("no_sell") || weaponSpecAPI.getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM)) continue;
            String id2 = weaponSpecAPI.getWeaponId();
            int count = 0;
            ArrayList<String> all = new ArrayList<String>();
            for (FactionAPI f : factions) {
                if (f.isPlayerFaction()) continue;
                Float p = f.getWeaponSellFrequency().get(id2);
                if (p != null && p.floatValue() > 1.0f) {
                    ++count;
                }
                if (!f.knowsWeapon(id2)) continue;
                all.add(f.getId());
            }
            if (count > 0) continue;
            System.out.println("Weapon [" + id2 + "] is not sold with higher frequency; known by: [" + Misc.getAndJoined(all) + "]");
        }
        System.out.println();
        System.out.println("----------------------- SHIPS -----------------------");
        System.out.println();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (ShipHullSpecAPI spec : Global.getSettings().getAllShipHullSpecs()) {
            if (spec.hasTag("restricted") || spec.hasTag("no_sell") || spec.getHullSize() == ShipAPI.HullSize.FIGHTER || (id = spec.getHullId()).endsWith("_default_D") || id.endsWith("_default_D") || id.startsWith("module_")) continue;
            int count = 0;
            String fId = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (FactionAPI f : factions) {
                if (f.isPlayerFaction() || !f.getKnownShips().contains(id)) continue;
                ++count;
                fId = f.getId();
                arrayList.add(fId);
            }
            if (count == 1) {
                linkedHashMap.put(id, fId);
            }
            if (count <= 0) continue;
            System.out.println("Ship [" + id + "] is known by: [" + Misc.getAndJoined(arrayList) + "]");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum OptionId {
        INIT,
        PIRATE_RAID,
        PUNITIVE_EXPEDITION,
        INSPECTION,
        PICK_STRENGTH,
        PRINT_LOG,
        TOPOGRAPHY_POINTS,
        HAEI_POINTS,
        ADD_LOG_INTEL,
        INCREASE_COLONY_SIZE,
        FINISH_CONSTRUCTION,
        FIGHT,
        TUTORIAL,
        LEAVE;

    }
}

