/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameGenData {
    public static final String TAG_PLANET = "planet";
    public static final String TAG_MOON = "moon";
    public static final String TAG_STAR = "star";
    public static final String TAG_ASTEROID_BELT = "asteroid_belt";
    public static final String TAG_ASTEROID_FIELD = "asteroid_field";
    public static final String TAG_MAGNETIC_FIELD = "magnetic_field";
    public static final String TAG_RING = "ring";
    public static final String TAG_ACCRETION = "accretion";
    public static final String TAG_NEBULA = "nebula";
    public static final String TAG_CONSTELLATION = "constellation";
    private String name;
    private String secondary;
    private float frequency;
    private boolean reusable;
    private Set<String> tags = new HashSet<String>();
    private Set<String> parents = new HashSet<String>();

    public NameGenData(String name, String secondary) {
        this.name = name;
        this.secondary = secondary;
        this.reusable = false;
        this.frequency = 1.0f;
    }

    public NameGenData(JSONObject row) throws JSONException {
        String parents;
        int n;
        String tags;
        this.name = row.getString("name");
        this.secondary = row.optString("secondary");
        if (this.name != null) {
            this.name = this.name.trim();
        }
        if (this.secondary != null) {
            this.secondary = this.secondary.trim();
        }
        this.frequency = (float)row.optDouble("frequency", 1.0);
        this.reusable = row.optBoolean("reusable", false);
        if (this.secondary != null && this.secondary.isEmpty()) {
            this.secondary = null;
        }
        if ((tags = row.optString("tags", null)) != null) {
            String[] split;
            String[] stringArray = split = tags.split(",");
            n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!(tag = tag.trim()).isEmpty()) {
                    this.addTag(tag);
                }
                ++n2;
            }
        }
        if ((parents = row.optString("parents", null)) != null) {
            String[] split;
            String[] stringArray = split = parents.split(",");
            int n3 = split.length;
            n = 0;
            while (n < n3) {
                String parent = stringArray[n];
                if (!(parent = parent.trim()).isEmpty()) {
                    this.addParent(parent);
                }
                ++n;
            }
        }
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public void setParents(Set<String> parents) {
        this.parents = parents;
    }

    public Set<String> getParents() {
        return this.parents;
    }

    public void addParent(String parent) {
        this.parents.add(parent);
    }

    public boolean hasParent(String parent) {
        return this.parents.contains(parent);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecondary() {
        return this.secondary;
    }

    public void setSecondary(String secondary) {
        this.secondary = secondary;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(float frequency) {
        this.frequency = frequency;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public void setReusable(boolean reusable) {
        this.reusable = reusable;
    }
}

