/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.Objectives;
import com.fs.starfarer.api.plugins.BuildObjectiveTypePicker;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public abstract class BaseAssignmentAI
implements EveryFrameScript {
    protected CampaignFleetAPI fleet;
    protected Boolean done = null;
    protected Boolean giveInitial = true;
    protected FleetActionDelegate delegate = null;
    protected IntervalUtil raidTracker;
    protected IntervalUtil capTracker;
    protected IntervalUtil buildTracker;
    public static String TEMP_ASSIGNMENT = "temp_PAV4";
    public static String TEMP_BUSY_REASON = "temp_PAV4";

    public BaseAssignmentAI() {
    }

    public BaseAssignmentAI(CampaignFleetAPI fleet) {
        this.fleet = fleet;
        this.giveInitialAssignments();
    }

    public FleetActionDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(FleetActionDelegate delegate) {
        this.delegate = delegate;
    }

    protected abstract void giveInitialAssignments();

    protected abstract void pickNext();

    public void advance(float amount) {
        if (this.fleet.getCurrentAssignment() == null) {
            this.pickNext();
        }
    }

    public boolean isDone() {
        return this.done != null;
    }

    public void setDone() {
        this.done = true;
    }

    public boolean runWhilePaused() {
        return false;
    }

    protected void checkRaid(float amount) {
        if (this.fleet.isInHyperspace()) {
            return;
        }
        if (this.raidTracker == null) {
            this.raidTracker = new IntervalUtil(0.3f, 0.7f);
        }
        this.raidTracker.advance(Misc.getDays(amount));
        if (!this.raidTracker.intervalElapsed()) {
            return;
        }
        this.checkColonyAction();
    }

    protected void checkCapture(float amount) {
        if (this.fleet.isInHyperspace()) {
            return;
        }
        if (this.capTracker == null) {
            this.capTracker = new IntervalUtil(0.3f, 0.7f);
        }
        this.capTracker.advance(Misc.getDays(amount));
        if (!this.capTracker.intervalElapsed()) {
            return;
        }
        this.checkObjectiveAction(false);
    }

    protected void checkBuild(float amount) {
        if (this.fleet.isInHyperspace()) {
            return;
        }
        if (this.buildTracker == null) {
            this.buildTracker = new IntervalUtil(0.3f, 0.7f);
        }
        this.buildTracker.advance(Misc.getDays(amount));
        if (!this.buildTracker.intervalElapsed()) {
            return;
        }
        this.checkObjectiveAction(true);
    }

    protected void checkObjectiveAction(boolean build) {
        float dist;
        if (!this.canTakeAction()) {
            return;
        }
        SectorEntityToken closest = null;
        float minDist = Float.MAX_VALUE;
        if (build) {
            for (SectorEntityToken objective : this.fleet.getContainingLocation().getEntitiesWithTag("stable_location")) {
                if (objective.hasTag("non_clickable") || objective.hasTag("fading_out_and_expiring") || objective.getMemoryWithoutUpdate().getBoolean("$recentlySalvaged") || !((dist = Misc.getDistance(this.fleet, objective)) < minDist)) continue;
                closest = objective;
                minDist = dist;
            }
        } else {
            for (SectorEntityToken objective : this.fleet.getContainingLocation().getEntitiesWithTag("objective")) {
                float dist2;
                if (objective.getFaction() == this.fleet.getFaction()) continue;
                if (!objective.getFaction().isHostileTo(this.fleet.getFaction()) && !Misc.isFleetMadeHostileToFaction(this.fleet, objective.getFaction())) {
                    boolean ownerHasColonyInSystem = false;
                    for (MarketAPI curr : Misc.getMarketsInLocation(objective.getContainingLocation())) {
                        if (curr.getFaction() != objective.getFaction() || curr.getFaction().isNeutralFaction()) continue;
                        ownerHasColonyInSystem = true;
                        break;
                    }
                    if (ownerHasColonyInSystem) continue;
                }
                if (!((dist2 = Misc.getDistance(this.fleet, objective)) < minDist)) continue;
                closest = objective;
                minDist = dist2;
            }
        }
        if (closest == null || minDist > 2000.0f) {
            return;
        }
        for (CampaignFleetAPI other : Misc.getNearbyFleets(closest, 2000.0f)) {
            if (other == this.fleet) continue;
            if (other.isHostileTo(this.fleet) && (float)other.getFleetPoints() > (float)this.fleet.getFleetPoints() * 0.25f) {
                return;
            }
            if (other.getFaction() != this.fleet.getFaction() || !((dist = Misc.getDistance(other, closest)) < minDist)) continue;
            return;
        }
        if (build) {
            BuildObjectiveTypePicker.BuildObjectiveParams params = new BuildObjectiveTypePicker.BuildObjectiveParams();
            params.faction = this.fleet.getFaction();
            params.fleet = this.fleet;
            params.stableLoc = closest;
            BuildObjectiveTypePicker pick = Global.getSector().getGenericPlugins().pickPlugin(BuildObjectiveTypePicker.class, params);
            String type = null;
            if (pick != null) {
                type = pick.pickObjectiveToBuild(params);
            }
            if (type != null) {
                this.giveBuildOrder(closest, type);
            }
        } else {
            this.giveCaptureOrder(closest);
        }
    }

    protected void giveCaptureOrder(final SectorEntityToken target) {
        float dist;
        this.clearTempAssignments(this.fleet);
        Misc.setFlagWithReason(this.fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", TEMP_BUSY_REASON, true, 1.5f + (float)Math.random());
        String name = ((CustomCampaignEntityAPI)target).getCustomEntitySpec().getNameInText();
        String capText = "\u6b63\u5728\u63a7\u5236 " + name;
        String moveText = "\u6b63\u5728\u524d\u5f80\u5e76\u63a7\u5236 " + name;
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(target.getLocation(), this.fleet.getLocation()));
        float holdRadius = this.fleet.getRadius() + target.getRadius() - 10.0f;
        loc.scale(holdRadius);
        Vector2f.add((Vector2f)loc, (Vector2f)target.getLocation(), (Vector2f)loc);
        SectorEntityToken holdLoc = target.getContainingLocation().createToken(loc);
        holdLoc.setCircularOrbit(target, Misc.getAngleInDegrees(target.getLocation(), this.fleet.getLocation()), holdRadius, 1000000.0f);
        this.fleet.getContainingLocation().addEntity(holdLoc);
        Misc.fadeAndExpire(holdLoc, 5.0f);
        this.fleet.addAssignmentAtStart(FleetAssignment.HOLD, holdLoc, 0.5f, capText, new Script(){

            public void run() {
                if (target.isAlive()) {
                    Objectives o = new Objectives(target);
                    o.control(BaseAssignmentAI.this.fleet.getFaction().getId());
                }
                BaseAssignmentAI.this.clearTempAssignments(BaseAssignmentAI.this.fleet);
            }
        });
        FleetAssignmentDataAPI curr = this.fleet.getCurrentAssignment();
        if (curr != null) {
            curr.setCustom(TEMP_ASSIGNMENT);
        }
        if ((dist = Misc.getDistance(target, this.fleet)) > this.fleet.getRadius() + target.getRadius() + 300.0f) {
            this.fleet.addAssignmentAtStart(FleetAssignment.DELIVER_CREW, target, 3.0f, moveText, null);
            curr = this.fleet.getCurrentAssignment();
            if (curr != null) {
                curr.setCustom(TEMP_ASSIGNMENT);
            }
        }
    }

    protected void giveBuildOrder(final SectorEntityToken target, String type) {
        float dist;
        this.clearTempAssignments(this.fleet);
        CustomEntitySpecAPI spec = Global.getSettings().getCustomEntitySpec(type);
        Misc.setFlagWithReason(this.fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", TEMP_BUSY_REASON, true, 1.5f + (float)Math.random());
        String name = spec.getNameInText();
        String capText = "constructing " + name;
        String moveText = "\u6b63\u5728\u524d\u5f80\u5e76\u5efa\u9020 " + name;
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(target.getLocation(), this.fleet.getLocation()));
        float holdRadius = this.fleet.getRadius() + target.getRadius();
        loc.scale(holdRadius);
        Vector2f.add((Vector2f)loc, (Vector2f)target.getLocation(), (Vector2f)loc);
        SectorEntityToken holdLoc = target.getContainingLocation().createToken(loc);
        holdLoc.setCircularOrbit(target, Misc.getAngleInDegrees(target.getLocation(), this.fleet.getLocation()), holdRadius, 1000000.0f);
        this.fleet.getContainingLocation().addEntity(holdLoc);
        Misc.fadeAndExpire(holdLoc, 5.0f);
        this.fleet.addAssignmentAtStart(FleetAssignment.HOLD, holdLoc, 0.5f, capText, new Script(){

            public void run() {
                if (target.isAlive()) {
                    BuildObjectiveTypePicker.BuildObjectiveParams params = new BuildObjectiveTypePicker.BuildObjectiveParams();
                    params.faction = BaseAssignmentAI.this.fleet.getFaction();
                    params.fleet = BaseAssignmentAI.this.fleet;
                    params.stableLoc = target;
                    BuildObjectiveTypePicker pick = Global.getSector().getGenericPlugins().pickPlugin(BuildObjectiveTypePicker.class, params);
                    String type = null;
                    if (pick != null) {
                        type = pick.pickObjectiveToBuild(params);
                    }
                    Objectives o = new Objectives(target);
                    o.build(type, BaseAssignmentAI.this.fleet.getFaction().getId());
                }
                BaseAssignmentAI.this.clearTempAssignments(BaseAssignmentAI.this.fleet);
            }
        });
        FleetAssignmentDataAPI curr = this.fleet.getCurrentAssignment();
        if (curr != null) {
            curr.setCustom(TEMP_ASSIGNMENT);
        }
        if ((dist = Misc.getDistance(target, this.fleet)) > this.fleet.getRadius() + target.getRadius() + 300.0f) {
            this.fleet.addAssignmentAtStart(FleetAssignment.DELIVER_CREW, target, 3.0f, moveText, null);
            curr = this.fleet.getCurrentAssignment();
            if (curr != null) {
                curr.setCustom(TEMP_ASSIGNMENT);
            }
        }
    }

    protected void clearTempAssignments(CampaignFleetAPI fleet) {
        Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", TEMP_BUSY_REASON, false, 0.0f);
        for (FleetAssignmentDataAPI curr : fleet.getAI().getAssignmentsCopy()) {
            if (!TEMP_ASSIGNMENT.equals(curr.getCustom())) continue;
            fleet.getAI().removeAssignment(curr);
        }
    }

    protected boolean canTakeAction() {
        ModularFleetAIAPI ai;
        if (!RouteManager.isPlayerInSpawnRange(this.fleet)) {
            return false;
        }
        if (this.fleet.getBattle() != null) {
            return false;
        }
        if (this.fleet.getMemoryWithoutUpdate().getBoolean("$core_fleetBusy")) {
            return false;
        }
        if (this.fleet.isCurrentAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN)) {
            return false;
        }
        MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
        if (Misc.flagHasReason(mem, "$core_fleetBusy", TEMP_BUSY_REASON)) {
            return false;
        }
        if (this.fleet.getAI() instanceof ModularFleetAIAPI && (ai = (ModularFleetAIAPI)this.fleet.getAI()).getAssignmentModule().areAssignmentsFrozen()) {
            return false;
        }
        CampaignFleetAPI pursueTarget = mem.getFleet("$ai_pursuitTarget");
        CampaignFleetAPI fleeingFrom = mem.getFleet("$ai_fleeingFrom");
        return pursueTarget == null && fleeingFrom == null;
    }

    protected void checkColonyAction() {
        if (!this.canTakeAction()) {
            return;
        }
        if (this.fleet.getMemoryWithoutUpdate().getBoolean("$recentlyPerformedRaid")) {
            return;
        }
        MarketAPI closest = null;
        float minDist = Float.MAX_VALUE;
        for (MarketAPI market : Misc.getMarketsInLocation(this.fleet.getContainingLocation())) {
            if (this.delegate == null ? !market.getFaction().isHostileTo(this.fleet.getFaction()) && !Misc.isFleetMadeHostileToFaction(this.fleet, market.getFaction()) : !this.delegate.canRaid(this.fleet, market)) continue;
            float dist = Misc.getDistance(this.fleet, market.getPrimaryEntity());
            if (!(dist < minDist)) continue;
            closest = market;
            minDist = dist;
        }
        if (closest == null || minDist > 2000.0f) {
            return;
        }
        for (CampaignFleetAPI other : Misc.getNearbyFleets(closest.getPrimaryEntity(), 2000.0f)) {
            float dist;
            boolean otherFromSameRaid;
            if (other == this.fleet) continue;
            if (other.isHostileTo(this.fleet)) {
                boolean canSee;
                SectorEntityToken.VisibilityLevel vis = other.getVisibilityLevelTo(this.fleet);
                boolean bl = canSee = vis == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || vis == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS;
                if (!canSee && other.getFaction() != this.fleet.getFaction()) continue;
                if (other.getAI() instanceof ModularFleetAIAPI) {
                    ModularFleetAIAPI ai = (ModularFleetAIAPI)other.getAI();
                    if (ai.isFleeing() || ai.isMaintainingContact()) continue;
                    if (ai.getTacticalModule().getTarget() == this.fleet) {
                        return;
                    }
                    MemoryAPI mem = other.getMemoryWithoutUpdate();
                    boolean smuggler = mem.getBoolean("$isSmuggler");
                    boolean trader = mem.getBoolean("$isTradeFleet");
                    if (smuggler || trader) continue;
                }
                if ((float)other.getFleetPoints() > (float)this.fleet.getFleetPoints() * 0.25f || other.isStationMode()) {
                    return;
                }
            }
            if (other.getFaction() != this.fleet.getFaction() || other.isStationMode()) continue;
            boolean bl = otherFromSameRaid = this.delegate != null && this.delegate.canRaid(other, closest);
            if (!Misc.isRaider(other) || Misc.isWarFleet(other) || otherFromSameRaid) continue;
            if (other.getFleetPoints() > this.fleet.getFleetPoints()) {
                return;
            }
            if (other.getFleetPoints() != this.fleet.getFleetPoints() || !((dist = Misc.getDistance(other, closest.getPrimaryEntity())) < minDist)) continue;
            return;
        }
        this.giveRaidOrder(closest);
    }

    protected void giveRaidOrder(final MarketAPI target) {
        float dist;
        this.clearTempAssignments(this.fleet);
        Misc.setFlagWithReason(this.fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", TEMP_BUSY_REASON, true, 1.5f + (float)Math.random());
        String name = target.getName();
        String capText = "\u6b63\u5728\u7a81\u88ad " + name;
        String moveText = "\u6b63\u5728\u524d\u5f80\u5e76\u7a81\u88ad " + name;
        if (this.delegate != null) {
            String s = this.delegate.getRaidApproachText(this.fleet, target);
            if (s != null) {
                moveText = s;
            }
            if ((s = this.delegate.getRaidActionText(this.fleet, target)) != null) {
                capText = s;
            }
        }
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(target.getPrimaryEntity().getLocation(), this.fleet.getLocation()));
        float holdRadius = this.fleet.getRadius() * 0.5f + target.getPrimaryEntity().getRadius();
        loc.scale(holdRadius);
        Vector2f.add((Vector2f)loc, (Vector2f)target.getPrimaryEntity().getLocation(), (Vector2f)loc);
        SectorEntityToken holdLoc = target.getContainingLocation().createToken(loc);
        holdLoc.setCircularOrbit(target.getPrimaryEntity(), Misc.getAngleInDegrees(target.getPrimaryEntity().getLocation(), this.fleet.getLocation()), holdRadius, 1000000.0f);
        this.fleet.getContainingLocation().addEntity(holdLoc);
        Misc.fadeAndExpire(holdLoc, 5.0f);
        final int fpAtStart = this.fleet.getFleetPoints();
        this.fleet.addAssignmentAtStart(FleetAssignment.HOLD, holdLoc, 0.5f, capText, new Script(){

            public void run() {
                if (fpAtStart == BaseAssignmentAI.this.fleet.getFleetPoints()) {
                    boolean raided = false;
                    if (BaseAssignmentAI.this.delegate != null) {
                        if (BaseAssignmentAI.this.delegate.canRaid(BaseAssignmentAI.this.fleet, target)) {
                            BaseAssignmentAI.this.delegate.performRaid(BaseAssignmentAI.this.fleet, target);
                            raided = true;
                        }
                    } else {
                        new MarketCMD(target.getPrimaryEntity()).doGenericRaid(BaseAssignmentAI.this.fleet.getFaction(), MarketCMD.getRaidStr(BaseAssignmentAI.this.fleet));
                        raided = true;
                    }
                    if (raided) {
                        BaseAssignmentAI.this.fleet.getMemoryWithoutUpdate().set("$recentlyPerformedRaid", true, 3.0f);
                    }
                    BaseAssignmentAI.this.clearTempAssignments(BaseAssignmentAI.this.fleet);
                }
            }
        });
        FleetAssignmentDataAPI curr = this.fleet.getCurrentAssignment();
        if (curr != null) {
            curr.setCustom(TEMP_ASSIGNMENT);
        }
        if ((dist = Misc.getDistance(target.getPrimaryEntity(), this.fleet)) > this.fleet.getRadius() + target.getPrimaryEntity().getRadius()) {
            this.fleet.addAssignmentAtStart(FleetAssignment.DELIVER_CREW, holdLoc, 3.0f, moveText, null);
            curr = this.fleet.getCurrentAssignment();
            if (curr != null) {
                curr.setCustom(TEMP_ASSIGNMENT);
            }
        }
    }

    public static interface FleetActionDelegate {
        public boolean canRaid(CampaignFleetAPI var1, MarketAPI var2);

        public String getRaidApproachText(CampaignFleetAPI var1, MarketAPI var2);

        public String getRaidActionText(CampaignFleetAPI var1, MarketAPI var2);

        public void performRaid(CampaignFleetAPI var1, MarketAPI var2);

        public String getRaidPrepText(CampaignFleetAPI var1, SectorEntityToken var2);

        public String getRaidInSystemText(CampaignFleetAPI var1);

        public String getRaidDefaultText(CampaignFleetAPI var1);
    }
}

