/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseAssignmentAI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class RouteFleetAssignmentAI
extends BaseAssignmentAI {
    protected RouteManager.RouteData route;
    protected Boolean gaveReturnAssignments = null;

    public RouteFleetAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route, BaseAssignmentAI.FleetActionDelegate delegate) {
        this.fleet = fleet;
        this.route = route;
        this.delegate = delegate;
        this.giveInitialAssignments();
    }

    public RouteFleetAssignmentAI(CampaignFleetAPI fleet, RouteManager.RouteData route) {
        this.fleet = fleet;
        this.route = route;
        this.giveInitialAssignments();
    }

    protected TravelState getTravelState(RouteManager.RouteSegment segment) {
        if (segment.isInSystem()) {
            return TravelState.IN_SYSTEM;
        }
        if (segment.hasLeaveSystemPhase() && segment.getLeaveProgress() < 1.0f) {
            return TravelState.LEAVING_SYSTEM;
        }
        if (segment.hasEnterSystemPhase() && segment.getEnterProgress() > 0.0f) {
            return TravelState.ENTERING_SYSTEM;
        }
        return TravelState.IN_HYPER_TRANSIT;
    }

    protected LocationAPI getLocationForState(RouteManager.RouteSegment segment, TravelState state) {
        switch (state) {
            case ENTERING_SYSTEM: {
                if (segment.to != null) {
                    return segment.to.getContainingLocation();
                }
                return segment.from.getContainingLocation();
            }
            case IN_HYPER_TRANSIT: {
                return Global.getSector().getHyperspace();
            }
            case IN_SYSTEM: {
                return segment.from.getContainingLocation();
            }
            case LEAVING_SYSTEM: {
                return segment.from.getContainingLocation();
            }
        }
        return null;
    }

    protected void giveInitialAssignments() {
        TravelState state = this.getTravelState(this.route.getCurrent());
        LocationAPI conLoc = this.getLocationForState(this.route.getCurrent(), state);
        if (this.fleet.getContainingLocation() != null) {
            this.fleet.getContainingLocation().removeEntity(this.fleet);
        }
        conLoc.addEntity(this.fleet);
        this.fleet.setFacing((float)Math.random() * 360.0f);
        this.pickNext(true);
    }

    public void advance(float amount) {
        this.advance(amount, true);
    }

    protected void advance(float amount, boolean withReturnAssignments) {
        if (withReturnAssignments && this.route.isExpired() && this.gaveReturnAssignments == null) {
            RouteManager.RouteSegment current = this.route.getCurrent();
            if (current != null && current.from != null && Misc.getDistance(this.fleet.getLocation(), current.from.getLocation()) < 1000.0f) {
                this.fleet.clearAssignments();
                this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, current.from, 1000.0f, "\u6b63\u5728\u8fd4\u56de " + current.from.getName());
            } else {
                Misc.giveStandardReturnToSourceAssignments(this.fleet);
            }
            this.gaveReturnAssignments = true;
            return;
        }
        super.advance(amount);
    }

    protected String getTravelActionText(RouteManager.RouteSegment segment) {
        return "\u884c\u52a8\u4e2d";
    }

    protected String getInSystemActionText(RouteManager.RouteSegment segment) {
        return "\u6b63\u5728\u5de1\u903b";
    }

    protected String getStartingActionText(RouteManager.RouteSegment segment) {
        if (segment.from == this.route.getMarket().getPrimaryEntity()) {
            return "\u6b63\u73af\u7ed5\u4e8e " + this.route.getMarket().getName();
        }
        return "\u6b63\u5728\u5de1\u903b";
    }

    protected String getEndingActionText(RouteManager.RouteSegment segment) {
        SectorEntityToken to = segment.to;
        if (to == null) {
            to = segment.from;
        }
        if (to == null) {
            to = this.route.getMarket().getPrimaryEntity();
        }
        return "\u6b63\u5728\u8fd4\u56de " + to.getName();
    }

    protected void pickNext() {
        this.pickNext(false);
    }

    protected void pickNext(boolean justSpawned) {
        RouteManager.RouteSegment current = this.route.getCurrent();
        if (current == null) {
            return;
        }
        List<RouteManager.RouteSegment> segments = this.route.getSegments();
        int index = this.route.getSegments().indexOf(this.route.getCurrent());
        if (index == 0 && this.route.getMarket() != null && !current.isTravel()) {
            if (current.getFrom() != null && (current.getFrom().isSystemCenter() || current.getFrom().getMarket() != this.route.getMarket())) {
                this.addLocalAssignment(current, justSpawned);
            } else {
                this.addStartingAssignment(current, justSpawned);
            }
            return;
        }
        if (index == segments.size() - 1 && this.route.getMarket() != null && !current.isTravel() && (current.elapsed >= current.daysMax || current.getFrom() == this.route.getMarket().getPrimaryEntity())) {
            this.addEndingAssignment(current, justSpawned);
            return;
        }
        if (current.isTravel()) {
            if (index == segments.size() - 1 && this.fleet.getContainingLocation() == current.to.getContainingLocation() && current.elapsed >= current.daysMax) {
                this.addEndingAssignment(current, justSpawned);
            } else {
                this.addTravelAssignment(current, justSpawned);
            }
            return;
        }
        if (!current.isTravel()) {
            this.addLocalAssignment(current, justSpawned);
        }
    }

    protected void addStartingAssignment(RouteManager.RouteSegment current, boolean justSpawned) {
        SectorEntityToken from = current.getFrom();
        if (from == null) {
            from = this.route.getMarket().getPrimaryEntity();
        }
        if (justSpawned) {
            float progress = current.getProgress();
            RouteLocationCalculator.setLocation(this.fleet, progress, from, from);
        }
        this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, from, current.daysMax - current.elapsed, this.getStartingActionText(current), this.goNextScript(current));
    }

    protected Script goNextScript(final RouteManager.RouteSegment current) {
        return new Script(){

            public void run() {
                RouteFleetAssignmentAI.this.route.goToAtLeastNext(current);
            }
        };
    }

    protected void addEndingAssignment(RouteManager.RouteSegment current, boolean justSpawned) {
        SectorEntityToken to;
        if (justSpawned) {
            float progress = current.getProgress();
            RouteLocationCalculator.setLocation(this.fleet, progress, current.getDestination(), current.getDestination());
        }
        if ((to = current.to) == null) {
            to = current.from;
        }
        if (to == null) {
            to = this.route.getMarket().getPrimaryEntity();
        }
        if (to == null || !to.isAlive()) {
            Vector2f loc = Misc.getPointAtRadius(this.fleet.getLocationInHyperspace(), 5000.0f);
            SectorEntityToken token = Global.getSector().getHyperspace().createToken(loc);
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, token, 1000.0f);
            return;
        }
        this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, to, 1000.0f, "\u6b63\u5728\u8fd4\u56de " + to.getName());
        if (current.daysMax > current.elapsed) {
            this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, to, current.daysMax - current.elapsed, this.getEndingActionText(current));
        }
        this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, to, 1000.0f, this.getEndingActionText(current), this.goNextScript(current));
    }

    protected void addLocalAssignment(RouteManager.RouteSegment current, boolean justSpawned) {
        if (justSpawned) {
            float progress = current.getProgress();
            RouteLocationCalculator.setLocation(this.fleet, progress, current.from, current.getDestination());
        }
        if (current.from != null && current.to == null && !current.isFromSystemCenter()) {
            this.fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, current.from, current.daysMax - current.elapsed, this.getInSystemActionText(current), this.goNextScript(current));
            return;
        }
        SectorEntityToken target = null;
        target = current.from.getContainingLocation() instanceof StarSystemAPI ? ((StarSystemAPI)current.from.getContainingLocation()).getCenter() : Global.getSector().getHyperspace().createToken(current.from.getLocation().x, current.from.getLocation().y);
        this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, target, current.daysMax - current.elapsed, this.getInSystemActionText(current));
    }

    protected void addTravelAssignment(RouteManager.RouteSegment current, boolean justSpawned) {
        if (justSpawned) {
            TravelState state = this.getTravelState(current);
            if (state == TravelState.LEAVING_SYSTEM) {
                float p = current.getLeaveProgress();
                SectorEntityToken jp = RouteLocationCalculator.findJumpPointToUse(this.fleet, current.from);
                if (jp == null) {
                    jp = current.from;
                }
                RouteLocationCalculator.setLocation(this.fleet, p, current.from, jp);
            } else if (state == TravelState.ENTERING_SYSTEM) {
                float p = current.getEnterProgress();
                SectorEntityToken jp = RouteLocationCalculator.findJumpPointToUse(this.fleet, current.to);
                if (jp == null) {
                    jp = current.to;
                }
                RouteLocationCalculator.setLocation(this.fleet, p, jp, current.to);
            } else if (state == TravelState.IN_SYSTEM) {
                float p = current.getTransitProgress();
                RouteLocationCalculator.setLocation(this.fleet, p, current.from, current.to);
            } else if (state == TravelState.IN_HYPER_TRANSIT) {
                float p = current.getTransitProgress();
                SectorEntityToken t1 = Global.getSector().getHyperspace().createToken(current.from.getLocationInHyperspace().x, current.from.getLocationInHyperspace().y);
                SectorEntityToken t2 = Global.getSector().getHyperspace().createToken(current.to.getLocationInHyperspace().x, current.to.getLocationInHyperspace().y);
                RouteLocationCalculator.setLocation(this.fleet, p, t1, t2);
            }
        }
        this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, current.to, 10000.0f, this.getTravelActionText(current), this.goNextScript(current));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TravelState {
        IN_SYSTEM,
        LEAVING_SYSTEM,
        IN_HYPER_TRANSIT,
        ENTERING_SYSTEM;

    }
}

