/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.MutableValue;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRemoveCommodity
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        boolean withText;
        if (dialog == null) {
            return false;
        }
        String commodityId = params.get(0).getString(memoryMap);
        float quantity = 0.0f;
        int next = 2;
        if (params.get(1).isOperator()) {
            quantity = -1.0f * params.get(2).getFloat(memoryMap);
            next = 3;
        } else {
            quantity = params.get(1).getFloat(memoryMap);
        }
        boolean bl = withText = Math.abs(quantity) >= 1.0f;
        if (dialog != null && params.size() >= next + 1) {
            boolean bl2 = withText = params.get(next).getBoolean(memoryMap) && withText;
        }
        if (commodityId.equals("credits")) {
            MutableValue credits = Global.getSector().getPlayerFleet().getCargo().getCredits();
            if (quantity > 0.0f) {
                credits.add(quantity);
                if (withText) {
                    AddRemoveCommodity.addCreditsGainText((int)quantity, dialog.getTextPanel());
                }
            } else {
                credits.subtract(Math.abs(quantity));
                if (credits.get() < 0.0f) {
                    credits.set(0.0f);
                }
                if (withText) {
                    AddRemoveCommodity.addCreditsLossText((int)Math.abs(quantity), dialog.getTextPanel());
                }
            }
        } else if (quantity > 0.0f) {
            Global.getSector().getPlayerFleet().getCargo().addCommodity(commodityId, quantity);
            if (withText) {
                AddRemoveCommodity.addCommodityGainText(commodityId, (int)quantity, dialog.getTextPanel());
            }
        } else {
            Global.getSector().getPlayerFleet().getCargo().removeCommodity(commodityId, Math.abs(quantity));
            if (withText) {
                AddRemoveCommodity.addCommodityLossText(commodityId, (int)Math.abs(quantity), dialog.getTextPanel());
            }
        }
        if (!"credits".equals(commodityId)) {
            AddRemoveCommodity.updatePlayerMemoryQuantity(commodityId);
        }
        return true;
    }

    public static void updatePlayerMemoryQuantity(String commodityId) {
        String key;
        if ("credits".equals(commodityId)) {
            CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
            MemoryAPI memory = Global.getSector().getCharacterData().getMemoryWithoutUpdate();
            memory.set("$credits", (int)fleet.getCargo().getCredits().get(), 0.0f);
            memory.set("$creditsStr", Misc.getWithDGS((int)fleet.getCargo().getCredits().get()), 0.0f);
            memory.set("$creditsStrC", String.valueOf(Misc.getWithDGS((int)fleet.getCargo().getCredits().get())) + "\u00a2", 0.0f);
            return;
        }
        MemoryAPI memory = Global.getSector().getCharacterData().getMemoryWithoutUpdate();
        if (memory.contains(key = "$" + commodityId) && (memory.get(key) instanceof Integer || memory.get(key) instanceof Float)) {
            memory.set(key, (int)Global.getSector().getPlayerFleet().getCargo().getCommodityQuantity(commodityId), 0.0f);
        }
    }

    public static void addStackGainText(CargoStackAPI stack, TextPanelAPI text) {
        AddRemoveCommodity.addStackGainText(stack, text, false);
    }

    public static void addStackGainText(CargoStackAPI stack, TextPanelAPI text, boolean lowerCase) {
        if (stack.getSize() < 1.0f) {
            return;
        }
        text.setFontSmallInsignia();
        String name = stack.getDisplayName();
        if (lowerCase) {
            name = name.toLowerCase();
        }
        int quantity = (int)stack.getSize();
        text.addParagraph("\u83b7\u5f97 " + Misc.getWithDGS(quantity) + "\u00d7" + " " + name, Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(quantity)) + "\u00d7");
        text.setFontInsignia();
    }

    public static void addFighterGainText(String wingId, int quantity, TextPanelAPI text) {
        FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(wingId);
        if (spec == null) {
            return;
        }
        text.setFontSmallInsignia();
        String name = spec.getWingName();
        text.addParagraph("\u83b7\u5f97 " + Misc.getWithDGS(quantity) + "\u00d7" + " " + name, Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(quantity)) + "\u00d7");
        text.setFontInsignia();
    }

    public static void addFighterLossText(String wingId, int quantity, TextPanelAPI text) {
        FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(wingId);
        if (spec == null) {
            return;
        }
        text.setFontSmallInsignia();
        String name = spec.getWingName();
        text.addParagraph("\u5931\u53bb\u4e86 " + Misc.getWithDGS(quantity) + "\u00d7" + " " + name, Misc.getNegativeHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(quantity)) + "\u00d7");
        text.setFontInsignia();
    }

    public static void addWeaponGainText(String weaponId, int quantity, TextPanelAPI text) {
        WeaponSpecAPI spec = Global.getSettings().getWeaponSpec(weaponId);
        if (spec == null) {
            return;
        }
        text.setFontSmallInsignia();
        String name = spec.getWeaponName();
        text.addParagraph("\u83b7\u5f97 " + Misc.getWithDGS(quantity) + "\u00d7" + " " + name, Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(quantity)) + "\u00d7");
        text.setFontInsignia();
    }

    public static void addWeaponLossText(String weaponId, int quantity, TextPanelAPI text) {
        WeaponSpecAPI spec = Global.getSettings().getWeaponSpec(weaponId);
        if (spec == null) {
            return;
        }
        text.setFontSmallInsignia();
        String name = spec.getWeaponName();
        text.addParagraph("\u5931\u53bb\u4e86 " + Misc.getWithDGS(quantity) + "\u00d7" + " " + name, Misc.getNegativeHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(quantity)) + "\u00d7");
        text.setFontInsignia();
    }

    public static void addItemGainText(SpecialItemData data, int quantity, TextPanelAPI text) {
        CargoAPI cargo = Global.getFactory().createCargo(true);
        cargo.addSpecial(data, 1.0f);
        CargoStackAPI stack = cargo.getStacksCopy().get(0);
        text.setFontSmallInsignia();
        String name = stack.getDisplayName();
        if (quantity == 1) {
            text.addParagraph("\u83b7\u5f97 " + name, Misc.getPositiveHighlightColor());
            text.highlightInLastPara(Misc.getHighlightColor(), name);
        } else {
            text.addParagraph("\u83b7\u5f97 " + Misc.getWithDGS(quantity) + "\u00d7" + " " + name, Misc.getPositiveHighlightColor());
            text.highlightInLastPara(Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(quantity)) + "\u00d7");
        }
        text.setFontInsignia();
    }

    public static void addItemLossText(SpecialItemData data, int quantity, TextPanelAPI text) {
        CargoAPI cargo = Global.getFactory().createCargo(true);
        cargo.addSpecial(data, 1.0f);
        CargoStackAPI stack = cargo.getStacksCopy().get(0);
        text.setFontSmallInsignia();
        String name = stack.getDisplayName();
        if (quantity == 1) {
            text.addParagraph("\u5931\u53bb\u4e86 " + name, Misc.getNegativeHighlightColor());
            text.highlightInLastPara(Misc.getHighlightColor(), name);
        } else {
            text.addParagraph("\u5931\u53bb\u4e86 " + Misc.getWithDGS(quantity) + "\u00d7" + " " + name, Misc.getNegativeHighlightColor());
            text.highlightInLastPara(Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(quantity)) + "\u00d7");
        }
        text.setFontInsignia();
    }

    public static void addCommodityGainText(String commodityId, int quantity, TextPanelAPI text) {
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(commodityId);
        text.setFontSmallInsignia();
        String name = spec.getLowerCaseName();
        text.addParagraph("\u83b7\u5f97 " + Misc.getWithDGS(quantity) + "\u00d7" + " " + name, Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(quantity)) + "\u00d7");
        text.setFontInsignia();
    }

    public static void addCommodityLossText(String commodityId, int quantity, TextPanelAPI text) {
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(commodityId);
        text.setFontSmallInsignia();
        String name = spec.getLowerCaseName();
        text.addParagraph("\u5931\u53bb\u4e86 " + Misc.getWithDGS(quantity) + "\u00d7" + " " + name, Misc.getNegativeHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(quantity)) + "\u00d7");
        text.setFontInsignia();
    }

    public static void addCreditsGainText(int credits, TextPanelAPI text) {
        text.setFontSmallInsignia();
        String str = String.valueOf(Misc.getWithDGS(credits)) + "\u00a2";
        text.addParagraph("\u83b7\u5f97 " + str, Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
        if (Global.getCurrentState() == GameState.CAMPAIGN) {
            CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
            MemoryAPI memory = Global.getSector().getCharacterData().getMemoryWithoutUpdate();
            memory.set("$credits", (int)fleet.getCargo().getCredits().get(), 0.0f);
            memory.set("$creditsStr", Misc.getWithDGS((int)fleet.getCargo().getCredits().get()), 0.0f);
            memory.set("$creditsStrC", String.valueOf(Misc.getWithDGS((int)fleet.getCargo().getCredits().get())) + "\u00a2", 0.0f);
        }
    }

    public static void addCreditsLossText(int credits, TextPanelAPI text) {
        text.setFontSmallInsignia();
        String str = String.valueOf(Misc.getWithDGS(credits)) + "\u00a2";
        text.addParagraph("\u5931\u53bb\u4e86 " + str, Misc.getNegativeHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
        if (Global.getCurrentState() == GameState.CAMPAIGN) {
            CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
            MemoryAPI memory = Global.getSector().getCharacterData().getMemoryWithoutUpdate();
            memory.set("$credits", (int)fleet.getCargo().getCredits().get(), 0.0f);
            memory.set("$creditsStr", Misc.getWithDGS((int)fleet.getCargo().getCredits().get()), 0.0f);
            memory.set("$creditsStrC", String.valueOf(Misc.getWithDGS((int)fleet.getCargo().getCredits().get())) + "\u00a2", 0.0f);
        }
    }

    public static void addAbilityGainText(String abilityId, TextPanelAPI text) {
        AbilitySpecAPI ability = Global.getSettings().getAbilitySpec(abilityId);
        text.setFontSmallInsignia();
        String str = "\"" + ability.getName() + "\"";
        text.addParagraph("\u83b7\u5f97\u80fd\u529b\uff1a" + str, Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
    }

    public static void addOfficerGainText(PersonAPI officer, TextPanelAPI text) {
        text.setFontSmallInsignia();
        String rank = officer.getRank();
        if (rank != null) {
            rank = Misc.ucFirst(rank);
        }
        String str = officer.getName().getFullName();
        if (rank != null) {
            str = String.valueOf(rank) + " " + str;
        }
        LabelAPI label = text.addParagraph(String.valueOf(str) + " (\u7b49\u7ea7 " + officer.getStats().getLevel() + ") \u5df2\u52a0\u5165\u4e86\u4f60\u7684\u8230\u961f", Misc.getPositiveHighlightColor());
        label.setHighlightColors(Misc.getHighlightColor(), Misc.getHighlightColor());
        label.setHighlight(str, " (\u7b49\u7ea7 " + officer.getStats().getLevel() + ")");
        text.setFontInsignia();
    }

    public static void addOfficerLossText(PersonAPI officer, TextPanelAPI text) {
        text.setFontSmallInsignia();
        String rank = officer.getRank();
        if (rank != null) {
            rank = Misc.ucFirst(rank);
        }
        String str = officer.getName().getFullName();
        if (rank != null) {
            str = String.valueOf(rank) + " " + str;
        }
        text.addParagraph(String.valueOf(str) + " \u79bb\u5f00\u4e86\u4f60\u7684\u8230\u961f", Misc.getNegativeHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
    }

    public static void addAdminGainText(PersonAPI admin, TextPanelAPI text) {
        text.setFontSmallInsignia();
        String rank = "\u884c\u653f\u5b98";
        String str = admin.getName().getFullName();
        if (rank != null) {
            str = String.valueOf(rank) + " " + str;
        }
        text.addParagraph(String.valueOf(str) + " \u52a0\u5165\u4e86\u4f60\u7684\u8230\u961f", Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
    }

    public static void addFleetMemberGainText(FleetMemberAPI member, TextPanelAPI text) {
        text.setFontSmallInsignia();
        String str = String.valueOf(member.getShipName()) + ", " + member.getVariant().getHullSpec().getHullNameWithDashClass() + " " + member.getVariant().getHullSpec().getDesignation();
        text.addParagraph("\u83b7\u5f97 " + str, Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
    }

    public static void addFleetMemberLossText(FleetMemberAPI member, TextPanelAPI text) {
        text.setFontSmallInsignia();
        String str = String.valueOf(member.getShipName()) + ", " + member.getVariant().getHullSpec().getHullNameWithDashClass() + " " + member.getVariant().getHullSpec().getDesignation();
        text.addParagraph("\u5931\u53bb\u4e86 " + str, Misc.getNegativeHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
    }

    public static void addFleetMemberGainText(ShipVariantAPI variant, TextPanelAPI text) {
        text.setFontSmallInsignia();
        String str = String.valueOf(variant.getHullSpec().getHullNameWithDashClass()) + " " + variant.getHullSpec().getDesignation();
        text.addParagraph("\u83b7\u5f97 " + str, Misc.getPositiveHighlightColor());
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
    }

    public static void addCRLossText(FleetMemberAPI member, TextPanelAPI text, float crLoss) {
        text.setFontSmallInsignia();
        String str = String.valueOf(member.getShipName()) + ", " + member.getVariant().getHullSpec().getHullNameWithDashClass() + " " + member.getVariant().getHullSpec().getDesignation();
        String cr = String.valueOf(Math.round(crLoss * 100.0f)) + "%";
        text.addPara("%s \u5931\u53bb\u4e86 %s \u7684\u6218\u5907\u503c (CR) ", Misc.getNegativeHighlightColor(), Misc.getHighlightColor(), str, cr);
        text.highlightInLastPara(Misc.getHighlightColor(), str);
        text.setFontInsignia();
    }
}

