/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastPlayerAction
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        CampaignFleetAIAPI.ActionType type = Enum.valueOf(CampaignFleetAIAPI.ActionType.class, params.get((int)0).string);
        float range = Float.parseFloat(params.get((int)1).string);
        String responseVariable = params.get((int)2).string;
        SectorEntityToken target = dialog.getInteractionTarget();
        if (target.getContainingLocation() == null) {
            return false;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        BroadcastPlayerAction.broadcast(type, range, responseVariable, playerFleet, target);
        return true;
    }

    public static void broadcast(CampaignFleetAIAPI.ActionType type, float range, String responseVariable, SectorEntityToken actor, SectorEntityToken target) {
        BroadcastPlayerAction.broadcast(type, range, responseVariable, actor, target, null);
    }

    public static void broadcast(CampaignFleetAIAPI.ActionType type, float range, String responseVariable, SectorEntityToken actor, SectorEntityToken target, SectorEntityToken exclude) {
        List<CampaignFleetAPI> fleets = target.getContainingLocation().getFleets();
        for (CampaignFleetAPI fleet : fleets) {
            float dist;
            if (fleet == exclude || !(fleet.getAI() instanceof CampaignFleetAIAPI) || !((dist = Misc.getDistance(target.getLocation(), fleet.getLocation())) <= range)) continue;
            CampaignFleetAIAPI ai = fleet.getAI();
            ai.reportNearbyAction(type, actor, target, responseVariable);
        }
    }
}

