/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CargoPodsEntityPlugin;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoScan
extends BaseCommandPlugin {
    public static String PODS_FOUND = "$scan_podsFound";
    public static String CONTRABAND_FOUND = "$scan_contrabandFound";
    public static String SUSPICOUS_CARGO_FOUND = "$scan_suspiciousCargoFound";
    public static String RESULT_KEY = "$scan_cargoScanResult";
    public static float INSPECTION_DAMAGE_MULT = 0.2f;
    public static float CHANCE_TO_FIND_ILLEGAL_MULT = 2.0f;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        float r;
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CampaignFleetAPI other = (CampaignFleetAPI)dialog.getInteractionTarget();
        FactionAPI faction = other.getFaction();
        CargoScanResult result = new CargoScanResult();
        float totalLegal = 0.0f;
        float totalLegalCargo = 0.0f;
        float totalIllegal = 0.0f;
        float totalIllegalFound = 0.0f;
        CargoAPI legalFound = Global.getFactory().createCargo(true);
        CargoAPI illegalFound = Global.getFactory().createCargo(true);
        CargoAPI all = Global.getFactory().createCargo(true);
        float totalCargo = playerFleet.getCargo().getSpaceUsed();
        float totalCrew = playerFleet.getCargo().getTotalPersonnel();
        float totalFuel = playerFleet.getCargo().getFuel();
        for (CargoStackAPI stack : playerFleet.getCargo().getStacksCopy()) {
            boolean legal;
            boolean bl = legal = !faction.isIllegal(stack);
            if (legal) {
                totalLegal += stack.getSize();
                totalLegalCargo += stack.getCargoSpace();
            } else {
                totalIllegal += stack.getSize();
            }
            all.addFromStack(stack);
        }
        float guiltMult = 1.0f;
        float shieldedFraction = Misc.getShieldedCargoFraction(playerFleet);
        float unshieldedFraction = 1.0f - shieldedFraction;
        float shieldedMult = 0.25f + 0.75f * unshieldedFraction;
        MarketAPI market = Misc.getSourceMarket(other);
        float level = market.getMemory().getFloat("$smugglingSuspicion");
        float suspicionMult = 0.0f;
        if (market != null && level >= 0.05f) {
            suspicionMult = 0.5f + 0.5f * level;
        }
        boolean suspicious = false;
        boolean suspiciousDueToLevel = false;
        if ((totalLegalCargo *= shieldedMult) > 50.0f || totalLegalCargo > playerFleet.getCargo().getMaxCapacity() * 0.5f) {
            boolean bl = suspicious = (totalLegalCargo *= suspicionMult) * guiltMult * (float)Math.random() > playerFleet.getCargo().getMaxCapacity() * (float)Math.random();
        }
        if (!suspicious && level >= 0.5f && (suspicious |= (r = (float)Math.random()) * r < level)) {
            suspiciousDueToLevel = true;
        }
        if (totalLegal + totalIllegal > 0.0f) {
            List<CargoStackAPI> stacks = all.getStacksCopy();
            Collections.shuffle(stacks);
            float illegalCargoSoFar = 0.0f;
            float illegalCrewSoFar = 0.0f;
            float illegalFuelSoFar = 0.0f;
            for (CargoStackAPI stack : stacks) {
                if (stack.getSize() <= 0.0f) continue;
                boolean legal = !faction.isIllegal(stack);
                float chanceToFind = 0.0f;
                if (stack.isPersonnelStack()) {
                    if (totalCrew > 0.0f) {
                        if (!legal) {
                            illegalCrewSoFar += stack.getSize();
                        }
                        chanceToFind = illegalCrewSoFar / totalCrew;
                    }
                } else if (stack.isFuelStack()) {
                    if (totalFuel > 0.0f) {
                        if (!legal) {
                            illegalFuelSoFar += stack.getSize();
                        }
                        chanceToFind = illegalFuelSoFar / totalFuel;
                    }
                } else if (totalCargo > 0.0f) {
                    if (!legal) {
                        illegalCargoSoFar += stack.getCargoSpace();
                    }
                    chanceToFind = illegalCargoSoFar / totalCargo;
                }
                chanceToFind *= guiltMult;
                chanceToFind *= shieldedMult;
                chanceToFind *= CHANCE_TO_FIND_ILLEGAL_MULT;
                if (legal) {
                    legalFound.addFromStack(stack);
                    continue;
                }
                if (!((float)Math.random() < chanceToFind)) continue;
                float qty = stack.getSize();
                qty *= 0.33f + (float)Math.random() * 0.67f;
                qty *= shieldedMult;
                if ((qty = (float)Math.round(qty)) < 1.0f) {
                    qty = 1.0f;
                }
                illegalFound.addItems(stack.getType(), stack.getData(), qty);
            }
        }
        if (suspicious && illegalFound.isEmpty()) {
            WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>();
            for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
                if (member.isMothballed() && member.getRepairTracker().getBaseCR() < 0.2f) continue;
                picker.add(member, member.getFleetPointCost());
            }
            if (picker.isEmpty()) {
                suspicious = false;
            } else {
                float totalDamage = (float)Math.min(playerFleet.getFleetPoints(), other.getFleetPoints()) * INSPECTION_DAMAGE_MULT;
                float picked = 0.0f;
                while (picked < totalDamage && !picker.isEmpty()) {
                    FleetMemberAPI pick = (FleetMemberAPI)picker.pickAndRemove();
                    result.shipsToDamage.add(pick);
                    picked += (float)pick.getFleetPointCost();
                }
            }
        }
        result.setLegalFound(legalFound);
        result.setIllegalFound(illegalFound);
        MemoryAPI memory = memoryMap.get("local");
        memory.set(CONTRABAND_FOUND, !illegalFound.isEmpty(), 0.0f);
        memory.set(SUSPICOUS_CARGO_FOUND, suspicious, 0.0f);
        memory.set(RESULT_KEY, result, 0.0f);
        float maxPodsDist = 1500.0f;
        block4: for (SectorEntityToken entity : other.getContainingLocation().getAllEntities()) {
            CargoPodsEntityPlugin plugin;
            float dist;
            if (!"cargo_pods".equals(entity.getCustomEntityType())) continue;
            SectorEntityToken.VisibilityLevel vLevel = entity.getVisibilityLevelTo(other);
            if (!(entity.getCustomPlugin() instanceof CargoPodsEntityPlugin) || (dist = Misc.getDistance(playerFleet, entity)) > maxPodsDist || !((plugin = (CargoPodsEntityPlugin)entity.getCustomPlugin()).getElapsed() <= 1.0f) || entity.getCargo() == null || vLevel != SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS && vLevel != SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS) continue;
            for (CargoStackAPI stack : entity.getCargo().getStacksCopy()) {
                boolean legal;
                boolean bl = legal = !faction.isIllegal(stack);
                if (legal) continue;
                memory.set(PODS_FOUND, true, 0.0f);
                Misc.fadeAndExpire(entity);
                break block4;
            }
        }
        TextPanelAPI text = dialog.getTextPanel();
        text.setFontSmallInsignia();
        Color hl = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        text.addParagraph("-----------------------------------------------------------------------------");
        if (!illegalFound.isEmpty()) {
            text.addParagraph("\u53d1\u73b0\u8fdd\u7981\u54c1\uff01", red);
            String para = "";
            ArrayList<String> highlights = new ArrayList<String>();
            for (CargoStackAPI stack : illegalFound.getStacksCopy()) {
                para = String.valueOf(para) + stack.getDisplayName() + " " + "\u00d7" + " " + (int)stack.getSize() + "\n";
                highlights.add("" + (int)stack.getSize());
            }
            para = para.substring(0, para.length() - 1);
            text.addParagraph(para);
            text.highlightInLastPara(hl, highlights.toArray(new String[0]));
        } else if (suspicious) {
            if (suspiciousDueToLevel) {
                text.addParagraph("\u7531\u4e8e\u603b\u4f53\u6000\u7591\u5ea6\u504f\u9ad8\u800c\u9700\u7740\u91cd\u68c0\u67e5\uff01", hl);
            } else {
                text.addParagraph("\u53d1\u73b0\u53ef\u7591\u8d27\u7269\uff01", hl);
            }
        } else {
            text.addParagraph("\u6ca1\u6709\u53d1\u73b0\u8fdd\u7981\u54c1\u6216\u53ef\u7591\u8d27\u7269\u3002");
        }
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
        for (CargoStackAPI stack : illegalFound.getStacksCopy()) {
            totalIllegalFound += stack.getSize();
        }
        float capacity = playerFleet.getCargo().getMaxCapacity();
        float repLoss = totalIllegalFound / 5.0f * totalIllegalFound / capacity;
        if ((repLoss = (float)Math.round(repLoss)) > 5.0f) {
            repLoss = 5.0f;
        }
        if (repLoss == 0.0f && totalIllegalFound > 0.0f) {
            repLoss = 1.0f;
        }
        if (suspicious) {
            repLoss = 5.0f;
        }
        if (repLoss > 0.0f) {
            CoreReputationPlugin.RepActionEnvelope envelope = new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOMS_CAUGHT_SMUGGLING, Float.valueOf(repLoss), dialog.getTextPanel());
            Global.getSector().adjustPlayerReputation((Object)envelope, faction.getId());
            envelope = new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOMS_CAUGHT_SMUGGLING, Float.valueOf(repLoss * 2.0f), dialog.getTextPanel());
            Global.getSector().adjustPlayerReputation((Object)envelope, dialog.getInteractionTarget().getActivePerson());
        }
        return true;
    }

    public static class CargoScanResult {
        protected CargoAPI legalFound;
        protected CargoAPI illegalFound;
        protected List<FleetMemberAPI> shipsToDamage = new ArrayList<FleetMemberAPI>();

        public CargoAPI getLegalFound() {
            return this.legalFound;
        }

        public void setLegalFound(CargoAPI legalFound) {
            this.legalFound = legalFound;
        }

        public CargoAPI getIllegalFound() {
            return this.illegalFound;
        }

        public void setIllegalFound(CargoAPI illegalFound) {
            this.illegalFound = illegalFound;
        }
    }
}

