/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.CustomsInspectionGenerateResult;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomsInspectionApplyRepLoss
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CampaignFleetAPI other = (CampaignFleetAPI)dialog.getInteractionTarget();
        FactionAPI faction = other.getFaction();
        MemoryAPI memory = memoryMap.get("entity");
        CustomsInspectionGenerateResult.CargoInspectionResult result = (CustomsInspectionGenerateResult.CargoInspectionResult)memory.get("$cargoInspectionResult");
        float totalIllegalFound = 0.0f;
        for (CargoStackAPI stack : result.getIllegalFound().getStacksCopy()) {
            totalIllegalFound += stack.getSize();
        }
        float capacity = playerFleet.getCargo().getMaxCapacity();
        float repLoss = totalIllegalFound / 10.0f * totalIllegalFound / capacity;
        if ((repLoss = (float)Math.round(repLoss)) > 5.0f) {
            repLoss = 5.0f;
        }
        if (repLoss == 0.0f && totalIllegalFound > 0.0f) {
            repLoss = 1.0f;
        }
        if (repLoss > 0.0f) {
            CoreReputationPlugin.RepActionEnvelope envelope = new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOMS_CAUGHT_SMUGGLING, Float.valueOf(repLoss), dialog.getTextPanel());
            Global.getSector().adjustPlayerReputation((Object)envelope, faction.getId());
        }
        return true;
    }
}

