/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.impl.campaign.econ.ShippingDisruption;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FleetDesc
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        MemoryAPI mem;
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
        FactionAPI faction = fleet.getFaction();
        TextPanelAPI text = dialog.getTextPanel();
        if (Global.getSettings().isDevMode() && !Global.getSettings().getBoolean("playtestingMode")) {
            text.addParagraph("\u8230\u957f\u6280\u80fd\uff1a");
            for (MutableCharacterStatsAPI.SkillLevelAPI skill : fleet.getCommanderStats().getSkillsCopy()) {
                if (!skill.getSkill().isAdmiralSkill()) continue;
                text.addParagraph("    " + skill.getSkill().getId());
            }
        }
        if (!(mem = fleet.getMemoryWithoutUpdate()).contains("$shownFleetDescAlready")) {
            mem.set("$shownFleetDescAlready", true, 0.0f);
        }
        boolean smuggler = mem.getBoolean("$isSmuggler");
        boolean trader = mem.getBoolean("$isTradeFleet");
        Color hl = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        RouteManager.RouteData route = RouteManager.getInstance().getRoute("econ", fleet);
        if ((trader || smuggler) && route != null) {
            EconomyFleetAssignmentAI.EconomyRouteData data = (EconomyFleetAssignmentAI.EconomyRouteData)route.getCustom();
            Integer id = route.getCurrentSegmentId();
            String from = data.from.getName();
            String to = data.to.getName();
            if (id >= EconomyFleetRouteManager.ROUTE_DST_LOAD) {
                from = data.to.getName();
                to = data.from.getName();
            }
            String cargo = "";
            if (id <= EconomyFleetRouteManager.ROUTE_DST_UNLOAD) {
                cargo = EconomyFleetAssignmentAI.EconomyRouteData.getCargoList(data.cargoDeliver);
                if (!cargo.isEmpty() && id == EconomyFleetRouteManager.ROUTE_SRC_LOAD) {
                    cargo = String.valueOf(cargo) + " (\u88c5\u8d27\u4e2d) ";
                }
            } else {
                cargo = EconomyFleetAssignmentAI.EconomyRouteData.getCargoList(data.cargoReturn);
                if (!cargo.isEmpty() && id == EconomyFleetRouteManager.ROUTE_DST_LOAD) {
                    cargo = String.valueOf(cargo) + " (\u88c5\u8d27\u4e2d) ";
                }
            }
            if (trader || smuggler) {
                LabelAPI label = text.addParagraph("\u4f60\u9047\u5230\u4e86 " + fleet.getFaction().getPersonNamePrefixAOrAn() + " " + fleet.getFaction().getPersonNamePrefix() + " " + fleet.getName().toLowerCase() + ".");
                label.highlightFirst(fleet.getFaction().getPersonNamePrefix());
                label.setHighlightColor(fleet.getFaction().getBaseUIColor());
                text.setFontSmallInsignia();
                text.addParagraph("--------------------------------------------------------------------------------------------------------------");
                if (data.from.isHidden()) {
                    text.addPara("\u59cb\u53d1\u6e2f\uff1a%s", hl, "\u4e0d\u660e");
                } else {
                    text.addPara("\u59cb\u53d1\u6e2f\uff1a%s", hl, data.from.getName());
                }
                text.addPara("\u76ee\u7684\u5730\uff1a%s", hl, to);
                if (from.equals(data.to.getName())) {
                    text.addPara("\u6b63\u5728\u8fd4\u56de\uff1a%s", hl, data.to.getName());
                }
                if (cargo.isEmpty()) {
                    text.addPara("\u6ca1\u6709\u8f7d\u8d27");
                } else {
                    text.addPara("\u6b63\u5728\u8fd0\u8f93\uff1a%s", hl, cargo);
                }
                text.addParagraph("--------------------------------------------------------------------------------------------------------------");
                text.setFontInsignia();
                int penalty = Math.round(ShippingDisruption.getPenaltyForShippingLost(data.from.getSize(), data.size) * 100.0f);
                if (!fleet.getFaction().isPlayerFaction()) {
                    if (data.from.isHidden()) {
                        text.addPara("\u5982\u679c\u8be5\u8230\u961f\u672a\u80fd\u5b89\u5168\u62b5\u8fbe\u5176\u76ee\u7684\u5730\uff0c\u4f1a\u6839\u636e\u5176\u643a\u5e26\u8d27\u7269\u5bfc\u81f4\u76ee\u7684\u5730\u5bf9\u5e94\u8d27\u7269\u906d\u53d7\u77ed\u7f3a\u3002\u6b64\u5916\uff0c\u8230\u961f\u7684\u635f\u5931\u4f1a\u5bfc\u81f4\u5176\u6765\u6e90\u6b96\u6c11\u5730\u7684 \u6d41\u901a\u6027 \u5728\u6700\u591a\u4e09\u4e2a\u6708\u5185\u51cf\u5c11 %s}\u3002", Misc.getTextColor(), Misc.getHighlightColor(), penalty + "%");
                    } else {
                        text.addPara("\u5982\u679c\u8fd9\u652f\u8230\u961f\u4e0d\u80fd\u5b89\u5168\u62b5\u8fbe\u76ee\u7684\u5730\uff0c\u5c31\u4f1a\u9020\u6210\u5176\u8fd0\u8f7d\u5546\u54c1\u7684\u77ed\u7f3a\u3002\u6b64\u5916\uff0c\u5b83\u7684\u635f\u5931\u4e5f\u4f1a\u964d\u4f4e " + data.from.getName() + " %s \u7684\u6d41\u901a\u6027\u3002", Misc.getTextColor(), Misc.getHighlightColor(), penalty + "%");
                    }
                }
            }
        }
        if (!fleet.getFaction().isPlayerFaction() && !fleet.getFaction().isNeutralFaction()) {
            if (fleet.getMemoryWithoutUpdate().getBoolean("$noRepImpact")) {
                if (Misc.isDecentralized(fleet.getFaction())) {
                    text.addPara("\u4e0e\u8fd9\u652f\u8230\u961f\u4ea4\u6218\uff0c\u5c06\u4e0d\u4f1a\u5f71\u54cd\u4f60\u4e0e\u5b83\u540d\u4e49\u4e0a\u6240\u5c5e\u52bf\u529b\u7684\u5173\u7cfb\u3002", Misc.getHighlightColor(), "\u4e0d\u4f1a\u5bf9\u4f60\u7684\u58f0\u8a89\u9020\u6210\u4efb\u4f55\u6539\u53d8");
                } else {
                    text.addPara("\u56e0\u8fd9\u652f\u8230\u961f\u5728\u672a\u7ecf\u5176\u540d\u4e49\u4e0a\u6240\u5c5e\u52bf\u529b\u7684\u6279\u51c6\u800c\u64c5\u81ea\u884c\u52a8\uff0c\u6240\u4ee5\u4e0e\u5176\u4ea4\u6218 \u5c06\u4e0d\u4f1a\u5bf9\u4f60\u7684\u58f0\u8a89\u9020\u6210\u4efb\u4f55\u5f71\u54cd\u3002", Misc.getHighlightColor(), "\u4e0d\u4f1a\u5bf9\u4f60\u7684\u58f0\u8a89\u9020\u6210\u4efb\u4f55\u6539\u53d8");
                }
            } else if (fleet.getMemoryWithoutUpdate().getBoolean("$lowRepImpact") && fleet.knowsWhoPlayerIs()) {
                if (Misc.isDecentralized(fleet.getFaction())) {
                    text.addPara("\u4e0e\u8fd9\u652f\u8230\u961f\u4ea4\u6218\uff0c\u5c06\u4e0d\u4f1a\u7acb\u5373\u5f15\u8d77\u5b83\u540d\u4e49\u4e0a\u6240\u5c5e\u52bf\u529b\u7684\u654c\u5bf9\u884c\u52a8\uff0c\u4f46\u4ecd\u4f1a\u4f7f\u53cc\u65b9\u7684\u5173\u7cfb\u7565\u5fae\u7d27\u5f20\u8d77\u6765\u3002", Misc.getHighlightColor(), "\u5c06\u4e0d\u4f1a\u7acb\u5373\u5f15\u8d77\u5b83\u540d\u4e49\u4e0a\u6240\u5c5e\u52bf\u529b\u7684\u654c\u5bf9\u884c\u52a8");
                } else {
                    text.addPara("\u8fd9\u4e2a\u8230\u961f\u8981\u4e48\u5728\u6cd5\u5f8b\u7684\u7070\u8272\u5730\u5e26\u884c\u52a8\uff0c\u8981\u4e48\u5728\u8fdb\u884c\u975e\u5e38\u89c4\u7684\u6d3b\u52a8\u3002\u4e0e\u5176\u4ea4\u950b\u4e0d\u4f1a\u7acb\u523b\u5bfc\u81f4\u548c\u5176\u6bcd\u52bf\u529b\u8fdb\u5165\u654c\u5bf9\u5173\u7cfb\uff0c\u4f46\u662f\u4f1a\u5bf9\u5173\u7cfb\u6709\u8f7b\u5fae\u7684\u8d1f\u9762\u5f71\u54cd\u3002", Misc.getHighlightColor(), "\u5c06\u4e0d\u4f1a\u7acb\u5373\u5f15\u8d77\u5b83\u540d\u4e49\u4e0a\u6240\u5c5e\u52bf\u529b\u7684\u654c\u5bf9\u884c\u52a8");
                }
            }
        }
        return true;
    }
}

