/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DelayedBlueprintLearnScript;
import com.fs.starfarer.api.impl.campaign.FusionLampEntityPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.KantasProtectionOneTimeFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.PiracyRespiteScript;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.DelayedActionScript;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KantaCMD
extends BaseCommandPlugin {
    public static final String KANTA_PROTECTION = "$kantaProtection";
    public static final String EVER_HAD_KANTA_PROTECTION = "$everHadKantaProtection";

    public static boolean playerHasProtection() {
        return Global.getSector().getCharacterData().getMemoryWithoutUpdate().getBoolean(KANTA_PROTECTION);
    }

    public static boolean playerEverHadProtection() {
        return Global.getSector().getCharacterData().getMemoryWithoutUpdate().getBoolean(EVER_HAD_KANTA_PROTECTION);
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        OptionPanelAPI options = dialog.getOptionPanel();
        TextPanelAPI text = dialog.getTextPanel();
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        CargoAPI cargo = pf.getCargo();
        String action = params.get(0).getString(memoryMap);
        MemoryAPI memory = memoryMap.get("local");
        if (memory == null) {
            return false;
        }
        MarketAPI market = dialog.getInteractionTarget().getMarket();
        if ("findLargeOmega".equals(action)) {
            for (CargoStackAPI stack : cargo.getStacksCopy()) {
                WeaponSpecAPI spec;
                if (!stack.isWeaponStack() || (spec = stack.getWeaponSpecIfWeapon()).getSize() != WeaponAPI.WeaponSize.LARGE || !spec.hasTag("omega")) continue;
                memory.set("$foundWeaponId", spec.getWeaponId());
                memory.set("$foundWeaponName", spec.getWeaponName());
                memory.set("$foundWeaponQuantity", Math.round(stack.getSize()));
                return true;
            }
        } else {
            if ("findContactToBetray".equals(action)) {
                ContactIntel best = null;
                int bestImportance = 0;
                float bestRel = 0.0f;
                for (IntelInfoPlugin curr : Global.getSector().getIntelManager().getIntel(ContactIntel.class)) {
                    ContactIntel intel = (ContactIntel)curr;
                    if (intel.isEnding() || intel.isEnded() || intel.getState() == ContactIntel.ContactState.POTENTIAL) continue;
                    int importance = intel.getPerson().getImportance().ordinal();
                    float rel = intel.getPerson().getRelToPlayer().getRel();
                    if (intel.getPerson().getImportance().ordinal() <= PersonImportance.MEDIUM.ordinal() || importance <= bestImportance && (importance < bestImportance || !(rel > bestRel))) continue;
                    best = intel;
                    bestImportance = importance;
                    bestRel = rel;
                }
                if (best == null) {
                    return false;
                }
                PersonAPI contact = best.getPerson();
                memory.set("$foundContactName", contact.getNameString());
                memory.set("$foundContactRank", contact.getRank().toLowerCase());
                memory.set("$foundContactPost", contact.getPost().toLowerCase());
                memory.set("$foundContactFaction", String.valueOf(contact.getFaction().getPersonNamePrefixAOrAn()) + " " + contact.getFaction().getPersonNamePrefix());
                memory.set("$foundContactIntel", best);
                return true;
            }
            if ("betrayContact".equals(action)) {
                ContactIntel intel = (ContactIntel)memory.get("$foundContactIntel");
                CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                impact.delta = -0.75f;
                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true, true), intel.getPerson());
                intel.loseContact(dialog);
            } else if ("gaveHamatsu".equals(action)) {
                PersonAPI ibrahim = People.getPerson(People.IBRAHIM);
                if (ibrahim != null) {
                    CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                    impact.delta = -2.0f;
                    Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true, true), ibrahim);
                    ContactIntel intel = ContactIntel.getContactIntel(ibrahim);
                    if (intel != null) {
                        intel.loseContact(dialog);
                    }
                }
            } else if ("findRemnantCapital".equals(action)) {
                for (FleetMemberAPI member : pf.getFleetData().getMembersListCopy()) {
                    if (!member.getHullSpec().hasTag("remnant") || !member.isCapital()) continue;
                    memory.set("$foundShipId", member.getId());
                    memory.set("$foundShipClass", member.getHullSpec().getNameWithDesignationWithDashClass());
                    memory.set("$foundShipName", member.getShipName());
                    return true;
                }
            } else if ("findShieldBlueprint".equals(action)) {
                for (CargoStackAPI stack : cargo.getStacksCopy()) {
                    IndustrySpecAPI spec;
                    SpecialItemData data;
                    if (!stack.isSpecialStack() || (data = stack.getSpecialDataIfSpecial()).getData() == null || !data.getId().equals("industry_bp") || !(spec = Global.getSettings().getIndustrySpec(data.getData())).getId().equals("planetaryshield")) continue;
                    memory.set("$foundIndustryId", spec.getId());
                    String firstWord = stack.getDisplayName().split(" ")[0];
                    memory.set("$foundIndustryName", String.valueOf(Misc.ucFirst(Misc.getAOrAnFor(firstWord))) + " " + stack.getDisplayName().replace("Blueprint", "blueprint"));
                    return true;
                }
            } else if ("findShipBlueprint".equals(action)) {
                FactionAPI pirates = Global.getSector().getFaction("pirates");
                for (CargoStackAPI stack : cargo.getStacksCopy()) {
                    SpecialItemData data;
                    if (!stack.isSpecialStack() || (data = stack.getSpecialDataIfSpecial()).getData() == null || !data.getId().equals("ship_bp") || pirates.knowsShip(data.getData())) continue;
                    ShipHullSpecAPI spec = Global.getSettings().getHullSpec(data.getData());
                    boolean match = spec.hasTag("kanta_gift");
                    if (!(match |= !spec.isCivilianNonCarrier() && spec.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP)) continue;
                    memory.set("$foundShipBPId", data.getData());
                    String firstWord = stack.getDisplayName().split(" ")[0];
                    memory.set("$foundShipBPName", String.valueOf(Misc.ucFirst(Misc.getAOrAnFor(firstWord))) + " " + stack.getDisplayName().replace("Blueprint", "blueprint"));
                    return true;
                }
            } else {
                if ("learnShipBP".equals(action)) {
                    String hullId = params.get(1).getString(memoryMap);
                    float daysDelay = params.get(2).getFloat(memoryMap);
                    DelayedBlueprintLearnScript script = new DelayedBlueprintLearnScript("pirates", daysDelay);
                    script.getShips().add(hullId);
                    Global.getSector().addScript(script);
                    return true;
                }
                if ("oweKantaAFavor".equals(action)) {
                    Global.getSector().addScript(new KantaFavorTrigger());
                } else if ("abortFavor".equals(action)) {
                    Global.getSector().removeScriptsOfClass(KantaFavorTrigger.class);
                } else {
                    if ("alreadyDidFavor".equals(action)) {
                        return !Global.getSector().hasScript(KantaFavorTrigger.class) && KantaCMD.playerHasProtection();
                    }
                    if ("installFusionLamp".equals(action)) {
                        List<String> unmet;
                        SpecialItemData data = new SpecialItemData("orbital_fusion_lamp", null);
                        InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(data.getId());
                        Industry ind = market.getIndustry("population");
                        if (ind != null && effect != null && ((unmet = effect.getUnmetRequirements(ind)) == null || unmet.isEmpty())) {
                            ind.setSpecialItem(data);
                            market.getPrimaryEntity().addScript(new FusionLampColorChanger(market));
                        }
                        return true;
                    }
                    if ("buildPlanetaryShield".equals(action)) {
                        Industry ind = market.getIndustry("planetaryshield");
                        if (ind == null) {
                            market.addIndustry("planetaryshield");
                        }
                        return true;
                    }
                    if ("gavePristineNanoforge".equals(action)) {
                        float daysDelay = params.get(1).getFloat(memoryMap);
                        MarketAPI kapteyn = Global.getSector().getEconomy().getMarket("station_kapteyn");
                        if (kapteyn != null) {
                            Global.getSector().addScript(new DelayedInstallItemScript(daysDelay, kapteyn, "orbitalworks", "pristine_nanoforge"));
                            Global.getSector().getListenerManager().addListener(new TakingBackTheNanoforgeChecker(kapteyn));
                        }
                        return true;
                    }
                    if ("kapteynHasForge".equals(action)) {
                        MarketAPI kapteyn = Global.getSector().getEconomy().getMarket("station_kapteyn");
                        if (kapteyn == null || kapteyn.hasCondition("decivilized")) {
                            return false;
                        }
                        Industry ind = market.getIndustry("orbitalworks");
                        if (ind == null) {
                            return false;
                        }
                        return ind.getSpecialItem() != null && "pristine_nanoforge".equals(ind.getSpecialItem().getId());
                    }
                    if ("gainProtection".equals(action)) {
                        Global.getSector().getCharacterData().getMemoryWithoutUpdate().set(KANTA_PROTECTION, true);
                        Global.getSector().getCharacterData().getMemoryWithoutUpdate().set(EVER_HAD_KANTA_PROTECTION, true);
                        text.setFontSmallInsignia();
                        text.addPara("\u83b7\u5f97\u4e86 Kanta \u7684\u4fdd\u62a4", Misc.getPositiveHighlightColor());
                        text.setFontInsignia();
                        Global.getSoundPlayer().playUISound("ui_rep_raise", 1.0f, 1.0f);
                        PirateHostileActivityFactor.avertOrAbortRaid();
                        HostileActivityEventIntel intel = HostileActivityEventIntel.get();
                        if (intel != null) {
                            intel.addFactor(new KantasProtectionOneTimeFactor(-Global.getSettings().getInt("HA_kantaProtection")), dialog);
                        }
                        new PiracyRespiteScript();
                    } else if ("loseProtection".equals(action)) {
                        KantaCMD.loseProtection(dialog);
                    }
                }
            }
        }
        return false;
    }

    public static void loseProtection(InteractionDialogAPI dialog) {
        if (!KantaCMD.playerHasProtection()) {
            return;
        }
        PersonAPI kanta = People.getPerson(People.KANTA);
        if (kanta != null) {
            Misc.incrUntrustwortyCount();
            TextPanelAPI text = dialog == null ? null : dialog.getTextPanel();
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = -0.5f;
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, text, true, true), kanta);
            Global.getSector().getCharacterData().getMemoryWithoutUpdate().unset(KANTA_PROTECTION);
            if (text != null) {
                text.setFontSmallInsignia();
                text.addPara("\u5931\u53bb\u4e86 Kanta \u7684\u4fdd\u62a4", Misc.getNegativeHighlightColor());
                text.setFontInsignia();
            }
            Global.getSoundPlayer().playUISound("ui_rep_drop", 1.0f, 1.0f);
        }
    }

    public static class DelayedInstallItemScript
    extends DelayedActionScript {
        protected MarketAPI market;
        protected String industryId;
        protected String itemId;

        public DelayedInstallItemScript(float daysLeft, MarketAPI market, String industryId, String itemId) {
            super(daysLeft);
            this.market = market;
            this.industryId = industryId;
            this.itemId = itemId;
        }

        public void doAction() {
            List<String> unmet;
            InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(this.itemId);
            Industry ind = this.market.getIndustry(this.industryId);
            if (ind != null && effect != null && !this.market.hasCondition("decivilized") && ((unmet = effect.getUnmetRequirements(ind)) == null || unmet.isEmpty())) {
                ind.setSpecialItem(new SpecialItemData(this.itemId, null));
            }
        }
    }

    public static class FusionLampColorChanger
    implements EveryFrameScript {
        protected MarketAPI market;
        protected IntervalUtil interval = new IntervalUtil(0.5f, 1.0f);

        public boolean isDone() {
            return this.market.getContainingLocation() == null;
        }

        public boolean runWhilePaused() {
            return false;
        }

        public FusionLampColorChanger(MarketAPI market) {
            this.market = market;
        }

        public void advance(float amount) {
            float days = Global.getSector().getClock().convertToDays(amount);
            if (Global.getSector().getClock().getMonth() == 11 && Global.getSector().getClock().getDay() == 28) {
                days *= 100.0f;
            }
            this.interval.advance(days);
            if (this.interval.intervalElapsed()) {
                for (CustomCampaignEntityAPI curr : this.market.getContainingLocation().getCustomEntities()) {
                    if (!curr.getCustomEntityType().equals("fusion_lamp") || curr.getOrbitFocus() != this.market.getPrimaryEntity()) continue;
                    WeightedRandomPicker<Pair<Color, Color>> picker = new WeightedRandomPicker<Pair<Color, Color>>();
                    picker.add(new Pair<Color, Color>(FusionLampEntityPlugin.GLOW_COLOR, FusionLampEntityPlugin.LIGHT_COLOR));
                    picker.add(new Pair<Color, Color>(new Color(255, 50, 50, 255), new Color(255, 50, 50, 255)));
                    picker.add(new Pair<Color, Color>(new Color(210, 230, 255, 255), new Color(210, 230, 255, 255)));
                    picker.add(new Pair<Color, Color>(new Color(245, 250, 255, 255), new Color(245, 250, 255, 255)));
                    picker.add(new Pair<Color, Color>(new Color(255, 225, 125, 255), new Color(255, 225, 125, 255)));
                    picker.add(new Pair<Color, Color>(new Color(100, 255, 100, 255), new Color(100, 255, 100, 255)));
                    Pair pick = (Pair)picker.pick();
                    FusionLampEntityPlugin plugin = (FusionLampEntityPlugin)curr.getCustomPlugin();
                    plugin.setGlowColor((Color)pick.one);
                    plugin.setLightColor((Color)pick.two);
                    break;
                }
            }
        }
    }

    public static class KantaFavorTrigger
    implements EveryFrameScript {
        public static float MIN_ELAPSED = 720.0f;
        public static float PROB_PER_MONTH = 0.01f;
        public static float MIN_DELAY_BETWEEN_COURIERS = 60.0f;
        public static float MAX_DELAY_BETWEEN_COURIERS = 90.0f;
        public static int MAX_ATTEMPTS = 5;
        protected IntervalUtil interval = new IntervalUtil(20.0f, 40.0f);
        protected float elapsed = 0.0f;
        protected float resendTimeout = 0.0f;
        protected int attempts = 0;
        protected Random random = new Random();
        protected boolean done = false;

        public void advance(float amount) {
            if (Global.getSector().getMemoryWithoutUpdate().getBoolean("$affk_inProgress")) {
                this.done = true;
                return;
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            this.elapsed += days;
            boolean send = false;
            this.interval.advance(days);
            if (this.interval.intervalElapsed() && this.random.nextFloat() < PROB_PER_MONTH) {
                send = true;
            }
            if (this.attempts <= 0 && this.elapsed < MIN_ELAPSED) {
                send = false;
            }
            if (this.attempts > 0 && this.elapsed < this.resendTimeout) {
                send = false;
            } else if (this.attempts > 0) {
                if (this.attempts >= MAX_ATTEMPTS) {
                    KantaCMD.loseProtection(null);
                    Global.getSector().getCampaignUI().addMessage("Kanta's Protection lost", Misc.getNegativeHighlightColor());
                    send = false;
                    this.done = true;
                    return;
                }
                send = true;
            }
            if (send) {
                this.elapsed = 0.0f;
                this.sendCourier();
                ++this.attempts;
                this.resendTimeout = MIN_DELAY_BETWEEN_COURIERS + (MAX_DELAY_BETWEEN_COURIERS - MIN_DELAY_BETWEEN_COURIERS) * this.random.nextFloat();
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean runWhilePaused() {
            return false;
        }

        public void sendCourier() {
            DelayedFleetEncounter e = new DelayedFleetEncounter(this.random, "kantaFavorCourier");
            e.setDelayNone();
            e.setLocationInnerSector(false, null);
            e.setEncounterFromSomewhereInSystem();
            e.setDoNotAbortWhenPlayerFleetTooStrong();
            e.beginCreate();
            e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_SMALL, HubMissionWithTriggers.FleetQuality.HIGHER, "pirates", "patrolSmall", new Vector2f());
            e.triggerFleetSetName("Courier");
            e.triggerMakeNonHostile();
            e.triggerFleetMakeImportantPermanent(null);
            e.triggerFleetMakeFaster(true, 0, true);
            e.triggerOrderFleetInterceptPlayer();
            e.triggerOrderFleetEBurn(1.0f);
            e.triggerSetFleetGenericHailPermanent("KantaFavorCourierHail");
            e.endCreate();
        }
    }

    public static class TakingBackTheNanoforgeChecker
    implements ColonyPlayerHostileActListener {
        protected MarketAPI market;

        public TakingBackTheNanoforgeChecker(MarketAPI market) {
            this.market = market;
        }

        public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
            if (this.market.hasCondition("decivilized")) {
                Global.getSector().getListenerManager().removeListener(this);
            }
            if (actionData.secret) {
                return;
            }
            if (market == this.market) {
                SpecialItemData specialItemData = new SpecialItemData("pristine_nanoforge", null);
                if (cargo.getQuantity(CargoAPI.CargoItemType.SPECIAL, specialItemData) > 0.0f) {
                    PersonAPI kanta = People.getPerson(People.KANTA);
                    if (kanta != null) {
                        TextPanelAPI text = dialog.getTextPanel();
                        text.addPara("\u5173\u4e8e\u8fd9\u4ef6\u4e8b\u7684\u6d41\u8a00\u80af\u5b9a\u4f1a\u4f20\u5230 Kanta \u7684\u8033\u4e2d\u3002\u4f60\u65e0\u6cd5\u60f3\u8c61\u5979\u5728\u88ab\u5982\u6b64\u611a\u5f04\u540e\u4f1a\u4f5c\u4f55\u53cd\u5e94\u3002");
                        KantaCMD.loseProtection(dialog);
                    }
                    Global.getSector().getListenerManager().removeListener(this);
                }
            }
        }

        public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
        }

        public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        }

        public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        }
    }
}

