/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.CharacterCreationData;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NGCAddDevStartingScript
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        CharacterCreationData data = (CharacterCreationData)memoryMap.get("local").get("$characterData");
        MemoryAPI memory = memoryMap.get("local");
        data.addScript(new Script(){

            public void run() {
                Global.getSector().getPlayerStats().addStoryPoints(100);
                CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
                fleet.getFleetData().addFleetMember("hammerhead_Balanced");
                fleet.getFleetData().addFleetMember("tarsus_Standard");
                fleet.getFleetData().addFleetMember("dram_Light");
                int crew = 0;
                int supplies = 0;
                for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                    crew = (int)((double)crew + Math.ceil(member.getMinCrew() + (member.getMaxCrew() - member.getMinCrew()) * 0.5f));
                    supplies = (int)((float)supplies + member.getDeploymentCostSupplies() * 4.0f);
                }
                CargoAPI cargo = fleet.getCargo();
                cargo.removeCrew(cargo.getCrew());
                cargo.addCrew(crew);
                cargo.addFuel(cargo.getMaxFuel() * 0.5f);
                cargo.addCommodity("alpha_core", 10.0f);
                cargo.addCommodity("beta_core", 10.0f);
                cargo.addCommodity("gamma_core", 10.0f);
                cargo.addSupplies(cargo.getSpaceLeft());
                fleet.getFleetData().ensureHasFlagship();
                for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                    float max = member.getRepairTracker().getMaxCR();
                    member.getRepairTracker().setCR(max);
                }
                fleet.getFleetData().setSyncNeeded();
                StarSystemAPI system = Global.getSector().getStarSystem("galatia");
                PlanetAPI ancyra = (PlanetAPI)system.getEntityById("ancyra");
                PersonAPI mainContact = TutorialMissionIntel.createMainContact(ancyra);
                PersonAPI jangalaContact = TutorialMissionIntel.getJangalaContact();
                TutorialMissionIntel.endGalatiaPortionOfMission(true, false);
                mainContact.getRelToPlayer().setRel(0.2f);
                jangalaContact.getRelToPlayer().setRel(0.1f);
                Global.getSector().getFaction("hegemony").getRelToPlayer().setRel(0.15f);
            }
        });
        return true;
    }
}

