/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.MutableValue;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveCommodity
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        boolean withText;
        if (dialog == null) {
            return false;
        }
        String commodityId = params.get(0).getString(memoryMap);
        float quantity = 0.0f;
        int next = 2;
        if (params.get(1).isOperator()) {
            quantity = -1.0f * params.get(2).getFloat(memoryMap);
            next = 3;
        } else {
            quantity = params.get(1).getFloat(memoryMap);
        }
        quantity = -quantity;
        boolean bl = withText = Math.abs(quantity) >= 1.0f;
        if (dialog != null && params.size() >= next + 1) {
            boolean bl2 = withText = params.get(next).getBoolean(memoryMap) && withText;
        }
        if (commodityId.equals("credits")) {
            MutableValue credits = Global.getSector().getPlayerFleet().getCargo().getCredits();
            if (quantity > 0.0f) {
                credits.add(quantity);
                if (withText) {
                    AddRemoveCommodity.addCreditsGainText((int)quantity, dialog.getTextPanel());
                }
            } else {
                credits.subtract(Math.abs(quantity));
                if (credits.get() < 0.0f) {
                    credits.set(0.0f);
                }
                if (withText) {
                    AddRemoveCommodity.addCreditsLossText((int)Math.abs(quantity), dialog.getTextPanel());
                }
            }
        } else if (quantity > 0.0f) {
            Global.getSector().getPlayerFleet().getCargo().addCommodity(commodityId, quantity);
            if (withText) {
                AddRemoveCommodity.addCommodityGainText(commodityId, (int)quantity, dialog.getTextPanel());
            }
        } else {
            Global.getSector().getPlayerFleet().getCargo().removeCommodity(commodityId, Math.abs(quantity));
            if (withText) {
                AddRemoveCommodity.addCommodityLossText(commodityId, (int)Math.abs(quantity), dialog.getTextPanel());
            }
        }
        if (!"credits".equals(commodityId)) {
            AddRemoveCommodity.updatePlayerMemoryQuantity(commodityId);
        }
        return true;
    }
}

